#ifndef GGAF_LIB_WMKEYINPUT_H_
#define GGAF_LIB_WMKEYINPUT_H_
#include "GgafLibCommonHeader.h"

#include <windows.h>

namespace GgafLib {


/**
 * L[͎t .
 * @version 1.00
 * @since 2018/09/28
 * @author Masatoshi Tsuge
 */
class WMKeyInput {

    /** ݃ANeBuȓ͏Ԃ̕\(0:\^1:) */
    static int _flip;
    /** ͏ԁi\Aj */
    static int _input_char_state[2][256];
    static int _wm_char_state[256];
public:

    /**
     *  .
     */
    static void init();

    /**
     * WM_CHARCxg̏ .
     * WINDOWvV[W  WM_CHARCxgLb`
     * {\bhsĂB
     * @param wParam WINDOWvV[W WPARAM wParam
     */
    static void catchWmChar(WPARAM wParam);

    /**
     * L[͏Ԃ̍XV .
     * AvP[VŁAt[ĂяoĂB
     */
    static void updateState();

    /**
     * ̓L[Ă邩𔻒 .
     * @param prm_c 肷͕iASCIIR[hj
     * @return true:̓̕L[Ă^false:ł͂ȂB
     */
    static inline bool isPressedKey(int prm_c) {
        return (_input_char_state[_flip][prm_c] == 1) ? true : false;
    }

    /**
     * ̓L[ꂽ𔻒 .
     * @param prm_c 肷͕iASCIIR[hj
     * @return true:̓̕L[ꂽ^false:ł͂ȂB
     * @return
     */
    static bool isPushedDownKey(int prm_c);

    /**
     * ݉Ă镶̓L[擾 .
     * @param prm_num Ɏ擾ő吔
     * @param prm_pa_char ʂi[zBprm_num̗vf̔znƁB
     * @return ݉Ă镶̓L[̐
     */
    static inline int getPressedKey(int prm_num, int* prm_pa_char) {
        int n = 0;
        for (int i = 0; i < 256; i ++) {
            if (_input_char_state[_flip][i] == 1) {
                if (n < prm_num) {
                    prm_pa_char[n] = i;
                    n++;
                    continue;
                } else {
                    break;
                }
            }
        }
        return n;
    }

    /**
     * ꂽ̓L[擾 .
     * @param prm_num Ɏ擾ő吔
     * @param prm_pa_char ʂi[zBprm_num̗vf̔znƁB
     * @return ꂽ̓L[̐
     */
    static int getPushedDownKey(int prm_num, int* prm_pa_char);


};

}
#endif /*GGAF_LIB_WMKEYINPUT_H_*/
