#ifndef GGAF_LIB_WALLSECTIONSCENE_H_
#define GGAF_LIB_WALLSECTIONSCENE_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/lib/scene/DefaultScene.h"

#define FULL_VAL (-2)
#define KARA_VAL (-2)

namespace GgafLib {

/**
 * XXN[̕ǃubNZNVV[ .
 * WallScene \V[̂PłA
 * WallSectionScene AĈ WallScene \܂B<BR>
 * WallSectionScene ͕ǃubNt@CǏǂݍ݁A
 * ^C~OiXN[Xs[hjvȂAŕǂo܂B<BR>
 * @version 1.00
 * @since 2010/10/18
 * @author Masatoshi Tsuge
 */
class WallSectionScene : public DefaultScene {

    /**
     * ǃubN(MassWallActor)̔zu\
     */
    struct WallInfo {
        /** vYʒu(> 0̏ꍇ̓vYA0̏ꍇBOX) */
        pos_t _pos_info;
        /** \YW */
        int _y;
        /** \ZW */
        int _z;
        /** \ʏ */
        int _wall_draw_face;
        /** 蔻̈AAB */
        int _aColliBoxStretch[6];
    };

public:
    /** [r]OǃV[̒iXW̕ǃubNj */
    int _area_len;
    /** [r]OǃV[̍iYW̕ǃubNj */
    int _area_height;
    /** [r]OǃV[̕iZW̕ǃubNj */
    int _area_width;
    /** [r]ǃubN̒iPMassWallActorIuWFNgXWj*/
    coord _wall_dep;
    /** [r]ǃubN̍iPMassWallActorIuWFNgYWj*/
    coord _wall_height;
    /** [r]ǃubN̕iPMassWallActorIuWFNgZWj*/
    coord _wall_width;
    /** [r]OǕ\XWʒu */
    coord _wall_start_x;
    /** [r]JԂ */
    int _loop_num;
    /** [r]JԂJE^ */
    int _cnt_loop;
    /** [r]OǕ\Ԋu */
    frame _frame_of_launch_next;
    /** [r]\ς݊OǃV[̒(ǃubN) */
    int _cnt_area_len;
    /** [r]SǃubN(MassWallActor)̔zu */
    WallInfo** _papaWallInfo;
    /** [r]SǃubN(MassWallActor)̔zúAOǂ̕ǃubNBvfubNڂ(_area_lenCfbNX) */
    int* _paWallNum;
    /** [r]ǃubN(MassWallActor)f|Wg */
    GgafCore::ActorDepository* _pDepo_wall;
    /** [r]OubN̓ߋ@\L̊ƂȂAN^[ */
    GgafDx::GeometricActor* _pActor_infront_alpha_target;
    /** ZNVV[JԂtO */
    bool _is_loop_end;
    MassWallActor* _pWallLast;

    WallScene*  _pWallScene;

public:
    /**
     * RXgN^ .
     * ǃubNt@Cǂݍ݁AIuWFNgɓWJ܂B
     * @param prm_name V[
     * @param prm_data_filename ǃubNt@C
     * @param prm_pWallScene e̕ǃV[IuWFNg
     */
    WallSectionScene(const char* prm_name, const char* prm_data_filename, WallScene* prm_pWallScene);

    /**
     * OǃV[ݒ.
     * new Ainitialize() s܂ł config ĉB
     * @param prm_pDepo_wall ǃubNiWallAABActorIuWFNgjo^Ăf|Wg
     * @param prm_wall_start_x OǏoXWʒu
     * @param prm_wall_dep ǃubN̒iPMassWallActorIuWFNgXWj
     * @param prm_wall_width ǃubN̍iPMassWallActorIuWFNgYWj
     * @param prm_wall_height ǃubN̍iPMassWallActorIuWFNgZWj
     */
    virtual void config(
            GgafCore::ActorDepository* prm_pDepo_wall,
            coord prm_wall_start_x,
            coord prm_wall_dep, coord prm_wall_width, coord prm_wall_height);

    /**
     *  .
     * f|Wg(_pDepo_wall)̃`FbNsĂ̂ .
     */
    virtual void initialize() override;

    /**
     * OǕ\ԊuԓvZݒ .
     * I[o[ChꍇȀ̒ WallSectionScene::onActive() ĂяoĉB
     */
    virtual void onActive() override;

    /**
     * OǂoAړ.
     * I[o[ChꍇȀ̒ WallSectionScene::processBehavior() ĂяoĉB
     */
    virtual void processBehavior() override;

    MassWallActor* getLastWallParts() const;

    /**
     * OubN̓ߋ@\LɂB
     * ɂꍇ nullptr ݒ肷
     * @param prm_pActor_infront_alpha_target O̊ɂȂAN^[
     */
    void enableInfrontAlpha(GgafDx::GeometricActor* prm_pActor_infront_alpha_target) {
        _pActor_infront_alpha_target = prm_pActor_infront_alpha_target;
    }

    /**
     * YZʂɁAubÑZbgoɌĂяoR[obNB .
     * I[o[ChĂ̂B
     * @param prm_loop_count ZNṼ[vJEg(0`)
     * @param prm_wall_count ZNVYZʃubNZbgJEg(0`)
     * @param prm_wall_x oYZʂ̃ubNXW
     */
    virtual void onBlockLaunch(int prm_loop_count, int prm_wall_count, coord prm_wall_x) {};

    virtual ~WallSectionScene();
};

}
#endif /*GGAF_LIB_WALLSECTIONSCENE_H_*/
