#ifndef GGAF_LIB_MENUACTOR_H_
#define GGAF_LIB_MENUACTOR_H_
#include "GgafLibCommonHeader.h"

#include "jp/ggaf/core/util/LinkedListRing.hpp"
#include "jp/ggaf/dx/actor/FigureActor.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/VecDriverMvAssistant.h"
#include "jp/ggaf/dx/util/Util.h"
#include "jp/ggaf/lib/actor/DefaultBoardActor.h"
#include "jp/ggaf/lib/actor/DefaultBoardSetActor.h"
#include "jp/ggaf/lib/actor/DefaultSpriteActor.h"
#include "jp/ggaf/lib/actor/DefaultSpriteSetActor.h"
#include "jp/ggaf/lib/actor/DefaultFramedBoardActor.h"
#include "jp/ggaf/lib/actor/menu/MenuActor.hpp"
#include "jp/ggaf/lib/actor/FontBoardActor.h"
#include "jp/ggaf/lib/actor/FontSpriteActor.h"


namespace GgafLib {

/**
 * j[ .
 * GUIȈՃj[ȒPɎ邽߂̃ev[głB<BR>
 * <b>ypz</b><BR>
 * Ej[ACe              c J[\őI\ȃIuWFNgi{^GUIijw܂B
 * Ej[x                c J[\őIs̕\pIuWFNgi{^GUIijw܂B
 * ELZij[ACejc uLZv̓삪҂GUIi̎wBiF [Cancel]  [] A[~] {^́j<BR>
 * EiU镑j              c [U[ŁAj[ACéuv̈ӎv\wBiF [ENTER]L[j<BR>
 * ELZiU镑j        c [U[ŁAj[ACéuLZv̈ӎv\wBiF [ESC]L[j<BR>
 * ɁuLZvƌ鎖ɂāA{eł̐ł́A<BR>
 * wuLZij[ACejvŁAuiU镑j vBx<BR>
 * Ƃ\ɂȂ܂B<BR>
 * ܂AႦ [Yes][No] {^A[Yes] {^IԂŁAESC͂[No]{^ɃJ[\IړꍇA<BR>
 *wYes̃j[ACeŁAuLZiU镑jv̂ŁAuLZij[ACejvɃJ[\Iړx
 * Ƃ\ɂȂ܂B<BR>
 * {NX́uLZij[ACejvuiU镑jvuLZiU镑jvʈA
 * ɂċ@\T|[g܂B<BR>
 * i[OK]{^́uij[ACejvɂēʈĂ܂j<BR>
 * @tparam T ̂̃j[ƂȂAN^[̌^
 * @version 1.00
 * @since 2011/12/20
 * @author Masatoshi Tsuge
 */
template<class T>
class MenuActor : public T {

protected:

    enum MenuItemWay {
        ITEM_RELATION_EX_NEXT = 0,
        ITEM_RELATION_EX_PREV,
        ITEM_RELATION_TO_CANCEL,
    };

    /** tF[hC true */
    bool _with_rising;
    /** tF[hAEg true */
    bool _with_sinking;
    /** tF[hCJnuԂ̃t[ true */
    bool _is_just_risen;
    /** tF[hAEgJnuԂ̃t[ true */
    bool _is_just_sunk;
    /** uiU镑jvuԂ̃t[ true */
    bool _is_just_decided;
    /** uLZiU镑jvuԂ̃t[ true */
    bool _is_just_cancelled;

    bool _will_be_rising_next_frame;

    bool _will_be_sinking_next_frame;

    bool _will_be_just_decided_next_frame;

    bool _will_be_just_cancelled_next_frame;

    bool _can_controll;

    bool _will_be_able_to_controll;

    /** CJ[\̕␳XW */
    coord _x_cursor_adjust;
    /** CJ[\̕␳YW */
    coord _y_cursor_adjust;
    /** CJ[\̕␳ZW */
    coord _z_cursor_adjust;
    /** CJ[\ړ惁j[ACȇOt[XW */
    coord _x_cursor_target_prev;
    /** CJ[\ړ惁j[ACȇOt[YW */
    coord _y_cursor_target_prev;
    /** CJ[\ړ惁j[ACȇOt[ZW */
    coord _z_cursor_target_prev;
    /** [r]CJ[\Aj[ACeԂړۂɔ₷Xt[ */
    int _cursor_move_frames;
    /** [r]CJ[\ړAj[ACeԈړ̑xO`ōɒB鎞_̊ */
    float _cursor_move_p1;
    /** [r]CJ[\ړAj[ACeԈړ̍ō猸Jn銄 */
    float _cursor_move_p2;
    /** [r]Cj[J[\ */
    GgafDx::FigureActor* _pCursorActor;

    /**
     * ⏕J[\ .
     */
    class SubCursor {
    public:
        /** [r]⏕J[\AN^[ */
        GgafDx::FigureActor* _pActor;
        /** I𒆃CfbNX  */
        int _select_index;
        /** ⏕J[\̕␳XW */
        coord _x_adjust;
        /** ⏕J[\̕␳YW */
        coord _y_adjust;
        /** ⏕J[\̕␳ZW */
        coord _z_adjust;
        /** ⏕J[\ړ惁j[ACȇOt[XW */
        coord _x_target_prev;
        /** ⏕J[\ړ惁j[ACȇOt[YW */
        coord _y_target_prev;
        /** ⏕J[\ړ惁j[ACȇOt[ZW */
        coord _z_target_prev;
        /** [r]⏕J[\Aj[ACeԂړۂɔ₷Xt[ */
        int _move_frames;
        /** [r]⏕J[\ړAj[ACeԈړ̑xO`ōɒB鎞_̊ */
        float _move_p1;
        /** [r]⏕J[\ړAj[ACeԈړ̍ō猸Jn銄 */
        float _move_p2;
    public:
        SubCursor() {
            _select_index = 0;
            _move_frames = 10;
            _move_p1 = 0.2;
            _move_p2 = 0.7;
            _x_target_prev = 0;
            _y_target_prev = 0;
            _z_target_prev = 0;
            _pActor = nullptr;
            _x_adjust = 0;
            _y_adjust = 0;
            _z_adjust = 0;
        }
        virtual ~SubCursor() {
        }
    };

protected:
    /**
     * CJ[\Ij[ACe(_lstItems ̃ANeBuvf)ֈړ .
     * uIvƁuJ[\̈ړv́AʁXōlĉB<BR>
     * {\bh͗\ߑIς݂̃j[ACeցuJ[\̈ړvłAoʂ̏ɓĂ܂B<BR>
     * uIv̂ŝł͂܂BuIv selectItem() ōs܂B<BR>
     * ܂AselectItem() ŁA moveCursor() ͎s܂B<BR>
     * ]āAmoveCursor() P̂ŌĂяo͖wǑz肵ĂȂ̂ŒӂĉB<BR>
     * J[\ړ̌ʉ炷ꍇ́AI[o[ChčĒ`邱ƂŎĂB<BR>
     * ̏ɏ moveCursor() ĂяôYȂ悤ɁB<BR>
     * @param prm_smooth X[Yړ邩ۂ
     */
    virtual void moveCursor(bool prm_smooth = true);

    /**
     * ⏕J[\Ij[ACeֈړ .
     * uIvƁuJ[\̈ړv́AʁXōlĉB<BR>
     * {\bh͗\ߑIς݃j[ACeցuJ[\̈ړvłAoʂ̏ɓĂ܂B<BR>
     * uIv̂ŝł͂܂BuIv selectItemBySubCursor() ōs܂B<BR>
     * ܂AselectItemBySubCursor() ŁA moveSubCursor() ͎s܂B<BR>
     * ]āAmoveCursor() P̂ŌĂяo͖wǑz肵ĂȂ̂ŒӂĉB<BR>
     * J[\ړ̌ʉ炷ꍇ́AI[o[ChčĒ`邱ƂŎĂB<BR>
     * ̏ɏ moveSubCursor() ĂяôYȂ悤ɁB<BR>
     * @param prm_subcur_no
     * @param prm_smooth
     */
    virtual void moveSubCursor(int prm_subcur_no, bool prm_smooth = true);

public:
    /** [r]j[ACẽXgAANeBu̓CJ[\IĂ */
    GgafCore::LinkedListRing<GgafDx::FigureActor> _lstItems;
    /** [r]̑\j[ACẽXg */
    GgafCore::LinkedListRing<GgafDx::FigureActor> _lstLabelActors;
    /** [r]CJ[\ړj[ACeCfbNX̃qXg[(0`NAA͑S -1 ) */
    GgafCore::LinkedListRing<int> _lstMvCursorHistory;
    /** [r]Ij[ACeCfbNX̃qXg[(0`NAA͑S -1 ) */
    GgafCore::LinkedListRing<int> _lstMvSelectHistory;
    /** [r]j[tFChCEAEg̃t[ */
    frame _fade_frames;
    /** [r]j[tFChCEAEg̃At@x */
    float _velo_alpha_fade;
    /** [r]Tuj[̃Xg */
    GgafCore::LinkedListRing<MenuActor<T> > _lstSubMenu;
    /** [r]TuJ[\̃Xg */
    GgafCore::LinkedListRing<SubCursor> _lstSubCursor;

public:
    /**
     * RXgN^ .
     * yӁz񊈓ԂftHgƂĂ܂B<BR>
     * ̓Iɂ T::inactivateImmed(); R[Ă܂B
     * @param prm_name
     * @param prm_model fʖ
     */
    MenuActor(const char* prm_name, const char* prm_model);

    /**
     * ݓ͂󂯕tĂԂԂ .
     * Tuj[\Ăԓ́AsɂȂA{\bhfalseԂ܂B
     * @return true:Rg[\/false:Rg[s\
     */
    virtual bool canControll() {
        return _can_controll;
    }

    /**
     * ͂󂯕t𖳌 .
     * IɌĂяoA̎gpzB
     */
    virtual void disableControll() {
        _will_be_able_to_controll = false;
    }

    /**
     * ͂󂯕tL .
     */
    virtual void enableControll() {
        _will_be_able_to_controll = true;
    }

    /**
     * j[tFChCEAEg̃At@xݒ .
     * @param prm_menu_fade_frames tF[ht[
     */
    virtual void setFadeFrames(frame prm_menu_fade_frames) {
        _fade_frames = prm_menu_fade_frames;
        if (prm_menu_fade_frames == 0) {
            _velo_alpha_fade = 1.0;
        } else {
            _velo_alpha_fade = 1.0 / prm_menu_fade_frames;
        }
    }

    /**
     * I\ȃj[ACeǉAj[ACeԂ̃I[_[Aǉ .
     * ǉꂽj[ACe̓j[ACe(this)̎qɓo^邽߁A
     * j[ACe^XNc[ɓo^Ȃ delete Kv͂ȂB
     * yӁz<BR>
     * ZWȂ΁A addItem() AOɕ\ƂȂB<BR>
     * @param prm_pItem j[ACe
     * @param prm_x_local j[ACẽ[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local j[ACẽ[JW(0,0,0)̑ΈʒuYW
     * @param prm_z_local j[ACẽ[JW(0,0,0)̑ΈʒuZW
     */
    virtual void addItem(GgafDx::FigureActor* prm_pItem,
                         coord prm_x_local, coord prm_y_local, coord prm_z_local);

    /**
     * I\j[ACeǉAj[ACeԂ̃I[_[Aǉ .
     * ǉꂽj[ACe̓j[ACe(this)̎qɓo^邽߁A
     * j[ACe^XNc[ɓo^Ȃ delete Kv͂ȂB<BR>
     * yӁz<BR>
     * ZWȂ΁A addItem() AOɕ\ƂȂB<BR>
     * ZẂAItZbg0ݒ肳B܂胁j[ACe̐ZẂÃ݂j[ZWƈvB<BR>
     * j[2DŁAj[ACe̕\vCIeB̍lKvȏꍇ́AItZbg-1ɖݒ\B
     * @param prm_pItem j[ACe
     * @param prm_x_local j[ACẽ[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local j[ACẽ[JW(0,0,0)̑ΈʒuYW
     */
    virtual void addItem(GgafDx::FigureActor* prm_pItem,
                         coord prm_x_local, coord prm_y_local) {
        addItem(prm_pItem, prm_x_local, prm_y_local, 0);
    }

    /**
     * I\j[ACeǉ .
     * ʒu͌ォ setPositionItem() ŕύXłB
     * @param prm_pItem j[ACe
     */
    virtual void addItem(GgafDx::FigureActor* prm_pItem) {
        addItem(prm_pItem, 0, 0, 0);
    }

    /**
     * ǉꂽI\j[ACe̍Wʒuݒ .
     * @param prm_index_of_item j[ACẽCfbNX
     * @param prm_x_local j[ACẽ[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local j[ACẽ[JW(0,0,0)̑ΈʒuYW
     * @param prm_z_local j[ACẽ[JW(0,0,0)̑ΈʒuZW
     */
    virtual void setPositionItem(int prm_index_of_item, coord prm_x_local, coord prm_y_local, coord prm_z_local);

    /**
     * ǉꂽj[ACe̍Wʒuݒ .
     * @param prm_index_of_item j[ACẽCfbNX
     * @param prm_x_local j[ACẽ[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local j[ACẽ[JW(0,0,0)̑ΈʒuYW
     */
    virtual void setPositionItem(int prm_index_of_item, coord prm_x_local, coord prm_y_local) {
        setPositionItem(prm_index_of_item, prm_x_local, prm_y_local, 0);
    }

    /**
     * Is̕\pj[x(j[x)ǉ .
     * yӁz<BR>
     * ZWȂ΁Ȁ addLabel() AOɕ\ƂȂB<BR>
     * @param prm_pItem \pj[x̃AN^[
     * @param prm_x_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuYW
     * @param prm_z_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuZW
     */
    virtual void addLabel(GgafDx::FigureActor* prm_pLabel,
                          coord prm_x_local, coord prm_y_local, coord prm_z_local);

    /**
     * Is̕\pj[xǉ .
     * yӁz<BR>
     * ZWȂ΁Ȁ addLabel() AOɕ\ƂȂB<BR>
     * ZẂAItZbg0ݒ肳B܂\pAN^[̐ZẂÃ݂j[ZWƈvB
     * j[2DŁAj[ACe̕\vCIeB̍lKvȏꍇ́AItZbg-1ɖݒ\B
     * @param prm_pItem \pj[x̃AN^[
     * @param prm_x_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuYW
     */
    virtual void addLabel(GgafDx::FigureActor* prm_pLabel,
                          coord prm_x_local, coord prm_y_local) {
        addLabel(prm_pLabel, prm_x_local, prm_y_local, 0);
    }

    /**
     * Is̕\pj[xǉ .
     * ʒu͌ォ setPositionLabel() ŕύXłB
     * @param prm_pLabel \pj[x̃AN^[
     */
    virtual void addLabel(GgafDx::FigureActor* prm_pLabel) {
        addLabel(prm_pLabel, 0, 0, 0);
    }

    /**
     * ǉꂽIs̕\pj[x̍Wʒuݒ .
     * @param prm_index_of_label j[x̃CfbNX
     * @param prm_x_local j[x̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local j[x̃[JW(0,0,0)̑ΈʒuYW
     * @param prm_z_local j[x̃[JW(0,0,0)̑ΈʒuZW
     */
    virtual void setPositionLabel(int prm_index_of_label, coord prm_x_local, coord prm_y_local, coord prm_z_local);

    /**
     * ǉꂽIs̕\pj[x̍Wʒuݒ .
     * @param prm_index_of_label j[x̃CfbNX
     * @param prm_x_local j[x̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_y_local j[x̃[JW(0,0,0)̑ΈʒuYW
     */
    virtual void setPositionLabel(int prm_index_of_label, coord prm_x_local, coord prm_y_local) {
        setPositionLabel(prm_index_of_label, prm_x_local, prm_y_local, 0);
    }

    /**
     * CJ[\IuWFNgݒ肷 .
     * yӁz<BR>
     * J[\ړ𐧌䂷邽߁AMenuActor<T>::processBehavior() ŁA<BR>
     * _pCursorActor->getVecDriver()->behave(); <BR>
     * sĂ܂BāÃJ[\NXŁA<BR>
     * getVecDriver()->behave(); <BR>
     * sKv͂܂B<BR>
     * @param prm_pCursorActor CJ[\
     * @param prm_x_cursor_adjust j[ACeƂ̏dȂ␳邽߂̉Z鍷XW
     * @param prm_y_cursor_adjust j[ACeƂ̏dȂ␳邽߂̉Z鍷YW
     * @param prm_z_cursor_adjust j[ACeƂ̏dȂ␳邽߂̉Z鍷ZW
     * @param prm_cursor_move_frames CJ[\j[ACeԈړɔ₷t[(ftHg8t[)
     * @param prm_cursor_move_p1 CJ[\ړAj[ACeԈړ̑xO`ōɒB鎞_̊(ftHg0.2)
     * @param prm_cursor_move_p2 CJ[\ړAj[ACeԈړ̍ō猸Jn銄(ftHg0.6)
     */
    virtual void setMainCursor(GgafDx::FigureActor* prm_pCursorActor,
                               coord prm_x_cursor_adjust = 0,
                               coord prm_y_cursor_adjust = 0,
                               coord prm_z_cursor_adjust = 0,
                               int prm_cursor_move_frames = 10,
                               float prm_cursor_move_p1 = 0.2,
                               float prm_cursor_move_p2 = 0.6);

    /**
     * ⏕J[\IuWFNgݒ肷 .
     * yӁz<BR>
     * J[\ړ𐧌䂷邽߁AMenuActor<T>::processBehavior() ŁA<BR>
     * _lstSubCursor.getFromFirst(i)->_pActor->getVecDriver()->behave(); <BR>
     * sĂ܂BāÃJ[\NXŁA<BR>
     * getVecDriver()->behave(); <BR>
     * sKv͂܂B<BR>
     * @param prm_pCursorActor ⏕J[\
     * @param prm_x_cursor_adjust j[ACeƂ̏dȂ␳邽߂̉Z鍷XW
     * @param prm_y_cursor_adjust j[ACeƂ̏dȂ␳邽߂̉Z鍷YW
     * @param prm_z_cursor_adjust j[ACeƂ̏dȂ␳邽߂̉Z鍷ZW
     * @param prm_cursor_move_frames ⏕J[\j[ACeԈړɔ₷t[(ftHg8t[)
     * @param prm_cursor_move_p1 ⏕J[\ړAj[ACeԈړ̑xO`ōɒB鎞_̊(ftHg0.2)
     * @param prm_cursor_move_p2 ⏕J[\ړAj[ACeԈړ̍ō猸Jn銄(ftHg0.6)
     */
    virtual void addSubCursor(GgafDx::FigureActor* prm_pCursorActor,
                              coord prm_x_cursor_adjust = 0,
                              coord prm_y_cursor_adjust = 0,
                              coord prm_z_cursor_adjust = 0,
                              int prm_cursor_move_frames = 10,
                              float prm_cursor_move_p1 = 0.2,
                              float prm_cursor_move_p2 = 0.6);

    /**
     * j[ACeԂ̃I[_[Agݒ(gFrom  To) .
     * addItem(GgafDx::FigureActor*) ɂAǉsƂŁAI<BR>
     * AOA̐`I[_[\zĂ邪A<BR>
     * ̃\bh͂Ƃ͕ʂɃj[ACeԂ́uvAuOvÅ֌Wǉݒ肷B<BR>
     * Ⴆ΁AuvL[ŁuvAuvL[Łu߂vƂɂȂĂƂɁA
     * Ɂuvuv̈ړʓrݒ肷Ƃgp@zB<BR>
     * @param prm_index_of_from_item Ãj[ACẽCfbNX
     * @param prm_index_of_to_item Ãj[ACẽCfbNX
     *                            uvɑΉÃj[ACẽCfbNX
     */
    virtual void relateItemToExNext(int prm_index_of_from_item, int prm_index_of_to_item);

    /**
     * j[ACeԂ̃I[_[Agݒ(item1  item2   item3) .
     * @param prm_index_of_item1 gA郁j[ACẽCfbNX1
     * @param prm_index_of_item2 gA郁j[ACẽCfbNX2
     * @param prm_index_of_item3 gA郁j[ACẽCfbNX3
     */
    virtual void relateItemToExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3 );

    virtual void relateItemToExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3,
                                    int prm_index_of_item4 );

    virtual void relateItemToExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3,
                                    int prm_index_of_item4,
                                    int prm_index_of_item5 );

    virtual void relateItemToExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3,
                                    int prm_index_of_item4,
                                    int prm_index_of_item5,
                                    int prm_index_of_item6 );

//    virtual void relateItemToExNext(int prm_index_of_fromitem, ...);

    /**
     * j[ACeԂ̃I[_[Agݒ(From  gTo) .
     * addItem(GgafDx::FigureActor*) ɂAǉsƂŁAI<BR>
     * AOA̐`I[_[\zĂ邪A<BR>
     * ̃\bh͂Ƃ͕ʂɃj[ACeԂ́uOvAuvÅ֌Wǉݒ肷B<BR>
     * Ⴆ΁AuvL[ŁuvAuvL[Łu߂vƂɂꍇ
     * uvuv̈ړݒ肷Ƃgp@zB<BR>
     * @param prm_index_of_fromitem Ãj[ACẽCfbNX
     * @param prm_index_of_toitem Ãj[ACẽCfbNX
     *                            uOvɑΉÃj[ACẽCfbNX
     */
    virtual void relateItemToExPrev(int prm_index_of_fromitem, int prm_index_of_toitem);

    /**
     * j[ACeSĂɑ΂AuLZij[ACejvւ̃I[_[Agݒ肷 .
     * @param prm_index_of_cancel_item LZij[ACejւ̃j[ACeCfbNX
     */
    virtual void relateAllItemToCancel(int prm_index_of_cancel_item);

    /**
     * j[ɐݒ肳Ă郁CJ[\擾 .
     * @return CJ[\IuWFNg
     */
    virtual GgafDx::FigureActor* getMainCursor();

    /**
     * j[ɐݒ肳Ă⏕J[\擾 .
     * @param prm_subcur_no ⏕J[\ԍ
     * @return ⏕J[\IuWFNg
     */
    virtual GgafDx::FigureActor* getSubCursor(int prm_subcur_no);

    /**
     * CJ[\Łuṽj[ACe(AisActive())ICJ[\ړ .
     * onSelect() R[obN͕K܂B<BR>
     */
    virtual void selectNext();

    /**
     * CJ[\ŁuOṽj[ACe(AisActive())ICJ[\ړ .
     * onSelect() R[obN͕K܂B<BR>
     */
    virtual void selectPrev();

    /**
     * CJ[\Łuiʂ́jṽj[ACe(AisActive())ICJ[\ړ .
     * onSelect() R[obN͕K܂B<BR>
     */
    virtual void selectExNext();

    /**
     * CJ[\Łuiʂ́jOṽj[ACe(AisActive())ICJ[\ړ .
     * onSelect() R[obN͕K܂B<BR>
     */
    virtual void selectExPrev();

    /**
     * CJ[\ŁuLZvj[ACeICJ[\ړ .
     * onSelect() R[obN͕K܂B<BR>
     */
    virtual void selectCancel();

    /**
     * CJ[\Ŏw̃CfbNX̃j[ACeuIvACJ[\ړ .
     * onSelect() R[obN͕K܂B<BR>
     *  moveCursor() R[obNACJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓CJ[\͉ړB<BR>
     * łɁACfbNX̃j[ACeIuWFNgQbgoB<BR>
     * @param prm_index ^[Qbg̃j[ACeCfbNX
     * @return prm_index̃j[ACeIuWFNg
     */
    virtual GgafDx::FigureActor* selectItem(int prm_index, bool prm_smooth = true);

    /**
     * ⏕J[\Ŏw̃CfbNX̃j[ACeuIvA⏕J[\ړ .
    * onSelect() R[obN͔܂B<BR>
     *  moveSubCursor() R[obNACJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓CJ[\͉ړB<BR>
     * łɁACfbNX̃j[ACeIuWFNgQbgoB<BR>
     * @param prm_subcur_no ⏕J[\ԍ
     * @param prm_index ^[Qbg̃j[ACeCfbNX
     * @return prm_index̃j[ACeIuWFNg
     */
    virtual GgafDx::FigureActor* selectItemBySubCursor(int prm_subcur_no, int prm_item_index, bool prm_smooth = true);

    /**
     * CJ[\Ŏw̃j[ACeuIvACJ[\ړ .
     * ̃^[Qbgj[ACẽCfbNX𒲂ׂāAselectItem(index); s܂B
     * @param prm_item ^[Qbgj[ACe
     * @return ^[Qbg̃j[ACeCfbNX
     */
    virtual int selectItem(GgafDx::FigureActor* prm_item, bool prm_smooth = true);

    /**
     * ⏕J[\Ŏw̃j[ACeuIvA⏕J[\ړ .
     *  moveSubCursor() R[obNAJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓J[\͉ړB<BR>
     * łɁAj[ACeIuWFNg̃CfbNXQbgoB<BR>
     * @param prm_subcur_no ⏕J[\ԍ
     * @param prm_item ^[Qbg̃j[ACe
     * @return
     */
    virtual int selectItemBySubCursor(int prm_subcur_no, GgafDx::FigureActor* prm_item, bool prm_smooth = true);

    /**
     * ݃CJ[\I𒆂̃j[ACẽCfbNX擾 .
     * @return I𒆂̃j[ACẽCfbNX
     */
    virtual int getSelectedIndex();

    /**
     * ݕ⏕J[\I𒆂̃j[ACẽCfbNX擾 .
     * @param prm_subcur_no ⏕J[\ԍ
     * @return I𒆂̃j[ACẽCfbNX
     */
    virtual int getSelectedIndexOnSubCursor(int prm_subcur_no);

    /**
     * ݃CJ[\I𒆂̃j[ACẽIuWFNg擾 .
     * @return I𒆂̃j[ACeIuWFNg
     */
    virtual GgafDx::FigureActor* getSelectedItem();

    /**
     * ݕ⏕J[\I𒆂̃j[ACẽIuWFNg擾 .
     * @param prm_subcur_no ⏕J[\ԍ
     * @return I𒆂̃j[ACeIuWFNg
     */
    virtual GgafDx::FigureActor* getSelectedItemOnSubCursor(int prm_subcur_no);

    /**
     * ߋɃCJ[\I𒆂j[ACẽCfbNX擾 .
     * getMvCursorHistoryIndex(0)  getSelectedIndex() ƓłB
     * w̉ߋȂꍇ -1 Ԃ܂B
     * @param prm_n ߋ̃J[\ʒu(0 `)
     * @return I𒆂̃j[ACeIuWFNg̃CfbNXiꍇ -1j
     */
    virtual int getMvCursorHistoryIndex(int prm_n);

    /**
     * uiU镑jvsꂽɁÃj[ACẽCfbNXԂ܂ .
     * ȊO̎  -1 Ԃ܂<BR>
     * j[̑Iڂ肳ꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnDecidedIndex() ̖߂l𖈃t[ׂ邱ƂŁA莞̏Lq邱Ƃ\B<BR>
     *  onDecision() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return 肳ꂽF̃j[ACẽCfbNX(>=0)^肳ĂȂꍇF -1
     */
    virtual int getOnDecidedIndex();

    /**
     * uiU镑jvsꂽɁÃj[ACeԂ܂ .
     * ȊO̎  nullptr Ԃ܂<BR>
     * j[̑Iڂ肳ꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnDecidedItem() ̖߂l𖈃t[ׂ邱ƂŁA莞̏Lq邱Ƃ\B<BR>
     *  onDecision() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return 肳ꂽF̃j[ACe^肳ĂȂꍇF nullptr
     */
    virtual GgafDx::FigureActor* getOnDecidedItem();

    /**
     * uLZiU镑jvsꂽɁÃj[ACẽCfbNXԂ܂ .
     * ȊO̎  -1 Ԃ܂<BR>
     * j[̑IڂLZꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnCancelledIndex() ̖߂l𖈃t[ׂ邱ƂŁALZ̏Lq邱Ƃ\B<BR>
     *  onCancel() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return LZꂽF̃j[ACẽCfbNX(>=0)^LZĂȂꍇF -1
     */
    virtual int getOnCancelledIndex();

    /**
     * uLZiU镑jvsꂽɁÃj[ACeԂ܂ .
     * ȊO̎  -1 Ԃ܂<BR>
     * j[̑IڂLZꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnCancelledItem() ̖߂l𖈃t[ׂ邱ƂŁALZ̏Lq邱Ƃ\B<BR>
     *  onCancel() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return LZꂽF̃j[ACe^LZĂȂꍇF nullptr
     */
    virtual GgafDx::FigureActor* getOnCancelledItem();

    /**
     * IΏۃj[ACẽIuWFNg擾 .
     * @param prm_index 擾IΏۃj[ACẽCfbNX(0`)
     * @return j[ACeIuWFNg
     */
    virtual GgafDx::FigureActor* getItem(int prm_index);

    /**
     * \pj[ACẽIuWFNg擾 .
     * @param prm_index 擾\pj[ACẽCfbNX(0`)
     * @return \pj[ACeIuWFNg
     */
    virtual GgafDx::FigureActor* getLabel(int prm_index);

    /**
     * uiU镑jvAƂ̐ .
     * ʃNXŃI[o[ChāAĂB <BR>
     * (Ⴆ EnterL[ꂽtrueԂ WbN) <BR>
     * t[ condDecision()  condCancel() ̏͂ǂ炩A
     * D揇ʂ́AcondDecision() ̕łB<BR>
     * @return true:uiU镑jv̏ / false:s
     */
    virtual bool condDecision() = 0;

    /**
     * uLZiU镑jvAƂ̐ .
     * ʃNXŃI[o[ChāAĂB<BR>
     * (Ⴆ ESCL[ꂽtrueԂ WbN) <BR>
     * t[ condDecision()  condCancel() ̏͂ǂ炩A
     * D揇ʂ́AcondDecision() ̕łB<BR>
     * @return true:uLZiU镑jv̏ / false:s
     */
    virtual bool condCancel() = 0;

    /**
     * CJ[\ũj[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * (Ⴆ L[ꂽtrueԂ WbN) <BR>
     * @return true:ũj[ACevֈړ̏ / false:s
     */
    virtual bool condSelectNext() = 0;

    /**
     * CJ[\uÕj[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * (Ⴆ L[ꂽtrueԂ WbN) <BR>
     * @return true:uÕj[ACevֈړ̏ / false:s
     */
    virtual bool condSelectPrev() = 0;

    /**
     * CJ[\u̕ʂ̎̃j[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:u̕ʂ̎̃j[ACevֈړ̏ / false:s
     */
    virtual bool condSelectExNext() = 0;

    /**
     * CJ[\u̕ʂ̑Õj[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:u̕ʂ̑Õj[ACevֈړ̏ / false:s
     */
    virtual bool condSelectExPrev() = 0;

    /**
     * CJ[\uLZij[ACejv֔ԏ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:uLZij[ACejvֈړ̏ / false:s
     */
    virtual bool condSelectCancel() = 0;

    /**
     * uiU镑jvꂽꍇɌĂяoR[obNB
     * I[o[ChĎĂB<BR>
     * j[̑Iڂ肳ꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior() ŁAgetOnDecidedIndex() ̖߂l𖈃t[ׂ邱ƂŁA莞̏Lq邱Ƃ\B<BR>
     *  onDecision() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B
     * @param prm_pItem 肳ꂽj[ACe
     * @param prm_item_index 肳ꂽj[ACẽCfbNX
     */
    virtual void onDecision(GgafDx::FigureActor* prm_pItem, int prm_item_index) = 0;

    /**
     * uLZiU镑jvꂽꍇɌĂяoR[obNB .
     * I[o[ChĎĂB<BR>
     * j[̑IڂLZꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior() ŁAgetCancelIndex() ̖߂l𖈃t[ׂ邱ƂŁALZ̏Lq邱Ƃ\B<BR>
     *  onCancel() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B
     * @param prm_pItem
     * @param prm_item_index
     */
    virtual void onCancel(GgafDx::FigureActor* prm_pItem, int prm_item_index) = 0;

    /**
     * CJ[\ړꍇɌĂяoR[obNB .
     * I[o[ChĎĂB<BR>
     * yߑz<BR>
     * onMoveCursor(int,int)  onSelect(int,int) ̃R[obN^C~O̍ɂāB<BR>
     * onMoveCursor(int,int) ́AselectXxxxx ñ\bhs̍ہAJ[\ړꍇ̂݌Ăяo܂B<BR>
     * onSelect(int,int) ́AselectXxxxx n ̃\bhsɁAȂĂяo܂(ƂAJ[\ړȂĂ)<BR>
     * Ăяo鏇́AonMoveCursor(int,int)   onSelect(int,int) ̏łB<BR>
     * @param prm_from_index ړ̃j[ACẽCfbNXiíjꍇ -1j
     * @param prm_selected_index   ړ̃j[ACẽCfbNX
     */
    virtual void onMoveCursor(int prm_from_index, int prm_selected_index) = 0;

    /**
     * CJ[\j[ACeIꂽꍇɌĂяoR[obNB .
     * I[o[ChĎĂB<BR>
     * yߑz<BR>
     * onMoveCursor(int,int)  onSelect(int,int) ̃R[obN^C~O̍ɂāB<BR>
     * onMoveCursor(int,int) ́AselectXxxxx ñ\bhs̍ہAJ[\ړꍇ̂݌Ăяo܂B<BR>
     * onSelect(int,int) ́AselectXxxxx n ̃\bhsɁAȂĂяo܂(ƂAJ[\ړȂĂ)<BR>
     * Ăяo鏇́AonMoveCursor(int,int)   onSelect(int,int) ̏łB<BR>
     * @param prm_from_index     IiIOj̃j[ACẽCfbNXiíjꍇ -1j
     * @param prm_selected_index Ĩj[ACẽCfbNX
     */
    virtual void onSelect(int prm_from_index, int prm_selected_index) = 0;


    /**
     * j[\Jn .
     * {IuWFNg𐶐A^XNɒǉA\^C~OŎsĂB<BR>
     */
    virtual void riseMe();

    /**
     * j[\JñR[obN .
     * riseMe() sAP񂾂R[obN܂B<BR>
     * KvɉăI[o[ChĂB<BR>
     */
    virtual void onRise();

    /**
     * j[\gWV .
     * riseMe() s ` tF[hC܂ł̊ԃR[ꑱ܂B
     * At@ZtF[hCʂsAAt@1.0ɂȂΏIB
     * ƂgWVς݂łB<BR>
     * gWVƎɍsꍇ̓I[o[ChAgWV<BR>
     * _with_rising = false;<BR>
     * sĂB<BR>
     */
    virtual void processRising();

    /**
     * j[\̃R[obN .
     * KvɉăI[o[ChĂB<BR>
     */
    virtual void onRiseDone();

    /**
     * ԃtOXVǉ̂߃I[o[Ch .
     *  T::nextFrame(); R[Ă܂B
     */
    virtual void nextFrame() override;

    /**
     * j[̐U镑 .
     * J[\̈ړyсAj[ACeƃJ[\j[̍̕WɒǏ]
     * ς݂łB<BR>
     * j[̐U镑ǉꍇ́AI[o[ChāA
     * ɏ processBehavior() ĂяôYȂ悤ɁB<BR>
     */
    virtual void processBehavior() override;

    /**
     * j[ďI .
     */
    virtual void sinkMe();

    /**
     * riseMe()sꂽォۂԂ .
     * @return true:x riseMe() sꂽł/false:ł͂Ȃ
     */
    virtual bool hasJustRisen() {
        return _is_just_risen;
    }

    /**
     * sinkMe() sꂽォۂԂ .
     * @return true:x sinkMe() sꂽł/false:ł͂Ȃ
     */
    virtual bool hasJustSunk() {
        return _is_just_sunk;
    }

    /**
     * uiU镑jvsꂽォۂԂ .
     * @return rue:x uiU镑jv sꂽł/false:ł͂Ȃ
     */
    virtual bool hasJustDecided() {
        if (_is_just_decided && _can_controll) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * uLZiU镑jvsꂽォۂԂ .
     * @return rue:x uLZiU镑jv sꂽł/false:ł͂Ȃ
     */
    virtual bool hasJustCancelled() {
        if (_is_just_cancelled && _can_controll) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * j[JñR[obN .
     * sinkMe() sAP񂾂R[obN܂B<BR>
     * KvɉăI[o[ChĂB<BR>
     */
    virtual void onSink();

    /**
     * j[̃gWV .
     * sinkMe() s ` tF[hAEg܂ł̊ԃR[ꑱ܂B
     * At@ZtF[hAEgʂsAAt@1.0ɂȂΏI
     * ƂgWVς݂łB<BR>
     * gWVƎɍsꍇ̓I[o[ChAgWV<BR>
     * _with_sinking = false;<BR>
     * T::inactivateTreeImmed();<BR>
     * sĂB<BR>
     */
    virtual void processSinking();

    /**
     * j[̃R[obN .
     * processSinking()A_with_sinking = false; ɂȂuԂɃR[܂B
     * KvɉăI[o[ChĂB<BR>
     */
    virtual void onSinkDone();

    /**
     * Tuj[ǉB
     * @param prm_pSubMenu Tuj[
     */
    virtual void addSubMenu(MenuActor<T>* prm_pSubMenu);

    /**
     * ej[Ԃ .
     * @return ej[
     */
    virtual MenuActor<T>* getParentMenu();

    /**
     * Tuj[擾 .
     * O addSubMenu() ŃTuj[ݒ肷Kv܂B<BR>
     * @param prm_index Tuj[̃CfbNX
     * @return
     */
    virtual MenuActor<T>* getSubMenu(int prm_index = 0);

    /**
     * ݃ANeBuȃTuj[擾 .
     * Tuj[o^̏ꍇB͓o^ĂĂAANeBuł͂Ȃꍇ nullptr ԂB
     * @return ANeBuȃTuj[/nullptr
     */
    virtual MenuActor<T>* getRisingSubMenu();

    /**
     * Tuj[ANeBuɂĕ\ .
     * O addSubMenu() ŃTuj[ݒ肷Kv܂B<BR>
     * ܂A{\bhɂ茻݃ANeBuȃTuj[(getRisingSubMenu())́A
     * CfbNX̃j[ɕύX܂B
     * Tuj[\ƁATuj[(sinkCurrentSubMenu()) ܂ŁA
     * Ăяoj[͑s\ɂȂ܂B
     * @param prm_index ANeBuɂTuj[̃CfbNX
     * @return ̃Tuj[
     */
    virtual MenuActor<T>* riseSubMenu(int prm_index = 0);

    /**
     * ݃ANeBuȃTuj[ďI .
     * O addSubMenu() ŃTuj[ݒ肷Kv܂B<BR>
     */
    virtual void sinkCurrentSubMenu();

    virtual ~MenuActor();
};


template<class T>
MenuActor<T>::MenuActor(const char* prm_name, const char* prm_model) :
  T(prm_name, prm_model),_lstItems(3) { //Sj[ACe}RǉFȗvȗOvuLZv̂R
    T::_class_name = "MenuActor";

    _fade_frames = 0;
    _velo_alpha_fade = 1.0;

    _with_rising = false;
    _with_sinking = false;
    _is_just_risen = false;
    _is_just_sunk = false;
    _is_just_decided = false;
    _is_just_cancelled = false;
    _will_be_rising_next_frame = false;
    _will_be_sinking_next_frame = false;
    _will_be_just_decided_next_frame = false;
    _will_be_just_cancelled_next_frame = false;
    _can_controll = false;
    _will_be_able_to_controll = false;

    _cursor_move_frames = 10;
    _cursor_move_p1 = 0.2;
    _cursor_move_p2 = 0.7;
    _x_cursor_target_prev = T::_x;
    _y_cursor_target_prev = T::_y;
    _z_cursor_target_prev = T::_z;
    _pCursorActor = nullptr;
    _x_cursor_adjust = 0;
    _y_cursor_adjust = 0;
    _z_cursor_adjust = 0;

    for (int i = 0; i < 10; i++) {
        _lstMvCursorHistory.addLast(new int(-1), true);
        _lstMvSelectHistory.addLast(new int(-1), true);
    }
    _lstMvCursorHistory.createIndex();
    _lstMvSelectHistory.createIndex();
    T::inactivate(); //j[Ȃ̂ŁAԂ͔񊈓ԂftHgƂ
}

template<class T>
void MenuActor<T>::nextFrame() {
    T::nextFrame();
    if (T::_can_live_flg) {
        _is_just_risen = false;
        if (_will_be_rising_next_frame) {
            _with_rising = true;
            _is_just_risen = true;
            _will_be_rising_next_frame = false;
            onRise();
        }

        _is_just_sunk = false;
        if (_will_be_sinking_next_frame) {
            _with_sinking = true;
            _is_just_sunk = true;
            _will_be_sinking_next_frame = false;
            onSink();
        }

        if (_will_be_just_decided_next_frame && _can_controll) {
            _is_just_decided = true;
            _will_be_just_decided_next_frame = false;
            onDecision(_lstItems.getCurrent(), _lstItems.getCurrentIndex());
        } else {
            _is_just_decided = false;
            _will_be_just_decided_next_frame = false;
        }

        if (_will_be_just_cancelled_next_frame && _can_controll) {
            _is_just_cancelled = true;
            _will_be_just_cancelled_next_frame = false;
            onCancel(_lstItems.getCurrent(), _lstItems.getCurrentIndex());
        } else {
            _is_just_cancelled = false;
            _will_be_just_cancelled_next_frame = false;
        }

        _can_controll = _will_be_able_to_controll;
    }
}

template<class T>
void MenuActor<T>::addItem(GgafDx::FigureActor* prm_pItem,
                           coord prm_x_local, coord prm_y_local, coord prm_z_local) {
    prm_pItem->_x_local = prm_x_local;
    prm_pItem->_y_local = prm_y_local;
    prm_pItem->_z_local = prm_z_local;
    prm_pItem->setAlpha(T::_alpha); //LB
    prm_pItem->inactivate();
    _lstItems.addLast(prm_pItem, false);
    T::appendChild(prm_pItem);
}

template<class T>
void MenuActor<T>::setPositionItem(int prm_index_of_item, coord prm_x_local, coord prm_y_local, coord prm_z_local) {
    GgafDx::FigureActor* p = getItem(prm_index_of_item);
    p->_x_local = prm_x_local;
    p->_y_local = prm_y_local;
    p->_z_local = prm_z_local;
}

template<class T>
void MenuActor<T>::addLabel(GgafDx::FigureActor* prm_pLabel,
                           coord prm_x_local, coord prm_y_local, coord prm_z_local) {
    prm_pLabel->_x_local = prm_x_local;
    prm_pLabel->_y_local = prm_y_local;
    prm_pLabel->_z_local = prm_z_local;
    prm_pLabel->setAlpha(T::_alpha); //LB
    prm_pLabel->inactivate();
    _lstLabelActors.addLast(prm_pLabel, false);
    T::appendChild(prm_pLabel);
}

template<class T>
void MenuActor<T>::setPositionLabel(int prm_index_of_label, coord prm_x_local, coord prm_y_local, coord prm_z_local) {
    GgafDx::FigureActor* p = getLabel(prm_index_of_label);
    p->_x_local = prm_x_local;
    p->_y_local = prm_y_local;
    p->_z_local = prm_z_local;
}

template<class T>
void MenuActor<T>::relateItemToExNext(int prm_index_of_from_item, int prm_index_of_to_item) {
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElemFrom =
            _lstItems.getElemFromFirst(prm_index_of_from_item);
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElemTo =
            _lstItems.getElemFromFirst(prm_index_of_to_item);
    pElemFrom->connect(ITEM_RELATION_EX_NEXT, pElemTo);
    pElemTo->connect(ITEM_RELATION_EX_PREV, pElemFrom);
}

template<class T>
void MenuActor<T>::relateItemToExNext(int prm_index_of_item1,
                                      int prm_index_of_item2,
                                      int prm_index_of_item3 ) {
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElem1 =
            _lstItems.getElemFromFirst(prm_index_of_item1);
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElem2 =
            _lstItems.getElemFromFirst(prm_index_of_item2);
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElem3 =
            _lstItems.getElemFromFirst(prm_index_of_item3);
    pElem1->connect(ITEM_RELATION_EX_NEXT, pElem2);
    pElem2->connect(ITEM_RELATION_EX_NEXT, pElem3);
    pElem3->connect(ITEM_RELATION_EX_PREV, pElem2);
    pElem2->connect(ITEM_RELATION_EX_PREV, pElem1);
}

template<class T>
void MenuActor<T>::relateItemToExNext(int prm_index_of_item1,
                                      int prm_index_of_item2,
                                      int prm_index_of_item3,
                                      int prm_index_of_item4 ) {
    relateItemToExNext(prm_index_of_item1, prm_index_of_item2, prm_index_of_item3);
    relateItemToExNext(prm_index_of_item3, prm_index_of_item4);
}

template<class T>
void MenuActor<T>::relateItemToExNext(int prm_index_of_item1,
                                      int prm_index_of_item2,
                                      int prm_index_of_item3,
                                      int prm_index_of_item4,
                                      int prm_index_of_item5 ) {
    relateItemToExNext(prm_index_of_item1, prm_index_of_item2, prm_index_of_item3);
    relateItemToExNext(prm_index_of_item3, prm_index_of_item4, prm_index_of_item5);
}

template<class T>
void MenuActor<T>::relateItemToExNext(int prm_index_of_item1,
                                      int prm_index_of_item2,
                                      int prm_index_of_item3,
                                      int prm_index_of_item4,
                                      int prm_index_of_item5,
                                      int prm_index_of_item6 ) {
    relateItemToExNext(prm_index_of_item1, prm_index_of_item2, prm_index_of_item3);
    relateItemToExNext(prm_index_of_item3, prm_index_of_item4, prm_index_of_item5);
    relateItemToExNext(prm_index_of_item5, prm_index_of_item6);
}


//template<class T>
//void MenuActor<T>::relateItemToExNext(int prm_index_of_fromitem, ...) {
//    va_list pArg;
//    va_start(pArg, prm_index_of_fromitem);         //ϒJn
//        va_arg( argptr, int );
//
//
//
//    va_end(pArg);      //ϒI
//}


template<class T>
void MenuActor<T>::relateItemToExPrev(int prm_index_of_fromitem, int prm_index_of_toitem) {
    _lstItems.getElemFromFirst(prm_index_of_fromitem)->connect(
            ITEM_RELATION_EX_PREV, _lstItems.getElemFromFirst(prm_index_of_toitem));
    _lstItems.getElemFromFirst(prm_index_of_toitem)->connect(
            ITEM_RELATION_EX_NEXT, _lstItems.getElemFromFirst(prm_index_of_fromitem));
}

template<class T>
void MenuActor<T>::relateAllItemToCancel(int prm_index_of_cancel_item) {
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pCancelElem =
            _lstItems.getElemFromFirst(prm_index_of_cancel_item);
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElem =
            _lstItems.getElemFirst();
    int n = _lstItems.length();
    for (int i = 0; i < n; i++) {
        pElem->connect(ITEM_RELATION_TO_CANCEL, pCancelElem);
        pElem = pElem->_pNext;
    }
}


template<class T>
GgafDx::FigureActor* MenuActor<T>::selectItem(int prm_index, bool prm_smooth) {
    int n = getSelectedIndex();
#ifdef MY_DEBUG
    if (n == -1) {
        throwCriticalException("MenuActor<T>::selectItem() j[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_index="<<prm_index);
    }
#endif
    if (n == prm_index) {
        //ɑIĂB
        *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
        onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
        return _lstItems.getCurrent();
    } else {
#ifdef MY_DEBUG
        if (_lstItems.length() <= prm_index) {
            throwCriticalException("MenuActor<T>::selectItem() j[ACevfI[o[ name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_index="<<prm_index);
        }
#endif
        GgafDx::FigureActor* pTargetItem = _lstItems.current(prm_index); //ŃZNgI
        if (T::getActiveFrame() > 1) {
            moveCursor(prm_smooth);  //X[Yړ͈
        } else {
            moveCursor(false); //X[Yړ(ÏׂselectItem)
        }
        *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
        onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
        return pTargetItem;
    }
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::selectItemBySubCursor(int prm_subcur_no, int prm_item_index, bool prm_smooth) {
    int n = getSelectedIndexOnSubCursor(prm_subcur_no);
#ifdef MY_DEBUG
    if (n == -1) {
        throwCriticalException("MenuActor<T>::selectItemBySubCursor() j[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item_index="<<prm_item_index);
    }
#endif
    //⏕J[\̓R[obNȂ
    if (n == prm_item_index) {
        //ɑIĂB
        return _lstItems.getFromFirst(n);
    } else {
#ifdef MY_DEBUG
        if (_lstItems.length() <= prm_item_index) {
            throwCriticalException("MenuActor<T>::selectItemBySubCursor() j[ACevfI[o[ name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item_index="<<prm_item_index);
        }
#endif
        _lstSubCursor.getFromFirst(prm_subcur_no)->_select_index = prm_item_index; //ŃZNgI
        GgafDx::FigureActor* pTargetItem = _lstItems.getFromFirst(prm_item_index);

        if (T::getActiveFrame() > 1) {
            moveSubCursor(prm_subcur_no, prm_smooth);  //X[Yړ͈ˑ
        } else {
            moveSubCursor(prm_subcur_no, false); //X[Yړ(ÏׂselectItem)
        }
        return pTargetItem;
    }
}

template<class T>
int MenuActor<T>::selectItem(GgafDx::FigureActor* prm_item, bool prm_smooth) {
    int index = _lstItems.indexOf(prm_item);
    if (index == -1) {
        throwCriticalException("MenuActor<T>::selectItem() ̑OɃj[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item="<<prm_item->getName());
    }
    selectItem(index, prm_smooth);
    return index;
}

template<class T>
int MenuActor<T>::selectItemBySubCursor(int prm_subcur_no, GgafDx::FigureActor* prm_item, bool prm_smooth) {
    int index = _lstItems.indexOf(prm_item);
    if (index == -1) {
        throwCriticalException("MenuActor<T>::selectItemBySubCursor() ̑OɃj[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item="<<prm_item->getName());
    }
    selectItemBySubCursor(index, prm_subcur_no, prm_smooth);
    return index;
}

template<class T>
void MenuActor<T>::setMainCursor(GgafDx::FigureActor* prm_pCursorActor,
                                 coord prm_x_cursor_adjust,
                                 coord prm_y_cursor_adjust,
                                 coord prm_z_cursor_adjust,
                                 int prm_cursor_move_frames,
                                 float prm_cursor_move_p1,
                                 float prm_cursor_move_p2) {
    _pCursorActor = prm_pCursorActor;
    _pCursorActor->setAlpha(T::_alpha);
    _pCursorActor->inactivate();
    T::appendChild(_pCursorActor);
    _x_cursor_adjust = prm_x_cursor_adjust;
    _y_cursor_adjust = prm_y_cursor_adjust;
    _z_cursor_adjust = prm_z_cursor_adjust;
    _cursor_move_frames = prm_cursor_move_frames;
    _cursor_move_p1 = prm_cursor_move_p1;
    _cursor_move_p2 = prm_cursor_move_p2;
    selectItem(0);
}

template<class T>
void MenuActor<T>::addSubCursor(GgafDx::FigureActor* prm_pCursorActor,
                                 coord prm_x_cursor_adjust,
                                 coord prm_y_cursor_adjust,
                                 coord prm_z_cursor_adjust,
                                 int prm_cursor_move_frames,
                                 float prm_cursor_move_p1,
                                 float prm_cursor_move_p2) {
    MenuActor<T>::SubCursor* pSubCursor = NEW MenuActor<T>::SubCursor();
    pSubCursor->_pActor = prm_pCursorActor;
    pSubCursor->_pActor->setAlpha(T::_alpha);
    pSubCursor->_pActor->inactivate();
    pSubCursor->_select_index = 0;
    pSubCursor->_x_adjust = prm_x_cursor_adjust;
    pSubCursor->_y_adjust = prm_y_cursor_adjust;
    pSubCursor->_z_adjust = prm_z_cursor_adjust;
    pSubCursor->_move_frames = prm_cursor_move_frames;
    pSubCursor->_move_p1 = prm_cursor_move_p1;
    pSubCursor->_move_p2 = prm_cursor_move_p2;
    _lstSubCursor.addLast(pSubCursor, true);
    T::appendChild(pSubCursor->_pActor);
    selectItemBySubCursor(0, _lstSubCursor.length()-1);
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getMainCursor() {
    return _pCursorActor;
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getSubCursor(int prm_subcur_no) {
    return _lstSubCursor.getFromFirst(prm_subcur_no)->_pActor;
}

template<class T>
int MenuActor<T>::getSelectedIndex() {
    return _lstItems.getCurrentIndex();
}

template<class T>
int MenuActor<T>::getSelectedIndexOnSubCursor(int prm_subcur_no) {
    return _lstSubCursor.getFromFirst(prm_subcur_no)->_select_index;
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getSelectedItem() {
    return _lstItems.getCurrent();
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getSelectedItemOnSubCursor(int prm_subcur_no) {
    return _lstItems.getFromFirst(getSelectedIndexOnSubCursor(prm_subcur_no));
}

template<class T>
int MenuActor<T>::getMvCursorHistoryIndex(int prm_n) {
    return (*(_lstMvCursorHistory.getPrev(prm_n)));
}

template<class T>
int MenuActor<T>::getOnDecidedIndex() {
    if (_is_just_decided) {
        return _lstItems.getCurrentIndex();
    } else {
        return -1;
    }
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getOnDecidedItem() {
    if (_is_just_decided) {
        return _lstItems.getCurrent();
    } else {
        return nullptr;
    }
}

template<class T>
int MenuActor<T>::getOnCancelledIndex() {
    if (_is_just_cancelled) {
        return _lstItems.getCurrentIndex();
    } else {
        return -1;
    }
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getOnCancelledItem() {
    if (_is_just_cancelled) {
        return _lstItems.getCurrent();
    } else {
        return nullptr;
    }
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getItem(int prm_index) {
#ifdef MY_DEBUG
    if (_lstItems.length() <= prm_index) {
        throwCriticalException("MenuActor<T>::getItem() j[ACevfI[o[ name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_index="<<prm_index);
    }
#endif
    return _lstItems.getFromFirst(prm_index);
}

template<class T>
GgafDx::FigureActor* MenuActor<T>::getLabel(int prm_index) {
#ifdef MY_DEBUG
    if (_lstLabelActors.length() <= prm_index) {
        throwCriticalException("MenuActor<T>::getLabel() \j[xj[ACevfI[o[ name="<<T::getName()<<" _lstLabelActors.length()="<<_lstLabelActors.length()<<" prm_index="<<prm_index);
    }
#endif
    return _lstLabelActors.getFromFirst(prm_index);
}


template<class T>
void MenuActor<T>::selectNext() {
    GgafDx::FigureActor* pCurrent = _lstItems.getCurrent();
    if (_pCursorActor) {
        _pCursorActor->setPositionAt(pCurrent);
    }
    GgafDx::FigureActor* pNext;
    while(true) {
        pNext = _lstItems.next();
        if (pNext->isActive()) {
            break;
        } else {
            if (pNext == pCurrent) {
                break;
            }
        }
    }
    moveCursor();
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectPrev() {
    GgafDx::FigureActor* pCurrent = _lstItems.getCurrent();
    if (_pCursorActor) {
        _pCursorActor->setPositionAt(pCurrent);
    }
    GgafDx::FigureActor* pPrev;
    while(true) {
        pPrev = _lstItems.prev();
        if (pPrev->isActive()) {
            break;
        } else {
            if (pPrev == pCurrent) {
                break;
            }
        }
    }
    moveCursor();
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectExNext() {
    if (_lstItems.getRelation(ITEM_RELATION_EX_NEXT)) {
        GgafDx::FigureActor* pCurrent = _lstItems.getCurrent();
        if (_pCursorActor) {
            _pCursorActor->setPositionAt(pCurrent);
        }
        GgafDx::FigureActor* pRelation;
        while(true) {
            pRelation = _lstItems.gotoRelation(ITEM_RELATION_EX_NEXT);
            if (pRelation->isActive()) {
                break;
            } else {
                if (pRelation == pCurrent) {
                    break;
                }
            }
        }
        moveCursor();
    }
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectExPrev() {
    if (_lstItems.getRelation(ITEM_RELATION_EX_PREV)) {
        GgafDx::FigureActor* pCurrent = _lstItems.getCurrent();
        if (_pCursorActor) {
            _pCursorActor->setPositionAt(pCurrent);
        }
        GgafDx::FigureActor* pRelation;
        while(true) {
            pRelation = _lstItems.gotoRelation(ITEM_RELATION_EX_PREV);
            if (pRelation->isActive()) {
                break;
            } else {
                if (pRelation == pCurrent) {
                    break;
                }
            }
        }
        moveCursor();
    } else {

    }
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectCancel() {
    if (_lstItems.getRelation(ITEM_RELATION_TO_CANCEL)) {
        if (_pCursorActor) {
            _pCursorActor->setPositionAt(_lstItems.getCurrent());
        }
        _lstItems.gotoRelation(ITEM_RELATION_TO_CANCEL);
        moveCursor();
    } else {

    }
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::moveCursor(bool prm_smooth) {
    if (_pCursorActor) {
        GgafDx::FigureActor* pTargetItem = _lstItems.getCurrent();
        GgafDx::VecDriver* pCursorActor_pVecDriver = _pCursorActor->getVecDriver();
        if (prm_smooth) {
            pCursorActor_pVecDriver->setMvAngTwd(
                                    pTargetItem->_x + _x_cursor_adjust,
                                    pTargetItem->_y + _y_cursor_adjust,
                                    pTargetItem->_z + _z_cursor_adjust
                                  );
            pCursorActor_pVecDriver->stopMv();
            pCursorActor_pVecDriver->asstMv()->slideByDt(
                                    UTIL::getDistance(_pCursorActor->_x,
                                                      _pCursorActor->_y,
                                                      _pCursorActor->_z,
                                                      pTargetItem->_x + _x_cursor_adjust,
                                                      pTargetItem->_y + _y_cursor_adjust,
                                                      pTargetItem->_z + _z_cursor_adjust ),
                                    _cursor_move_frames,
                                    _cursor_move_p1, _cursor_move_p2, 0 , true
                                  );
            _x_cursor_target_prev = pTargetItem->_x;
            _y_cursor_target_prev = pTargetItem->_y;
            _z_cursor_target_prev = pTargetItem->_z;
        } else {
            pCursorActor_pVecDriver->asstMv()->stopSliding();
            pCursorActor_pVecDriver->stopMv();
            _pCursorActor->_x = pTargetItem->_x + _x_cursor_adjust;
            _pCursorActor->_y = pTargetItem->_y + _y_cursor_adjust;
            _pCursorActor->_z = pTargetItem->_z + _z_cursor_adjust;
        }
        *(_lstMvCursorHistory.next()) = _lstItems.getCurrentIndex();
        onMoveCursor(*(_lstMvCursorHistory.getPrev()), *(_lstMvCursorHistory.getCurrent())); //R[obN
    }
}


template<class T>
void MenuActor<T>::moveSubCursor(int prm_subcur_no, bool prm_smooth) {
    if (_lstSubCursor.length() > 0) {
        GgafDx::FigureActor* pTargetItem = getSelectedItemOnSubCursor(prm_subcur_no);
        SubCursor* pSubCursor = _lstSubCursor.getFromFirst(prm_subcur_no);
        GgafDx::FigureActor* pSubCursorActor = pSubCursor->_pActor;
        GgafDx::VecDriver* pSubCursorActor_pVecDriver = pSubCursorActor->getVecDriver();
        if (prm_smooth) {
            pSubCursorActor_pVecDriver->setMvAngTwd(
                                         pTargetItem->_x + pSubCursor->_x_adjust,
                                         pTargetItem->_y + pSubCursor->_y_adjust,
                                         pTargetItem->_z + pSubCursor->_z_adjust
                                     );
            pSubCursorActor_pVecDriver->stopMv();
            pSubCursorActor_pVecDriver->asstMv()->slideByDt(
                                      UTIL::getDistance(pSubCursorActor->_x,
                                                        pSubCursorActor->_y,
                                                        pSubCursorActor->_z,
                                                        pTargetItem->_x + pSubCursor->_x_adjust,
                                                        pTargetItem->_y + pSubCursor->_y_adjust,
                                                        pTargetItem->_z + pSubCursor->_z_adjust ),
                                      pSubCursor->_move_frames,
                                      pSubCursor->_move_p1, pSubCursor->_move_p2, 0 , true
                                    );
            pSubCursor->_x_target_prev = pTargetItem->_x;
            pSubCursor->_y_target_prev = pTargetItem->_y;
            pSubCursor->_z_target_prev = pTargetItem->_z;
        } else {
            pSubCursorActor_pVecDriver->asstMv()->stopSliding();
            pSubCursorActor_pVecDriver->stopMv();
            pSubCursorActor->_x = pTargetItem->_x + pSubCursor->_x_adjust;
            pSubCursorActor->_y = pTargetItem->_y + pSubCursor->_y_adjust;
            pSubCursorActor->_z = pTargetItem->_z + pSubCursor->_z_adjust;
        }
    }
}

template<class T>
void MenuActor<T>::riseMe() {
    _with_rising = false;
    _with_sinking = false;
    _is_just_risen = false;
    _is_just_sunk = false;
    _will_be_rising_next_frame = true;
    _will_be_sinking_next_frame = false;
    enableControll();
    if (_velo_alpha_fade >= 1.0) {
        T::setAlpha(1.0);
    } else {
        T::setAlpha(0.0);
    }
    T::activate();
    //j[ACezu
    GgafDx::FigureActor* p;
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElem = _lstItems.getElemFirst();
    int n_i = _lstItems.length();
    for (int i = 0; i < n_i; i++) {
        p = pElem->getValue();
        p->setPosition(T::_x + p->_x_local,
                       T::_y + p->_y_local,
                       T::_z + p->_z_local);
        p->setAlpha(T::getAlpha());
        p->activate();
        pElem = pElem->_pNext;
    }
    //\j[ACezu
    pElem = _lstLabelActors.getElemFirst();
    int n_da = _lstLabelActors.length();
    for (int i = 0; i < n_da; i++) {
        p = pElem->getValue();
        p->setPosition(T::_x + p->_x_local,
                       T::_y + p->_y_local,
                       T::_z + p->_z_local);
        p->setAlpha(T::getAlpha());
        p->activate();
        pElem = pElem->_pNext;
    }

    if (_pCursorActor) {
        _pCursorActor->setAlpha(T::getAlpha());
        _pCursorActor->activate();
    }
    int n_sc = _lstSubCursor.length();
    for (int i = 0; i < n_sc; i++) {
        GgafDx::FigureActor* pSubCursorActor = _lstSubCursor.getFromFirst(i)->_pActor;
        pSubCursorActor->setAlpha(T::getAlpha());
        pSubCursorActor->activate();
    }
}

template<class T>
void MenuActor<T>::onRise() {
}

template<class T>
void MenuActor<T>::processRising() {
    T::addAlpha(_velo_alpha_fade);
    if (T::getAlpha() >= 1.0) {
        T::setAlpha(1.0);
        _with_rising = false;
        onRiseDone();
    }
}

template<class T>
void MenuActor<T>::onRiseDone() {
}

template<class T>
void MenuActor<T>::processBehavior() {
    if (_with_sinking) {
        processSinking();
    }
    if (_with_rising) {
        processRising();
    }
    frame active_frames = T::getActiveFrame();
    if (active_frames == 1) {
        onSelect(-1, *(_lstMvSelectHistory.getCurrent())); //R[obN
    }
    if (_can_controll && active_frames > 1) {
        if (condDecision()) {
            _will_be_just_decided_next_frame = true;
        } else if (condCancel()) {
            _will_be_just_cancelled_next_frame = true;
        } else if (condSelectNext()) {
            selectNext();
        } else if (condSelectPrev()) {
            selectPrev();
        } else if (condSelectExNext()) {
            selectExNext();
        } else if (condSelectExPrev()) {
            selectExPrev();
        } else if (condSelectCancel()) {
            selectCancel();
        }
    }

    if (_pCursorActor) {
        _pCursorActor->getVecDriver()->behave();
        //CJ[\ŁA_pVecDriver->behave() Ȃ悤ɒ
    }
    int n_sc = _lstSubCursor.length();
    for (int i = 0; i < n_sc; i++) {
        SubCursor* pSubCursor = _lstSubCursor.getFromFirst(i);
        pSubCursor->_pActor->getVecDriver()->behave();
        //⏕J[\ŁA_pVecDriver->behave() Ȃ悤ɒ
    }

    //j[ACej[ɒǏ]
    GgafDx::FigureActor* p;
    GgafCore::LinkedListRing<GgafDx::FigureActor>::Elem* pElem = _lstItems.getElemFirst();
    int n_i = _lstItems.length();
    for (int i = 0; i < n_i; i++) {
        p = pElem->getValue();
        p->setPosition(T::_x + p->_x_local,
                       T::_y + p->_y_local,
                       T::_z + p->_z_local);
        if (_with_sinking) {
            if (T::getAlpha() < p->getAlpha()) {
                p->setAlpha(T::getAlpha());
            }
        } else if (_with_rising) {
            if (T::getAlpha() > p->getAlpha()) {
                p->setAlpha(T::getAlpha());
            }
        }
        pElem = pElem->_pNext;
    }

    //\j[ACej[ɒǏ]
    pElem = _lstLabelActors.getElemFirst();
    int n_da = _lstLabelActors.length();
    for (int i = 0; i < n_da; i++) {
        p = pElem->getValue();
        p->setPosition(T::_x + p->_x_local,
                       T::_y + p->_y_local,
                       T::_z + p->_z_local);
        if (_with_sinking) {
            if (T::getAlpha() < p->getAlpha()) {
                p->setAlpha(T::getAlpha());
            }
        } else if (_with_rising) {
            if (T::getAlpha() > p->getAlpha()) {
                p->setAlpha(T::getAlpha());
            }
        }
        pElem = pElem->_pNext;
    }

    //CJ[\j[ACeɒǏ]
    if (_pCursorActor) {
        GgafDx::FigureActor* pTargetItem = _lstItems.getCurrent();
        if (_pCursorActor->getVecDriver()->asstMv()->isSliding()) {
            _pCursorActor->_x += (pTargetItem->_x - _x_cursor_target_prev);
            _pCursorActor->_y += (pTargetItem->_y - _y_cursor_target_prev);
            _pCursorActor->_z += (pTargetItem->_z - _z_cursor_target_prev);
            _x_cursor_target_prev = pTargetItem->_x;
            _y_cursor_target_prev = pTargetItem->_y;
            _z_cursor_target_prev = pTargetItem->_z;
        } else {
            _pCursorActor->setPosition(pTargetItem->_x + _x_cursor_adjust,
                                       pTargetItem->_y + _y_cursor_adjust,
                                       pTargetItem->_z + _z_cursor_adjust );
        }
        if (_with_sinking) {
            if (T::getAlpha() < _pCursorActor->getAlpha()) {
                _pCursorActor->setAlpha(T::getAlpha());
            }
        } else if (_with_rising) {
            if (T::getAlpha() > _pCursorActor->getAlpha()) {
                _pCursorActor->setAlpha(T::getAlpha());
            }
        }
    }

    //⏕J[\j[ACeɒǏ]
    for (int i = 0; i < n_sc; i++) {
        SubCursor* pSubCursor = _lstSubCursor.getFromFirst(i);
        GgafDx::FigureActor* pTargetItem = _lstItems.getFromFirst(pSubCursor->_select_index);
        GgafDx::FigureActor* pSubCursorActor = pSubCursor->_pActor;
        if (pSubCursorActor->getVecDriver()->asstMv()->isSliding()) {
            pSubCursorActor->_x += (pTargetItem->_x - pSubCursor->_x_target_prev);
            pSubCursorActor->_y += (pTargetItem->_y - pSubCursor->_y_target_prev);
            pSubCursorActor->_z += (pTargetItem->_z - pSubCursor->_z_target_prev);
            pSubCursor->_x_target_prev = pTargetItem->_x;
            pSubCursor->_y_target_prev = pTargetItem->_y;
            pSubCursor->_z_target_prev = pTargetItem->_z;
        } else {
            pSubCursorActor->setPosition(pTargetItem->_x + pSubCursor->_x_adjust,
                                         pTargetItem->_y + pSubCursor->_y_adjust,
                                         pTargetItem->_z + pSubCursor->_z_adjust );
        }
        if (_with_sinking) {
            if (T::getAlpha() < pSubCursorActor->getAlpha()) {
                pSubCursorActor->setAlpha(T::getAlpha());
            }
        } else if (_with_rising) {
            if (T::getAlpha() > pSubCursorActor->getAlpha()) {
                pSubCursorActor->setAlpha(T::getAlpha());
            }
        }
    }

    //Tuj[riseMe() sinkMe() 
    int n_sm = _lstSubMenu.length();
    for (int i = 0; i < n_sm; i++) {
        MenuActor<T>* pSubMenu = _lstSubMenu.getFromFirst(i);
        if (pSubMenu->hasJustRisen()) {
            disableControll(); //Tuj[オ̂ŁAg͑s
            _can_controll = false; //
        }
        if (pSubMenu->hasJustSunk()) {
            if (_with_sinking || _is_just_sunk || _will_be_sinking_next_frame) {
                disableControll(); //gɕĂꍇ
                _can_controll = false; //
            } else {
                enableControll(); //Tuj[̂ŁAg̑앜A
            }
        }
    }
}

template<class T>
void MenuActor<T>::sinkMe() {
    _with_rising = false;
    _with_sinking = false;
    _is_just_risen = false;
    _is_just_sunk = false;
    _will_be_rising_next_frame = false;
    _will_be_sinking_next_frame = true;
    disableControll();
    _can_controll = false; //
    if (_velo_alpha_fade >= 1.0) {
        T::setAlpha(0.0);
        T::inactivateTree();
    }
}

template<class T>
void MenuActor<T>::onSink() {
}

template<class T>
void MenuActor<T>::processSinking() {
    T::addAlpha(-_velo_alpha_fade);
    if (T::getAlpha() <= 0.0) {
        T::setAlpha(0.0);
        _with_sinking = false;
        T::inactivateTree();
        onSinkDone(); //R[obN
    }
}

template<class T>
void MenuActor<T>::onSinkDone() {
}

template<class T>
void MenuActor<T>::addSubMenu(MenuActor<T>* prm_pSubMenu) {
    _lstSubMenu.addLast(prm_pSubMenu, false);
    T::appendChild(prm_pSubMenu); //qɒǉ
}

template<class T>
MenuActor<T>* MenuActor<T>::getParentMenu() {
    GgafCore::Actor* pActor = T::getParent(); //qɒǉ
#ifdef MY_DEBUG
    MenuActor<T>* pMenuActor = dynamic_cast<MenuActor<T>*>(pActor);
    if (pMenuActor == nullptr) {
        throwCriticalException("MenuActor<T>::getParentMenu em[h͓j[ł͂܂łBname="<<T::getName()<<" this="<<this);
    }
#endif
    return (MenuActor<T>*)pActor;
}

template<class T>
MenuActor<T>* MenuActor<T>::getSubMenu(int prm_index) {
#ifdef MY_DEBUG
    if (_lstSubMenu.length() < prm_index+1) {
        throwCriticalException("MenuActor<T>::getSubMenu() Tuj[ACevfI[o[ name="<<T::getName()<<" _lstSubMenu.length()="<<_lstSubMenu.length()<<" prm_index="<<prm_index);
    }
#endif
    return _lstSubMenu.getFromFirst(prm_index);
}

template<class T>
MenuActor<T>* MenuActor<T>::getRisingSubMenu() {
    MenuActor<T>* pSubMenu = _lstSubMenu.getCurrent();
    if (pSubMenu) {
        if (pSubMenu->isActiveInTheTree()) {
            return pSubMenu;
        } else {
            return nullptr;
        }
    } else {
        return nullptr;
    }
}


template<class T>
MenuActor<T>* MenuActor<T>::riseSubMenu(int prm_index) {
#ifdef MY_DEBUG
    if (_lstSubMenu.length() < prm_index+1) {
        throwCriticalException("MenuActor<T>::riseSubMenu() Tuj[ACevfI[o[ name="<<T::getName()<<" _lstSubMenu.length()="<<_lstSubMenu.length()<<" prm_index="<<prm_index);
    }
#endif
    MenuActor<T>* pSubMenu = _lstSubMenu.current(prm_index);
    pSubMenu->riseMe();
    return pSubMenu;
}

template<class T>
void MenuActor<T>::sinkCurrentSubMenu() {
    _lstSubMenu.getCurrent()->sinkMe();
}

template<class T>
MenuActor<T>::~MenuActor() {
}

}
#endif /*GGAF_LIB_MENUACTOR_H_*/
