#ifndef GGAF_LIB_REFRACTIONLASERCHIP_H_
#define GGAF_LIB_REFRACTIONLASERCHIP_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChip.h"

namespace GgafLib {

/**
 * ˁi܁j[U[p|C̃`bv .
 * ˁi܁j[U[Ȃǂǂƕ\Ă邪Amɂ <BR>
 * EˍWŒiˌW͒ʏ͈ړsj <BR>
 * EړAx͐擪`bv݂̂߁Ac`bv͒PɒǏ]<BR>
 * Eړ͒iAAԊuňړω <BR>
 * ƌׂA_CAX̃{X̑i[U[ƌׂAȊB<BR>
 * f|Wgo^Oconfig()Őݒ肵ĂB<BR>
 * 擪`bv  GgafDx::VecDriver#behave() ňړ܂B<BR>
 * dispatch() AW VecDriverixEjݒ肵ĉB<BR>
 * @version 1.00
 * @since 2010/01/19
 * @author Masatoshi Tsuge
 */
class RefractionLaserChip : public LaserChip {
    friend class LaserChipDepository;

private:
    /** [r]()܊Jnt[ */
    frame _frame_refraction_enter;
    /** [r]܏It[ */
    frame _frame_refraction_out;
    /** [r]܂ɋܒiړĂȂj̏ꍇtrue */
    bool _is_refracting;
    /** [r]݂̋܉ */
    int _cnt_refraction;

    int _begining_x;
    int _begining_y;
    int _begining_z;
    angle _begining_rx;
    angle _begining_ry;
    angle _begining_rz;
    angle _begining_rz_mv;
    angle _begining_ry_mv;
    velo _begining_velo_mv;
    int _prev_x;
    int _prev_y;
    int _prev_z;
    angle _prev_rx;
    angle _prev_ry;
    angle _prev_rz;
    angle _prev_rz_mv;
    angle _prev_ry_mv;
    velo _prev_velo_mv;

    bool _prev_is_refracting;
    GgafDx::FigureActor* _prev_pRefractionEffect;

    /** ܃GtFNgAN^[̃f|WgiV[ς݂ł邱Ɓj */
    GgafCore::ActorDepository* _pDepo_refraction_effect;
    GgafDx::FigureActor* _pRefractionEffect;
    /** ܏I܂ł̃t[ */
    frame _refraction_end_frames;
public:
    /** 擱`bvi{̐擪`bvjtO */
    bool _is_leader; //{̐擪`bvƂ́A[U[ړɂĔɂ킩擪`bvł͖ƂӖB;
    /** [r]ŏIIȋ܉ */
    int _num_refraction;
    /** [r]iJn(܏I)`i`iI(܊Jn)Ãt[(>= 1) */
    frame _frame_between_refraction;
    /** [r]܎(iI(܊Jn)`~`iJn(܏I))̒ؒ߃t[(>= 1) */
    frame _frame_standstill_refraction;
    /** [r]ˊJnWŒ肩ۂ(true:ŒAĂь̍W㏑āAŏ[0]̍Wɋ㏑/false:ŒBXN[V[z̏ꍇ false ǂ */
    bool _is_fix_begin_pos;

public:
    RefractionLaserChip(const char* prm_name, const char* prm_model);

    /**
     * tNV[U[` .
     * @param prm_num_refraction ܂邩
     * @param prm_frame_between_refraction iJn(܏I)`i`iI(܊Jn)Ãt[(>= 1)
     * @param prm_frame_standstill_refraction ܎(iI(܊Jn)`~`iJn(܏I))̒ؒ߃t[(>= 1)
     * @param prm_is_fix_beginning_pos true:[U[ˌ́A擪[U[`bv̍WɌŒ肳B^false:ꂼ̃[U[`bv̍WɈˑ
     * @param prm_pDepo_refraction_effect ܎̃GtFNgAN^[̃f|Wg(̏ꍇnullptr)
     */
    virtual void config(int prm_num_refraction,
                        frame prm_frame_between_refraction,
                        frame prm_frame_standstill_refraction,
                        bool prm_is_fix_begin_pos,
                        GgafCore::ActorDepository* prm_pDepo_refraction_effect);

    virtual void onCreateModel() override {}

    virtual void initialize() override {}

    /**
     * [U[`bvWvZ .
     * Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
     * ̍ہA{NX processBehavior() \bhĂяoĂB
     * ́A
     * 擪`bv́AGgafDx::VecDriver#behave() sɂړs܂B
     * ܒ GgafDx::VecDriver#behave() ɂړ͍s܂B
     * 擪ȊÕ`bvȊÓA擪`bvɒǏ]Ƃs܂B
     */
    virtual void processBehavior() override;

    virtual void processJudgement() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    /**
     * 擪`bṽ[U[̒iI`܊Jn̏ .
     * 擪`bv̂݃R[obN܂B<BR>
     * @param prm_num_refraction ܃JEg(ڂ̋܊Jn)(0`)
     */
    virtual void onRefractionInto(int prm_num_refraction) = 0;

    /**
     * 擪`bṽ[U[̂ߌ܌I`iJn̏ .
     * 擪`bv̂݃R[obN܂B<BR>
     * ۂɂ݂͑Ȃ0ڂ̋܏IX^[gB<BR>
     * 0ڂ̋܏I onActive() ɃR[obN܂B<BR>
     * I[o[ChA܌̎̈ړƑx͎Aɐݒ肷
     * sĂB<BR>
     * @param prm_num_refraction ܃JEg(ڂ̋܏I)(0`)
     */
    virtual void onRefractionOutOf(int prm_num_refraction) = 0;

    /**
     * [U[`bvo .
     * Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
     * ̍ ́A{NX onActive() \bhĂяoĂB
     */
    virtual void onActive() override;

    /**
     * [U[`bv .
     * Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
     * ̍ ́A{NX onInactive() \bhĂяoĂB
     */
    virtual void onInactive() override;

    /**
     * ܃[U[Jn`I܂ł̃t[𓾂 .
     * @return ܃[U[Jn`I܂ł̃t[
     */
    inline frame getRefractionFinishFrames() {
        return _refraction_end_frames;
    }

    virtual ~RefractionLaserChip();

};

}
#endif /*GGAF_LIB_HOMINGLASERCHIP_H_*/

