#ifndef GGAF_LIB_IFIXEDFONT_H_
#define GGAF_LIB_IFIXEDFONT_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/exception/CriticalException.h"
#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include <string.h>

namespace GgafLib {

template<class T, int N, int L>
class ICharacterChip {

    T* _pBaseActor;
public:

    /** [r/w]x[X̂P(px) */
    pixcoord _chr_base_width_px;
    /** [r/w]x[X̂P(px) */
    pixcoord _chr_base_height_px;
    /** [r/w]p^[ԍ0Ƃ镶 */
    int _chr_ptn_zero;
    /** [r/w]\sv󔒂Ƃ镶(w肷ƕ`敶) */
    int _chr_blank;
    /** [r/w]sƂ镶 */
    int _chr_newline;
    /** [r]`敶 */
    int* _draw_string;
    /** [r]󂯓\ȕ(obt@̒) */
    int _max_buf;
    /** [r]obt@ */
    int* _buf;
    struct InstancePart {
        float px_local_x;
        float px_local_y;
        float offset_u;
        float offset_v;
    };
    InstancePart* _paInstancePart;
    /** [r] */
    int _len;
    /** [r]`敶i񒷂sƋ󔒂lj*/
    int _draw_chr_num;
    /** [r]obt@̍̕sPʂ̕(px) */
    pixcoord _px_row_width[L];
    /** [r]obt@̍̕s */
    int _nn;
    /** [r/w]eԊu(px) */
    pixcoord _px_chr_width[N];
    bool _is_fixed_width;

    pixcoord _px_total_width;
    pixcoord _px_total_height;
    /**
     * obt@̒8̔{̐؂グɕύX .
     * @param prm_max_buf Vobt@
     */
    void extendBuffer(int prm_max_buf);
    virtual void prepare1(const char* prm_str);
    virtual void prepare1(const int prm_append_chr);
    virtual void prepare1_append(const char* prm_str);
    virtual void prepare1_append(const int prm_append_chr);
    virtual void prepare1_delete(int prm_delete_byte_num);
    virtual void prepare2();
public:
    /**
     * `敶XVݒ .
     * @param X XW(sNZ : W  1 : LEN_UNIT)
     * @param Y YW(sNZ : W  1 : LEN_UNIT)
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, const char* prm_str);
    virtual void update(coord X, coord Y, const int prm_chr);
    /**
     * `敶XVݒ  .
     * @param X XW(sNZ : W  1 : LEN_UNIT)
     * @param Y YW(sNZ : W  1 : LEN_UNIT)
     * @param Z vCIeB(lO)
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, coord Z, const char* prm_str);
    virtual void update(coord X, coord Y, coord Z, const int prm_chr);

    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     */
    virtual void update(const char* prm_str);
    virtual void update(const int prm_chr);

    /**
     * `敶XVݒ .
     * @param X XW(sNZ : W  1 : LEN_UNIT)
     * @param Y YW(sNZ : W  1 : LEN_UNIT)
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(coord X, coord Y, const char* prm_str,
                        Align prm_align,
                        Valign prm_valign);

    /**
     * `敶XVݒ  .
     * @param X XW(sNZ : W  1 : LEN_UNIT)
     * @param Y YW(sNZ : W  1 : LEN_UNIT)
     * @param Z vCIeB(lO)
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(coord X, coord Y, coord Z, const char* prm_str,
                        Align prm_align,
                        Valign prm_valign);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(const char* prm_str,
                        Align prm_align,
                        Valign prm_valign);

    /**
     * `敶ǉčXVݒ  .
     * update() AvZǉɌ肷̂ŁA኱ptH[}XǂB
     * @param prm_str ǉ镶
     */
    virtual void appendUpdate(const char* prm_str);

    /**
    * `敶ǉčXVݒ  .
     * update() AvZǉɌ肷̂ŁA኱ptH[}XǂB
     * @param prm_c ǉASCII(0`255)
     */
    virtual void appendUpdate(const int prm_c);

    /**
     * `敶𖖔珜čXVݒ  .
     * update() A኱ptH[}XǂB
     * sPƂĈ
     * @param prm_delete_byte_num 폜
     */
    virtual void deleteUpdate(int prm_delete_byte_num);

    /**
     * `敶XVꂽɌĂяoR[obN .
     * ʂŎĂB
     */
    virtual void onUpdate() {
    }

    /**
     * SĂ̐̕ݒBupdate() ɂ\XVȂƔf܂B .
     * @param prm_width_ratio ̗(l̕ɏ悶lAl1.0)
     */
    inline void setBaseChrWidth(pixcoord prm_width_px) {
        _is_fixed_width = true;
        _chr_base_width_px = prm_width_px;
        pixcoord* p = _px_chr_width;
        for (int i = 0; i < N; i++) {
            *p = prm_width_px;
            ++p;
        }
    }

    /**
     * ̔̕䗦XɐݒBupdate() ɂ\XVȂƔf܂B .
     * @param c 
     * @param prm_width_ratio ̗(l̕ɏ悶lAl1.0)
     */
    inline void setChrWidthRatio(const unsigned char c, double prm_width_ratio) {
        _is_fixed_width = false;
        _px_chr_width[c] = _chr_base_width_px * prm_width_ratio;
    }
    /**
     * 󔒂̕ݒ肷 .
     * 󔒂͕̕`揈XLbv̂ŁAptH[}XシB
     * ftHg ' ' ݒ肳ĂB
     * @param prm_c 󔒕
     */
    inline void setBlankChr(int prm_c) {
        _chr_blank = prm_c;
    }

    /**
     * sݒ肷 .
     * ftHg '\n' ݒ肳ĂB
     * @param prm_c
     */
    inline void setNewlineChr(int prm_c) {
        _chr_newline = prm_c;
    }

    /**
     * UvFlipper̃p^[ԍ0ԂƂ镶ݒ肷 .
     * ftHg ' ' ݒ肳ĂB
     * @param prm_c
     */
    inline void setPatternZeroChr(int prm_c) {
        _chr_ptn_zero = prm_c;
    }

    inline void getDrawString(char* out_paCh) {
        int len = _len;
        for (int i = 0; i < len; i++) {
            out_paCh[i] = _draw_string[i];
        }
        out_paCh[len] = '\0';
    }

    inline std::string getDrawString() {
        int len = _len;
        char* paCh = NEW char[len+1];
        getDrawString(paCh);
        std::string s = paCh;
        GGAF_DELETEARR(paCh);
        return s;
    }

    inline int getDrawStringLength() {
        return _len;
    }
    inline pixcoord getTotalWidth() {
        return _px_total_width;
    }
    inline pixcoord getTotalHeight() {
        return _px_total_height;
    }

public:
    ICharacterChip(T* prm_pBaseActor, int prm_chr_base_width_px, int prm_chr_base_height_px);

    virtual ~ICharacterChip();

};

template<class T, int N, int L>
ICharacterChip<T, N, L>::ICharacterChip(T* prm_pBaseActor, int prm_chr_base_width_px, int prm_chr_base_height_px) :
_pBaseActor(prm_pBaseActor),
_chr_base_width_px(prm_chr_base_width_px),
_chr_base_height_px(prm_chr_base_height_px)
{
    _max_buf = 8;  //ŏ̓obt@8
    _chr_ptn_zero = (int)(' '); //UvFlipper  p^[0Ԃ̕B
    _chr_blank = (int)(' ');
    _chr_newline = (int)('\n');
    _len = 0;
    _draw_chr_num = 0;
    _buf = NEW int[_max_buf];
    _buf[0] = (int)('\0');
    _paInstancePart = NEW InstancePart[_max_buf];
    _draw_string = _buf;
    for (int i = 0; i < L; i++) {
        _px_row_width[i] = 0;
    }
    _nn = 0;
    _is_fixed_width = false;
    //ftHĝP̕(px)ݒ
    for (int i = 0; i < N; i++) {
        _px_chr_width[i] = _chr_base_width_px;
    }
    _px_total_width = 0;
    _px_total_height = 0;
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::extendBuffer(int prm_max_buf) {
    _max_buf = 8*((prm_max_buf+8)/8); //߂W̔{ɐ؂グ
    GGAF_DELETEARR(_buf);
    GGAF_DELETEARR(_paInstancePart);
    _buf = NEW int[_max_buf];
    _buf[0] = (int)('\0');
    _paInstancePart = NEW InstancePart[_max_buf];
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::prepare1(const char* prm_str) {
    _len = (int)strlen(prm_str);
    if (_len+1 > _max_buf) {
        extendBuffer(_len+1); //obt@g
    }
    onUpdate(); //R[obN
    _draw_string = _buf;
    //ێ(_draw_string)AȂs(_nn)߂A
    //łɊesPʂ̕(_px_row_width)߂Ă
    bool is_different = false;
    const char* p_prm_str = prm_str;
    int* p_draw_string = _draw_string;
    pixcoord* p_width_line_px = _px_row_width;
    pixcoord max_width_line_px = 0;

    *p_width_line_px = 0;
    _nn = 0;
    _draw_chr_num = 0;
    int c;
    const int chr_blank = _chr_blank;
    const bool is_fixed_width = _is_fixed_width;
    const pixcoord chr_base_width_px = _chr_base_width_px;
    while (true) {
        c = (int)(*p_prm_str);
#ifdef MY_DEBUG
        if (0 > c || c > (N-1)) {
            throwCriticalException("ICharacterChip::prepare1() ͈͊ÖȂ킪܂ prm_str=["<<prm_str<<"] ̒̒l:"<<c<<"B 0`"<<(N-1)<<"͈̔͂ɂĉBthis="<<this);
        }
#endif
        if (c != (*p_draw_string)) {
            is_different = true;
            *p_draw_string = c; //ۑ
        }
        if (c == _chr_newline) {
            if (_nn == 0 || max_width_line_px < *p_width_line_px) {
                max_width_line_px = *p_width_line_px;
            }
            _nn++; //sJEg
            ++p_width_line_px;  *p_width_line_px = 0; //s̕ێz  0ɃZbg
        } else if (c == '\0') {
            if (_nn == 0 || max_width_line_px < *p_width_line_px) {
                max_width_line_px = *p_width_line_px;
            }
            _nn++; //ŌsPƂăJEgB͉sŏIKvȂB
            break;
        } else {
            *p_width_line_px += (is_fixed_width ? chr_base_width_px : _px_chr_width[c]); //s̕(px)Z
        }
        if (c != chr_blank) { //uN
            _draw_chr_num++; //`敶JEg
        }
        ++p_prm_str;  ++p_draw_string;
    }
    _px_total_width = max_width_line_px;
    _px_total_height = _chr_base_height_px*_nn;
    if (is_different) {
        prepare2();
    }
#ifdef MY_DEBUG
    if (_nn > L) {
        throwCriticalException("ICharacterChip::prepare1() ̍s"<<L<<"𒴂܂Bname="<<_pBaseActor->getName()<<" prm_str="<<prm_str);
    }
#endif
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::prepare1(const int prm_chr) {
    onUpdate(); //R[obN
    _draw_string = _buf;
    bool is_different = false;
    if (_draw_string[0] != prm_chr) {
        is_different = true;
        _draw_string[0] = prm_chr; //ۑ
        _draw_string[1] = '\0'; //ۑ
    }
    if (prm_chr == _chr_newline) {
        _len = 0;
        _px_total_width = 0;
        _draw_chr_num = 0;
    } else if (prm_chr == '\0') {
        _len = 1;
        _px_total_width = 0;
        _draw_chr_num = 0;
    } else {
        _len = 1;
        _px_total_width = (_is_fixed_width ? _chr_base_width_px : _px_chr_width[prm_chr]); //s̕(px)Z
        _draw_chr_num = 1;
    }
    _nn = 1;
    _px_total_height = _chr_base_height_px*_nn;
    if (is_different) {
        prepare2();
    }
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::prepare1_append(const int prm_append_chr) {
    int new_buffer_size = _len+1+1;
    if (new_buffer_size > _max_buf) {//obt@g
        _max_buf = 8*((new_buffer_size+8)/8); //߂W̔{ɐ؂グ
        int* tmp_buf = NEW int[_max_buf];
        memcpy(tmp_buf, _buf, sizeof(int)*(_len+1));
        InstancePart* tmp_paInstancePart = NEW InstancePart[_max_buf];
        memcpy(tmp_paInstancePart, _paInstancePart, sizeof(InstancePart)*(_len+1));
        GGAF_DELETEARR(_buf);
        GGAF_DELETEARR(_paInstancePart);
        _buf = tmp_buf;
        _paInstancePart = tmp_paInstancePart;
    }
    onUpdate(); //R[obN
    _draw_string = _buf;
    const pixcoord chr_base_width_px = _chr_base_width_px;
#ifdef MY_DEBUG
    if (0 > prm_append_chr || prm_append_chr > (N-1)) {
        throwCriticalException("ICharacterChip::prepare1_append() ͈͊ÖȂ킪܂ prm_append_chr="<<prm_append_chr<<"B 0`"<<(N-1)<<"͈̔͂ɂĉBthis="<<this);
    }
#endif
    _draw_string[_len-1 + 1] = prm_append_chr; //ۑ
    _draw_string[_len-1 + 1+1] = '\0';//ۑ
    _len += 1;
    if (_nn > 0) {
        _nn--;//s͖mԂɂȂ̂ŁA -1 B
    }
    if (prm_append_chr == _chr_newline) {
        _nn++; //sJEg
    } else {
        _px_row_width[_nn] += (_is_fixed_width ? chr_base_width_px : _px_chr_width[prm_append_chr]); //s̕(px)Z
        if (_nn == 0 || _px_total_width < _px_row_width[_nn]) {
            _px_total_width = _px_row_width[_nn];
        }
        _nn++; //Pǉ͍sPƂăJEgB
    }
    if (prm_append_chr != _chr_blank) { //uN
        _draw_chr_num++; //`敶JEg
    }
    _px_total_height = _chr_base_height_px*_nn;
    prepare2();
#ifdef MY_DEBUG
    if (_nn > L) {
        throwCriticalException("ICharacterChip::prepare1_append() ̍s"<<L<<"𒴂܂Bname="<<_pBaseActor->getName()<<" prm_append_chr="<<prm_append_chr);
    }
#endif
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::prepare1_append(const char* prm_append_str) {
    int append_len = (int)strlen(prm_append_str);
    int new_buffer_size = _len+append_len+1;
    if (new_buffer_size > _max_buf) {//obt@g
        _max_buf = 8*((new_buffer_size+8)/8); //߂W̔{ɐ؂グ
        int* tmp_buf = NEW int[_max_buf];
        memcpy(tmp_buf, _buf, sizeof(int)*(_len+1));
        InstancePart* tmp_paInstancePart = NEW InstancePart[_max_buf];
        memcpy(tmp_paInstancePart, _paInstancePart, sizeof(InstancePart)*(_len+1));
        GGAF_DELETEARR(_buf);
        GGAF_DELETEARR(_paInstancePart);
        _buf = tmp_buf;
        _paInstancePart = tmp_paInstancePart;

    }
    onUpdate(); //R[obN
    _draw_string = _buf;
    //ێ(_draw_string)AȂs(_nn)߂A
    //łɊesPʂ̕(_px_row_width)߂Ă
    const char* p_prm_append_str = prm_append_str;
    int* p_draw_string = &_draw_string[_len-1 + 1]; //+1appendʒuƂӖ
    _len += append_len;
    if (_nn > 0) {
        _nn--;//s͖mԂɂȂ̂ŁA -1 B
    }
    pixcoord* p_width_line_px = &_px_row_width[_nn];
    pixcoord max_width_line_px = _px_total_width;
    int c;
    const int chr_blank = _chr_blank;
    const bool is_fixed_width = _is_fixed_width;
    const pixcoord chr_base_width_px = _chr_base_width_px;
    while (true) {
        c = (int)(*p_prm_append_str);
#ifdef MY_DEBUG
        if (0 > c || c > (N-1)) {
            throwCriticalException("ICharacterChip::prepare1_append() ͈͊ÖȂ킪܂ p_append_str=["<<p_prm_append_str<<"] ̒̒l:"<<c<<"B 0`"<<(N-1)<<"͈̔͂ɂĉBthis="<<this);
        }
#endif
        *p_draw_string = c; //ۑ
        if (c == _chr_newline) {
            if (_nn == 0 || max_width_line_px < *p_width_line_px) {
                max_width_line_px = *p_width_line_px;
            }
            _nn++; //sJEg
            ++p_width_line_px;  *p_width_line_px = 0; //s̕ێz  0ɃZbg
        } else if (c == '\0') {
            if (_nn == 0 || max_width_line_px < *p_width_line_px) {
                max_width_line_px = *p_width_line_px;
            }
            _nn++; //ŌsPƂăJEgB͉sŏIKvȂB
            break;
        } else {
            *p_width_line_px += (is_fixed_width ? chr_base_width_px : _px_chr_width[c]); //s̕(px)Z
        }
        if (c != chr_blank) { //uN
            _draw_chr_num++; //`敶JEg
        }
        ++p_prm_append_str;  ++p_draw_string;
    }
    _px_total_width = max_width_line_px;
    _px_total_height = _chr_base_height_px*_nn;
    prepare2();
#ifdef MY_DEBUG
    if (_nn > L) {
        throwCriticalException("ICharacterChip::prepare1_append() ̍s"<<L<<"𒴂܂Bname="<<_pBaseActor->getName()<<" prm_str="<<prm_append_str);
    }
#endif
}


template<class T, int N, int L>
void ICharacterChip<T, N, L>::prepare1_delete(int prm_delete_byte_num) {
    onUpdate(); //R[obN
    _len -= prm_delete_byte_num;
    _draw_string[_len] = '\0';
    int* p_draw_string = _draw_string;
    pixcoord* p_width_line_px = _px_row_width;
    pixcoord max_width_line_px = 0;
    *p_width_line_px = 0;
    _nn = 0;
    _draw_chr_num = 0;
    int c;
    const int chr_blank = _chr_blank;
    const bool is_fixed_width = _is_fixed_width;
    const pixcoord chr_base_width_px = _chr_base_width_px;
    while (true) {
        c = *p_draw_string;
        if (c == _chr_newline) {
            if (_nn == 0 || max_width_line_px < *p_width_line_px) {
                max_width_line_px = *p_width_line_px;
            }
            _nn++; //sJEg
            ++p_width_line_px;  *p_width_line_px = 0; //s̕ێz  0ɃZbg
        } else if (c == '\0') {
            if (_nn == 0 || max_width_line_px < *p_width_line_px) {
                max_width_line_px = *p_width_line_px;
            }
            _nn++; //ŌsPƂăJEgB͉sŏIKvȂB
            break;
        } else {
            *p_width_line_px += (is_fixed_width ? chr_base_width_px : _px_chr_width[c]); //s̕(px)Z
        }
        if (c != chr_blank) { //uN
            _draw_chr_num++; //`敶JEg
        }
        ++p_draw_string;
    }
    _px_total_width = max_width_line_px;
    _px_total_height = _chr_base_height_px*_nn;
    prepare2();
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::prepare2() {
    //ALIGN_RIGHT VALIGN_BOTTOM ׂ̈
    //ǂĂQS[vłȂ߂KvB
    //prepare1() ͂Pڂ̃[vA prepare2() ͂Qڂ̃[vɑ
    if (_len == 0) {
        return;
    }
    const Align align  = _pBaseActor->_align;
    const Valign valign = _pBaseActor->_valign;
    const pixcoord chr_base_height_px = _chr_base_height_px;
    const pixcoord chr_base_width_px = _chr_base_width_px;
    const int chr_newline = _chr_newline;
    const int chr_blank = _chr_blank;
    const int chr_ptn_zero = _chr_ptn_zero;
    GgafDx::UvFlipper* pUvFlipper = _pBaseActor->getUvFlipper();
    if (_is_fixed_width) {
        //Œ蕝
        //Yʒu߂
        pixcoord px_y, px_x;
        int nnn = 0; // num of \n now
        if (align == ALIGN_CENTER) {
            px_x = -(_px_row_width[nnn]/2);
        } else if (align == ALIGN_RIGHT) {
            px_x = -(_px_row_width[nnn]);
        } else {  //ALIGN_LEFT
            px_x = 0;
        }
        if (valign == VALIGN_BOTTOM) {
            px_y = -_px_total_height;
        } else if (valign == VALIGN_MIDDLE) {
            px_y = -(_px_total_height/2);
        } else { //VALIGN_TOP
            px_y = 0;
        }
        float u, v;
        int* p_chr  = _draw_string;
        InstancePart* pInstancePart = _paInstancePart;
        while(true) { //ePʂ̃[v
            int draw_chr = *p_chr;
            if (draw_chr == (int)('\0')) {
                break; //܂
            } else if (draw_chr == chr_newline) {
                nnn++;
                if (align == ALIGN_CENTER) {
                    px_x = -(_px_row_width[nnn]/2);
                } else if (align == ALIGN_RIGHT) {
                    px_x = -(_px_row_width[nnn]);
                } else {  //ALIGN_LEFT
                    px_x = 0;
                }
                px_y += chr_base_height_px;
                ++p_chr;
                continue; //\͂Ȃ
            }
            //XV
            if (draw_chr != chr_blank) {
                pInstancePart->px_local_x = (float)px_x;
                pInstancePart->px_local_y = (float)px_y;
                pUvFlipper->getUV(draw_chr-chr_ptn_zero, u, v);
                pInstancePart->offset_u = u;
                pInstancePart->offset_v = v;
                ++pInstancePart;
            }
            px_x += chr_base_width_px;
            ++p_chr;
        }
    } else {
        //ϕ
        //Yʒu߂
        pixcoord px_y = 0;
        if (align == ALIGN_LEFT || align == ALIGN_CENTER) {
            if (valign == VALIGN_BOTTOM) {
                px_y = -_px_total_height;
            } else if (valign == VALIGN_MIDDLE) {
                px_y = -(_px_total_height/2);
            } else { //VALIGN_TOP
                px_y = 0;
            }
            int nnn = 0; // num of \n now
            pixcoord px_x =  -(align == ALIGN_CENTER ? _px_row_width[nnn]/2 : 0);
            pixcoord x_tmp = px_x;
            float u, v;
            int* p_chr  = _draw_string;
            InstancePart* pInstancePart = _paInstancePart;
            while(true) { //ePʂ̃[v
                int draw_chr = *p_chr;
                if (draw_chr == (int)('\0')) {
                    break; //܂
                } else if (draw_chr == chr_newline) {
                    nnn++;
                    px_x = -(align == ALIGN_CENTER ? _px_row_width[nnn]/2 : 0);
                    x_tmp = px_x;
                    px_y += chr_base_height_px;
                    ++p_chr;
                    continue; //\͂Ȃ
                }
                //v|[ViȕvZ
                int w = ((chr_base_width_px - _px_chr_width[draw_chr]) / 2);
                px_x = x_tmp - w;
                x_tmp = px_x + chr_base_width_px - w;

                //XV
                if (draw_chr != chr_blank) {
                    pInstancePart->px_local_x = (float)px_x;
                    pInstancePart->px_local_y = (float)px_y;
                    pUvFlipper->getUV(draw_chr-chr_ptn_zero, u, v);
                    pInstancePart->offset_u = u;
                    pInstancePart->offset_v = v;
                    ++pInstancePart;
                }
                ++p_chr;
            }
        } else if (align == ALIGN_RIGHT) {
            if (valign == VALIGN_BOTTOM) {
                px_y = -chr_base_height_px;
            } else if (valign == VALIGN_MIDDLE) {
                px_y = ((_px_total_height/2) - chr_base_height_px);
            } else { //VALIGN_TOP
                px_y = ((_px_total_height*_nn) - chr_base_height_px);
            }

            //E\
            pixcoord px_x = 0;
            pixcoord x_tmp = px_x;
            float u, v;
            int w;
            int* p_chr = &(_draw_string[_len-1]); //񂷁B_len  strlen ̒l
            InstancePart* pInstancePart = &(_paInstancePart[_draw_chr_num - 1]);
            while (true) {
                int draw_chr = *p_chr;
                if (draw_chr == chr_newline) {
                    px_x = 0;
                    x_tmp = px_x;
                    px_y -= chr_base_height_px;
                    p_chr--;
                    continue;
                }
                //v|[ViȕvZ
                w = ((chr_base_width_px - _px_chr_width[draw_chr]) / 2);
                px_x = x_tmp - (w + _px_chr_width[draw_chr]);
                x_tmp = px_x + w;
                //XV
                if (draw_chr != chr_blank) {
                    pInstancePart->px_local_x = (float)px_x;
                    pInstancePart->px_local_y = (float)px_y;
                    pUvFlipper->getUV(draw_chr-chr_ptn_zero, u, v);
                    pInstancePart->offset_u = (float)u;
                    pInstancePart->offset_v = (float)v;
                    pInstancePart--;
                }
                if (p_chr == _draw_string) { //ԍɓB
                     break; //܂
                }
                p_chr--;
            }
        }
    }
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(coord X, coord Y, const char* prm_str) {
    update(prm_str);
    _pBaseActor->setPosition(X, Y);
}
template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(coord X, coord Y, const int prm_chr) {
    update(prm_chr);
    _pBaseActor->setPosition(X, Y);
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(coord X, coord Y, coord Z, const char* prm_str) {
    update(prm_str);
    _pBaseActor->setPosition(X, Y, Z);
}
template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(coord X, coord Y, coord Z, const int prm_chr) {
    update(prm_chr);
    _pBaseActor->setPosition(X, Y, Z);
}


template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(const char* prm_str) {
    prepare1(prm_str);
}
template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(const int prm_chr) {
    prepare1(prm_chr);
}
template<class T, int N, int L>
void ICharacterChip<T, N, L>::appendUpdate(const int prm_c) {
    prepare1_append(prm_c);
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::appendUpdate(const char* prm_str) {
    prepare1_append(prm_str);
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::deleteUpdate(int prm_delete_byte_num) {
#ifdef MY_DEBUG
    if (prm_delete_byte_num < 0 || prm_delete_byte_num > _len) {
        throwCriticalException("ICharacterChip::deleteUpdate() 폜͈̔͊OłB_len="<<_len<<" prm_delete_byte_num="<<prm_delete_byte_num<<
                " name="<<_pBaseActor->getName());
    }
#endif
    prepare1_delete(prm_delete_byte_num);
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(coord X, coord Y, const char* prm_str, Align prm_align, Valign prm_valign) {
    update(prm_str, prm_align, prm_valign);
    _pBaseActor->setPosition(X, Y);
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(coord X, coord Y, coord Z, const char* prm_str, Align prm_align, Valign prm_valign) {
    update(prm_str, prm_align, prm_valign);
    _pBaseActor->setPosition(X, Y, Z);
}

template<class T, int N, int L>
void ICharacterChip<T, N, L>::update(const char* prm_str, Align prm_align, Valign prm_valign) {
    update(prm_str);
    _pBaseActor->setAlign(prm_align, prm_valign);
}

template<class T, int N, int L>
ICharacterChip<T, N, L>::~ICharacterChip() {
     GGAF_DELETEARR(_buf);
     GGAF_DELETEARR(_paInstancePart);
}

}

#endif /*GGAF_LIB_IFIXEDFONT_H_*/
