#ifndef GGAF_LIB_CAMERAWORKER_H_
#define GGAF_LIB_CAMERAWORKER_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/actor/MainActor.h"


#define DEFAULT_CAMERA_SLIDE_FRAMES (60)

namespace GgafLib {

/**
 * J} .
 * J(VioletVreath::Camera)ƁA_(VioletVreath::CameraViewPoint) 𑀂A
 *  UP̕xNg pUp_ Ǘ܂B
 * @version 1.00
 * @since 2010/10/25
 * @author Masatoshi Tsuge
 */
class CameraWorker : public GgafCore::MainActor {

public:
    /** [r]Jւ̎Q */
    DefaultCamera* _pCam;
    /** [r]_ւ̎Q */
    DefaultCameraViewPoint* _pVp;
    /** [r]J̏̈ʒuxNg */
    DefaultCameraUpVector*  _pUp;
    /** J}̈ړڕWW */
    coord _t_x_CAM, _t_y_CAM, _t_z_CAM;
    /** J}̃r[|Cg̈ړڕWW */
    coord _t_x_VP, _t_y_VP, _t_z_VP;
    /** UPxNgڕW */
    coord _t_x_UP, _t_y_UP, _t_z_UP;

    frame _frame_of_behaving_since_onSwitch;

public:
    CameraWorker(const char* prm_name, DefaultCamera* prm_pCamera);

    static bool initStatic();

    virtual void initialize() override;

    virtual void onActive() override;
    /**
     * XCb`ꂽꍇɌĂяoR[obN .
     * ܂ŎgANeBu CameraWorker A
     * Spacetime::changeCameraWork() ɂ育wA
     *  Spacetime::undoCameraWork() sɂ蕜AA
     * ƂɂAANeBuɐ؂ւŏ̃t[
     * Spacetime::processBehavior() ŃR[obNB
     */
    virtual void onSwitchCameraWork();

    /**
     *  CameraWorker ɐ؂ւۂ̃R[obN .
     * ܂ŎgANeBu CameraWorker A
     * Spacetime::changeCameraWork()  Spacetime::undoCameraWork() sɂA
     *  CameraWorker ɐ؂ւ̂ŁAt[玩gANeBu
     * ȂĂ܂Ƃ inactivate() s钼OɌĂяoR[obNB
     */
    virtual void onChangedToOtherCameraWork();

    void targetAutoCamup();

    virtual void processJudgement() override {}

    virtual void processDraw() override {}

    virtual void processFinal() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual bool processHitChkLogic(GgafCore::Actor* prm_pOtherActor) override {
        return false;
    }

    inline frame getSwitchedFrame() {
        return _frame_of_behaving_since_onSwitch;
    }

    void slideMvCamTo(GgafDx::GeometricActor* pTarget, frame t);
    void slideMvCamTo(GgafDx::GeometricActor* pTarget, frame t,
                      float prm_x_p1, float prm_y_p1, float prm_z_p1);
    void slideMvCamTo(coord tx, coord ty, coord tz, frame t, float prm_p1=0.3f, float prm_p2=0.7f);
    void slideMvCamTo(coord tx, coord ty, coord tz, frame t,
                      float prm_x_p1, float prm_y_p1, float prm_z_p1);
    void mvCamTo(coord tx, coord ty, coord tz);

    bool isCamSliding();
    void slideMvVpTo(GgafDx::GeometricActor* pTarget, frame t);
    void slideMvVpTo(coord tx, coord ty, coord tz, frame t, float prm_p1=0.3f, float prm_p2=0.7f);

    void slideMvUpVecTo(coord tx, coord ty, coord tz, frame t, float prm_p1=0.3f, float prm_p2=0.7f);

    void setUpVec(coord tx, coord ty, coord tz);

    void stopMvCam();
    void stopMvVp();

    virtual ~CameraWorker(); //fXgN^
};

}
#endif /*CAMERAWORKER_H_*/
