#ifndef GGAF_LIB_CAMERAWORKERCHANGER_H_
#define GGAF_LIB_CAMERAWORKERCHANGER_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/actor/MainActor.h"

namespace GgafLib {

#define CAM_WORKER_HISTORY_NUM (30)

/**
 * J}`FW[ .
 * @version 1.00
 * @since 2019/03/2
 * @author Masatoshi Tsuge
 */
class CameraWorkerChanger : public GgafCore::MainActor {

public:
    class History {
    public:
        CameraWorkerConnection* _apCamWorkerConnection[CAM_WORKER_HISTORY_NUM];
        uint32_t _p;
        History();
        CameraWorkerConnection* getLast();
        void push(CameraWorkerConnection* prm_pCamWorkerCon);
        CameraWorkerConnection* pop();
        void dump();
        ~History();
    };

public:
    /** [r]݂̃J} */
    GgafLib::CameraWorker* _pActiveCamWorker;
    /** [r]J}̃}l[W[ */
    CameraWorkerManager* _pCamWorkerManager;
    /** [r]J}̃X^bN */
    History _stack_CamWorkerConnection;
    DefaultCamera* _pCamera;
public:
    CameraWorkerChanger(const char* prm_name, DefaultCamera* prm_pCamera);

    static bool initStatic();

    /**
     * J}֐ .
     * I[o[Ch prm_idstr ɉJ}𐶐鏈ĂB
     * @param prm_idstr
     * @param prm_pConnector
     * @return
     */
    virtual CameraWorker* createCameraWorker(const char* prm_idstr, void* prm_pConnector) = 0;

    /**
     * ݂̃J}Ԃ .
     * Ԃ́AftHgJ}(DefaultCamWorker)l܂B
     * @return ݂̃J}
     */
    GgafLib::CameraWorker* getActiveCamWorker() {
        return _pActiveCamWorker;
    }
    /**
     * J}؂ւ .
     * ̃J}ID߂ĂȂ΁AJ}PlǉAɃJ̊^؂ւ܂B <br>
     * ̃J}ID݊̃J}ƓIDw肵ꍇAPɖ܂B <br>
     * ̃J}ID݊̃J}Ƃ͈قȂ邪AȑO؂ւς݂IDꍇAȑỖJ}ɐ؂ւ܂B <br>
     * @param prm_pID VJ}IDiID CameraWorkerManager ɎOo^vj
     * @return J}ID
     */
    GgafLib::CameraWorker* changeCameraWork(const char* prm_pID);
    /**
     * ݊̃J}A؂ւÕJ}ɖ߂܂B .
     * O changeCameraWork() PȏsĂKv܂B
     * @return XA߂̃J}
     */
    GgafLib::CameraWorker* undoCameraWork();
    /**
     * J}B|B
     *  changeCameraWork() sĂ悤ƁAftHgJ}(DefaultCamWorker)
     * Pl̏Ԃɖ߂܂B
     */
    void cleanCamWorker();

    virtual void initialize() override;

    virtual void onActive() override {}

    virtual void processBehavior() override;

    virtual void processJudgement() override {}

    virtual void processDraw() override {}

    virtual void processFinal() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual bool processHitChkLogic(GgafCore::Actor* prm_pOtherActor) override {
        return false;
    }

    virtual ~CameraWorkerChanger(); //fXgN^
};

}
#endif /*GGAF_LIB_CAMERAWORKERCHANGER_H_*/
