#include "jp/ggaf/dx/util/curve/FixedFrameCurveVecDriverLeader.h"

#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/util/Util.h"
#include "jp/ggaf/dx/util/curve/CurveSource.h"
#include "jp/ggaf/dx/util/curve/FixedFrameCurveManufacture.h"

using namespace GgafDx;

FixedFrameCurveVecDriverLeader::FixedFrameCurveVecDriverLeader(CurveManufacture* prm_pManufacture, GgafDx::VecDriver* prm_pVecDriver_target) :
        DriverLeader(prm_pManufacture, prm_pVecDriver_target->_pActor) {
    _pVecDriver_target = prm_pVecDriver_target;
    _pFixedFrameSplManuf = (FixedFrameCurveManufacture*)prm_pManufacture;
    _leading_frames = 0;
    _point_index = 0;
    _prev_point_index = -1;
    _hosei_frames = 0;
}
void FixedFrameCurveVecDriverLeader::restart() {
    DriverLeader::restart();
    _leading_frames = 0;
    _hosei_frames = 0;
    _point_index = 0;
    _prev_point_index = -1;

    //n_֍sʏB
    //n_ւ̋(_distance_to_begin) 킩Ă̂ŁA
    //
    // n_ւ̑x = (velo)(_distance_to_begin / _pFixedFrameSplManuf->_frame_of_segment)
    //
    //ƂA
    //_pFixedFrameSplManuf->_frame_of_segment ́AW`n_ 
    //vZŋ߂Ă̂ŁA⊮_ȂꍇA₳t[v̌덷傫B
    //Ŏn_ւ̋0Ƃ݂Ȃꍇɂ́AW`n_ ȂRgɂB
    //łȂΎdȂ̂ŁA₳t[v̌덷F߂dlƂB
//    if (ABS(_distance_to_begin) <= PX_C(1)) {
    if ( (ucoord)(_distance_to_begin + PX_C(1)) <= (ucoord)(PX_C(2)) ) {
        //n_ւ̋AԈB
        //_TRACE_("xFixedFrameCurveVecDriverLeader::start("<<prm_option<<") _pActor_target="<<_pActor_target->getName()<<
        //    " W`n_[0]ւ̋ 0 ł邽߁AW`n_ւ̈ړvZX̓Jbg܂B");
        _hosei_frames = _pFixedFrameSplManuf->_frame_of_segment;
        //ɂA_point_index ́A񂢂Ȃ1n܂B
    } else {
        _TRACE_("xFixedFrameCurveVecDriverLeader::restart("<<_option<<") _pActor_target="<<_pActor_target->getName()<<
            " W`n_[0]ւ̋("<<_distance_to_begin<<" coord)Ă邽߁AW`n_ւ̈ړvZXƂăZOg{P܂B"<<
            "̂߁Avړt[ԂɌ덷(+"<<_pFixedFrameSplManuf->_frame_of_segment<<"t[)܂B܂B");
        _hosei_frames = 0;
        //ɂA_point_index ́A0n܂B
    }

}

void FixedFrameCurveVecDriverLeader::behave() {
    if (_is_leading) {
        GgafDx::VecDriver* const pVecDriver_target = _pVecDriver_target;
        const double frame_of_segment = _pFixedFrameSplManuf->_frame_of_segment;
        //݂̓_INDEX
        _point_index = (_leading_frames+_hosei_frames) / frame_of_segment;
        if ( _point_index == _pFixedFrameSplManuf->_pCurve->_rnum) {
            if (_cnt_loop == _max_loop) {
                //I
                _is_leading = false;
                pVecDriver_target->stopTurningMvAng();
                return;
            } else {
                //[v
                _cnt_loop++;
                restart();
                _point_index = (_leading_frames+_hosei_frames) / frame_of_segment;
            }
        }

        //ς
        if (_prev_point_index != _point_index) {
            _prev_point_index = _point_index;
            coord x, y, z;
            getPointCoord(_point_index, x, y, z);
            pVecDriver_target->turnMvAngTwd(x, y, z,
                                         _pFixedFrameSplManuf->_angvelo_rzry_mv, 0,
                                         _pFixedFrameSplManuf->_turn_way, _pFixedFrameSplManuf->_turn_optimize);

            if (_point_index == 0) {
                //WƊJnĂB
                //덷dȂ̂ _frame_of_segment Ŏn_Ɉړ鑬xt^
                pVecDriver_target->setMvVelo((velo)(_distance_to_begin / frame_of_segment));
            } else {
                const coord calc_d = _pFixedFrameSplManuf->_paDistance_to[_point_index];
                const coord actually_d = UTIL::getDistance(
                                        _pActor_target->_x,
                                        _pActor_target->_y,
                                        _pActor_target->_z,
                                        x, y, z);

                if (calc_d*1.06 < actually_d) {
                    //x␳F\zJĂ(1.06{ȏ󂢂Ă)̂ŏ}(1.05{̃Xs[hɂ)
                    pVecDriver_target->setMvVelo(_pFixedFrameSplManuf->_paSPMvVeloTo[_point_index] * 1.05) ;
                } if (calc_d*0.94 > actually_d) {
                    //x␳F\z߂(0.94{ȓɂȂĂ)̂ŏ肷(0.95{̃Xs[hɂ)
                    pVecDriver_target->setMvVelo(_pFixedFrameSplManuf->_paSPMvVeloTo[_point_index] * (((1.0*actually_d)/calc_d)*0.95)) ;
                } else {
                    pVecDriver_target->setMvVelo(_pFixedFrameSplManuf->_paSPMvVeloTo[_point_index]);
                }
            }
        }
        _leading_frames++;
    }
    //_TRACE_(_pActor_target->getBehaveingFrame()<<": "<<_leading_frames<<": _cnt_loop="<<_cnt_loop<<"  _point_index="<<_point_index<<" velo="<<_pActor_target->getVecDriver()->getMvVelo()<<" xyz="<<_pActor_target->_x<<","<<_pActor_target->_y<<","<<_pActor_target->_z);
}
FixedFrameCurveVecDriverLeader::~FixedFrameCurveVecDriverLeader() {

}
