#include "jp/ggaf/dx/util/curve/FixedFrameCurveManufacture.h"

#include "jp/ggaf/dx/util/curve/CurveSource.h"
#include "jp/ggaf/dx/util/curve/FixedFrameCurveVecDriverLeader.h"
#include "jp/ggaf/dx/util/curve/FixedFrameCurveGeoDriverLeader.h"

using namespace GgafDx;

FixedFrameCurveManufacture::FixedFrameCurveManufacture(const char* prm_coord_spl_file,
                                                       frame prm_spent_frames,
                                                       angvelo prm_angvelo_rzry_mv,
                                                       int prm_turn_way,
                                                       bool prm_turn_optimaize) : CurveManufacture(prm_coord_spl_file) {
    _spent_frames = prm_spent_frames;
    _angvelo_rzry_mv = prm_angvelo_rzry_mv;
    _turn_way = prm_turn_way;
    _turn_optimize = prm_turn_optimaize;

    //PԂ̎gp\t[
    _frame_of_segment = 1.0*_spent_frames / (_pCurve->_rnum-1);
    if (_frame_of_segment < 1.0) {
        _TRACE_("xFixedFrameCurveManufacture ["<<prm_coord_spl_file<<"] _frame_of_segment="<<_frame_of_segment<<" < 1.0f łB"
                "⊮_("<<(_pCurve->_rnum)<<")An_`I_t[("<<_spent_frames<<")̂ŁA⊮_̔тȂ߁AI_frame_of_segment1.0ɏ㏑B"
                "]Ĉړɂ"<<(_pCurve->_rnum)<<"t[܂BB");
        _frame_of_segment = 1.0;
    }
    _paSPMvVeloTo = NEW velo[_pCurve->_rnum];
    _move_method = FixedFrame;
}

FixedFrameCurveManufacture::FixedFrameCurveManufacture(CurveSource* prm_pCurve,
                                                       frame prm_spent_frames,
                                                       angvelo prm_angvelo_rzry_mv,
                                                       int prm_turn_way,
                                                       bool prm_turn_optimaize) : CurveManufacture(prm_pCurve) {
    _spent_frames = prm_spent_frames;
    _angvelo_rzry_mv = prm_angvelo_rzry_mv;
    _turn_way = prm_turn_way;
    _turn_optimize = prm_turn_optimaize;

    //PԂ̎gp\t[
    _frame_of_segment = 1.0*_spent_frames / (_pCurve->_rnum-1);
    if (_frame_of_segment < 1.0) {
        _TRACE_("xFixedFrameCurveManufacture  _frame_of_segment="<<_frame_of_segment<<" < 1.0f łB"
                "⊮_("<<(_pCurve->_rnum)<<")An_`I_t[("<<_spent_frames<<")̂ŁA⊮_̔тȂ߁AI_frame_of_segment1.0ɏ㏑B"
                "]Ĉړɂ"<<(_pCurve->_rnum)<<"t[܂BB");
        _frame_of_segment = 1.0;
    }
    _paSPMvVeloTo = NEW velo[_pCurve->_rnum];
    _move_method = FixedFrame;
}


void FixedFrameCurveManufacture::calculate() {
    //̂Q̃e[uČvZXV܂B
    // _paDistance_to[] : ̕⊮_܂ł̋
    // _paSPMvVeloTo[] : ̕⊮_BɕKvȑx

    //e_̎_́AƑx\ߑS߂Ă
    // _[2][3] = { {1000,2000,3000}, {2000,1000,0}, {3900, 0, 1000} }
    // point_num = 3          //_̐
    // accuracy = 0.25(=1/4)  //⊮_x
    // spent_frame = 120      //₷t[
    // ̏ꍇA}̂悤ɂȂ܂B
    //
    // X:_
    // o:_Ԃ̕⊮_iXvCȐʉߓ_j
    // X--o: ړ\̍W
    // _paDistance_to[] : ̕⊮_܂ł̋
    // _paSPMvVeloTo[] : ̕⊮_BɕKvȑx
    //
    // sp._rnum ͍v̓_̐ԂB sp._rnum = 9 ɂȂB
    // accuracy YȕɂȂȂꍇA_ɕ⊮_J邩ƂAʓ|Ȃ̂ŁAsp._rnumKgp
    // }YɏdȂꍇ̐}łB
    //
    //           v = _paSPMvVeloTo[1]                           v = _paSPMvVeloTo[8]
    //               _paDistance_to[1]     _paDistance_to[5]          _paDistance_to[8]
    //                    ||                     ||                         ||
    //                   <-->                 <------>                    <----->
    //                  X----o----o----o-----X--------o---------o--------o-------X
    //                  ^                    ^        ^                          ^
    //                  |                    |        |                          |
    //            (sp._x_compute[0],         | (sp._x_compute[5],        sp._x_compute[8]
    //             sp._y_compute[0],         |  sp._y_compute[5],        sp._y_compute[8]
    //             sp._z_compute[0])         |  sp._z_compute[5])        sp._z_compute[8]
    //                  |                    |                                   |
    //              (_[0][0],       (_[1][0],                       (_[2][0],
    //               _[0][1],        _[1][1],                        _[2][1],
    //               _[0][2])        _[1][2])                        _[2][2])
    //            = (1000,2000,3000)    = (2000,1000,0)                      = (3900, 0, 1000)
    //
    //                 <--------------------------------------------------------->
    //                                 120Frame₵Ĉړ(=_spent_frames)
    //                  <-->
    //                  _spent_frames = PԂ 120/8 Frame = _spent_frames / (sp._rnum-1);
    CurveManufacture::calculate();
    int rnum = _pCurve->_rnum;
    //_TRACE_("rnum="<<rnum);
    for (int t = 1; t < rnum; t++) {
        // paDistanceTo[t] Afrm_segment ňړ邽߂ɕKvȑx߂B
        //
        _paSPMvVeloTo[t] = ((velo)(_paDistance_to[t] / _frame_of_segment));
        if (_paSPMvVeloTo[t] == 0) {
            _paSPMvVeloTo[t] = 1;
        }
        //_TRACE_("_paDistance_to["<<t<<"]="<<_paDistance_to[t]<<" _frame_of_segment="<<_frame_of_segment<<" _paSPMvVeloTo["<<t<<"]="<<_paDistance_to[t]<<"");
    }
    _paSPMvVeloTo[0] = 0; //n_܂ł̑xȂǕȂB
    _paDistance_to[0] = 0;   //n_܂ł̋ȂǕȂB
}

void FixedFrameCurveManufacture::recalculateBySpentFrame(frame prm_spent_frames) {
    _spent_frames = prm_spent_frames;
    _frame_of_segment = 1.0*_spent_frames / (_pCurve->_rnum-1);
    if (_frame_of_segment < 1.0) {
        _TRACE_("xFixedFrameCurveManufacture::setSpentFrames()  _frame_of_segment="<<_frame_of_segment<<" < 1.0f łB"
                "⊮_("<<(_pCurve->_rnum)<<")An_`I_t[("<<_spent_frames<<")̂ŁA⊮_̔тȂ߁AI_frame_of_segment1.0ɏ㏑B"
                "]Ĉړɂ"<<(_pCurve->_rnum)<<"t[܂BB");
        _frame_of_segment = 1.0;
    }
    int rnum = _pCurve->_rnum;
    for (int t = 1; t < rnum; t++) {
        _paSPMvVeloTo[t] = ((velo)(_paDistance_to[t] / _frame_of_segment));
        if (_paSPMvVeloTo[t] == 0) {
            _paSPMvVeloTo[t] = 1;
        }
    }
    _paSPMvVeloTo[0] = 0; //n_܂ł̑xȂǕȂB
}

DriverLeader* FixedFrameCurveManufacture::createVecDriverLeader(GgafDx::VecDriver* prm_pVecDriver) {
    return NEW FixedFrameCurveVecDriverLeader(this, prm_pVecDriver);
}
DriverLeader* FixedFrameCurveManufacture::createGeoDriverLeader(GgafDx::GeoDriver* prm_pGeoDriver) {
    return NEW FixedFrameCurveGeoDriverLeader(this, prm_pGeoDriver);
}
FixedFrameCurveManufacture::~FixedFrameCurveManufacture() {
    //CjVCYOɉ邩Ȃ
    GGAF_DELETEARR_NULLABLE(_paDistance_to);
    //CjVCYOɉ邩Ȃ
    GGAF_DELETEARR_NULLABLE(_paSPMvVeloTo);
}
