#include "jp/ggaf/dx/util/SkinAniMeshAllocHierarchy.h"

#include "jp/ggaf/dx/util/SkinAniMeshContainer.h"
#include "jp/ggaf/dx/util/SkinAniMeshFrame.h"
#include "jp/ggaf/dx/exception/CriticalException.h"

using namespace GgafDx;

SkinAniMeshAllocHierarchy::SkinAniMeshAllocHierarchy() : BoneAniMeshAllocHierarchy() {
}

SkinAniMeshAllocHierarchy::~SkinAniMeshAllocHierarchy() {
}

// bVRei֐
HRESULT SkinAniMeshAllocHierarchy::CreateMeshContainer(THIS_
        LPCSTR Name,
        CONST D3DXMESHDATA *pMeshData,
        CONST D3DXMATERIAL *pMaterials,
        CONST D3DXEFFECTINSTANCE *pEffectInstances,
        DWORD NumMaterials,
        CONST DWORD *pAdjacency,
        LPD3DXSKININFO pSkinInfo,
        LPD3DXMESHCONTAINER *ppNewMeshContainer) {
    // bVReiIuWFNg̐
    SkinAniMeshContainer* pNewMC = (SkinAniMeshContainer*)createNewMeshContainer();
    HRESULT hr;

    // Oo^
    pNewMC->Name = copyStr( Name );
    // אڃ|Si[̂߂̃obt@m
    DWORD polynum = pMeshData->pMesh->GetNumFaces();
    pNewMC->pAdjacency = NEW DWORD[ polynum * 3 ];   // z񐶐
    memset(pNewMC->pAdjacency, 0, polynum * 3 * sizeof(DWORD)); // Rs[

    // XLo^
    if(pSkinInfo) {
        pNewMC->pSkinInfo = pSkinInfo;// XLRs[
        pNewMC->pSkinInfo->AddRef();
        DWORD bone_num = pSkinInfo->GetNumBones();
        // `撸_Ɋ֌W{[̐  {[ItZbgs̐
        pNewMC->_dwBoneOffsetMatrixNum = bone_num;
        _TRACE_("pSkinInfo->GetNumBones() = "<<bone_num);
        pNewMC->_paBoneOffsetMatrix = new D3DXMATRIX[bone_num];
        for (DWORD i =  0; i < bone_num; i++) {
            // ItZbgsRs[
            memcpy(&pNewMC->_paBoneOffsetMatrix[i], pSkinInfo->GetBoneOffsetMatrix(i), sizeof(D3DXMATRIX));
        }
        _TRACE_("{[ItZbgsRs[܂");

        // bVf[^o^
        pNewMC->MeshData.Type = pMeshData->Type;   // bV^Cv
        //bVf[^œK
        //E_A`ʂבւčœK
        //E{[̉e͈͂ƂɁAbVTuZbgɕ
        //E_Ƀuhdlt^
        //E{[ɍ킹Ē_ړ
//        DWORD Options = D3DXMESH_SYSTEMMEM|D3DXMESHOPT_VERTEXCACHE;
        LPD3DXBUFFER pVertexRemap;
        hr = pNewMC->pSkinInfo->ConvertToBlendedMesh(
          pMeshData->pMesh,                  //[in] LPD3DXMESH pMesh, ̓bV
          NULL,                              //[in] DWORD Options,          gpH
          pAdjacency,                        //[in] CONST LPDWORD pAdjacencyIn, ̓bVאږʏizHj
          pNewMC->pAdjacency,                //[out]LPDWORD pAdjacencyOut,     o̓bVאږʏ
          NULL,                 //[out]DWORD *pFaceRemap,         ʂǂבւ̏AsvNULL
          &(pVertexRemap),                 //[out]LPD3DXBUFFER *ppVertexRemap, _ǂבւ̏AsvNULL
          &(pNewMC->_dwMaxInfleNum),         //[out]DWORD *pMaxFaceInfl, ̒_ɉe^{[̐̍ől
          &(pNewMC->_dwBoneCombNum),         //[out]DWORD *pNumBoneCombinations, {[Rrl[V̐
          &(pNewMC->_pBoneCombinationTable), //[out]LPD3DXBUFFER *ppBoneCombinationTable, {[Rrl[VA{[ƒ_̑Ή\z
          &(pNewMC->MeshData.pMesh)          //[out]LPD3DXMESH *ppMesh o̓bVAς݂̃bVԂĂ
        );
        checkDxException(hr, D3D_OK, "ConvertToBlendedMeshɎs܂B");
        //RemapA^[Qbg̒_obt@OIɏԕύXꂽꍇ́Ã\bhĂяoKv܂B
        DWORD* d = (DWORD*)pVertexRemap->GetBufferPointer();
        pNewMC->pSkinInfo->Remap(pNewMC->MeshData.pMesh->GetNumVertices(),d);
        pVertexRemap->Release();

        // ConvertToBlenderMesh֐Ŗ߂Ă ID3DXBuffer ɂ́A
        // D3DXBONECOMBINATION\̂@NumBoneCombinations ĂB
    } else {
        //throwCriticalException("SkinAniMeshAllocHierarchy::CreateMeshContainer()  pSkinInfo 񂪂܂");
        _TRACE_("xSkinAniMeshAllocHierarchy::CreateMeshContainer()  pSkinInfo 񂪂܂B pNewMC->Name="<<pNewMC->Name);
        pNewMC->pSkinInfo = nullptr;
        pNewMC->_dwBoneOffsetMatrixNum = 0;
        pNewMC->_paBoneOffsetMatrix = nullptr;
        pNewMC->_dwMaxInfleNum = 0;
        pNewMC->_dwBoneCombNum = 0;
        pNewMC->_pBoneCombinationTable = nullptr;
        BoneAniMeshAllocHierarchy::createNewMeshContainer(); //̂ƂύXȂ
    }

    // }eAo^
    pNewMC->NumMaterials = NumMaterials;
    registerMaterial( pMaterials, NumMaterials, &pNewMC->pMaterials);
    // GtFNgo^
    registerEffect( pEffectInstances, &pNewMC->pEffects );

    *ppNewMeshContainer = pNewMC;

    return D3D_OK;
}

D3DXFRAME* SkinAniMeshAllocHierarchy::createNewFrame() {
    SkinAniMeshFrame* tmp = NEW SkinAniMeshFrame;
    ZeroMemory( tmp, sizeof(D3DXFRAME) );
    //eNXo(BoneAniMeshFrame)
    tmp->_frame_index = MAXDWORD; // 0 LȃCfbNXȂ̂ 0 ŏȂ
    D3DXMatrixIsIdentity(&(tmp->_world_trans_matrix)); //Ƃ肠Pʍs
    //g̏
    tmp->_bone_id = MAXDWORD;
    D3DXMatrixIsIdentity(&(tmp->_bone_offset_matrix));
    D3DXMatrixIsIdentity(&(tmp->_combined_matrix));
    return tmp;
}

D3DXMESHCONTAINER* SkinAniMeshAllocHierarchy::createNewMeshContainer() {
    SkinAniMeshContainer* tmp = NEW SkinAniMeshContainer();
    ZeroMemory(tmp, sizeof(D3DXMESHCONTAINER));
    //g̏
    tmp->_dwMaxInfleNum = 0;    // {[őe
    tmp->_dwBoneCombNum = 0;    // {[Rrl[V
    tmp->_pBoneCombinationTable = nullptr;  // {[Rrl[V\̔zւ̃|C^

    tmp->_dwBoneOffsetMatrixNum = UINT_MAX;
    tmp->_paBoneOffsetMatrix = nullptr;
    return tmp;
}

// Rei폜
HRESULT SkinAniMeshAllocHierarchy::DestroyMeshContainer(THIS_
        LPD3DXMESHCONTAINER pMeshContainerToFree) {
    SkinAniMeshContainer* p = (SkinAniMeshContainer*)pMeshContainerToFree;

    delete[] p->Name;
    ID3DXMesh* pMesh = p->MeshData.pMesh;
    GGAF_RELEASE_NULLABLE(pMesh);

    for(unsigned int i=0; i < p->NumMaterials; i++){
        delete[] p->pMaterials[i].pTextureFilename;
    }
    delete[] p->pMaterials;

    // GtFNg
    for(int i = 0; i < p->pEffects->NumDefaults; i++) {
        delete[] p->pEffects->pDefaults[i].pParamName;
        delete[] p->pEffects->pDefaults[i].pValue;
    }

    delete[] p->pEffects->pEffectFilename;
    delete[] p->pEffects->pDefaults;
    delete p->pEffects;

    delete[] p->pAdjacency;
    LPD3DXSKININFO pSkinInfo = p->pSkinInfo;
    GGAF_RELEASE_NULLABLE(pSkinInfo);

    //ǉȂ͓
    ID3DXBuffer* pBoneCombinationTable = p->_pBoneCombinationTable;
    GGAF_RELEASE_NULLABLE(pBoneCombinationTable);

    D3DXMATRIX* paBoneOffsetMatrix = p->_paBoneOffsetMatrix;
    GGAF_DELETEARR_NULLABLE(pBoneCombinationTable);

    delete p;
    return D3D_OK;
}
