#include "jp/ggaf/dx/model/PointSpriteSetModel.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/Config.h"
#include "jp/ggaf/dx/actor/PointSpriteSetActor.h"
#include "jp/ggaf/dx/effect/PointSpriteSetEffect.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/manager/EffectManager.h"
#include "jp/ggaf/dx/manager/ModelManager.h"
#include "jp/ggaf/dx/manager/TextureConnection.h"
#include "jp/ggaf/dx/manager/TextureManager.h"
#include "jp/ggaf/dx/model/MassModel.h"
#include "jp/ggaf/dx/texture/Texture.h"


using namespace GgafDx;

DWORD PointSpriteSetModel::FVF = (D3DFVF_XYZ | D3DFVF_PSIZE | D3DFVF_DIFFUSE | D3DFVF_TEX1  );
//LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer = nullptr;

PointSpriteSetModel::PointSpriteSetModel(const char* prm_model_name) : Model(prm_model_name) {
    _TRACE3_("_model_name="<<_model_name);
    _set_num = 0;
    _pVertexBuffer = nullptr;
    _paVtxBuffer_data = nullptr;
    _square_size_px = 0.0f;
    _texture_size_px = 0.0f;
    _texture_split_rowcol = 1;
    _inv_texture_split_rowcol = 1.0f / _texture_split_rowcol;
    _size_vertices = 0;
    _size_vertex_unit= 0;
    _nVertices = 0;
    _obj_model |= Obj_GgafDx_PointSpriteSetModel;
}

HRESULT PointSpriteSetModel::draw(FigureActor* prm_pActor_target, int prm_draw_set_num, void* prm_pPrm) {
    _TRACE4_("PointSpriteSetModel::draw("<<prm_pActor_target->getName()<<") this="<<getName());
#ifdef MY_DEBUG
    if (prm_draw_set_num > _set_num) {
        _TRACE_(FUNC_NAME<<" "<<_model_name<<" ̕`ZbgI[o[B_set_num="<<_set_num<<" ɑ΂Aprm_draw_set_num="<<prm_draw_set_num<<"łB");
    }
#endif
    IDirect3DDevice9* pDevice = God::_pID3DDevice9;
    //ΏۃAN^[
    const PointSpriteSetActor* pTargetActor = (PointSpriteSetActor*)prm_pActor_target;
    //ΏPointSpriteSetActor̃GtFNgbp
    PointSpriteSetEffect* pPointSpriteSetEffect = (PointSpriteSetEffect*)prm_pActor_target->getEffect();
    //ΏۃGtFNg
    ID3DXEffect* const pID3DXEffect = pPointSpriteSetEffect->_pID3DXEffect;

    HRESULT hr;
    //fłAZbgȂΒ_obt@ACfbNXobt@̐ݒ̓XLbvł
    Model* pModelLastDraw = ModelManager::_pModelLastDraw;
    if (pModelLastDraw != this) {
        if (pModelLastDraw && (pModelLastDraw->_obj_model & Obj_GgafDx_MassModel)) {
            ((MassModel*)pModelLastDraw)->resetStreamSourceFreq();
        }
        //_obt@ƃCfbNXobt@ݒ
        pDevice->SetStreamSource(0, _pVertexBuffer,  0, _size_vertex_unit);
        pDevice->SetFVF(PointSpriteSetModel::FVF);
        if (_papTextureConnection[0]) {
            hr = pDevice->SetTexture(0, getDefaultTextureConnection()->peek()->_pIDirect3DBaseTexture9);
        } else {
            _TRACE_("PointSpriteSetModel::draw("<<prm_pActor_target->getName()<<") eNX`܂B"<<(CONFIG::WHITE_TEXTURE)<<"ݒ肳ׂłBł");
            //΃eNX`
            hr = pDevice->SetTexture(0, nullptr);
        }
        pDevice->SetIndices(nullptr);

        hr = pID3DXEffect->SetFloat(pPointSpriteSetEffect->_hTexSize, _texture_size_px);
        checkDxException(hr, D3D_OK, "SetFloat(_hTexSize) Ɏs܂B");
        hr = pID3DXEffect->SetInt(pPointSpriteSetEffect->_hTextureSplitRowcol, _texture_split_rowcol);
        checkDxException(hr, D3D_OK, "SetInt(_hTextureSplitRowcol) Ɏs܂B");
        hr = pID3DXEffect->SetFloat(pPointSpriteSetEffect->_hInvTextureSplitRowcol, _inv_texture_split_rowcol);
        checkDxException(hr, D3D_OK, "SetInt(_hInvTextureSplitRowcol) Ɏs܂B");
    }

    Effect* pEffect_active = EffectManager::_pEffect_active;
    if (FigureActor::_hash_technique_last_draw != prm_pActor_target->_hash_technique) {
        if (pEffect_active) {
            _TRACE4_("EndPass("<<pEffect_active->_pID3DXEffect<<"): /_pEffect_active="<<pEffect_active->_effect_name<<"("<<pEffect_active<<")");
            hr = pEffect_active->_pID3DXEffect->EndPass();
            checkDxException(hr, D3D_OK, "EndPass() Ɏs܂B");
            hr = pEffect_active->_pID3DXEffect->End();
            checkDxException(hr, D3D_OK, "End() Ɏs܂B");
#ifdef MY_DEBUG
            if (pEffect_active->_begin == false) {
                throwCriticalException("begin Ă܂ "<<(pEffect_active==nullptr?"nullptr":pEffect_active->_effect_name)<<"");
            } else {
                pEffect_active->_begin = false;
            }
#endif
        }
        _TRACE4_("SetTechnique("<<pTargetActor->_technique<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pPointSpriteSetEffect->_effect_name);
        hr = pID3DXEffect->SetTechnique(pTargetActor->_technique);
        checkDxException(hr, S_OK, "SetTechnique("<<pTargetActor->_technique<<") Ɏs܂B");

        _TRACE4_("BeginPass("<<pID3DXEffect<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pPointSpriteSetEffect->_effect_name<<"("<<pPointSpriteSetEffect<<")");
        //UINT numPass;
        hr = pID3DXEffect->Begin(&_num_pass, D3DXFX_DONOTSAVESTATE );
        checkDxException(hr, D3D_OK, "Begin() Ɏs܂B");
        hr = pID3DXEffect->BeginPass(0);
        checkDxException(hr, D3D_OK, "BeginPass(0) Ɏs܂B");

#ifdef MY_DEBUG
        if (pPointSpriteSetEffect->_begin) {
            throwCriticalException("End Ă܂ "<<(EffectManager::_pEffect_active==nullptr?"nullptr":EffectManager::_pEffect_active->_effect_name)<<"");
        } else {
            pPointSpriteSetEffect->_begin = true;
        }
#endif
    } else {
        hr = pID3DXEffect->CommitChanges();
        checkDxException(hr, D3D_OK, "CommitChanges() Ɏs܂B");
    }
    _TRACE4_("DrawIndexedPrimitive: /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pPointSpriteSetEffect->_effect_name);
    hr = pDevice->DrawPrimitive(D3DPT_POINTLIST, 0, _nVertices*prm_draw_set_num);
    checkDxException(hr, D3D_OK, " pass=1 Ɏs܂B");
#ifdef MY_DEBUG
        GgafCore::God::_num_drawing++;
#endif

    ModelManager::_pModelLastDraw = this;
    EffectManager::_pEffect_active = pPointSpriteSetEffect;
    FigureActor::_hash_technique_last_draw = prm_pActor_target->_hash_technique;
    return D3D_OK;
}

void PointSpriteSetModel::restore() {
    _TRACE3_("_model_name=" << _model_name << " start");
    if (_paVtxBuffer_data == nullptr) {
        ModelManager* pModelManager = pGOD->_pModelManager;
        HRESULT hr;
        //ÓIȏݒ
        std::vector<std::string> names = UTIL::split(std::string(_model_name), ",");
        std::string xfile_name = ""; //ǂݍXt@C
        if (names.size() == 1) {
            _TRACE_(FUNC_NAME<<" "<<_model_name<<" ̍ő哯`IuWFNǵAftHg15ݒ肳܂B");
            _set_num = 15;
            xfile_name = ModelManager::getSpriteFileName(names[0], "psprx");
        } else if (names.size() == 2) {
            _set_num = STOI(names[0]);
            xfile_name = ModelManager::getSpriteFileName(names[1], "psprx");
        } else {
            throwCriticalException("_model_name ɂ \"xxxxxx\" or \"8,xxxxx\" `w肵ĂB \n"
                    "ۂ́A_model_name="<<_model_name<<" łB");
        }
//        if (_set_num < 1 || _set_num > GGAFDXMASS_MAX_INSTANCE_NUM) {
//            throwCriticalException(_model_name<<"̍ő哯`IuWFNgsB͈͂ 1`"<<GGAFDXMASS_MAX_INSTANCE_NUM<<"ZbgłB_set_num="<<_set_num);
//        }
//        if (xfile_name == "") {
//            throwCriticalException("|CgXvCg`t@C(*.psprx)܂Bmodel_name="<<(_model_name));
//        }
        ModelManager::PointSpriteXFileFmt xdata;
        pModelManager->obtainPointSpriteInfo(&xdata, xfile_name);

        //}eA`P̂ŁA`̂߂ɖP}eA쐬B
//        _num_materials = 1; ////setMaterial();Ŏsς
        setMaterial();
//        _pa_texture_filenames = NEW std::string[1]; ////setMaterial();Ŏsς
        _pa_texture_filenames[0] = std::string(xdata.TextureFile);
        //foCXɃeNX`쐬 (ɂ邪A̓foCXXgs)
        //_obt@psize̎ZoɁAeNX`̒KvȂ߁AňU߂Ă
        if (_papTextureConnection == nullptr) {
            _papTextureConnection = NEW TextureConnection*[1];
            _papTextureConnection[0] =
                (TextureConnection*)(pModelManager->_pModelTextureManager->connect(_pa_texture_filenames[0].c_str(), this));
        }

        Texture* pTex = _papTextureConnection[0]->peek();
        float tex_width  = (float)(pTex->_pD3DXIMAGE_INFO->Width); //eNX`̕(px)
        float tex_height = (float)(pTex->_pD3DXIMAGE_INFO->Height); //eNX`̍(px)ƓɂȂ
        if ((int)(tex_width*100000) != (int)(tex_height*100000)) {
            throwCriticalException("|CgXvCgpeNX`["<<pTex->getName()<<"]("<<tex_width<<"x"<<tex_height<<")́A`łKv܂B");
        }
        _texture_size_px = tex_width;
        _square_size_px = xdata.SquareSize;
        _texture_split_rowcol = xdata.TextureSplitRowCol;
        _inv_texture_split_rowcol = 1.0f / _texture_split_rowcol;
        _nVertices = xdata.VerticesNum;
        if (_nVertices*_set_num > 65535) {
            throwCriticalException("_ 65535𒴂܂B\nΏModelF"<<getName()<<"  _nVertices*_set_num:"<<_nVertices*_set_num);
        }
//        _nFaces = 0; //_nFaces͎gpȂ
        _paVtxBuffer_data = NEW PointSpriteSetModel::VERTEX[_nVertices*_set_num];
        _size_vertex_unit = sizeof(PointSpriteSetModel::VERTEX);
        _size_vertices = sizeof(PointSpriteSetModel::VERTEX) * _nVertices*_set_num;

        FLOAT model_bounding_sphere_radius;


        for (UINT i = 0; i < _nVertices; i++) {
            _paVtxBuffer_data[i].x = xdata.paD3DVECTOR_Vertices[i].x;
            _paVtxBuffer_data[i].y = xdata.paD3DVECTOR_Vertices[i].y;
            _paVtxBuffer_data[i].z = xdata.paD3DVECTOR_Vertices[i].z;

            _paVtxBuffer_data[i].psize = (_square_size_px*_texture_split_rowcol / _texture_size_px) * xdata.paFLOAT_InitScale[i]; //PSIZEɂ̓sNZTCYł͂Ȃ{𖄂ߍށB
            //VF[_[ŊgksNZvZ
            _paVtxBuffer_data[i].color = D3DCOLOR_COLORVALUE(xdata.paD3DVECTOR_VertexColors[i].r,
                                                                   xdata.paD3DVECTOR_VertexColors[i].g,
                                                                   xdata.paD3DVECTOR_VertexColors[i].b,
                                                                   xdata.paD3DVECTOR_VertexColors[i].a );
            _paVtxBuffer_data[i].ini_ptn_no = (float)(xdata.paInt_InitUvPtnNo[i]); //_XvCgUVp^[ԍ
            _paVtxBuffer_data[i].index = 0; //_ԍiނ薄ߍ݁j

            model_bounding_sphere_radius = (FLOAT)(sqrt(_paVtxBuffer_data[i].x * _paVtxBuffer_data[i].x +
                                                        _paVtxBuffer_data[i].y * _paVtxBuffer_data[i].y +
                                                        _paVtxBuffer_data[i].z * _paVtxBuffer_data[i].z  )
                                                   + (((_square_size_px/PX_UNIT) * 1.41421356 ) / 2.0)
                                                 );

            if (_bounding_sphere_radius < model_bounding_sphere_radius) {
                _bounding_sphere_radius = model_bounding_sphere_radius;
            }
        }

        for (int n = 1; n < _set_num; n++) {
            int os = n*_nVertices;
            for (UINT i = 0; i < _nVertices; i++) {
                _paVtxBuffer_data[os+i].x = _paVtxBuffer_data[i].x;
                _paVtxBuffer_data[os+i].y = _paVtxBuffer_data[i].y;
                _paVtxBuffer_data[os+i].z = _paVtxBuffer_data[i].z;
                _paVtxBuffer_data[os+i].psize = _paVtxBuffer_data[i].psize;
                _paVtxBuffer_data[os+i].color = _paVtxBuffer_data[i].color;
                _paVtxBuffer_data[os+i].ini_ptn_no = _paVtxBuffer_data[i].ini_ptn_no;
                _paVtxBuffer_data[os+i].index = n; //_ԍiނ薄ߍ݁j
            }
        }

    }

    //foCXɒ_obt@쐬(f)
    if (_pVertexBuffer == nullptr) {
        HRESULT hr;
        //_obt@쐬
        hr = God::_pID3DDevice9->CreateVertexBuffer(
                _size_vertices,
                D3DUSAGE_WRITEONLY | D3DUSAGE_POINTS,
                PointSpriteSetModel::FVF,
                D3DPOOL_DEFAULT, //D3DPOOL_DEFAULT D3DPOOL_MANAGED
                &(_pVertexBuffer),
                nullptr);
        checkDxException(hr, D3D_OK, "_pID3DDevice9->CreateVertexBuffer s model="<<(_model_name));
        //obt@֍쐬ςݒ_f[^𗬂
        void* pDeviceMemory = 0;
        hr = _pVertexBuffer->Lock(0, _size_vertices, (void**)&pDeviceMemory, 0);
        checkDxException(hr, D3D_OK, "_obt@̃bN擾Ɏs model="<<_model_name);
        memcpy(pDeviceMemory, _paVtxBuffer_data, _size_vertices);
        hr = _pVertexBuffer->Unlock();
        checkDxException(hr, D3D_OK, "_obt@̃AbN擾Ɏs model="<<_model_name);
    }

    //foCXɃeNX`쐬
    if (_papTextureConnection == nullptr) {
        ModelManager* pModelManager = pGOD->_pModelManager;
        _papTextureConnection = NEW TextureConnection*[1];
        _papTextureConnection[0] =
            (TextureConnection*)(pModelManager->_pModelTextureManager->connect(_pa_texture_filenames[0].c_str(), this));
    }

//    //CfbNXobt@͎gȂ
//    _pIndexBuffer = nullptr;

    _TRACE3_("_model_name=" << _model_name << " end");
}

void PointSpriteSetModel::onDeviceLost() {
    _TRACE3_("_model_name=" << _model_name << " start");
    release();
    _TRACE3_("_model_name=" << _model_name << " end");
}

void PointSpriteSetModel::release() {
    _TRACE3_("_model_name=" << _model_name << " start");

    //eNX`
    if (_papTextureConnection) {
        for (int i = 0; i < (int)_num_materials; i++) {
            if (_papTextureConnection[i]) {
                _TRACE3_("close() _papTextureConnection["<<i<<"]->"<<(_papTextureConnection[i]->getIdStr()));
                _papTextureConnection[i]->close();
            }
        }
    }
    GGAF_DELETEARR(_papTextureConnection); //eNX`̔z
    GGAF_RELEASE(_pVertexBuffer);
    _TRACE3_("_model_name=" << _model_name << " end");

}
PointSpriteSetModel::~PointSpriteSetModel() {
    GGAF_DELETEARR(_paVtxBuffer_data);
    GGAF_DELETEARR(_paMaterial_default);
    GGAF_DELETEARR_NULLABLE(_pa_texture_filenames);
}

