#include "jp/ggaf/dx/model/MorphMeshModel.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/Config.h"
#include "jp/ggaf/dx/actor/MorphMeshActor.h"
#include "jp/ggaf/dx/effect/MorphMeshEffect.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/manager/EffectManager.h"
#include "jp/ggaf/dx/manager/ModelManager.h"
#include "jp/ggaf/dx/manager/TextureConnection.h"
#include "jp/ggaf/dx/manager/TextureManager.h"
#include "jp/ggaf/dx/model/MassModel.h"
#include "jp/ggaf/dx/texture/Texture.h"


using namespace GgafDx;

MorphMeshModel::MorphMeshModel(const char* prm_model_name) : Model(prm_model_name) {
    _obj_model |= Obj_GgafDx_MorphMeshModel;
    _TRACE3_("_model_name="<<_model_name);
    _morph_target_num = 0;

    _papModel3D = nullptr;
    _papMeshesFront = nullptr;

    _pVertexDeclaration = nullptr;
    _pVertexBuffer_primary = nullptr;
    _paIDirect3DVertexBuffer9_morph = nullptr;
    _pIndexBuffer = nullptr;
    _paVtxBuffer_data_primary = nullptr;
    _papaVtxBuffer_data_morph = nullptr;
    _paIndexBuffer_data = nullptr;
    _paIndexParam = nullptr;
    _material_list_grp_num = 0;
    _size_vertices_primary = 0;
    _size_vertex_unit_primary = 0;
    _size_vertices_morph = 0;
    _size_vertex_unit_morph = 0;

}

HRESULT MorphMeshModel::draw(FigureActor* prm_pActor_target, int prm_draw_set_num, void* prm_pPrm) {
    IDirect3DDevice9* pDevice = God::_pID3DDevice9;
    _TRACE4_("MorphMeshModel::draw("<<prm_pActor_target->getName()<<") this="<<getName());

    //ΏۃAN^[
    const MorphMeshActor* const pTargetActor = (MorphMeshActor*)prm_pActor_target;
    //ΏۃAN^[̃GtFNgbp
    MorphMeshEffect* const pMorphMeshEffect = (MorphMeshEffect*)prm_pActor_target->getEffect();
    //ΏۃGtFNg
    ID3DXEffect* const pID3DXEffect = pMorphMeshEffect->_pID3DXEffect;

    HRESULT hr;
    //_obt@ݒ
    Model* pModelLastDraw = ModelManager::_pModelLastDraw;
    if (pModelLastDraw != this) {
        if (pModelLastDraw && (pModelLastDraw->_obj_model & Obj_GgafDx_MassModel)) {
            ((MassModel*)pModelLastDraw)->resetStreamSourceFreq();
        }
        pDevice->SetVertexDeclaration( _pVertexDeclaration); //_tH[}bg
        pDevice->SetStreamSource(0, _pVertexBuffer_primary, 0, _size_vertex_unit_primary);
        for (int i = 1; i <= _morph_target_num; i++) {
            pDevice->SetStreamSource(i, _paIDirect3DVertexBuffer9_morph[i-1], 0, _size_vertex_unit_morph);
        }
        //CfbNXobt@ݒ
        pDevice->SetIndices(_pIndexBuffer);

        hr = pID3DXEffect->SetFloat(pMorphMeshEffect->_h_tex_blink_power, _power_blink);
        checkDxException(hr, D3D_OK, "SetFloat(_h_tex_blink_power) Ɏs܂B");
        hr = pID3DXEffect->SetFloat(pMorphMeshEffect->_h_tex_blink_threshold, _blink_threshold);
        checkDxException(hr, D3D_OK, "SetFloat(_h_tex_blink_threshold) Ɏs܂B");
        hr = pID3DXEffect->SetFloat(pMorphMeshEffect->_h_specular, _specular);
        checkDxException(hr, D3D_OK, "SetFloat(_h_specular) Ɏs܂B");
        hr = pID3DXEffect->SetFloat(pMorphMeshEffect->_h_specular_power, _specular_power);
        checkDxException(hr, D3D_OK, "SetFloat(_h_specular_power) Ɏs܂B");
    }

    //`
    for (UINT i = 0; i < _material_list_grp_num; i++) {
        const UINT material_no = _paIndexParam[i].MaterialNo;
        if (ModelManager::_pModelLastDraw != this || _material_list_grp_num != 1) {
            if (_papTextureConnection[material_no]) {
                if (material_no == 0) {
                    //}eA0Ԃ́AʂɋK̃eNX`ݒ肷dl
                    pDevice->SetTexture(0, getDefaultTextureConnection()->peek()->_pIDirect3DBaseTexture9);
                } else {
                    pDevice->SetTexture(0, _papTextureConnection[material_no]->peek()->_pIDirect3DBaseTexture9);
                }
            } else {
                _TRACE_("MorphMeshModel::draw("<<prm_pActor_target->getName()<<") eNX`܂B"<<(CONFIG::WHITE_TEXTURE)<<"ݒ肳ׂłBł");
                //΃eNX`
                pDevice->SetTexture(0, nullptr);
            }
        }
        hr = pID3DXEffect->SetValue(pMorphMeshEffect->_h_colMaterialDiffuse, &(pTargetActor->_paMaterial[material_no].Diffuse), sizeof(D3DCOLORVALUE) );
        checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");
        Effect* pEffect_active = EffectManager::_pEffect_active;
        if ((FigureActor::_hash_technique_last_draw != prm_pActor_target->_hash_technique) && i == 0) {
            if (pEffect_active) {
               _TRACE4_("EndPass("<<pEffect_active->_pID3DXEffect<<"): /_pEffect_active="<<pEffect_active->_effect_name<<"("<<pEffect_active<<")");
                hr = pEffect_active->_pID3DXEffect->EndPass();
                checkDxException(hr, D3D_OK, "EndPass() Ɏs܂B");
                hr = pEffect_active->_pID3DXEffect->End();
                checkDxException(hr, D3D_OK, "End() Ɏs܂B");
#ifdef MY_DEBUG
                if (pEffect_active->_begin == false) {
                    throwCriticalException("begin Ă܂ "<<(pEffect_active==nullptr?"nullptr":pEffect_active->_effect_name)<<"");
                } else {
                    pEffect_active->_begin = false;
                }
#endif
             }
            _TRACE4_("SetTechnique("<<pTargetActor->_technique<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pMorphMeshEffect->_effect_name);
            hr = pID3DXEffect->SetTechnique(pTargetActor->_technique);
            checkDxException(hr, S_OK, "SetTechnique("<<pTargetActor->_technique<<") Ɏs܂B");


            _TRACE4_("BeginPass("<<pID3DXEffect<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pMorphMeshEffect->_effect_name<<"("<<pMorphMeshEffect<<")");
            UINT numPass;
            hr = pID3DXEffect->Begin( &numPass, D3DXFX_DONOTSAVESTATE );
            checkDxException(hr, D3D_OK, "Begin() Ɏs܂B");
            //[t^[Qbg̐ɂ pass ؂ւĂ
            //v}bV̂                             = pass0
            //vC}bV{[t^[QbgbVP = pass1
            //vC}bV{[t^[QbgbVQ = pass2
            //ȉőX܂
            hr = pID3DXEffect->BeginPass(_morph_target_num);
            checkDxException(hr, D3D_OK, "BeginPass("<<_morph_target_num<<") Ɏs܂B");

#ifdef MY_DEBUG
            if (pMorphMeshEffect->_begin) {
                throwCriticalException("End Ă܂ "<<(EffectManager::_pEffect_active==nullptr?"nullptr":EffectManager::_pEffect_active->_effect_name)<<"");
            } else {
                pMorphMeshEffect->_begin = true;
            }
#endif

        } else {
            hr = pID3DXEffect->CommitChanges();
            checkDxException(hr, D3D_OK, "CommitChanges() Ɏs܂B");
        }

        _TRACE4_("DrawIndexedPrimitive: /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pMorphMeshEffect->_effect_name);
        pDevice->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,
                                      _paIndexParam[i].BaseVertexIndex,
                                      _paIndexParam[i].MinIndex,
                                      _paIndexParam[i].NumVertices,
                                      _paIndexParam[i].StartIndex,
                                      _paIndexParam[i].PrimitiveCount);
#ifdef MY_DEBUG
        GgafCore::God::_num_drawing++;
#endif
    }
    ModelManager::_pModelLastDraw = this;
    EffectManager::_pEffect_active = pMorphMeshEffect;
    FigureActor::_hash_technique_last_draw = prm_pActor_target->_hash_technique;

    return D3D_OK;
}

void MorphMeshModel::restore() {
    _TRACE3_("_model_name=" << _model_name << " start");
    //yMorphMeshModelč\zijTvz
    //{IɂrestoreMeshModel̏izj𑝂₵悤Ȃ
    //PjvC}{[t^[QbgN ́A_obt@A_CfbNXobt@ 쐬
    //QjꂼXt@CAƎɎ̏ǂݍ݁A_obt@A_CfbNXobt@ ɗށB
    //RjQjsȂߒŁA MeshModel Ɏ̃o쐬B
    //@@@@EvC}bV_obt@̎ʂ
    //@@@@E[t^[QbgN ̒_obt@̎ʂ
    //@@@@E_CfbNXobt@̎ʂivC}bV̂݁j
    //@@@@E}eAz(vf}eABvC}bV̂)
    //@@@@EeNX`z(vf}eABvC}bV̂)
    //@@@@EDrawIndexedPrimitivepz(vf}eAXgωBvC}bV̂)
    if (_paVtxBuffer_data_primary == nullptr) {
        ModelManager* pModelManager = pGOD->_pModelManager;
        std::string model_name = std::string(_model_name);

        std::string::size_type pos = model_name.find_last_of('_');
        if (pos == std::string::npos) {
            throwCriticalException("_model_name ɂ  \"xxx_4\" ̌`ŁA[t^[Qbg܂ރfw肵ĂB \n"
                    "ۂ́A_model_name="<<_model_name<<" łB(1)");
        }
        std::string str_model = model_name.substr(0, pos);  // "xxx_4"  xxx 
        std::string str_t_num = model_name.substr(pos + 1); // "xxx_4"  4 
        int morph_target_num  = STOI(str_t_num);
        _morph_target_num = morph_target_num;
        std::string* paXfileName = NEW std::string[_morph_target_num+1];
        for (int i = 0; i < _morph_target_num+1; i++) {
            paXfileName[i] = ModelManager::getMeshFileName(str_model + "_" + XTOS(i));
        }
        HRESULT hr;
        //ޒ_obt@f[^쐬
        ToolBox::IO_Model_X* paIOX = nullptr;
        Frm::Model3D**                        papModel3D = nullptr;
        Frm::Mesh**                           papMeshesFront = nullptr;

        MorphMeshModel::INDEXPARAM*     paIndexParam = nullptr;
        MorphMeshModel::VERTEX_PRIMARY* paVtxBuffer_data_primary = nullptr;
        MorphMeshModel::VERTEX_MORPH**  papaVtxBuffer_data_morph = nullptr;
        WORD*                                 paIdxBuffer_data = nullptr;


        paIOX = NEW ToolBox::IO_Model_X[morph_target_num+1];
        papModel3D = NEW Frm::Model3D*[morph_target_num+1];
        papMeshesFront = NEW Frm::Mesh*[morph_target_num+1];
        papaVtxBuffer_data_morph = NEW MorphMeshModel::VERTEX_MORPH*[morph_target_num];
        int nVertices = 0;
        int nTextureCoords = 0;
        int nFaces = 0;
//        int nFaceNormals = 0;
        FLOAT model_bounding_sphere_radius;
        for (int pattern = 0; pattern < morph_target_num+1; pattern++) {
            papModel3D[pattern] = NEW Frm::Model3D();
            bool r = paIOX[pattern].Load(paXfileName[pattern], papModel3D[pattern]);
            if (r == false) {
                throwCriticalException("Xt@C̓ǍݎsB2/ ƂYĂ܂񂩁H Ώ="<<paXfileName[pattern]);
            }
            //bVOɁAmۂĂ
            int nMesh = (int)papModel3D[pattern]->_Meshes.size();
            uint16_t* paNumVertices = NEW uint16_t[nMesh];
            int index_Mesh = 0;
            for (std::list<Frm::Mesh*>::iterator iteMeshes = papModel3D[pattern]->_Meshes.begin();
                    iteMeshes != papModel3D[pattern]->_Meshes.end(); iteMeshes++) {
                paNumVertices[index_Mesh] = ((*iteMeshes)->_nVertices);
                index_Mesh++;
            }
            papModel3D[pattern]->ConcatenateMeshes(); //bVq
            papMeshesFront[pattern] = papModel3D[pattern]->_Meshes.front();
            nVertices = papMeshesFront[pattern]->_nVertices;
            nTextureCoords = papMeshesFront[pattern]->_nTextureCoords;
            nFaces = papMeshesFront[pattern]->_nFaces;
//            nFaceNormals = papMeshesFront[pattern]->_nFaceNormals;

            if (nVertices*(morph_target_num+1) > 65535) {
                throwCriticalException("_ 65535𒴂܂B\nΏModelF"<<getName()<<"  nVertices:"<<nVertices<<"  Zbg:"<<(morph_target_num+1));
            }

            if (pattern == 0) {
                //vC}bV
                paVtxBuffer_data_primary = NEW MorphMeshModel::VERTEX_PRIMARY[nVertices];
                _size_vertices_primary = sizeof(MorphMeshModel::VERTEX_PRIMARY) * nVertices;
                _size_vertex_unit_primary = sizeof(MorphMeshModel::VERTEX_PRIMARY);
                //@ȊOݒ
                for (int i = 0; i < nVertices; i++) {
                    paVtxBuffer_data_primary[i].x = papMeshesFront[pattern]->_Vertices[i].data[0];
                    paVtxBuffer_data_primary[i].y = papMeshesFront[pattern]->_Vertices[i].data[1];
                    paVtxBuffer_data_primary[i].z = papMeshesFront[pattern]->_Vertices[i].data[2];
                    paVtxBuffer_data_primary[i].nx = 0.0f;
                    paVtxBuffer_data_primary[i].ny = 0.0f;
                    paVtxBuffer_data_primary[i].nz = 0.0f;
                    paVtxBuffer_data_primary[i].color = D3DCOLOR_ARGB(255,255,255,255);
                    if (i < nTextureCoords) {
                        paVtxBuffer_data_primary[i].tu = papMeshesFront[pattern]->_TextureCoords[i].data[0];  //oUVWݒ
                        paVtxBuffer_data_primary[i].tv = papMeshesFront[pattern]->_TextureCoords[i].data[1];
                    } else {
                        paVtxBuffer_data_primary[i].tu = 0.0f;
                        paVtxBuffer_data_primary[i].tv = 0.0f;
                    }

                    //
                    model_bounding_sphere_radius = (FLOAT)(sqrt(paVtxBuffer_data_primary[i].x * paVtxBuffer_data_primary[i].x +
                                                                paVtxBuffer_data_primary[i].y * paVtxBuffer_data_primary[i].y +
                                                                paVtxBuffer_data_primary[i].z * paVtxBuffer_data_primary[i].z));
                    if (_bounding_sphere_radius < model_bounding_sphere_radius) {
                        _bounding_sphere_radius = model_bounding_sphere_radius;
                    }
                }
            } else {
                //[t^[QbgbV
                papaVtxBuffer_data_morph[pattern-1] = NEW MorphMeshModel::VERTEX_MORPH[nVertices];
                _size_vertices_morph = sizeof(MorphMeshModel::VERTEX_MORPH) * nVertices;
                _size_vertex_unit_morph = sizeof(MorphMeshModel::VERTEX_MORPH);
                //@ȊOݒ
                for (int i = 0; i < nVertices; i++) {
                    papaVtxBuffer_data_morph[pattern-1][i].x = papMeshesFront[pattern]->_Vertices[i].data[0];
                    papaVtxBuffer_data_morph[pattern-1][i].y = papMeshesFront[pattern]->_Vertices[i].data[1];
                    papaVtxBuffer_data_morph[pattern-1][i].z = papMeshesFront[pattern]->_Vertices[i].data[2];
                    papaVtxBuffer_data_morph[pattern-1][i].nx = 0.0f;
                    papaVtxBuffer_data_morph[pattern-1][i].ny = 0.0f;
                    papaVtxBuffer_data_morph[pattern-1][i].nz = 0.0f;
                }
            }

            if (nVertices < nTextureCoords) {
                _TRACE_("nTextureCoords="<<nTextureCoords<<"/nVertices="<<nVertices);
                _TRACE_("UVWA_obt@zĂ܂B_܂łݒ肳܂BΏ="<<paXfileName[pattern]);
            }

            //@ݒFrameTransformMatrixKp
            if (pattern == 0) { //vC}bV
                prepareVtx((void*)paVtxBuffer_data_primary, _size_vertex_unit_primary,
                           papModel3D[pattern], paNumVertices);
            } else {            //^[QbgbV
                prepareVtx((void*)(papaVtxBuffer_data_morph[pattern-1]), _size_vertex_unit_morph,
                           papModel3D[pattern], paNumVertices);
            }
            GGAF_DELETE(paNumVertices);
        }

        //CfbNXobt@擾
        paIdxBuffer_data = NEW WORD[nFaces*3];
        for (int i = 0; i < nFaces; i++) {
            paIdxBuffer_data[i*3 + 0] = papMeshesFront[0]->_Faces[i].data[0];
            paIdxBuffer_data[i*3 + 1] = papMeshesFront[0]->_Faces[i].data[1];
            paIdxBuffer_data[i*3 + 2] = papMeshesFront[0]->_Faces[i].data[2];
        }

        //`掞iDrawIndexedPrimitivej̃p[^Xg쐬
        MorphMeshModel::INDEXPARAM* paParam = NEW MorphMeshModel::INDEXPARAM[nFaces];

        int prev_materialno = -1;
        int materialno = 0;
        int paramno = 0;
        int faceNoCnt_break = 0;
        int prev_faceNoCnt_break = -1;
        UINT max_num_vertices = 0;
        UINT min_num_vertices = UINT_MAX;

        int faceNoCnt;
        for (faceNoCnt = 0; faceNoCnt < nFaces; faceNoCnt++) {
            materialno = papMeshesFront[0]->_FaceMaterials[faceNoCnt];
            if (prev_materialno != materialno) {
                //_TRACE3_("BREAK! paramno="<<paramno);
                prev_faceNoCnt_break = faceNoCnt_break;
                faceNoCnt_break = faceNoCnt;

                paParam[paramno].MaterialNo = materialno;
                paParam[paramno].BaseVertexIndex = 0;
                paParam[paramno].MinIndex = UINT_MAX; //uCNɐݒAςȒlɂƂ
                paParam[paramno].NumVertices = UINT_MAX; //uCNɐݒ
                paParam[paramno].StartIndex = faceNoCnt*3;
                paParam[paramno].PrimitiveCount = UINT_MAX; //uCNɐݒ

                if (faceNoCnt > 0) {
                    paParam[paramno-1].MinIndex = min_num_vertices;
                    paParam[paramno-1].NumVertices = (UINT)(max_num_vertices - min_num_vertices + 1);
                    paParam[paramno-1].PrimitiveCount = (UINT)(faceNoCnt_break - prev_faceNoCnt_break);
                    //Zbg
                    max_num_vertices = 0;
                    min_num_vertices = UINT_MAX;
                }
                paramno++;
            }

            if (max_num_vertices <  paIdxBuffer_data[faceNoCnt*3 + 0]) {
                max_num_vertices = paIdxBuffer_data[faceNoCnt*3 + 0];
            }
            if (max_num_vertices <  paIdxBuffer_data[faceNoCnt*3 + 1]) {
                max_num_vertices = paIdxBuffer_data[faceNoCnt*3 + 1];
            }
            if (max_num_vertices <  paIdxBuffer_data[faceNoCnt*3 + 2]) {
                max_num_vertices = paIdxBuffer_data[faceNoCnt*3 + 2];
            }
            if (min_num_vertices >  paIdxBuffer_data[faceNoCnt*3 + 0]) {
                min_num_vertices = paIdxBuffer_data[faceNoCnt*3 + 0];
            }
            if (min_num_vertices >  paIdxBuffer_data[faceNoCnt*3 + 1]) {
                min_num_vertices = paIdxBuffer_data[faceNoCnt*3 + 1];
            }
            if (min_num_vertices >  paIdxBuffer_data[faceNoCnt*3 + 2]) {
                min_num_vertices = paIdxBuffer_data[faceNoCnt*3 + 2];
            }
            prev_materialno = materialno;
        }
        if (nFaces > 0) {
            paParam[paramno-1].MinIndex = min_num_vertices;
            paParam[paramno-1].NumVertices = (UINT)(max_num_vertices - min_num_vertices + 1);
            paParam[paramno-1].PrimitiveCount = (UINT)(faceNoCnt - faceNoCnt_break);
        }

        paIndexParam = NEW MorphMeshModel::INDEXPARAM[paramno];
        for (int i = 0; i < paramno; i++) {
            paIndexParam[i].MaterialNo = paParam[i].MaterialNo;
            paIndexParam[i].BaseVertexIndex = paParam[i].BaseVertexIndex;
            paIndexParam[i].MinIndex = paParam[i].MinIndex;
            paIndexParam[i].NumVertices = paParam[i].NumVertices;
            paIndexParam[i].StartIndex = paParam[i].StartIndex;
            paIndexParam[i].PrimitiveCount = paParam[i].PrimitiveCount;
        }
        _material_list_grp_num = paramno;
        delete[] paParam;


        GGAF_DELETEARR(paIOX);
        GGAF_DELETEARR(paXfileName);

        //fɕێ
        _papModel3D               = papModel3D;
        _papMeshesFront           = papMeshesFront;
        _paIndexBuffer_data       = paIdxBuffer_data;
        _paVtxBuffer_data_primary = paVtxBuffer_data_primary;
        _papaVtxBuffer_data_morph = papaVtxBuffer_data_morph;
        _paIndexParam             = paIndexParam;
        //}eAݒ
        //}eA̓vC}bṼ}eAA
        //vC}yёS[t^[Qbg̃}eAƂB
        //papMeshesFront[0]gAc͎gȂB
        //TODO:Iɂ̓[t^[QbgʂɃ}eAݒłΕ\B悤AԐB
        setMaterial(papMeshesFront[0]);
    }

    if (_pVertexDeclaration == nullptr) {
        HRESULT hr;
        int elemnum = (4+(2*_morph_target_num))+1; //D3DVERTEXELEMENT9 \̂̔zvf
        D3DVERTEXELEMENT9* paVtxelem = NEW D3DVERTEXELEMENT9[elemnum];
                                                         // 4 = vC}bV
                                                         // (2*morph_target_num) = [t^[QbgbV
                                                         // 1 = D3DDECL_END()
        //vC}bV_tH[}bg
        //FVF͎gȂ̂ŁACreateVertexDeclaration
        //TODO:_tH[}bg𖈉\zł͂ȂāAfɕێB
        //vC}_tH[}bg
        //float x, y, z; // _W
        paVtxelem[0].Stream = 0;
        paVtxelem[0].Offset = 0;
        paVtxelem[0].Type = D3DDECLTYPE_FLOAT3;
        paVtxelem[0].Method = D3DDECLMETHOD_DEFAULT;
        paVtxelem[0].Usage = D3DDECLUSAGE_POSITION;
        paVtxelem[0].UsageIndex = 0;
        //float nx, ny, nz; // @
        paVtxelem[1].Stream = 0;
        paVtxelem[1].Offset = sizeof(float)*3;
        paVtxelem[1].Type = D3DDECLTYPE_FLOAT3;
        paVtxelem[1].Method = D3DDECLMETHOD_DEFAULT;
        paVtxelem[1].Usage = D3DDECLUSAGE_NORMAL;
        paVtxelem[1].UsageIndex = 0;
        //DWORD color; // _J[
        paVtxelem[2].Stream = 0;
        paVtxelem[2].Offset = sizeof(float)*6;
        paVtxelem[2].Type = D3DDECLTYPE_D3DCOLOR;
        paVtxelem[2].Method = D3DDECLMETHOD_DEFAULT;
        paVtxelem[2].Usage = D3DDECLUSAGE_COLOR;
        paVtxelem[2].UsageIndex = 0;
        //float tu, tv; // eNX`W
        paVtxelem[3].Stream = 0;
        paVtxelem[3].Offset = sizeof(float)*6+sizeof(DWORD);
        paVtxelem[3].Type = D3DDECLTYPE_FLOAT2;
        paVtxelem[3].Method = D3DDECLMETHOD_DEFAULT;
        paVtxelem[3].Usage = D3DDECLUSAGE_TEXCOORD;
        paVtxelem[3].UsageIndex = 0;
        //[t^[QbgbV_tH[}bg
        for (int i = 4, s = 1; i < elemnum-1; i+=2, s++) {
            //float x, y, z; // _W
            paVtxelem[i].Stream = s;
            paVtxelem[i].Offset = 0;
            paVtxelem[i].Type = D3DDECLTYPE_FLOAT3;
            paVtxelem[i].Method = D3DDECLMETHOD_DEFAULT;
            paVtxelem[i].Usage = D3DDECLUSAGE_POSITION;
            paVtxelem[i].UsageIndex = s;
            //float nx, ny, nz; // @
            paVtxelem[i+1].Stream = s;
            paVtxelem[i+1].Offset = sizeof(float)*3;
            paVtxelem[i+1].Type = D3DDECLTYPE_FLOAT3;
            paVtxelem[i+1].Method = D3DDECLMETHOD_DEFAULT;
            paVtxelem[i+1].Usage = D3DDECLUSAGE_NORMAL;
            paVtxelem[i+1].UsageIndex = s;
        }
        //D3DDECL_END()
        paVtxelem[elemnum-1].Stream = 0xFF;
        paVtxelem[elemnum-1].Offset = 0;
        paVtxelem[elemnum-1].Type = D3DDECLTYPE_UNUSED;
        paVtxelem[elemnum-1].Method = 0;
        paVtxelem[elemnum-1].Usage = 0;
        paVtxelem[elemnum-1].UsageIndex = 0;

        hr = God::_pID3DDevice9->CreateVertexDeclaration( paVtxelem, &(_pVertexDeclaration) );
        checkDxException(hr, D3D_OK, "God::_pID3DDevice9->CreateVertexDeclaration s model="<<(_model_name));
        //Xg[擾        hr = m_pDecl->GetDeclaration( m_pElement, &m_numElements);

        GGAF_DELETEARR(paVtxelem);
    }
    //_obt@쐬
    if (_pVertexBuffer_primary == nullptr) {
        HRESULT hr;
        _paIDirect3DVertexBuffer9_morph = NEW LPDIRECT3DVERTEXBUFFER9[_morph_target_num];
        for (int pattern = 0; pattern < _morph_target_num+1; pattern++) {

            if (pattern == 0) {
                //vC}_obt@
                hr = God::_pID3DDevice9->CreateVertexBuffer(
                        _size_vertices_primary,
                        D3DUSAGE_WRITEONLY,
                        0, //MorphMeshModel::FVF,
                        D3DPOOL_DEFAULT, //D3DPOOL_DEFAULT
                        &(_pVertexBuffer_primary),
                        nullptr);
                checkDxException(hr, D3D_OK, "_pID3DDevice9->CreateVertexBuffer sivC}j model="<<(_model_name));
                void *pVertexBuffer;
                hr = _pVertexBuffer_primary->Lock(0, _size_vertices_primary, (void**)&pVertexBuffer, 0);
                checkDxException(hr, D3D_OK, "_obt@̃bN擾ɎsivC}j model="<<_model_name);
                memcpy(pVertexBuffer, _paVtxBuffer_data_primary, _size_vertices_primary); //pVertexBuffer  paVertex
                _pVertexBuffer_primary->Unlock();
            } else {
                //[t^[Qbg_obt@
                hr = God::_pID3DDevice9->CreateVertexBuffer(
                        _size_vertices_morph,
                        D3DUSAGE_WRITEONLY,
                        0, //MorphMeshModel::FVF,
                        D3DPOOL_DEFAULT, //D3DPOOL_DEFAULT
                        &(_paIDirect3DVertexBuffer9_morph[pattern-1]),
                        nullptr);
                checkDxException(hr, D3D_OK, "_pID3DDevice9->CreateVertexBuffer si[t:"<<pattern-1<<"j model="<<(_model_name));
                void *pVertexBuffer;
                hr = _paIDirect3DVertexBuffer9_morph[pattern-1]->Lock(0, _size_vertices_morph, (void**)&pVertexBuffer, 0);
                checkDxException(hr, D3D_OK, "_obt@̃bN擾Ɏsi[t:"<<pattern-1<<"j model="<<_model_name);
                memcpy(pVertexBuffer, _papaVtxBuffer_data_morph[pattern-1], _size_vertices_morph); //pVertexBuffer  paVertex
                _paIDirect3DVertexBuffer9_morph[pattern-1]->Unlock();
            }
        }
    }


    //CfbNXobt@f[^쐬ivC}A[t^[Qbgɓj
    if (_pIndexBuffer == nullptr) {
        HRESULT hr;
        int nFaces = _papMeshesFront[0]->_nFaces;
        hr = God::_pID3DDevice9->CreateIndexBuffer(
                                    sizeof(WORD) * nFaces * 3,
                                    D3DUSAGE_WRITEONLY,
                                    D3DFMT_INDEX16,
                                    D3DPOOL_DEFAULT,
                                    &(_pIndexBuffer),
                                    nullptr);
        checkDxException(hr, D3D_OK, "_pID3DDevice9->CreateIndexBuffer s model="<<(_model_name));
        void* pIndexBuffer;
        _pIndexBuffer->Lock(0,0,(void**)&pIndexBuffer,0);
        memcpy(pIndexBuffer, _paIndexBuffer_data , sizeof(WORD) * nFaces * 3);
        _pIndexBuffer->Unlock();
    }

    if (!_papTextureConnection) {
        ModelManager* pModelManager = pGOD->_pModelManager;
        _papTextureConnection = NEW TextureConnection*[_num_materials];
        for (DWORD n = 0; n < _num_materials; n++) {
            _papTextureConnection[n] =
                    (TextureConnection*)(pModelManager->_pModelTextureManager->connect(_pa_texture_filenames[n].c_str(), this));
        }
    }

    _TRACE3_("_model_name=" << _model_name << " end");
}

void MorphMeshModel::onDeviceLost() {
    _TRACE3_("_model_name=" << _model_name << " start");
    release();
    _TRACE3_("_model_name=" << _model_name << " end");
}

void MorphMeshModel::release() {
    _TRACE3_("_model_name=" << _model_name << " start");

    //eNX`
    if (_papTextureConnection) {
        for (DWORD i = 0; i < _num_materials; i++) {
            if (_papTextureConnection[i]) {
                _papTextureConnection[i]->close();
            }
        }
    }
    GGAF_DELETEARR(_papTextureConnection); //eNX`̔z

    for (int pattern = 0; pattern <= _morph_target_num; pattern++) {
        if (pattern == 0) {
            GGAF_RELEASE(_pVertexBuffer_primary);
        } else {
            GGAF_RELEASE(_paIDirect3DVertexBuffer9_morph[pattern-1]);
        }
    }
    GGAF_DELETEARR(_paIDirect3DVertexBuffer9_morph);
    GGAF_RELEASE(_pIndexBuffer);
    GGAF_RELEASE(_pVertexDeclaration);
    _TRACE3_("_model_name=" << _model_name << " end");

}
MorphMeshModel::~MorphMeshModel() {

    for (int pattern = 0; pattern <= _morph_target_num; pattern++) {
        if (pattern == 0) {
            GGAF_DELETEARR(_paVtxBuffer_data_primary);
        } else {
            GGAF_DELETEARR(_papaVtxBuffer_data_morph[pattern-1]);
        }
        if (_papModel3D) {
            Frm::Model3D* p = _papModel3D[pattern];
            GGAF_DELETE(p);
        }
    }
    GGAF_DELETEARR(_papaVtxBuffer_data_morph);
    GGAF_DELETEARR(_papModel3D);
    //_papMeshesFront[0],_papMeshesFront[1]  _papModel3D DELETEĂ̂łKv͖
    GGAF_DELETEARR(_papMeshesFront);
    _papMeshesFront = nullptr;
    GGAF_DELETEARR(_paIndexBuffer_data);
    GGAF_DELETEARR(_paIndexParam);
    GGAF_DELETEARR(_paMaterial_default);
    GGAF_DELETEARR_NULLABLE(_pa_texture_filenames);
    //release();
    //ModelConnection::processReleaseResource(Model* prm_pResource) ŌĂяo
}

