#include "jp/ggaf/dx/model/D3DXMeshModel.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/Config.h"
#include "jp/ggaf/dx/actor/D3DXMeshActor.h"
#include "jp/ggaf/dx/effect/MeshEffect.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/manager/EffectManager.h"
#include "jp/ggaf/dx/manager/ModelManager.h"
#include "jp/ggaf/dx/manager/TextureConnection.h"
#include "jp/ggaf/dx/manager/TextureManager.h"
#include "jp/ggaf/dx/model/MassModel.h"
#include "jp/ggaf/dx/texture/Texture.h"


using namespace GgafDx;

D3DXMeshModel::D3DXMeshModel(const char* prm_model_name, DWORD prm_dwOptions) : Model(prm_model_name) {
    _pID3DXMesh = nullptr;
    _num_materials = 0L;
    _dwOptions = prm_dwOptions;
    _obj_model |= Obj_GgafDx_D3DXMeshModel;
}

HRESULT D3DXMeshModel::draw(FigureActor* prm_pActor_target, int prm_draw_set_num, void* prm_pPrm) {
    _TRACE4_("D3DXMeshModel::draw("<<prm_pActor_target->getName()<<")");
    IDirect3DDevice9* const pDevice = God::_pID3DDevice9;
    //ΏۃAN^[
    const D3DXMeshActor* const pTargetActor = (D3DXMeshActor*)prm_pActor_target;
    //ΏMeshActor̃GtFNgbp
    MeshEffect* const pMeshEffect = (MeshEffect*)prm_pActor_target->getEffect();
    //ΏۃGtFNg
    ID3DXEffect* const pID3DXEffect = pMeshEffect->_pID3DXEffect;

    pDevice->SetFVF(D3DXMeshActor::FVF);
    HRESULT hr;
    Model* pModelLastDraw = ModelManager::_pModelLastDraw;
    if (pModelLastDraw != this) {
        if (pModelLastDraw && (pModelLastDraw->_obj_model & Obj_GgafDx_MassModel)) {
            ((MassModel*)pModelLastDraw)->resetStreamSourceFreq();
        }
    }
    for (DWORD i = 0; i < _num_materials; i++) {
        if (ModelManager::_pModelLastDraw != this || _num_materials != 1) {
            if (_papTextureConnection[i]) {
                if (i == 0) {
                    //}eA0Ԃ́AʂɋK̃eNX`ݒ肷dl
                    pDevice->SetTexture(0, getDefaultTextureConnection()->peek()->_pIDirect3DBaseTexture9);
                } else {
                    pDevice->SetTexture(0, _papTextureConnection[i]->peek()->_pIDirect3DBaseTexture9);
                }
            } else {
                _TRACE_("D3DXMeshModel::draw("<<prm_pActor_target->getName()<<") eNX`܂B"<<(CONFIG::WHITE_TEXTURE)<<"ݒ肳ׂłBł");
                //΃eNX`
                pDevice->SetTexture(0, nullptr);
            }
            //}eÃZbg
            hr = pID3DXEffect->SetValue(pMeshEffect->_h_colMaterialDiffuse, &(pTargetActor->_paMaterial[i].Diffuse), sizeof(D3DCOLORVALUE) );
            checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(pMeshEffect->_h_tex_blink_power, _power_blink);
            checkDxException(hr, D3D_OK, "SetFloat(_h_tex_blink_power) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(pMeshEffect->_h_tex_blink_threshold, _blink_threshold);
            checkDxException(hr, D3D_OK, "SetFloat(_h_tex_blink_threshold) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(pMeshEffect->_h_specular, _specular);
            checkDxException(hr, D3D_OK, "SetFloat(_h_specular) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(pMeshEffect->_h_specular_power, _specular_power);
            checkDxException(hr, D3D_OK, "SetFloat(_h_specular_power) Ɏs܂B");
        }

        //`
        Effect* pEffect_active = EffectManager::_pEffect_active;
        if ((FigureActor::_hash_technique_last_draw != prm_pActor_target->_hash_technique) && i == 0) {
            if (pEffect_active) {
                _TRACE4_("EndPass("<<pEffect_active->_pID3DXEffect<<"): /_pEffect_active="<<pEffect_active->_effect_name<<"("<<pEffect_active<<")");
                hr = pEffect_active->_pID3DXEffect->EndPass();
                checkDxException(hr, D3D_OK, "EndPass() Ɏs܂B");
                hr = pEffect_active->_pID3DXEffect->End();
                checkDxException(hr, D3D_OK, "End() Ɏs܂B");
#ifdef MY_DEBUG
                if (pEffect_active->_begin == false) {
                    throwCriticalException("begin Ă܂ "<<(pEffect_active==nullptr?"nullptr":pEffect_active->_effect_name)<<"");
                } else {
                    pEffect_active->_begin = false;
                }
#endif
            }
            _TRACE4_("SetTechnique("<<pTargetActor->_technique<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pMeshEffect->_effect_name);
            hr = pID3DXEffect->SetTechnique(pTargetActor->_technique);
            checkDxException(hr, S_OK, "SetTechnique("<<pTargetActor->_technique<<") Ɏs܂B");

            _TRACE4_("BeginPass("<<pID3DXEffect<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pMeshEffect->_effect_name<<"("<<pMeshEffect<<")");
            UINT numPass;
            hr = pID3DXEffect->Begin( &numPass, D3DXFX_DONOTSAVESTATE );
            checkDxException(hr, D3D_OK, "Begin() Ɏs܂B");
            hr = pID3DXEffect->BeginPass(0);
            checkDxException(hr, D3D_OK, "BeginPass(0) Ɏs܂B");

#ifdef MY_DEBUG
            if (pMeshEffect->_begin) {
                throwCriticalException("End Ă܂ "<<(EffectManager::_pEffect_active==nullptr?"nullptr":EffectManager::_pEffect_active->_effect_name)<<"");
            } else {
                pMeshEffect->_begin = true;
            }
#endif

        } else {
            hr = pID3DXEffect->CommitChanges();
            checkDxException(hr, D3D_OK, "CommitChanges() Ɏs܂B");
        }
        _TRACE4_("DrawSubset: /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pMeshEffect->_effect_name);
        hr = _pID3DXMesh->DrawSubset(i);  //Ȃĕ֗ȃ\bhB
#ifdef MY_DEBUG
        GgafCore::God::_num_drawing++;
#endif
    }
    //O`惂ff
    ModelManager::_pModelLastDraw = this;
    EffectManager::_pEffect_active = pMeshEffect;
    FigureActor::_hash_technique_last_draw = prm_pActor_target->_hash_technique;

    return D3D_OK;
}

//VF[_[O
//        if (pTargetActor->_sx == LEN_UNIT &&
//            pTargetActor->_sy == LEN_UNIT &&
//            pTargetActor->_sz == LEN_UNIT)
//        {
//            hr = _pID3DXMesh->DrawSubset(i); //Ȃĕ֗ȃ\bhI
//        } else {
//            //gkȂĂ邽߁AJԂɃgXtH[ꂽŒ_@̐K悤ɐݒi׍j
//            pDevice->SetRenderState(D3DRS_NORMALIZENORMALS, TRUE);
//            hr = _pID3DXMesh->DrawSubset(i); //Ȃĕ֗ȃ\bhI
//            pDevice->SetRenderState(D3DRS_NORMALIZENORMALS, FALSE);
//        }


void D3DXMeshModel::restore() {
    _TRACE3_("_model_name=" << _model_name << " start");
    ModelManager* pModelManager = pGOD->_pModelManager;
    //yrestoreD3DXMeshModelč\zijTvz
    //1)D3DXLoadMeshFromXgpXt@Cǂݍ
    //2)D3DXMeshModel̃oɃZbg

    //Xt@C̃[hĕKvȓeD3DXMeshModeloɐݒ肵CX^XƂĊ
    LPD3DXMESH pID3DXMesh; //bV(ID3DXMeshC^[tFCXւ̃|C^j
    D3DMATERIAL9* paMaterial; //}eA(D3DXMATERIAL\̂̔z̐擪vfw|C^j
    TextureConnection** papTextureConnection; //eNX`z(IDirect3DTexture9C^[tFCXւ̃|C^ێIuWFNgj
    DWORD num_materials;
    std::string xfile_name = ModelManager::getMeshFileName(_model_name);
    if (xfile_name == "") {
         throwCriticalException("bVt@C(*.x)܂Bmodel_name="<<(_model_name));
    }

    LPD3DXBUFFER pID3DXBuffer; //󂯎pobt@i}eApj
    HRESULT hr;
    //Xt@C̃t@C[h
    hr = D3DXLoadMeshFromX(
            xfile_name.c_str(),             //[in]  LPCTSTR pFilename
            _dwOptions, //[in]  DWORD Options  D3DXMESH_SYSTEMMEM D3DXMESH_VB_DYNAMIC
            God::_pID3DDevice9,       //[in]  LPDIRECT3DDEVICE9 pDevice
            nullptr,                        //[out] LPD3DXBUFFER* ppAdjacency
            &pID3DXBuffer,                  //[out] LPD3DXBUFFER* ppMaterials
            nullptr,                        //[out] LPD3DXBUFFER* ppEffectInstances
            &num_materials,                //[out] DWORD* pNumMaterials
            &pID3DXMesh                     //[out] LPD3DXMESH* pMesh
         );
    checkDxException(hr, D3D_OK, "D3DXLoadMeshFromXɂ郍[hsBΏ="<<xfile_name);

    //œK
    DWORD *pAdjacency = NEW DWORD [ pID3DXMesh->GetNumFaces() * 3 ];
    hr = pID3DXMesh->GenerateAdjacency( 1e-6f, pAdjacency );
    checkDxException(hr, D3D_OK, "GenerateAdjacency܂BΏ="<<xfile_name);
    hr = pID3DXMesh->OptimizeInplace( D3DXMESHOPT_ATTRSORT, pAdjacency, nullptr, nullptr, nullptr );
    checkDxException(hr, D3D_OK, "D3DXMESHOPT_ATTRSORTł܂BΏ="<<xfile_name);
    hr = pID3DXMesh->OptimizeInplace( D3DXMESHOPT_VERTEXCACHE, pAdjacency, nullptr, nullptr, nullptr );
    checkDxException(hr, D3D_OK, "D3DXMESHOPT_VERTEXCACHEł܂BΏ="<<xfile_name);
    GGAF_DELETEARR(pAdjacency);

    //}eAo
    D3DXMATERIAL* paD3DMaterial9_tmp = (D3DXMATERIAL*)(pID3DXBuffer->GetBufferPointer());
    //2008/02/02 ̔]݂
    // Ă邱ƃ
    // GetBufferPointer()Ŏ擾ł D3DXMATERIAL\̔z̃oMatD3D (D3DMATERIAL9\) ~B
    //\̂𕨗Rs[ĕۑ邱Ƃɂ܂`AƂ肠`܂傤B
    paMaterial = NEW D3DMATERIAL9[num_materials];
    for ( DWORD i = 0; i < num_materials; i++) {
        paMaterial[i] = paD3DMaterial9_tmp[i].MatD3D;
    }

    //}eADiffuse˂Ambient˂ɃRs[
    //RFAmbientCggpB̂߂ɂ͓RAmbient˒l}eAɐݒ肵Ȃ΂Ȃ
    //GNX|[gꂽxt@C̃}eAAmbient˒lݒ肳ĂȂic[̂HjB
    //܂قƂDiffuse=AmbientŖȂnYƍlB
    //ŃftHgŁADiffuse˒lAmbient˒lݒ肷邱ƂɂAƂ肠B
    //2009/3/13
    //ŒpCvC͂gȂȂBɔ}eADiffuse̓VF[_[̃p[^݂̂ŗpĂB
    //TODO:݃}eAAmbient͎QƂȂBH
    for ( DWORD i = 0; i < num_materials; i++) {
        paMaterial[i].Ambient = paMaterial[i].Diffuse;
    }

    //eNX`o
    papTextureConnection = NEW TextureConnection*[num_materials];
    char* texture_filename;
    for ( DWORD i = 0; i < num_materials; i++) {
        texture_filename = paD3DMaterial9_tmp[i].pTextureFilename;
        if (texture_filename != nullptr && lstrlen(texture_filename) > 0 ) {
            papTextureConnection[i] = (TextureConnection*)(pModelManager->_pModelTextureManager->connect(texture_filename, this));
        } else {
            //eNX`
            papTextureConnection[i] = (TextureConnection*)(pModelManager->_pModelTextureManager->connect(CONFIG::WHITE_TEXTURE.c_str(), this));
        }
    }
    GGAF_RELEASE(pID3DXBuffer);//eNX`t@C͂Ȃ̂Ńobt@

    //Xt@Cɖ@ȂꍇAFVFɖ@ǉA@vZĂݒB
    if(pID3DXMesh->GetFVF() != (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1)) {
        LPD3DXMESH pID3DXMesh_tmp = nullptr;
        hr = pID3DXMesh->CloneMeshFVF(
                           pID3DXMesh->GetOptions(),             // [in]  DWORD Options,
                           D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1, // [in]  DWORD FVF,
                           God::_pID3DDevice9,             // [in]  LPDIRECT3DDEVICE9 pDevice,
                           &pID3DXMesh_tmp                       // [out] LPD3DXMESH *ppCloneMesh
                         );
        checkDxException(hr, D3D_OK, " pID3DXMesh->CloneMeshFVF()sBΏ="<<xfile_name);
        D3DXComputeNormals(pID3DXMesh_tmp, nullptr); //@vZiFace̕\ǂɖ@邩AǂĔ肵Ă̂낤EEEj
        GGAF_RELEASE(pID3DXMesh);
        pID3DXMesh = pID3DXMesh_tmp;
    }

    //bVA}eAAeNX`̎QƁA}eAfIuWFNgɕێ
    _pID3DXMesh             = pID3DXMesh;
    _paMaterial_default     = paMaterial;
    _papTextureConnection   = papTextureConnection;
    _num_materials          = num_materials;
    _bounding_sphere_radius = 10.0f; //TODO:Ea傫Ƃ肠100px
    _TRACE3_("_model_name=" << _model_name << " end");
}

void D3DXMeshModel::onDeviceLost() {
    _TRACE3_("_model_name=" << _model_name << " start");
    //foCXXg͉܂B
    release();
    _TRACE3_("_model_name=" << _model_name << " end");
}

void D3DXMeshModel::release() {
    _TRACE3_("_model_name=" << _model_name << " start");
    if (_pID3DXMesh == nullptr) {
        _TRACE_("x [D3DXMeshModel::release()]  "<<_model_name<<"  _pID3DXMesh IuWFNgɂȂĂȂ release ł܂I");
    }
    //eNX`
    if (_papTextureConnection) {
        for (int i = 0; i < (int)_num_materials; i++) {
            if (_papTextureConnection[i]) {
                _TRACE3_("close() _papTextureConnection["<<i<<"]->"<<(_papTextureConnection[i]->getIdStr()));
                _papTextureConnection[i]->close();
            }
        }
    }
    GGAF_DELETEARR(_papTextureConnection); //eNX`̔z
    GGAF_RELEASE(_pID3DXMesh);
    GGAF_DELETEARR(_paMaterial_default);
    GGAF_DELETEARR_NULLABLE(_pa_texture_filenames);
    _TRACE3_("_model_name=" << _model_name << " end");
}

D3DXMeshModel::~D3DXMeshModel() {
    //release();
    //ModelConnection::processReleaseResource(Model* prm_pResource) ŌĂяo
}
