#include "jp/ggaf/dx/manager/SeManager.h"

#include <cstring>
#include "jp/ggaf/dx/manager/SeConnection.h"


using namespace GgafDx;

SeManager::SeManager(const char* prm_manager_name) :
    GgafCore::ResourceManager<Se> (prm_manager_name) {
    _se_master_volume_rate = 1.0;
}

Se* SeManager::processCreateResource(const char* prm_idstr, void* prm_pConnector) {
    // prm_idstr = "1,laser" ̏ꍇAf}l[W[̃L[ɂ"1,laser"œo^邱ƂɂȂB
    // Aǂݍwavet@C"laser.wav"ƂB
    // ́Awave𕡐`lŖ炵ꍇAŏ̐lω΁A
    // mۂƎӖB

    Se* pResource = nullptr;
    std::string idstr = std::string(prm_idstr);
    std::vector<std::string> names = UTIL::split(idstr, ",", 1); //ŏ̃XbVŕ
    if (names.size() == 2) {
        pResource = NEW Se(names[1].c_str());
    } else {
        pResource = NEW Se(names[0].c_str());
    }
    return pResource;
}

void SeManager::setSeMasterVolumeRate(double prm_volume_rate) {
    _se_master_volume_rate = prm_volume_rate;
    while (_is_connecting_resource) {
        Sleep(1);
    }
    SeConnection* pConne = (SeConnection*)_pConn_first;
    while (pConne) {

        Se* pSe = pConne->peek();
        pSe->setVolume(pSe->getVolume());

        while (_is_connecting_resource) { //ȈՔr
            Sleep(1);
        }
        pConne = (SeConnection*)(pConne->getNext());
    }
}

double SeManager::getSeMasterVolumeRate() {
    return _se_master_volume_rate;
}

GgafCore::ResourceConnection<Se>* SeManager::processCreateConnection(const char* prm_idstr, Se* prm_pResource) {
    _TRACE3_("prm_idstr="<<prm_idstr<<" 𐶐JnB");
    SeConnection* pConne = NEW SeConnection(prm_idstr, prm_pResource);
    _TRACE3_("prm_idstr="<<prm_idstr<<" 𐶐IB");
    return pConne;
}
