#include "jp/ggaf/dx/effect/MassSpriteEffect.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/scene/Spacetime.h"


using namespace GgafDx;

MassSpriteEffect::MassSpriteEffect(const char* prm_effect_name) : MassEffect(prm_effect_name) {
    _obj_effect |= Obj_GgafDx_MassSpriteEffect;
    Camera* const pCam = pGOD->getSpacetime()->getCamera();
    //VF[_[ʂ̃O[oϐݒ
    HRESULT hr;
    //ˉeϊs
    hr = _pID3DXEffect->SetMatrix("g_matProj", pCam->getProjectionMatrix() );
    checkDxException(hr, D3D_OK, "SetMatrix(g_matProj) Ɏs܂B");
    hr = _pID3DXEffect->SetFloat("g_zf", pCam->getZFar());
    checkDxException(hr, D3D_OK, "SetFloat(g_zf) Ɏs܂B");

    //VF[_[nh
    _h_matView  = _pID3DXEffect->GetParameterByName( nullptr, "g_matView" );
    _h_tex_blink_power = _pID3DXEffect->GetParameterByName( nullptr, "g_tex_blink_power" );
    _h_tex_blink_threshold = _pID3DXEffect->GetParameterByName( nullptr, "g_tex_blink_threshold" );
}

void MassSpriteEffect::setParamPerFrame() {
    Camera* const pCam = pGOD->getSpacetime()->getCamera();
    HRESULT hr = _pID3DXEffect->SetMatrix(_h_matView, pCam->getViewMatrix());
    checkDxException(hr, D3D_OK, "setParamPerFrame SetMatrix(_h_matView) Ɏs܂B");
}

MassSpriteEffect::~MassSpriteEffect() {
}

