#include "jp/ggaf/dx/actor/supporter/VecDriver.h"

#include <math.h>
#include "jp/ggaf/dx/actor/FigureActor.h"
#include "jp/ggaf/dx/actor/supporter/VecDriverMvAssistant.h"
#include "jp/ggaf/dx/actor/supporter/VecDriverFaceAngAssistant.h"
#include "jp/ggaf/dx/actor/supporter/VecDriverMvAngAssistant.h"
#include "jp/ggaf/dx/util/Util.h"

using namespace GgafDx;

VecDriver::VecDriver(GeometricActor* prm_pActor) : ActorDriver(prm_pActor) {
    _pAsstMv = nullptr;
    _pAsstFaceAng = nullptr;
    _pAsstMvAng = nullptr;
    reset();
}
VecDriverMvAssistant* VecDriver::asstMv() {
    return _pAsstMv ? _pAsstMv : _pAsstMv = NEW VecDriverMvAssistant(this);
}
VecDriverFaceAngAssistant* VecDriver::asstFaceAng() {
    return _pAsstFaceAng ? _pAsstFaceAng : _pAsstFaceAng = NEW VecDriverFaceAngAssistant(this);
}
VecDriverMvAngAssistant* VecDriver::asstMvAng() {
    return _pAsstMvAng ? _pAsstMvAng : _pAsstMvAng = NEW VecDriverMvAngAssistant(this);
}

void VecDriver::reset() {
    GGAF_DELETE_NULLABLE(_pAsstMv);
    GGAF_DELETE_NULLABLE(_pAsstFaceAng);
    GGAF_DELETE_NULLABLE(_pAsstMvAng);

    _actor_face[0] = &(_pActor->_rx);
    _actor_face[1] = &(_pActor->_ry);
    _actor_face[2] = &(_pActor->_rz);

    for (int ax = 0; ax < 3; ax++) { // i=0:XA1:YA2:Z \
        //ʕp̊pxiʕp̑j= 0 angle/fream
        _angvelo_face[ax] = 0; //1t[ɉZ鐳ʕp̊pBftHg͐ʕp̊pA܂UB
        //ʕp̊px  360,000 angle/fream
        _top_angvelo_face[ax] = D360ANG; //_angvelo_face[n] ̑̏BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊px  -360,000 angle/fream
        _bottom_angvelo_face[ax] = D360ANG * -1; //_angvelo_face[n] ̑̉BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊pxipx̑j  0 angle/fream^2
        _angacce_face[ax] = 0; //_angvelo_face[n] ̑BftHg͐ʕp̊px

        _angjerk_face[ax] = 0;
        //ڕWʕpւ̎tO = 
        _is_targeting_face[ax] = false;
        //ڕWʕpւ̎~tO = 
        _face_targeting_stop_flg[ax] = false;
        //ڕW̐ʕp
        _target_face[ax] = 0; //ڕWʕpւ̎tO = Ȁꍇ͖Ӗ
        //ڕW̐ʕp~@\LɂȂ]
        _face_stop_allow_way[ax] = TURN_BOTH;
        //ڕW̐ʕp~@\LɂȂpxi]ʁj
        _face_stop_allow_angvelo[ax] = D360ANG;
    }

    //////////////////////////////////////////////////////
    //L̈ړpPʃxNg
    _vX = 1.0f;
    _vY = _vZ = 0.0f;
    //ړpZ]
    _rz_mv = 0;
    //ړpY]
    _ry_mv = 0;
    //ړx
    _velo_mv = 0;
    //ړx
    _top_velo_mv = INT_MAX;
    //ړx
    _bottom_velo_mv = INT_MIN;
    //ړxiړx̑j = 0 px/fream^2
    _acc_mv = 0; //_velo_mv ̑BftHg͉

    //_jerkMv = 0;
    //ړpiZ]j̊px = 0 angle/fream
    _angvelo_rz_mv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiZ]j̊px = +360,000 angle/fream
    _top_angvelo_rz_mv = D360ANG; //_angvelo_rz_mv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = -360,000 angle/fream
    _bottom_angvelo_rz_mv = D360ANG * -1; //_angvelo_rz_mv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = 0 angle/fream^2
    _angacce_rz_mv = 0; //_angvelo_rz_mv ̑BftHg͈ړp̊px

    _angjerk_rz_mv = 0;
    //ڕWړpiZ]jւ̎tO = 
    _is_targeting_rz_mv = false;
    //ڕWړpiZ]jւ̎~tO = 
    _rz_mv_targeting_stop_flg = false;

    //ڕẄړpiZ]j
    _target_rz_mv = 0;
    //ڕẄړpiZ]j~@\LɂȂ]
    _rz_mv_stop_allow_way = TURN_BOTH;
    //ڕẄړpiZ]j~@\LɂȂړppx(px)
    _rz_mv_stop_allow_angvelo = D360ANG;
    //ړpiZ]jɔZʕp̓@\tO  
    _relate_RzFaceAng_with_RzMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    //ړpiY]j̊px = 0 angle/fream
    _angvelo_ry_mv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiY]j̊px = +360,000 angle/fream
    _top_angvelo_ry_mv = D360ANG; //_angvelo_ry_mv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = -360,000 angle/fream
    _bottom_angvelo_ry_mv = D360ANG * -1; //_angvelo_ry_mv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = 0 angle/fream^2
    _angacce_ry_mv = 0; //_angvelo_ry_mv ̑BftHg͈ړp̊px

    _angjerk_ry_mv = 0;
    //ڕWړpiY]jւ̎tO = 
    _is_targeting_ry_mv = false;
    //ڕWړpiY]jւ̎~tO = 
    _ry_mv_targeting_stop_flg = false;
    //ڕẄړpiY]j
    _target_ry_mv = 0;
    //ڕẄړpiY]j~@\LɂȂ]
    _ry_mv_stop_allow_way = TURN_BOTH;
    //ڕẄړpiY]j~@\LɂȂړppx(px)
    _ry_mv_stop_allow_angvelo = D360ANG;
    //ړpiY]jɔZʕp̓@\tO  
    _relate_RyFaceAng_with_RyMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    _taget_face_alltime_flg = false;
    _taget_face_alltime_pActor = nullptr;
    _taget_face_alltime_tx = 0;
    _taget_face_alltime_ty = 0;
    _taget_face_alltime_tz = 0;
    _taget_face_alltime_angvelo = 0;
    _taget_face_alltime_angacce = 0;
    _taget_face_alltime_way = TURN_CLOSE_TO;
    _taget_face_alltime_optimize_ang = true;
}

void VecDriver::behave() {
    if (_pAsstMv) {
        _pAsstMv->behave();
    }
    if (_pAsstFaceAng) {
        _pAsstFaceAng->behave();
    }
    if (_pAsstMvAng) {
        _pAsstMvAng->behave();
    }

    //ʕp
    for (axis ax = 0; ax < 3; ax++) {

        _angvelo_face[ax] += _angacce_face[ax];
        if (_angvelo_face[ax] > _top_angvelo_face[ax]) {
            _angvelo_face[ax] = _top_angvelo_face[ax];
        } else if (_angvelo_face[ax] < _bottom_angvelo_face[ax]) {
            _angvelo_face[ax] = _bottom_angvelo_face[ax];
        }

        if (_is_targeting_face[ax]) { //^[Qbgꍇ

            if (_angvelo_face[ax] > 0) { //v̏ꍇ
                const angle ang_distance = getFaceAngDistance(ax, _target_face[ax], TURN_COUNTERCLOCKWISE);
                if (_angvelo_face[ax] > ang_distance && _face_stop_allow_way[ax] != TURN_CLOCKWISE &&
                        _face_stop_allow_angvelo[ax] >= _angvelo_face[ax]) {
                    _angvelo_face[ax] = ang_distance;
                    if (_face_targeting_stop_flg[ax]) {
                        _is_targeting_face[ax] = false; //tO߂ďI
                        _face_targeting_stop_flg[ax] = false;
                    }
                } else {
                    // ȂɂȂĂ悢
                }
            } else if (_angvelo_face[ax] < 0) { //v̏ꍇ
                const angle ang_distance = getFaceAngDistance(ax, _target_face[ax], TURN_CLOCKWISE);
                if (_angvelo_face[ax] < ang_distance && _face_stop_allow_way[ax] != TURN_COUNTERCLOCKWISE
                        && -1 * _face_stop_allow_angvelo[ax] <= _angvelo_face[ax]) { //ڕWs߂Ă܂EEEȓ
                    _angvelo_face[ax] = ang_distance;
                    if (_face_targeting_stop_flg[ax]) {
                        _is_targeting_face[ax] = false; //tO߂ďI
                        _face_targeting_stop_flg[ax] = false;
                    }
                } else {
                    // ȂɂȂĂ悢
                }
            } else {
                //_angvelo_face[ax] == 0
                const angle ang_distance = getFaceAngDistance(ax, _target_face[ax], TURN_CLOSE_TO);
                if (ang_distance == 0) {
                    if (_face_targeting_stop_flg[ax]) {
                        _is_targeting_face[ax] = false; //tO߂ďI
                        _face_targeting_stop_flg[ax] = false;
                    }
                } else {
                    if (_angacce_face[ax] == 0) { //x0̏ꍇ~(iɓBȂ)
                        if (_face_targeting_stop_flg[ax]) {
                            _is_targeting_face[ax] = false; //tO߂ďI
                            _face_targeting_stop_flg[ax] = false;
                        }
                    }
                }
            }

            //Actorɔf
            (*(_actor_face[ax])) = UTIL::simplifyAng((*(_actor_face[ax])) + _angvelo_face[ax]);
            if (_is_targeting_face[ax] == false) {
                //ڕWɓB̏
                //_top_angvelo_face[ax] = D360ANG; //ʕp̊px  360,000 angle/fream
                //_bottom_angvelo_face[ax] = D360ANG * -1; //ʕp̊px  -360,000 angle/fream
                //ڕWɓBA~sȂ
                _angacce_face[ax] = 0; //]pApxO
                setFaceAngVelo(ax, 0); //]pApxO
            }

        } else {
            //^[Qbgꍇ
            //Actorɔf
            (*(_actor_face[ax])) = UTIL::simplifyAng((*(_actor_face[ax])) +  _angvelo_face[ax]);
        }

    }


    ///////////////////////////////////////////////////Mover

    //_acc_mv += _jerkMv;
    //ړx̏
    _velo_mv += _acc_mv;
    if (_velo_mv > _top_velo_mv) {
        _velo_mv = _top_velo_mv;
    } else if (_velo_mv < _bottom_velo_mv) {
        _velo_mv = _bottom_velo_mv;
    }

    ///////////
    //ڕWړpiZ]jAO~@\gp̏ꍇ
    if (_is_targeting_rz_mv) {

        _angvelo_rz_mv += _angacce_rz_mv;
        setRzMvAngVelo(_angvelo_rz_mv);

        if (_angvelo_rz_mv > 0) { //v̏ꍇ
            const angle ang_distance = getRzMvAngDistance(_target_rz_mv, TURN_COUNTERCLOCKWISE);
            if (_angvelo_rz_mv > ang_distance && _rz_mv_stop_allow_way != TURN_CLOCKWISE
                    && _rz_mv_stop_allow_angvelo >= _angvelo_rz_mv) { //ڕWs߂Ă܂EEEȓ
                addRzMvAng(ang_distance);
                if (_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_rz_mv = false; //tO߂ďI
                    _rz_mv_targeting_stop_flg = false;
                }
            } else {
                addRzMvAng(_angvelo_rz_mv);
            }
        } else if (_angvelo_rz_mv < 0) { //v̏ꍇ

            const angle ang_distance = getRzMvAngDistance(_target_rz_mv, TURN_CLOCKWISE);
            if (_angvelo_rz_mv < ang_distance && _rz_mv_stop_allow_way != TURN_COUNTERCLOCKWISE
                    && -1*_rz_mv_stop_allow_angvelo <= _angvelo_rz_mv) {
                addRzMvAng(ang_distance);
                if (_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_rz_mv = false; //tO߂ďI
                    _rz_mv_targeting_stop_flg = false;
                }
            } else {
                addRzMvAng(_angvelo_rz_mv);
            }
        } else {
            const angle ang_distance = getRzMvAngDistance(_target_rz_mv, TURN_CLOSE_TO);
            if (ang_distance == 0) {
                addRzMvAng(ang_distance);
                if (_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_rz_mv = false; //tO߂ďI
                    _rz_mv_targeting_stop_flg = false;
                }
            } else {
                if (_angacce_rz_mv == 0) { //xȂꍇ~
                    if (_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                        _is_targeting_rz_mv = false; //tO߂ďI
                        _rz_mv_targeting_stop_flg = false;
                    }
                }
            }
        }
        if (_is_targeting_rz_mv == false) {
            //_top_angvelo_rz_mv = D360ANG; //ړpiZ]j̊px  360,000 angle/fream
            //_bottom_angvelo_rz_mv = D360ANG * -1; //ړpiZ]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacce_rz_mv = 0; //ZړpApxO
            setRzMvAngVelo(0); //ZړpApxO
        }

    } else {
        //if (_angacce_rz_mv != 0) {

        _angacce_rz_mv += _angjerk_rz_mv;
        //t[̈ړpiZ]j̏
        _angvelo_rz_mv += _angacce_rz_mv;
        if (_angvelo_rz_mv != 0) {
            addRzMvAng(_angvelo_rz_mv);
        }
        //}
    }
    ////////////////
    //ڕWړpiY]jAO~@\gp̏ꍇ
    if (_is_targeting_ry_mv) {

        _angvelo_ry_mv += _angacce_ry_mv;
        setRyMvAngVelo(_angvelo_ry_mv);

        if (_angvelo_ry_mv > 0) { //݂͔v̏ꍇ
            angle ang_distance = getRyMvAngDistance(_target_ry_mv, TURN_COUNTERCLOCKWISE);
            if (_angvelo_ry_mv > ang_distance &&
                _ry_mv_stop_allow_way != TURN_CLOCKWISE &&
                _ry_mv_stop_allow_angvelo >= _angvelo_ry_mv)
            { //ڕWs߂Ă܂EEEȓ
                addRyMvAng(ang_distance);
                if (_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ry_mv = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angvelo_ry_mv);
            }
        } else if (_angvelo_ry_mv < 0) { //݂͎v̏ꍇ

            angle ang_distance = getRyMvAngDistance(_target_ry_mv, TURN_CLOCKWISE);
            if (_angvelo_ry_mv < ang_distance &&
                _ry_mv_stop_allow_way != TURN_COUNTERCLOCKWISE &&
                -1*_ry_mv_stop_allow_angvelo <= _angvelo_ry_mv)
            {
                addRyMvAng(ang_distance);
                if (_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ry_mv = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angvelo_ry_mv);
            }
        } else { //_angvelo_ry_mv==0
            angle ang_distance = getRyMvAngDistance(_target_ry_mv, TURN_CLOSE_TO);
            if (ang_distance == 0) {
                addRyMvAng(ang_distance);
                if (_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ry_mv = false; //tO߂ďI
                    _ry_mv_targeting_stop_flg = false;
                }
            } else {
                if (_angacce_ry_mv == 0) { //xȂꍇ~
                    if (_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                        _is_targeting_ry_mv = false; //tO߂ďI
                        _ry_mv_targeting_stop_flg = false;
                    }
                }
            }
        }
        if (_is_targeting_ry_mv == false) {
            //_top_angvelo_ry_mv = D360ANG; //ړpiY]j̊px  360,000 angle/fream
            //_bottom_angvelo_ry_mv = D360ANG*-1; //ړpiY]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacce_ry_mv = 0; //YړpApxO
            setRyMvAngVelo(0); //YړpApxO
        }

    } else {
        //if (_angacce_ry_mv != 0) {
        _angacce_ry_mv += _angjerk_ry_mv;
        //t[̈ړpiY]j̏
        _angvelo_ry_mv += _angacce_ry_mv;
        if(_angvelo_ry_mv != 0) {
            addRyMvAng(_angvelo_ry_mv);
        }
        //}
    }

    ///////////////
    if (_taget_face_alltime_flg && _is_targeting_face[AXIS_Z] == false && _is_targeting_face[AXIS_Y] == false) {
        if (_taget_face_alltime_pActor) {
            keepOnTurningFaceAngTwd(
                    _taget_face_alltime_pActor,
                    _taget_face_alltime_angvelo,
                    _taget_face_alltime_angacce,
                    _taget_face_alltime_way,
                    _taget_face_alltime_optimize_ang);
        } else {
            keepOnTurningFaceAngTwd(
                    _taget_face_alltime_pActor->_x,
                    _taget_face_alltime_pActor->_y,
                    _taget_face_alltime_pActor->_z,
                    _taget_face_alltime_angvelo,
                    _taget_face_alltime_angacce,
                    _taget_face_alltime_way,
                    _taget_face_alltime_optimize_ang);
        }

    }
    //Actorɔf
    _pActor->_x += (coord)(_vX * _velo_mv);
    _pActor->_y += (coord)(_vY * _velo_mv);
    _pActor->_z += (coord)(_vZ * _velo_mv);
}

void VecDriver::setFaceAngVelo(axis prm_axis, angvelo prm_angvelo) {
    if (prm_angvelo > _top_angvelo_face[prm_axis]) {
        _angvelo_face[prm_axis] = _top_angvelo_face[prm_axis];
    } else if (prm_angvelo < _bottom_angvelo_face[prm_axis]) {
        _angvelo_face[prm_axis] = _bottom_angvelo_face[prm_axis];
    } else {
        _angvelo_face[prm_axis] = prm_angvelo;
    }
}

void VecDriver::setRollPitchYawFaceAngVelo(angvelo prm_axis_x_angvelo,
                                         angvelo prm_axis_z_angvelo,
                                         angvelo prm_axis_y_angvelo) {
    setFaceAngVelo(AXIS_X, prm_axis_x_angvelo);
    setFaceAngVelo(AXIS_Z, prm_axis_z_angvelo);
    setFaceAngVelo(AXIS_Y, prm_axis_y_angvelo);
}

void VecDriver::forceFaceAngVeloRange(axis prm_axis,
                                    angvelo prm_angvelo01,
                                    angvelo prm_angvelo02) {
    if (prm_angvelo01 < prm_angvelo02) {
        _top_angvelo_face[prm_axis] = prm_angvelo02;
        _bottom_angvelo_face[prm_axis] = prm_angvelo01;
    } else {
        _top_angvelo_face[prm_axis] = prm_angvelo01;
        _bottom_angvelo_face[prm_axis] = prm_angvelo02;
    }
    setFaceAngVelo(prm_axis, _angvelo_face[prm_axis]); //Đݒ肵Ĕ͈͓ɕ␳
}

void VecDriver::setFaceAngAcce(axis prm_axis, angacce prm_angacce) {
    _angacce_face[prm_axis] = prm_angacce;
}

void VecDriver::setStopTargetFaceAngTwd(axis prm_axis,
                                      coord prm_tx,
                                      coord prm_ty,
                                      int prm_allow_way,
                                      angvelo prm_allow_angvelo) {
    setStopTargetFaceAng(
      prm_axis,
      UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)),
      prm_allow_way,
      prm_allow_angvelo
    );
}

void VecDriver::setStopTargetFaceAng(axis prm_axis,
                                   angle prm_target,
                                   int prm_allow_way,
                                   angvelo prm_allow_angvelo) {
    _is_targeting_face[prm_axis] = true;
    _face_targeting_stop_flg[prm_axis] = true;
    _target_face[prm_axis] = UTIL::simplifyAng(prm_target);
    _face_stop_allow_way[prm_axis] = prm_allow_way;
    _face_stop_allow_angvelo[prm_axis] = prm_allow_angvelo;
}

angle VecDriver::getFaceAngDistance(axis prm_axis, coord prm_tx, coord prm_ty, int prm_way) {
    return getFaceAngDistance(
               prm_axis,
               UTIL::getAngle2D(prm_tx-(_pActor->_x), prm_ty-(_pActor->_y)),
               prm_way);
}

angle VecDriver::getFaceAngDistance(axis prm_axis, angle prm_target, int prm_way) {
    return UTIL::getAngDiff( (*(_actor_face[prm_axis])),  prm_target, prm_way);
}

void VecDriver::forceMvVeloRange(velo prm_velo) {
    forceMvVeloRange(-prm_velo, prm_velo);
}

void VecDriver::forceMvVeloRange(velo prm_velo_mv01, velo prm_velo_mv02) {
    if (prm_velo_mv01 < prm_velo_mv02) {
        _top_velo_mv = prm_velo_mv02;
        _bottom_velo_mv = prm_velo_mv01;
    } else {
        _top_velo_mv = prm_velo_mv01;
        _bottom_velo_mv = prm_velo_mv02;
    }
    setMvVelo(_velo_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void VecDriver::setMvVelo(velo prm_velo_mv) {
    if (prm_velo_mv > _top_velo_mv) {
        _velo_mv = _top_velo_mv;
    } else if (prm_velo_mv < _bottom_velo_mv) {
        _velo_mv = _bottom_velo_mv;
    } else {
        _velo_mv = prm_velo_mv;
    }
}

void VecDriver::addMvVelo(velo prm_velo_mv_Offset) {
    setMvVelo(_velo_mv + prm_velo_mv_Offset);
}

void VecDriver::setMvAcce(int prm_acceMove) {
    _acc_mv = prm_acceMove;
}

frame VecDriver::setMvAcceToStop(coord prm_target_distance) {
    double acc = UTIL::getAcceToStop(prm_target_distance, _velo_mv);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _acc_mv = acc;
    return (frame)((2.0*prm_target_distance) / _velo_mv); //gpt[
}

frame VecDriver::setFaceAngAcceToStop(axis prm_axis, angle prm_target_distance) {
    double acc = UTIL::getAcceToStop(prm_target_distance, _angvelo_face[prm_axis]);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacce_face[prm_axis] = acc;
    return (frame)((2.0*prm_target_distance) / _angvelo_face[prm_axis]); //gpt[
}

frame VecDriver::setMvAcceByD(coord prm_target_distance, velo prm_target_velo) {
    double acc = UTIL::getAcceByVd(_velo_mv, prm_target_velo, prm_target_distance);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _acc_mv = acc;
    return (frame)((1.0*prm_target_velo - _velo_mv) / acc); //gpt[
}
frame VecDriver::setFaceAngAcceByD(axis prm_axis, angle prm_target_distance, angvelo prm_target_angvelo) {
    double acc = UTIL::getAcceByVd(prm_target_angvelo, prm_target_distance, _angvelo_face[prm_axis]);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacce_face[prm_axis] = acc;
    return (frame)((1.0*prm_target_angvelo - _angvelo_face[prm_axis]) / acc); //gpt[
}
    // y⑫z
    // V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇ́AD(ڕW)LŖȂB
    // ł
    // V0 < 0     Vt > 0  ꍇA邢  V0 > 0     Vt < 0   ꍇ́AǂȂ邩H
    //
    //    x(v)
    //     ^        a:x
    //     |        D:ړiڕWBxɒB܂łɔ₷j
    //     |       V0:_̑x
    //     |       Vt:ڕWBx
    //     |       Te:ڕWBxɒB̎ԁit[j
    //  V0 |
    //     |_
    //     |  _  Xa
    //     | D1 _
    //     |      _ Tc     Te
    //   --+--------_------+---> (t)
    //   0 |          _ D2 |
    //     |            _  |
    //   Vt|.............._|
    //     |
    //
    //    D Ŝ̈ړƂ
    //    D = D1 - D2 , v = 0  t  Tc Ƃ
    //
    //    D1 = (1/2) V0 Tc
    //    D2 = (1/2) -Vt (Te - Tc)
    //    D = D1 - D2 
    //    D = (1/2) V0 Tc -  { (1/2) -Vt (Te - Tc) }
    //      = (V0 Tc + Vt Te - Vt Tc) / 2    EEE@
    //
    //     v = a t + V0 ɂ v = 0  t = Tc ł̂
    //    0 = a Tc + V0
    //    Tc = -V0 / a
    //     @ ֑
    //    D = (V0 (-V0 / a) + Vt Te - Vt (-V0 / a)) / 2 EEEA
    //    ܂ a = (Vt - V0) / Te ł̂
    //    Te = (Vt - V0) / a  A ֑
    //    
    //    D = (V0 (-V0 / a) + Vt ((Vt - V0) / a) - Vt (-V0 / a)) / 2
    //
    //    a ɂĉ
    //
    //    D = ( -(V0^2) / a  + (Vt (Vt - V0)) / a + (Vt V0) / a) / 2
    //    a D = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2
    //    a = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2D
    //    a = (-(V0^2) + Vt^2 - Vt V0 + Vt V0) / 2D
    //    a = (Vt^2 - V0^2) / 2D
    //
    //     a = (Vt^2 - V0^2) / 2D ƂȂ̂
    //    V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇƓł

coord VecDriver::setMvAcceByT(frame prm_target_frames, velo prm_target_velo) {
    double acc = UTIL::getAcceByTv(prm_target_frames, _velo_mv, prm_target_velo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _acc_mv = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_velo_mv + prm_target_velo) * prm_target_frames) / 2 ;
}
angle VecDriver::setFaceAngAcceByT(axis prm_axis, frame prm_target_frames, angvelo prm_target_angvelo) {
    double acc = UTIL::getAcceByTv(prm_target_frames, _angvelo_face[prm_axis], prm_target_angvelo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacce_face[prm_axis] = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_angvelo_face[prm_axis] + prm_target_angvelo) * prm_target_frames) / 2 ;
}

void VecDriver::setRzMvAng(angle prm_ang) {
    if (prm_ang !=  _rz_mv) {
        _rz_mv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_rz_mv, _ry_mv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _rz_mv;
    }
}

void VecDriver::addRzMvAng(angle prm_ang) {
    angle ang_offset = prm_ang;
    if (_bottom_angvelo_rz_mv > prm_ang) {
        ang_offset = _bottom_angvelo_rz_mv;
    } else if (prm_ang > _top_angvelo_rz_mv) {
        ang_offset = _top_angvelo_rz_mv;
    }
    setRzMvAng(_rz_mv + ang_offset);
}

void VecDriver::setRzMvAngVelo(angvelo prm_angvelo_rz_mv) {
    if (prm_angvelo_rz_mv > _top_angvelo_rz_mv) {
        _angvelo_rz_mv = _top_angvelo_rz_mv;
    } else if (prm_angvelo_rz_mv < _bottom_angvelo_rz_mv) {
        _angvelo_rz_mv = _bottom_angvelo_rz_mv;
    } else {
        _angvelo_rz_mv = prm_angvelo_rz_mv;
    }
}

void VecDriver::setRzMvAngAcce(angacce prm_angacce_rz_mv) {
    _angacce_rz_mv = prm_angacce_rz_mv;
}

void VecDriver::forceRzMvAngVeloRange(angvelo prm_angvelo_rz_mv01,
                                    angvelo prm_angvelo_rz_mv02) {
    if (prm_angvelo_rz_mv01 < prm_angvelo_rz_mv02) {
        _top_angvelo_rz_mv = prm_angvelo_rz_mv02;
        _bottom_angvelo_rz_mv = prm_angvelo_rz_mv01;
    } else {
        _top_angvelo_rz_mv = prm_angvelo_rz_mv01;
        _bottom_angvelo_rz_mv = prm_angvelo_rz_mv02;
    }
    setRzMvAngVelo(_angvelo_rz_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void VecDriver::setStopTargetRzMvAng(angle prm_target_rz_mv,
                                   int prm_allow_way,
                                   angvelo prm_allow_angvelo) {
    _is_targeting_rz_mv = true;
    _rz_mv_targeting_stop_flg = true;
    _target_rz_mv = UTIL::simplifyAng(prm_target_rz_mv);
    _rz_mv_stop_allow_way = prm_allow_way;
    _rz_mv_stop_allow_angvelo = prm_allow_angvelo;
}

angle VecDriver::getRzMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way) {
    return getRzMvAngDistance(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)), prm_way);
}

angle VecDriver::getRzMvAngDistance(angle prm_target_rz_mv, int prm_way) {
    return UTIL::getAngDiff(_rz_mv, prm_target_rz_mv, prm_way);
}


//void VecDriver::setRyMvAngTwd(coord prm_tx, coord prm_ty) {
//    setRyMvAng(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)));
//}

void VecDriver::setRyMvAng(angle prm_ang) {
    if (prm_ang != _ry_mv) {
        _ry_mv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_rz_mv, _ry_mv, _vX, _vY, _vZ);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ry_mv;
    }
}

void VecDriver::addRyMvAng(angle prm_ang) {
    angle ang_offset = prm_ang;
    if (_bottom_angvelo_ry_mv > prm_ang) {
        ang_offset = _bottom_angvelo_ry_mv;
    } else if (prm_ang > _top_angvelo_ry_mv) {
        ang_offset = _top_angvelo_ry_mv;
    }
    setRyMvAng(_ry_mv + ang_offset);
}

void VecDriver::setRyMvAngVelo(angvelo prm_angvelo_ry_mv) {
    if (prm_angvelo_ry_mv > _top_angvelo_ry_mv) {
        _angvelo_ry_mv = _top_angvelo_ry_mv;
    } else if (prm_angvelo_ry_mv < _bottom_angvelo_ry_mv) {
        _angvelo_ry_mv = _bottom_angvelo_ry_mv;
    } else {
        _angvelo_ry_mv = prm_angvelo_ry_mv;
    }
}

void VecDriver::setRyMvAngAcce(angacce prm_angacce_ry_mv) {
    _angacce_ry_mv = prm_angacce_ry_mv;
}

void VecDriver::forceRyMvAngVeloRange(angvelo prm_angvelo_ry_mv01,
                                    angvelo prm_angvelo_ry_mv02) {
    if (prm_angvelo_ry_mv01 < prm_angvelo_ry_mv02) {
        _top_angvelo_ry_mv = prm_angvelo_ry_mv02;
        _bottom_angvelo_ry_mv = prm_angvelo_ry_mv01;
    } else {
        _top_angvelo_ry_mv = prm_angvelo_ry_mv01;
        _bottom_angvelo_ry_mv = prm_angvelo_ry_mv02;
    }
    setRyMvAngVelo(_angvelo_ry_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void VecDriver::forceRzRyMvAngVeloRange(angvelo prm_angvelo_rzry_mv01, angvelo prm_angvelo_rzry_mv02) {
    if (prm_angvelo_rzry_mv01 < prm_angvelo_rzry_mv02) {
        _top_angvelo_rz_mv = prm_angvelo_rzry_mv02;
        _bottom_angvelo_rz_mv = prm_angvelo_rzry_mv01;
        _top_angvelo_ry_mv = prm_angvelo_rzry_mv02;
        _bottom_angvelo_ry_mv = prm_angvelo_rzry_mv01;
    } else {
        _top_angvelo_rz_mv = prm_angvelo_rzry_mv01;
        _bottom_angvelo_rz_mv = prm_angvelo_rzry_mv02;
        _top_angvelo_ry_mv = prm_angvelo_rzry_mv01;
        _bottom_angvelo_ry_mv = prm_angvelo_rzry_mv02;
    }
    setRzMvAngVelo(_angvelo_rz_mv); //Đݒ肵Ĕ͈͓ɕ␳
    setRyMvAngVelo(_angvelo_ry_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void VecDriver::setRzRyMvAngAcce(angacce prm_angacce_rz_mv, angacce prm_angacce_ry_mv) {
    _angacce_rz_mv = prm_angacce_rz_mv;
    _angacce_ry_mv = prm_angacce_ry_mv;
}

void VecDriver::setRzRyMvAngVelo(angvelo prm_angvelo_rz_mv, angvelo prm_angvelo_ry_mv) {
    if (prm_angvelo_rz_mv > _top_angvelo_rz_mv) {
        _angvelo_rz_mv = _top_angvelo_rz_mv;
    } else if (prm_angvelo_rz_mv < _bottom_angvelo_rz_mv) {
        _angvelo_rz_mv = _bottom_angvelo_rz_mv;
    } else {
        _angvelo_rz_mv = prm_angvelo_rz_mv;
    }
    if (prm_angvelo_ry_mv > _top_angvelo_ry_mv) {
        _angvelo_ry_mv = _top_angvelo_ry_mv;
    } else if (prm_angvelo_ry_mv < _bottom_angvelo_ry_mv) {
        _angvelo_ry_mv = _bottom_angvelo_ry_mv;
    } else {
        _angvelo_ry_mv = prm_angvelo_ry_mv;
    }
}

void VecDriver::setStopTargetRyMvAng(angle prm_target_ry_mv,
                                   int prm_allow_way,
                                   angvelo prm_allow_angvelo) {
    _is_targeting_ry_mv = true;
    _ry_mv_targeting_stop_flg = true;
    _target_ry_mv = UTIL::simplifyAng(prm_target_ry_mv);
    _ry_mv_stop_allow_way = prm_allow_way;
    _ry_mv_stop_allow_angvelo = prm_allow_angvelo;
}

angle VecDriver::getRyMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way) {
    return getRyMvAngDistance(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)), prm_way);
}

angle VecDriver::getRyMvAngDistance(angle prm_target_ry_mv, int prm_way) {
    return UTIL::getAngDiff(_ry_mv, prm_target_ry_mv, prm_way);
}

void VecDriver::getRzRyMvAngDistanceTwd(angle prm_target_rz, angle prm_target_ry, int prm_way,
                                      angle& out_d_rz, angle& out_d_ry) {
    angle target_rz = UTIL::simplifyAng(prm_target_rz);
    angle target_ry = UTIL::simplifyAng(prm_target_ry);
    angle d1_rz = getRzMvAngDistance(target_rz, prm_way); //Rz̍
    angle d1_ry = getRyMvAngDistance(target_ry, prm_way);
    angle d1 = ABS(d1_rz) + ABS(d1_ry);
    UTIL::anotherRzRy(target_rz, target_ry);
    angle d2_rz = getRzMvAngDistance(target_rz, prm_way);
    angle d2_ry = getRyMvAngDistance(target_ry, prm_way);
    angle d2 = ABS(d2_rz) + ABS(d2_ry);

    if (prm_way == TURN_ANTICLOSE_TO) {
        if (d1 >= d2) { //艓̗p
            out_d_rz = d1_rz;
            out_d_ry = d1_ry;
        } else {
            out_d_rz = d2_rz;
            out_d_ry = d2_ry;
        }
    } else {
        if (d1 <= d2) { //߂̗p
            out_d_rz = d1_rz;
            out_d_ry = d1_ry;
        } else {
            out_d_rz = d2_rz;
            out_d_ry = d2_ry;
        }
    }
}

void VecDriver::getRzRyFaceAngDistanceTwd(angle prm_target_rz, angle prm_target_ry,int prm_way,
                                        angle& out_d_rz, angle& out_d_ry) {
    angle target_rz = UTIL::simplifyAng(prm_target_rz);
    angle target_ry = UTIL::simplifyAng(prm_target_ry);
    angle d1_rz = getFaceAngDistance(AXIS_Z, target_rz, TURN_CLOSE_TO);
    angle d1_ry = getFaceAngDistance(AXIS_Y, target_ry, TURN_CLOSE_TO);
    angle d1 = ABS(d1_rz) + ABS(d1_ry);
    UTIL::anotherRzRy(target_rz, target_ry);
    angle d2_rz = getFaceAngDistance(AXIS_Z, target_rz, TURN_CLOSE_TO);
    angle d2_ry = getFaceAngDistance(AXIS_Y, target_ry, TURN_CLOSE_TO);
    angle d2 = ABS(d2_rz) + ABS(d2_ry);

    if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        if (d1 >= d2) {
            out_d_rz = d1_rz;
            out_d_ry = d1_ry;
        } else {
            out_d_rz = d2_rz;
            out_d_ry = d2_ry;
        }
    } else {
        if (d1 <= d2) {
            out_d_rz = d1_rz;
            out_d_ry = d1_ry;
        } else {
            out_d_rz = d2_rz;
            out_d_ry = d2_ry;
        }
    }
}

void VecDriver::setRzRyMvAng(angle prm_rz, angle prm_ry) {
    if (prm_rz != _rz_mv || prm_ry !=_ry_mv ) {
        _rz_mv = UTIL::simplifyAng(prm_rz);
        _ry_mv = UTIL::simplifyAng(prm_ry);
        UTIL::convRzRyToVector(_rz_mv, _ry_mv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _rz_mv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ry_mv;
    }
}

void VecDriver::setRzRyMvAng(dxcoord prm_vx, dxcoord prm_vy, dxcoord prm_vz, bool prm_opt) {
    if (prm_opt) {
        angle rz_mv1, ry_mv1;
        UTIL::convVectorToRzRy(prm_vx, prm_vy, prm_vz,
                               rz_mv1, ry_mv1 );
        angle d1_rz = getRzMvAngDistance(rz_mv1, TURN_CLOSE_TO);
        angle d1_ry = getRyMvAngDistance(ry_mv1, TURN_CLOSE_TO);
        angle d1 = ABS(d1_rz) + ABS(d1_ry);

        angle rz_mv2 = rz_mv1;
        angle ry_mv2 = ry_mv1;
        UTIL::anotherRzRy(rz_mv2, ry_mv2);
        angle d2_rz = getRzMvAngDistance(rz_mv2, TURN_CLOSE_TO);
        angle d2_ry = getRyMvAngDistance(ry_mv2, TURN_CLOSE_TO);
        angle d2 = ABS(d2_rz) + ABS(d2_ry);
        if (d1 <= d2) {
            _rz_mv = rz_mv1;
            _ry_mv = ry_mv1;
        } else {
            _rz_mv = rz_mv2;
            _ry_mv = ry_mv2;
        }
    } else {
        UTIL::convVectorToRzRy(prm_vx, prm_vy, prm_vz,
                               _rz_mv, _ry_mv );
    }
    UTIL::getNormalizedVector(prm_vx, prm_vy, prm_vz,
                             _vX, _vY, _vZ);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _rz_mv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ry_mv;
    }
}

void VecDriver::setRzRyMvAng_by_RyRz(angle prm_ryRz_Ry, angle prm_ryRz_Rz) {
    angle RyRz_Ry = UTIL::simplifyAng(prm_ryRz_Ry);
    angle RyRz_Rz = UTIL::simplifyAng(prm_ryRz_Rz);
    float out_vY, out_vZ;
    UTIL::convRzRyToVector(RyRz_Ry, D360ANG-RyRz_Rz, _vX, out_vY, out_vZ);
    _vY = -1.0f*out_vZ;
    _vZ = out_vY;
    UTIL::convVectorToRzRy(_vX, _vZ, _vY, _rz_mv, _ry_mv);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _rz_mv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ry_mv;
    }
}


void VecDriver::setMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    coord vx = prm_tx - _pActor->_x;
    coord vy = prm_ty - _pActor->_y;
    coord vz = prm_tz - _pActor->_z;
    if (vx == 0 && vy == 0 && vz == 0) {
        //AN^[̍Wɓ̂ŁAȂB
    } else {
        UTIL::convVectorToRzRy(vx, vy, vz,
                               _rz_mv, _ry_mv );
        UTIL::getNormalizedVector(vx, vy, vz,
                                  _vX, _vY, _vZ);
        if (_relate_RzFaceAng_with_RzMvAng_flg) {
            _pActor->_rz = _rz_mv;
        }
        if (_relate_RyFaceAng_with_RyMvAng_flg) {
            _pActor->_ry = _ry_mv;
        }
    }
}

void VecDriver::reverseMvAng() {
    _vX = -_vX;
    _vY = -_vY;
    _vZ = -_vZ;
    _rz_mv = UTIL::simplifyAng(_rz_mv-D180ANG);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _rz_mv;
    }
}

void VecDriver::setStopTargetMvAngTwd(const GeometricActor* prm_pActor_target) {
    setStopTargetMvAngTwd(
        prm_pActor_target->_x,
        prm_pActor_target->_y,
        prm_pActor_target->_z
    );
}

void VecDriver::setStopTargetMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    coord vx = prm_tx - _pActor->_x;
    coord vy = prm_ty - _pActor->_y;
    coord vz = prm_tz - _pActor->_z;
    if (vx == 0 && vy == 0 && vz == 0) {
        //AN^[̍Wɓ̂ŁAȂB
    } else {
        angle rz_target, ry_target;
        UTIL::convVectorToRzRy(vx, vy, vz,
                               rz_target, ry_target);
        setStopTargetRzMvAng(rz_target);
        setStopTargetRyMvAng(ry_target);
    }
}

void VecDriver::turnRzRyFaceAngTo(angle prm_rz_target, angle prm_ry_target,
                                angvelo prm_angvelo, angacce prm_angacce,
                                int prm_way, bool prm_optimize_ang) {
    angle out_d_rz;
    angle out_d_ry;
    if (prm_optimize_ang) {
        getRzRyFaceAngDistanceTwd(prm_rz_target, prm_ry_target,prm_way,
                                   out_d_rz, out_d_ry);
    } else {
        out_d_rz = getFaceAngDistance(AXIS_Z, prm_rz_target, prm_way);
        out_d_ry = getFaceAngDistance(AXIS_Y, prm_ry_target, prm_way);
    }
    double drz = ABS(out_d_rz);
    double dry = ABS(out_d_ry);
    if (drz > dry) {
        double drr = dry / drz ;
        if (out_d_rz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angvelo);
            setFaceAngAcce(AXIS_Z, prm_angacce);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angvelo);
            setFaceAngAcce(AXIS_Z, -prm_angacce);
        }

        angvelo rv = prm_angvelo*drr;
        if (rv == 0 && prm_angvelo > 0) {
            rv = ABS(prm_angvelo);
        }
        angacce ra = prm_angacce*drr;
        if (ra == 0 && prm_angacce > 0) {
            ra = ABS(prm_angacce);
        }
        if (out_d_ry > 0) {
            setFaceAngVelo(AXIS_Y, rv);
            setFaceAngAcce(AXIS_Y, ra);
        } else {
            setFaceAngVelo(AXIS_Y, -rv);
            setFaceAngAcce(AXIS_Y, -ra);
        }
    } else if (drz < dry) {
        float t_sin_rz = ABS(ANG_SIN(UTIL::simplifyAng(prm_rz_target)) * 0.8);// Y]ɍW␳B0.8͊ɂ邽
        double hosei = 1.0 / (1.0 - t_sin_rz); //* 0.8Ă̂ŁAt_sin_rz  1.0ɂȂȂ̂ 0Z͋NȂB


        double drr = drz / dry ;

        angvelo rv = prm_angvelo*drr;
        if (rv == 0 && prm_angvelo > 0) {
            rv = ABS(prm_angvelo);
        }
        angacce ra = prm_angacce*drr;
        if (ra == 0 && prm_angacce > 0) {
            ra = ABS(prm_angacce);
        }
        if (out_d_rz > 0) {
            setFaceAngVelo(AXIS_Z, rv);
            setFaceAngAcce(AXIS_Z, ra);
        } else {
            setFaceAngVelo(AXIS_Z, -rv);
            setFaceAngAcce(AXIS_Z, -ra);
        }
        if (out_d_ry > 0) {
            setFaceAngVelo(AXIS_Y, prm_angvelo*hosei);
            setFaceAngAcce(AXIS_Y, prm_angacce*hosei);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angvelo*hosei);
            setFaceAngAcce(AXIS_Y, -prm_angacce*hosei);
        }
    } else {

        float t_sin_rz = ABS(ANG_SIN(UTIL::simplifyAng(prm_rz_target)) * 0.8);// Y]ɍW␳B0.8͊ɂ邽
        double hosei = 1.0 / (1.0 - t_sin_rz); //* 0.8Ă̂ŁAt_sin_rz  1.0ɂȂȂ̂ 0Z͋NȂB


        if (out_d_rz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angvelo);
            setFaceAngAcce(AXIS_Z, prm_angacce);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angvelo);
            setFaceAngAcce(AXIS_Z, -prm_angacce);
        }
        if (out_d_ry > 0) {
            setFaceAngVelo(AXIS_Y, prm_angvelo*hosei);
            setFaceAngAcce(AXIS_Y, prm_angacce*hosei);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angvelo*hosei);
            setFaceAngAcce(AXIS_Y, -prm_angacce*hosei);
        }
    }

    setStopTargetFaceAng(AXIS_Z, prm_rz_target);
    setStopTargetFaceAng(AXIS_Y, prm_ry_target);
    _taget_face_alltime_pActor = nullptr;
    _taget_face_alltime_flg = false;
}

void VecDriver::turnFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                             angvelo prm_angvelo, angacce prm_angacce,
                             int prm_way, bool prm_optimize_ang) {
    coord vx = prm_tx - _pActor->_x;
    coord vy = prm_ty - _pActor->_y;
    coord vz = prm_tz - _pActor->_z;
    if (vx == 0 && vy == 0 && vz == 0) {
        //g̍Wɓ̂ŁAȂ
    } else {
        angle out_rz_Target;
        angle out_ry_Target;
        UTIL::convVectorToRzRy(vx, vy, vz,
                               out_rz_Target, out_ry_Target);

        turnRzRyFaceAngTo(out_rz_Target, out_ry_Target,
                          prm_angvelo, prm_angacce,
                          prm_way, prm_optimize_ang);
    }
}


void VecDriver::turnFaceAng(axis prm_axis,
                          angle prm_distance,
                          angvelo prm_angvelo, angacce prm_angacce) {
    int s = SGN(prm_distance);
    setFaceAngVelo(prm_axis, ABS(prm_angvelo)*s);
    setFaceAngAcce(prm_axis, ABS(prm_angacce)*s);
    setStopTargetFaceAng(prm_axis, (*(_actor_face[prm_axis])) + prm_distance);
    _taget_face_alltime_pActor = nullptr;
    _taget_face_alltime_flg = false;
}


void VecDriver::turnRzFaceAngTo(angle prm_rz_target,
                              angvelo prm_angvelo, angacce prm_angacce,
                              int prm_way) {
    if (getFaceAngDistance(AXIS_Z, prm_rz_target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Z, prm_angvelo);
        setFaceAngAcce(AXIS_Z, prm_angacce);
    } else {
        setFaceAngVelo(AXIS_Z, -prm_angvelo);
        setFaceAngAcce(AXIS_Z, -prm_angacce);
    }
    setStopTargetFaceAng(AXIS_Z, prm_rz_target);
    _taget_face_alltime_pActor = nullptr;
    _taget_face_alltime_flg = false;
}

void VecDriver::turnRyFaceAngTo(angle prm_ry_target,
                              angvelo prm_angvelo, angacce prm_angacce,
                              int prm_way) {
    if (getFaceAngDistance(AXIS_Y, prm_ry_target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Y, prm_angvelo);
        setFaceAngAcce(AXIS_Y, prm_angacce);
    } else {
        setFaceAngVelo(AXIS_Y, -prm_angvelo);
        setFaceAngAcce(AXIS_Y, -prm_angacce);
    }
    setStopTargetFaceAng(AXIS_Y, prm_ry_target);
    _taget_face_alltime_pActor = nullptr;
    _taget_face_alltime_flg = false;
}

void VecDriver::rollFaceAngTo(angle prm_rx_target,
                            angvelo prm_angvelo, angacce prm_angacce,
                            int prm_way) {
    if (getFaceAngDistance(AXIS_X, prm_rx_target, prm_way) > 0) {
        setFaceAngVelo(AXIS_X, prm_angvelo);
        setFaceAngAcce(AXIS_X, prm_angacce);
    } else {
        setFaceAngVelo(AXIS_X, -prm_angvelo);
        setFaceAngAcce(AXIS_X, -prm_angacce);
    }
    setStopTargetFaceAng(AXIS_X, prm_rx_target);
}

void VecDriver::turnRzRyMvAngTo(angle prm_rz_target, angle prm_ry_target,
                              angvelo prm_angvelo, angacce prm_angacce,
                              int prm_way, bool prm_optimize_ang) {
    angle out_d_rz;
    angle out_d_ry;
    if (prm_optimize_ang) {
        getRzRyMvAngDistanceTwd(prm_rz_target, prm_ry_target,prm_way,
                                out_d_rz, out_d_ry);
    } else {
        out_d_rz = getRzMvAngDistance(prm_rz_target, prm_way);
        out_d_ry = getRyMvAngDistance(prm_ry_target, prm_way);
    }

    //Rz, Ry AڕWAO֓ɓB悤Ɋpx𒲐
    double drz = ABS(out_d_rz);
    double dry = ABS(out_d_ry);
    if (drz > dry) {
        double drr = dry / drz ;
        if (out_d_rz > 0) {
            setRzMvAngVelo(prm_angvelo);
            setRzMvAngAcce(prm_angacce);
        } else {
            setRzMvAngVelo(-prm_angvelo);
            setRzMvAngAcce(-prm_angacce);
        }
        angvelo rv = prm_angvelo*drr;
        if (rv == 0 && prm_angvelo > 0) {
            rv = ABS(prm_angvelo);
        }
        angacce ra = prm_angacce*drr;
        if (ra == 0 && prm_angacce > 0) {
            ra = ABS(prm_angacce);
        }
        if (out_d_ry > 0) {
            setRyMvAngVelo(rv);
            setRyMvAngAcce(ra);
        } else {
            setRyMvAngVelo(-rv);
            setRyMvAngAcce(-ra);
        }
    } else if (drz < dry) {
        float t_sin_rz = ABS(ANG_SIN(UTIL::simplifyAng(prm_rz_target)) * 0.8);// Y]ɍW␳B0.8͊ɂ邽
        double hosei = 1.0 / (1.0 - t_sin_rz); //* 0.8Ă̂ŁAt_sin_rz  1.0ɂȂȂ̂ 0Z͋NȂB
        double drr = drz / dry;
        angvelo rv = prm_angvelo*drr;
        if (rv == 0 && prm_angvelo > 0) {
            rv = ABS(prm_angvelo);
        }
        angacce ra = prm_angacce*drr;
        if (ra == 0 && prm_angacce > 0) {
            ra = ABS(prm_angacce);
        }
        if (out_d_rz > 0) {
            setRzMvAngVelo(rv);
            setRzMvAngAcce(ra);
        } else {
            setRzMvAngVelo(-rv);
            setRzMvAngAcce(-ra);
        }
        if (out_d_ry > 0) {
            setRyMvAngVelo(prm_angvelo*hosei);
            setRyMvAngAcce(prm_angacce*hosei);
        } else {
            setRyMvAngVelo(-prm_angvelo*hosei);
            setRyMvAngAcce(-prm_angacce*hosei);
        }
    } else {

        float t_sin_rz = ABS(ANG_SIN(UTIL::simplifyAng(prm_rz_target)) * 0.8);// Y]ɍW␳B0.8͊ɂ邽
        double hosei = 1.0 / (1.0 - t_sin_rz); //* 0.8Ă̂ŁAt_sin_rz  1.0ɂȂȂ̂ 0Z͋NȂB
        if (out_d_rz > 0) {
            setRzMvAngVelo(prm_angvelo);
            setRzMvAngAcce(prm_angacce);
        } else {
            setRzMvAngVelo(-prm_angvelo);
            setRzMvAngAcce(-prm_angacce);
        }
        if (out_d_ry > 0) {
            setRyMvAngVelo(prm_angvelo*hosei);
            setRyMvAngAcce(prm_angacce*hosei);
        } else {
            setRyMvAngVelo(-prm_angvelo*hosei);
            setRyMvAngAcce(-prm_angacce*hosei);
        }
    }
    setStopTargetRzMvAng(prm_rz_target);
    setStopTargetRyMvAng(prm_ry_target);
}

void VecDriver::turnMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                           angvelo prm_angvelo, angacce prm_angacce,
                           int prm_way, bool prm_optimize_ang) {
    coord vx = prm_tx - _pActor->_x;
    coord vy = prm_ty - _pActor->_y;
    coord vz = prm_tz - _pActor->_z;
    if (vx == 0 && vy == 0 && vz == 0) {
        //AN^[̍Wɓ̂ŁAȂB
    } else {
        angle out_rz_Target;
        angle out_ry_Target;
        UTIL::convVectorToRzRy(vx, vy, vz,
                               out_rz_Target,
                               out_ry_Target);
        turnRzRyMvAngTo(out_rz_Target, out_ry_Target,
                        prm_angvelo, prm_angacce,
                        prm_way, prm_optimize_ang);
    }
}

void VecDriver::turnRzMvAng(angle prm_rz_distance,
                          angvelo prm_angvelo, angacce prm_angacce) {
    int s = SGN(prm_rz_distance);
    setRzMvAngVelo(ABS(prm_angvelo) * s);
    setRzMvAngAcce(ABS(prm_angacce) * s);
    setStopTargetRzMvAng(_rz_mv+prm_rz_distance);
}

void VecDriver::turnRyMvAng(angle prm_ry_distance,
                          angvelo prm_angvelo, angacce prm_angacce) {
    int s = SGN(prm_ry_distance);
    setRyMvAngVelo(ABS(prm_angvelo) * s);
    setRyMvAngAcce(ABS(prm_angacce) * s);
    setStopTargetRyMvAng(_ry_mv+prm_ry_distance);
}

void VecDriver::turnRzMvAngTo(angle prm_rz_target,
                           angvelo prm_angvelo, angacce prm_angacce,
                           int prm_way) {
    if (getRzMvAngDistance(prm_rz_target, prm_way) > 0) {
        setRzMvAngVelo(prm_angvelo);
        setRzMvAngAcce(prm_angacce);
    } else {
        setRzMvAngVelo(-prm_angvelo);
        setRzMvAngAcce(-prm_angacce);
    }
    setStopTargetRzMvAng(prm_rz_target);
}

void VecDriver::turnRyMvAngTo(angle prm_ry_target,
                            angvelo prm_angvelo, angacce prm_angacce,
                            int prm_way) {
    if (getRyMvAngDistance(prm_ry_target, prm_way) > 0) {
        setRyMvAngVelo(prm_angvelo);
        setRyMvAngAcce(prm_angacce);
    } else {
        setRyMvAngVelo(-prm_angvelo);
        setRyMvAngAcce(-prm_angacce);
    }
    setStopTargetRyMvAng(prm_ry_target);
}

void VecDriver::takeoverMvFrom(VecDriver* const prm_pVecDriver) {
    // L̈ړpPʃxNg
    _vX = prm_pVecDriver->_vX;
    _vY = prm_pVecDriver->_vY;
    _vZ = prm_pVecDriver->_vZ;
    // ړpZ]p
    _rz_mv = prm_pVecDriver->_rz_mv;
    // ړpY]p
    _ry_mv = prm_pVecDriver->_ry_mv;
    // ړx
    _velo_mv = prm_pVecDriver->_velo_mv;
    // ړx
    _top_velo_mv = prm_pVecDriver->_top_velo_mv;
    // ړx
    _bottom_velo_mv = prm_pVecDriver->_bottom_velo_mv;
    // ړx
    _acc_mv = prm_pVecDriver->_acc_mv;
    // ړx
    //_jerkMv = prm_pVecDriver->_jerkMv;
}

void VecDriver::stopTurningMvAng() {
    _is_targeting_rz_mv = false;
    _rz_mv_targeting_stop_flg = false;
    _is_targeting_ry_mv = false;
    _ry_mv_targeting_stop_flg = false;
    if (_pAsstMvAng) {
        _pAsstMvAng->stopTurning();
    }
    setRzRyMvAngVelo(0, 0);
    setRzRyMvAngAcce(0, 0);
}

void VecDriver::stopTurningFaceAng() {
    _is_targeting_face[AXIS_X] = false;
    _is_targeting_face[AXIS_Y] = false;
    _is_targeting_face[AXIS_Z] = false;
    _taget_face_alltime_pActor = nullptr;
    _taget_face_alltime_flg = false;
    if (_pAsstFaceAng) {
        _pAsstFaceAng->stopTurn();
    }
    setFaceAngVelo(AXIS_Z, 0);
    setFaceAngVelo(AXIS_Y, 0);
    setFaceAngAcce(AXIS_Z, 0);
    setFaceAngAcce(AXIS_Y, 0);
}

bool VecDriver::isTurningFaceAng() const {
    if (_is_targeting_face[AXIS_X] ||
        _is_targeting_face[AXIS_Y] ||
        _is_targeting_face[AXIS_Z] ) {
        return true;
    } else {
        if (_pAsstFaceAng) {
            return _pAsstFaceAng->isTurning();
        } else {
            return false;
        }
        return false;
    }
}

bool VecDriver::isTurningMvAng() const {
    if (_is_targeting_rz_mv || _is_targeting_ry_mv) {
        return true;
    } else {
        if (_pAsstMvAng) {
            return _pAsstMvAng->isTurning();
        } else {
            return false;
        }
    }
}

void VecDriver::stopMv() {
   setMvAcce(0);
   setMvVelo(0);
   if (_pAsstMv) {
       _pAsstMv->stopSliding();
   }
}

VecDriver::~VecDriver() {
    GGAF_DELETE_NULLABLE(_pAsstMv);
    GGAF_DELETE_NULLABLE(_pAsstFaceAng);
    GGAF_DELETE_NULLABLE(_pAsstMvAng);
}


// yY^z{NX̍lƃRg̒P̕\
//
// Qނ̕
// uL̕vƂtBȂ߁ÂQނ̒P`BuړpijvƁuʕpijvB
// uړpv̓L̐iŝ݂\B́uړxvƔāAL͍Wړ邱ƂƂB
// uʕpv̓ĽiOĵ݂\鎖ƂB
// LN^ʂ̏㕔牺ֈړĂALN^͉Ƃ͌炸@ɌĂقꍇB
// ܂́AEɃLāAɈړƂBꂼQ̕ݒ肪KvB
//
// ړp̂Qނ̕\@
// LiޕA܂uړpv́̕A_Pʋ̕\ʂɌĐLтxNg (_vX, _vY, _vZ) ŕ\@ƁA
// Q]AOl (_rz_mv, _ry_mv) ŕ\@̂QޗpӂBNH[^jÎ͍Ƃ떳B
// _rz_mv  Z]pA _ry_mv  Y]p ӖĂB
// ͕xNgAܓxƌoxAipƃAW}Xj̊֌WɌāAΉ悤ƂB
// ӂ邱Ƃ́AY]pox ͏ɐ藧AZ]pܓx ́AZ]p  Y]p̏ԂłꍇɌ萬藧B
// {NXł́AuZ]  Y]̏ԂłZ]pEY]pvȗāAPɁuZ]pEY]pvƕ\鎖ƂB
// ꂼuړpiZjvuړpiYjvƕ\鎖B
//
// \[XR[h́Aϐ⃁\bh
// uRzMvvƂ\ĹuړpiZjvӖĂB
// uRyMvvƂ\ĹuړpiYjvӖĂB
// uRzRyMvvƂ\́uZ]  Y]̏Ԃ̈ړpv\ĂB
//
// Z]pAY]pƂ0xAxNg(1, 0, 0) ̕ƒ`B
// Z]p̐̑́AZ̐̕ĔvB
// Y]p̐̑́AY̐̕ĔvBƂB
//
// ƂŐwIɁupv́AxNgiXYZ̒ljŕ\邱ƂƎvB
// ̖{NXł́A悭ĝ͂Q\̕ŁA\bh _rz_mv  _ry_mv 𑀍삷̂SƂȂĂB
// ͌ǓŒPʕxNg߂Ă̂AW]vZA^ _rz_mv  _ry_mv ł񂴂sĂA
// ŌɂPPʃxNg߂BƂ̂ł͂ƍl߁Â悤Ȑ݌vɂȂB
// TODO:œK̗]nԎcĂnYB܂B
// (_rz_mv, _ry_mv)\bhɂ葀삵āAet[̍Ō̓ŕxNg(_vX, _vY, _vZ) 𓯊ĂB
// (_vX, _vY, _vZ)o[\bhg킸ڑ삷ƁA(_rz_mv, _ry_mv)Ƃ̓̂ŒӁB
// {NX̃\bhgpł́AȂƂ͋NȂB
//
// ړx:Velo or MvVelo
// Ĺuړxv(_velo_mv)ێĂBړ@͊ȒPŁA{Iɖt[uړpvɁuړxvB
// Ẃuړpv(_vX, _vY, _vZ)Ɂuړxv(_velo_mv)|ZĂB
// Pt[̍W݂͌̍W (_vX*_velo_mv, _vY*_velo_mv, _vZ*_velo_mv) ړꏊłB
// ̃xNgɖ{Cu̒Pʋ(Q[̒Pƍl鐮{lj悶B
// āA(_vX*_velo_mv*LEN_UNIT, _vY*_velo_mv*LEN_UNIT, _vZ*_velo_mv*LEN_UNIT)Pt[̍WB

// ʕp:AngFace
// L̃[JWŌĂpijuʕpvƌĂԂƂɂB
//uʕpv́A[hϊs̎]Ɠ]@łB
// [hϊs̎]Ƃ́AX]pAY]pAZ]p̂ƂŁAꂼA
// _face[AXIS_X], _face[AXIS_Y], _face[AXIS_Z] ƈvB
// {Cuł́AxNg(1, 0, 0) ĹuOvƐݒ肵ĂB
// Xt@CȂǂ̃Lf́AԂŐXɌĂ邱ƂOƂB܂Afúv́i0, 1, 0)ƂB
// [hϊs̉]s̊|鏇Ԃ́A{I uX]s > Z]s > Y]s > ړs v ƂB
// (  X > Y > Z ̏ł͂ȂIj
// āAX]p͊]悤ƂALĂ͕ς炸AcZ]pƁAY]pŃLĂ肷邱ƂƂB
// X]p̓L̃XsÂQpiZ]pEY]pjŃĹuOvp肷ƂꍇA
// uʕpvقǂ́uړpvƓ悤ɁAZ]pY]piܓxƌox)̂Q̃AOl
// (_face[AXIS_Z], _face[AXIS_Y])ŕ\łB
// ܂AuOv Z]pEY]p0xƂAႦ΁uv(Z]p,Y]p)=(0x,180x) ƕ\BB
// PɁuZ]pvȂǂƏƁAuړpvZ]pȂ̂AuʕpvZ]pȂ̂BɂȂ邽߁A
// uʕp(Z)vuʕp(Y)vƏƂƂBiuʕp(X)v邪A̓Xs\ւ̉e͂Ȃj
// Œӂ́AP̃LĂpɑ΂āAɂQʂ̃ANZX@ƂƁBႦ΁A
// uO(1, 0, 0)Đ^Ev  (ʕp(Z), ʕp(Y))=(0, 90x) or (180x,270x) Ƃŕ\łB
// iʕp(Y)͍nŴY̐Ĕvj
//  uOv (0x,0x) Ƃ (180x,180x) Ƃ\ł邵Au^v  (0x,180x) Ƃ (180x,0x) Ƃ\łB
// Ă͓Ap(L̏)قȂBpقȂƂ܂L͒ӂ邱ƁB
// RAuړpvłAQʂ̃ANZX@̂A͎p̂ŌڂŕȂB
// pxvZƂɉeoꍇ̂ŒӂKvB


// O@\
// Ă uړpiZjvuړpiYjvAꂼuʕp(Z)vuʕp(Y)v փRs[ĂƁA
// ړpƁALN^̌̓ȒPɎ邶ȂI
// uO@\vƂ́Auړpvݒ肷ƁAɔĎIɁuʕpvݒ肷鎖ƂB
// ̓Iɂ́Aȉ̂悤Ƀt[ɁAAOl㏑Rs[ijB͍Zi炩ɕ`jĂB
//  EړpiZj  ʕp(Z)
//  EړpiYj  ʕp(Y)
// uʕpvݒĂuړpvωȂit͊֘AȂĵŒӁB

// px:AngVelo
// uړpiZjvuړpiYjvAuʕp(Z)vuʕp(Y)vɂ́Aꂼ́upxv݂ĂB
// Ⴆ90xEɌꍇALȂJNƌςĂ͔߂̂ŁAt[pxpZ悤ɂāA
// 炩Ɍς悤ɂB
// upxv͐̒ӂKvB̏ꍇ͔vȀꍇ͎vɂȂB
// ]ꍇA^[QbgƂȂpxւ̓BAv[`͐]̂Qʂ肾A
// \5ʂ̍lŎwł悤݌vB
// 1.uɔvōsv TURN_ANTICLOSE_TO
// 2.uɎvōsv TURN_CLOCKWISE
// 3.u߂p̎ōsvTURN_CLOSE_TO
// 4.uȊp̎ōsvTURN_ANTICLOSE_TO
// 5.u݉Ă̂܂܂ōsv
// łBꂼpr̂ŁAIvVȂǂŁAIł悤ɂȁBłB



//̑ǋLA
//EړxAړppxA]ppxɂ́AꂼxݒłI
//E]́A{ Z > X > Y ̎]Ԃɂ̂ʓÎ悤B܂O̊TOZŉł킯AȂقǂ킩₷B
//  ݂ X > Z > Y ́AZOXłB
//  Ƃ2D̉XN[V[eBO낤ƎvĂA X > Z Ő݌vsĂ̂łB
//  Y]CȂSRȂEEEBxBłS̒ł́A{V[B

// ړ: VxMv VyMv VzMv
// L̈ړ̌nƂ͂܂ʂɁAƗ XAYAZɕsȈړw肪łB
// uXړxvuYړxvuZړxvݒ肷ƁAt[(_x,_y,_z)ɂꂼ̈ړ
// ZB
// i̋@\ GeoDriver ɏW񂳂ƗNXƂȂ܂Ij

//2010/02/19ǋL
// ܂ɁuRyRzvƂ\݂iuRzRyvƈقȂjÁuY]  Z]̏Ԃ̈ړpv\Ă̂ŒӁB
//   ܂AuړpiZjv]̏Ԃ̈Ⴂ𖾊mɂ邽
//   uRzRyRzvuRyRzRzvƏ肵ĂƂBiPɁuRzv̏ꍇ́uRzRyRzvӖĂj

//ǋL
//E炩ړ\ɁI

//TODO:
//xixj̒ǉ
//Cӎ]iNH[^jIj
//NX̔剻  (sړx)
//yzZ߂
