#include "jp/ggaf/dx/actor/ex/SpriteMeshSetActor.h"

#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include "jp/ggaf/dx/effect/MeshSetEffect.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/Config.h"
#include "jp/ggaf/dx/manager/TextureConnection.h"
#include "jp/ggaf/dx/model/MeshSetModel.h"
#include "jp/ggaf/dx/scene/Spacetime.h"
#include "jp/ggaf/dx/util/Util.h"


using namespace GgafDx;

SpriteMeshSetActor::SpriteMeshSetActor(const char* prm_name,
                                                   const char* prm_model,
                                                   Checker* prm_pChecker) :

                                                    MeshSetActor(prm_name,
                                                                       prm_model,
                                                                       "SpriteMeshSetEffect",
                                                                       "SpriteMeshSetTechnique",
                                                                       prm_pChecker) {

    _obj_class |= Obj_GgafDx_SpriteMeshSetActor;
    _class_name = "SpriteMeshSetActor";

    Texture* pTexture = getModel()->getDefaultTextureConnection()->peek();
    _pUvFlipper = NEW UvFlipper(pTexture);
    _pUvFlipper->locatePatternNo(1, 1);
    _pUvFlipper->setActivePtn(0);
    _pUvFlipper->exec(NOT_ANIMATED, 1);
}


void SpriteMeshSetActor::processDraw() {

    int draw_set_num = 0; //SpriteMeshSetActor̓fœeNjbN
                       //AĂJEgB`[x͈xɕ`悷B
    ID3DXEffect* const pID3DXEffect = _pMeshSetEffect->_pID3DXEffect;
    HRESULT hr;
    FigureActor* pDrawActor = this;
    SpriteMeshSetActor* pSpriteMeshSetActor = nullptr;
    int model_set_num = _pMeshSetModel->_set_num;
    float u = 0;
    float v = 0;
    while (pDrawActor) {
        if (pDrawActor->getModel() == _pMeshSetModel && pDrawActor->_hash_technique == _hash_technique) {
            pSpriteMeshSetActor = (SpriteMeshSetActor*)pDrawActor;

            hr = pID3DXEffect->SetMatrix(_pMeshSetEffect->_ah_matWorld[draw_set_num], &(pSpriteMeshSetActor->_matWorld));
            checkDxException(hr, D3D_OK, "SetMatrix(g_matWorld) Ɏs܂B");
            hr = pID3DXEffect->SetValue(_pMeshSetEffect->_ah_materialDiffuse[draw_set_num], &(pSpriteMeshSetActor->_paMaterial[0].Diffuse), sizeof(D3DCOLORVALUE) );
            checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");
#ifdef MY_DEBUG
            if (pDrawActor->instanceOf(Obj_GgafDx_SpriteMeshSetActor)) {
                //OK
            } else {
                throwCriticalException("pDrawActor["<<pDrawActor->getName()<<"] SpriteMeshSetActorł͂܂B");
            }
#endif
            //[MEMO]
            //SpriteMeshSetActor ́AMeshSetActor hĂ邽߁AfNX͓MeshSetModelłB
            //SpriteMeshSetActorgp郂f("x,10,Flora")ƁAMeshSetActorgp郂f
            //݂̂ꍇApDrawActor ́AMeshSetActor ̉\B
            //́Adraw_set_num ߂郍WbN͓[xŘA̓(AhX)fłBƂ肵sĂȂ߁B
            //͂ŁASpriteMeshSetActor  MeshSetActor œꃂfgp邱Ƃ͋֎~ɂ̂łB
            //{ Actor ̎ނɊ֌WȂA Model ŘAȂ΁AXe[g؂ւ邱ƂEł̂A
            //SpriteMeshSetActor ́AMeshSetActor hĂɂ炸AGtFNĝύXĂB
            //ɎȂ΁AʕƂĂꂼʂ Model NX쐬ׂȂAModelNXƂĂ̏̂
            //SpriteMeshSetActorAMeshSetActor ɑSŗǂB
            //Y񂾌ʁAModel NX𕪂ĎA댯ȃLXgsƂƂB
            //Ƃ肠SpriteMeshSetActor ƁAMeshSetActor ̃fdȂ悤Ђӎ邱ƂɂB
            //fobN[hŏ\eXgB
            //Actor ͔hĂ̂ɁAModelEffect́AeActorƈႤASetnBȊ֌WɒӂBi[U[`bvƂEEEj
            //TODO:dȂ悤ɂdg݂ȂƂ

            //UVItZbgݒ
            pSpriteMeshSetActor->_pUvFlipper->getUV(u, v);
            hr = pID3DXEffect->SetFloat(_pMeshSetEffect->_ah_offset_u[draw_set_num], u);
            checkDxException(hr, D3D_OK, "SetMatrix(_h_offset_u) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(_pMeshSetEffect->_ah_offset_v[draw_set_num], v);
            checkDxException(hr, D3D_OK, "SetMatrix(_h_offset_v) Ɏs܂B");

            draw_set_num++;
            if (draw_set_num >= model_set_num) {
                break;
            }
            pDrawActor = pDrawActor->_pNextRenderActor;
        } else {
            break;
        }
    }
    Spacetime::_pActor_draw_active = pSpriteMeshSetActor; //`Zbg̍ŌAN^[Zbg
    _pMeshSetModel->MeshSetModel::draw(this, draw_set_num);
}


SpriteMeshSetActor::~SpriteMeshSetActor() {
    GGAF_DELETE(_pUvFlipper);
}
