#include "jp/ggaf/dx/actor/camera/Camera.h"

#include "jp/ggaf/dx/Config.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/camera/CameraViewPoint.h"
#include "jp/ggaf/dx/actor/camera/CameraUpVector.h"
#include "jp/ggaf/dx/God.h"


using namespace GgafDx;

Camera::Camera(const char* prm_name, double prm_rad_fovX, double prm_dep) :
        GeometricActor(prm_name, nullptr),
_rad_fovX(prm_rad_fovX),      //SĂ̊fovXl
_dep(prm_dep),
_rad_half_fovX(_rad_fovX / 2.0),
_screen_aspect(1.0 * (CONFIG::GAME_BUFFER_WIDTH) / (CONFIG::GAME_BUFFER_HEIGHT)),
_rad_fovY(atan( ( (tan(_rad_fovX/2.0)) / _screen_aspect) )*2.0),
_rad_half_fovY(_rad_fovY / 2.0),
_tan_half_fovX(tan(_rad_fovX/2.0)),
_tan_half_fovY(tan(_rad_fovY/2.0)),
_cameraZ_org(-1.0 * ((1.0 * (CONFIG::GAME_BUFFER_HEIGHT) / PX_UNIT) / 2.0) / _tan_half_fovY),
_zn(0.1f),
_zf(-_cameraZ_org*(_dep+1.0)),
_x_buffer_left(PX_C(CONFIG::GAME_BUFFER_WIDTH) / -2),
_x_buffer_right(PX_C(CONFIG::GAME_BUFFER_WIDTH) / 2),
_y_buffer_top(PX_C(CONFIG::GAME_BUFFER_HEIGHT) / 2),
_y_buffer_bottom(PX_C(CONFIG::GAME_BUFFER_HEIGHT) / -2)
{
    _class_name = "Camera";
    //fovXƃAXyNg䂩fovYvZċ߂
    _TRACE_(FUNC_NAME<<" ʃAXyNgF"<<_screen_aspect);
    _TRACE_(FUNC_NAME<<" FovX="<<prm_rad_fovX<<" FovY="<<_rad_fovY);


    //Jʒu͎_(0,0,Z)A_(0,0,0)
    //ŹALZ=0XYʂŒxLlsNZƈv悤ȏɃJ
    _TRACE_(FUNC_NAME<<" J̈ʒu(0,0,"<<_cameraZ_org<<")");
    _pVecCamFromPoint   = NEW D3DXVECTOR3( 0.0f, 0.0f, (FLOAT)_cameraZ_org); //ʒu
    _pVecCamLookatPoint = NEW D3DXVECTOR3( 0.0f, 0.0f, 0.0f ); //
    _pVecCamUp          = NEW D3DXVECTOR3( 0.0f, 1.0f, 0.0f ); //

    // VIEWϊs쐬
    D3DXMatrixLookAtLH(
       &_matView,             // pOut [in, out] Zʂł D3DXMATRIX \̂ւ̃|C^B
        _pVecCamFromPoint,    // pEye [in] _` D3DXVECTOR3 \̂ւ̃|C^B̒ĺAsړɎgpB
        _pVecCamLookatPoint,  // pAt  [in] J̒Ώۂ` D3DXVECTOR3 \̂ւ̃|C^B
        _pVecCamUp            // pUp  [in] Jg [h̏Aʂɂ [0, 1, 0] ` D3DXVECTOR3 \̂ւ̃|C^B
    );

    // ˉeϊs쐬


    _TRACE_(FUNC_NAME<<" ͈ ["<<_zn<<" ~ "<<_zf<<"]");
    if (CONFIG::PRJ_2D_MODE) {
        //2D[hˉe
        D3DXMatrixOrthoLH(
            &_matProj,
            PX_DX(CONFIG::GAME_BUFFER_WIDTH),
            PX_DX(CONFIG::GAME_BUFFER_HEIGHT),
            _zn,
            _zf
        );
    } else {
        //3D[hʏˉe
        D3DXMatrixPerspectiveFovLH(
                &_matProj,
                _rad_fovY,       //ypfBA(0`)
                _screen_aspect,  //AXyNg  640~480 ̏ꍇ  640/480
                _zn,             //zn:J߂̃Nbvʂ܂ł̋(ǂ̋\Ώۂj0
                _zf              //zf:J牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn
        );
    }

    setPosition(0, 0, DX_C(_cameraZ_org));
    setFaceAngTwd(0,0,0);
    getVecDriver()->setMvAngTwd(0,0,0);
    setHitAble(false);

    God::_pID3DDevice9->GetViewport(&_viewport);

    _x_prev = 0;
    _y_prev = 0;
    _z_prev = 0;

    _pCameraViewPoint = nullptr;
    _pCameraUpVector = nullptr;
}

void Camera::initialize() {
    getCameraViewPoint();
    getCameraUpVector();
}

void Camera::processBehavior() {

    // _viewport.MinZ / MaxZ ́Aʏ킻ꂼ 0 / 1
    const dxcoord x1 = dxcoord(_viewport.X);
    const dxcoord y1 = dxcoord(_viewport.Y);
    const dxcoord x2 = dxcoord(_viewport.X + _viewport.Width);
    const dxcoord y2 = dxcoord(_viewport.Y + _viewport.Height);

    // ̂W_i[CX^X
    _vecNear[0].x = x1;  _vecNear[0].y = y1;  _vecNear[0].z = _viewport.MinZ;   //  (ϊ)
    _vecNear[1].x = x2;  _vecNear[1].y = y1;  _vecNear[1].z = _viewport.MinZ;   // E (ϊ)
    _vecNear[2].x = x1;  _vecNear[2].y = y2;  _vecNear[2].z = _viewport.MinZ;   //  (ϊ)
    _vecNear[3].x = x2;  _vecNear[3].y = y2;  _vecNear[3].z = _viewport.MinZ;   // E (ϊ)

    _vecFar[0].x  = x1;  _vecFar[0].y  = y1;  _vecFar[0].z  = _viewport.MaxZ;   //  (ϊ)
    _vecFar[1].x  = x2;  _vecFar[1].y  = y1;  _vecFar[1].z  = _viewport.MaxZ;   // E (ϊ)
    _vecFar[2].x  = x1;  _vecFar[2].y  = y2;  _vecFar[2].z  = _viewport.MaxZ;   //  (ϊ)
    _vecFar[3].x  = x2;  _vecFar[3].y  = y2;  _vecFar[3].z  = _viewport.MaxZ;   // E (ϊ)

    // ̂W_̌vZ
    const D3DXMATRIX mat_world = D3DXMATRIX(
        1.0f,  0.0f,  0.0f,  0.0f,
        0.0f,  1.0f,  0.0f,  0.0f,
        0.0f,  0.0f,  1.0f,  0.0f,
        0.0f,  0.0f,  0.0f,  1.0f
    );
    // [h  r[  ˉe  XN[ϊ ̋ts
    for ( int i = 0; i < 4; i++ ) {
        D3DXVec3Unproject(
            &_vecNear[i], //D3DXVECTOR3 *pOut,              [in, out] Zʂł D3DXVECTOR3 \̂ւ̃|C^B
            &_vecNear[i], //CONST D3DXVECTOR3 *pV,          [in] ̊ɂȂ D3DXVECTOR3 \̂ւ̃|C^B
            &_viewport,   //CONST D3DVIEWPORT9 *pViewport,  [in] r[|[g\ D3DVIEWPORT9 \̂ւ̃|C^B
            &_matProj,    //CONST D3DXMATRIX *pProjection,  [in] ˉes\ D3DXMATRIX \̂ւ̃|C^B
            &_matView,    //CONST D3DXMATRIX *pView,        [in] r[s\ D3DXMATRIX \̂ւ̃|C^B
            &mat_world    //CONST D3DXMATRIX *pWorld        [in] [hs\ D3DXMATRIX \̂ւ̃|C^B
        );
        D3DXVec3Unproject(
            &_vecFar[i],
            &_vecFar[i],
            &_viewport,
            &_matProj,
            &_matView,
            &mat_world
        );
    }

    // ̖
    //-------------------------------------------------
    //  ʕFax+by+cz+d
    //  ʂ̖@xNgFn = (a, b, c)
    //  ʏ1_Ap = (x0, y0, z0) ƂƁA
    //  ʂ̖@xNgƕʏ1_̓ρFd = n*p
    //
    //  \Ƃ́A_ p = (x0, y0, z0)A
    //  p = (x0, y0, z0, 1) Ƃ݂ȂA
    //  ʂƂ̓ρFa*x0 + b*y0 + c*z0 + d*1 = ans
    //  ans > 0 Ȃ\Aans < 0 Ȃ痠Aans == 0 ȂʏAƂȂB
    //  DXPlaneDotCoord() ́ȀsĂ
    //
    //  ܂Ap = (x0, y0, z0, 0) Ƃ݂Ȃēς̌vZsƁA
    //  px̊֌W𒲂ׂ邱ƂłB
    //   D3DXPlaneDotNormal()
    //-------------------------------------------------

     //  ( FANANE )
    D3DXPlaneNormalize(
        &_plnTop,
        D3DXPlaneFromPoints(&_plnTop, &(_vecFar[2]), &(_vecNear[2]), &(_vecNear[3]))
    );
    //  ( FANEAN )
    D3DXPlaneNormalize(
        &_plnBottom,
        D3DXPlaneFromPoints(&_plnBottom, &(_vecFar[0]), &(_vecNear[1]), &(_vecNear[0]))
    );
    //  ( FANAN )
    D3DXPlaneNormalize(
        &_plnLeft,
        D3DXPlaneFromPoints(&_plnLeft, &(_vecFar[0]), &(_vecNear[0]), &(_vecNear[2]))
    );
    // E ( FEANEANE )
    D3DXPlaneNormalize(
        &_plnRight,
        D3DXPlaneFromPoints(&_plnRight, &(_vecFar[1]), &(_vecNear[3]), &(_vecNear[1]))
    );
    // O ( NANANE)
    D3DXPlaneNormalize(
        &_plnInfront,
        D3DXPlaneFromPoints(&_plnInfront, &(_vecNear[2]), &(_vecNear[0]), &(_vecNear[3]))
    );
    //  ( FEAFAF)
    D3DXPlaneNormalize(
        &_plnBack,
        D3DXPlaneFromPoints(&_plnBack, &(_vecFar[3]), &(_vecFar[0]), &(_vecFar[2]))
    );

    // S i{[pŎgpj
    _vecVerticalCenter[0].x = (_vecFar[1].x + _vecFar[0].x)*0.5f;
    _vecVerticalCenter[0].y = (_vecFar[1].y + _vecFar[0].y)*0.5f;
    _vecVerticalCenter[0].z = (_vecFar[1].z + _vecFar[0].z)*0.5f;

    _vecVerticalCenter[1].x = (_vecNear[3].x + _vecNear[2].x)*0.5f;
    _vecVerticalCenter[1].y = (_vecNear[3].y + _vecNear[2].y)*0.5f;
    _vecVerticalCenter[1].z = (_vecNear[3].z + _vecNear[2].z)*0.5f;

    _vecVerticalCenter[2].x = (_vecNear[1].x + _vecNear[0].x)*0.5f;
    _vecVerticalCenter[2].y = (_vecNear[1].y + _vecNear[0].y)*0.5f;
    _vecVerticalCenter[2].z = (_vecNear[1].z + _vecNear[0].z)*0.5f;

    D3DXPlaneNormalize(
        &_plnVerticalCenter,
        D3DXPlaneFromPoints(&_plnVerticalCenter, &(_vecVerticalCenter[0]),
                                                 &(_vecVerticalCenter[1]),
                                                 &(_vecVerticalCenter[2])
                            )
    );

}

void Camera::processSettlementBehavior() {
    _fX = C_DX(_x);
    _fY = C_DX(_y);
    _fZ = C_DX(_z);

    _x_prev = _x;
    _y_prev = _y;
    _z_prev = _z;
    _pVecCamFromPoint->x = _fX;
    _pVecCamFromPoint->y = _fY;
    _pVecCamFromPoint->z = _fZ;
    CameraViewPoint* pVp = getCameraViewPoint();
    _pVecCamLookatPoint->x = pVp->_fX;
    _pVecCamLookatPoint->y = pVp->_fY;
    _pVecCamLookatPoint->z = pVp->_fZ;
    CameraUpVector* pUpv = getCameraUpVector();
    _pVecCamUp->x = pUpv->_fX;
    _pVecCamUp->y = pUpv->_fY;
    _pVecCamUp->z = pUpv->_fZ;
    D3DXMatrixLookAtLH(&_matView,
                       _pVecCamFromPoint, _pVecCamLookatPoint, _pVecCamUp);
}

CameraViewPoint* Camera::getCameraViewPoint() {
    if (_pCameraViewPoint) {
        return _pCameraViewPoint;
    } else {
        _pCameraViewPoint = createCameraViewPoint();
        _pCameraViewPoint->setPosition(0, 0, 0);
        appendGroupChild(_pCameraViewPoint);
        return _pCameraViewPoint;
    }
}

CameraUpVector* Camera::getCameraUpVector() {
    if (_pCameraUpVector) {
        return _pCameraUpVector;
    } else {
        _pCameraUpVector = createCameraUpVector();
        _pCameraUpVector->setPosition(0, DX_C(1), 0);
        appendGroupChild(_pCameraUpVector);
        return _pCameraUpVector;
    }
}

void Camera::setDefaultPosition() {
    _x = 0;
    _y = 0;
    _z = DX_C(_cameraZ_org);
    CameraViewPoint* pVp = getCameraViewPoint();
    pVp->setPosition(0, 0, 0);
    CameraUpVector* pUpv = getCameraUpVector();
    pUpv->setPosition(0, DX_C(1), 0);
}

bool Camera::isMoving() {
    if (_x_prev == _x && _y_prev == _y && _z_prev == _z) {
        return false;
    } else {
        return true;
    }
}

Camera::~Camera() {
    GGAF_DELETE(_pVecCamFromPoint);
    GGAF_DELETE(_pVecCamLookatPoint);
    GGAF_DELETE(_pVecCamUp);
}
