#include "jp/ggaf/dx/actor/MeshSetActor.h"

#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/effect/MeshSetEffect.h"
#include "jp/ggaf/dx/model/MeshSetModel.h"
#include "jp/ggaf/dx/scene/Spacetime.h"
#include "jp/ggaf/dx/util/Util.h"


using namespace GgafDx;

MeshSetActor::MeshSetActor(const char* prm_name,
                           const char* prm_model_id,
                           const char* prm_effect_id,
                           const char* prm_technique,
                           Checker* prm_pChecker) :

                               FigureActor(prm_name,
                                           prm_model_id,
                                           TYPE_MESHSET_MODEL,
                                           prm_effect_id,
                                           TYPE_MESHSET_EFFECT,
                                           prm_technique,
                                           prm_pChecker),
_pMeshSetModel((MeshSetModel*)_pModel),
_pMeshSetEffect((MeshSetEffect*)_pEffect)
{
    _obj_class |= Obj_GgafDx_MeshSetActor;
    _class_name = "MeshSetActor";
    defineRotMvWorldMatrix(UTIL::setWorldMatrix_RxRzRyMv); //ftHg̉]~ړ̕ϊs
}

MeshSetActor::MeshSetActor(const char* prm_name,
                           const char* prm_model_id,
                           const char prm_model_type,
                           const char* prm_effect_id,
                           const char prm_effect_type,
                           const char* prm_technique,
                           Checker* prm_pChecker) :

                               FigureActor(prm_name,
                                           prm_model_id,
                                           prm_model_type,
                                           prm_effect_id,
                                           prm_effect_type,
                                           prm_technique,
                                           prm_pChecker),
_pMeshSetModel((MeshSetModel*)_pModel),
_pMeshSetEffect((MeshSetEffect*)_pEffect) {

    _obj_class |= Obj_GgafDx_MeshSetActor;
    _class_name = "MeshSetActor";
    defineRotMvWorldMatrix(UTIL::setWorldMatrix_RxRzRyMv); //ftHg̉]~ړ̕ϊs
}

void MeshSetActor::processDraw() {
    int draw_set_num = 0; //MeshSetActor̓fœeNjbN
                       //AĂJEgB`[x͈xɕ`悷B
    ID3DXEffect* const pID3DXEffect = _pMeshSetEffect->_pID3DXEffect;
    HRESULT hr;
    FigureActor* pDrawActor = this;
    MeshSetActor* pMeshSetActor = nullptr;
    const int model_set_num = _pMeshSetModel->_set_num;
    while (pDrawActor) {
        if (pDrawActor->getModel() == _pMeshSetModel && pDrawActor->_hash_technique == _hash_technique) {
            pMeshSetActor = (MeshSetActor*)pDrawActor;
            hr = pID3DXEffect->SetMatrix(_pMeshSetEffect->_ah_matWorld[draw_set_num], &(pMeshSetActor->_matWorld));
            checkDxException(hr, D3D_OK, "SetMatrix(g_matWorld) Ɏs܂B");
            hr = pID3DXEffect->SetValue(_pMeshSetEffect->_ah_materialDiffuse[draw_set_num], &(pMeshSetActor->_paMaterial[0].Diffuse), sizeof(D3DCOLORVALUE) );
            //yMeshSetActor̃}eAJ[ɂčlzY^
            //{̓}eAPIuWFNgɕێA}eAXg̃O[vɐݒ肷̂AsxœKƎgpWX^팸(sNZVF[_[2.0)ׁ̈A
            //eZbg[0]̃}eAŜ̃}eAƂB
            //MeshSetActor̓}eAF͂PFs\B
            //ꂼ̂PFA}eAFƂăIuWFNgʂɂ邽ߒ_J[ŎĂB
            //ƂƖ{NX́AꃂfIuWFNgAɈŕ`悵Xs[hAbv}邱ƂړIƂNXŁA}eAO[vIuWFNgɂ͕sƂӖłB
            //PeNX`Ŋ撣ΖȂEEEƂjB}eAFŐFꍇ MeshActor gȂB
            checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");
            draw_set_num++;
            if (draw_set_num >= model_set_num) {
                break;
            }
            pDrawActor = pDrawActor->_pNextRenderActor;
        } else {
            break;
        }
    }
    Spacetime::_pActor_draw_active = pMeshSetActor; //`Zbg̍ŌAN^[Zbg
    ((MeshSetModel*)_pMeshSetModel)->MeshSetModel::draw(this, draw_set_num);
}

MeshSetActor::~MeshSetActor() {
}
