#ifndef GGAF_DX_BGMCONDUCTOR_H_
#define GGAF_DX_BGMCONDUCTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include <vector>

namespace GgafDx {

/**
 * BGMtw҃NX .
 * BGMƂɕRʁAp̒lێ
 * BGM}X^[{[l
 * @version 1.00
 * @since 2010/04/19
 * @author Masatoshi Tsuge
 */
class BgmConductor : public GgafCore::Object {

public:
//    static int _active_bgm_bpm;
    /** [r]BGMԍ */
    int _bgm_num;
    /** [r]Bgmڑ */
    std::vector<BgmConnection*>  _vecBgmConnection;
    /** [r]BGM̃{[z(YBGMԍ) */
    std::vector<double> _vec_volume;
    /** [r]BGM̃pl(YBGMԍ) */
    std::vector<float> _vec_pan;
    /** [r]tF[h^[Qbg{[̔z(Y̓`l) */
    std::vector<double> _vec_target_volume;
    /** [r]{[Zl̔z(Y̓`l) */
    std::vector<double> _vec_inc_volume;
    /** [r]݃tF[hۂ̔z(Y̓`l) */
    std::vector<bool> _vec_is_fade;
    /** [r]tF[h~̂ǂ̔z(Y̓`l) */
    std::vector<bool> _vec_is_fadeafter_stop;

public:
    BgmConductor();

    /**
     * BGM .
     * tOɕKsĂKv܂B
     * @param prm_bgm_no BGMԍ(0 ` )
     * @param prm_bgm_name vpeBt@Ckey
     */
    virtual void ready(int prm_bgm_no, const char* prm_bgm_name);

    /**
     * BGMt鏀Ă邩 .
     * @param prm_bgm_no  BGMԍ(0 ` )
     * @return true:tł^false:tłȂ
     */
    virtual bool isReady(int prm_bgm_no);

    /**
     * {[lݒ肷 .
     * BGM}X^[{[lꂽʂɐݒ肳B
     * @param prm_bgm_no BGMԍ(0 ` )
     * @param prm_volume {[l(0 ` 1000)
     */
    virtual void setVolume(int prm_bgm_no, double prm_volume);

    /**
     * {[l擾 .
     * BGM}X^[{[lĂȂsetVolume()Őݒ肳ꂽʂ擾B
     * @param prm_bgm_no BGMԍ(0 ` )
     * @return {[l(0 ` 1000)
     */
    virtual int getVolume(int prm_bgm_no) {
        return _vec_volume[prm_bgm_no];
    }

    /**
     * {[lZ .
     * BGM}X^[{[lꂽʂɐݒ肳B
     * @param prm_bgm_no BGMԍ(0 ` )
     * @param prm_volume Z{[l(0 ` 1000)
     * @return
     */
    virtual void addVolume(int prm_bgm_no, double prm_volume) {
        setVolume(prm_bgm_no, _vec_volume[prm_bgm_no] + prm_volume);
    }

    /**
     * plݒ .
     * BGM}X^[p͖쐬̂߁Â܂ܔf
     * @param prm_pan pl(left:-1.0 ` center:0 ` right:1.0)
     */
    virtual void setPan(int prm_bgm_no, float prm_pan);

    /**
     * pl擾 .
     * @param prm_bgm_no
     * @return
     */
    virtual float getPan(int prm_bgm_no) {
        return _vec_pan[prm_bgm_no];
    }

    /**
     * t .
     * ꎞ~Ăꍇ́A牉tBȂ̍ŏƂ͌ȂB
     * @param prm_bgm_no  BGMԍ(0 ` )
     * @param prm_is_loop  [v邩ǂitrue:[vĐ^false:[vĐȂj
     */
    virtual void perform(int prm_bgm_no, bool prm_is_loop = true);

    /**
     * Ȃ̍ŏ牉t .
     * @param prm_bgm_no  BGMԍ(0 ` )
     * @param prm_is_loop [v邩ǂitrue:[vĐ^false:[vĐȂj
     */
    virtual void performFromTheBegining(int prm_bgm_no, bool prm_is_loop = true);

    /**
     * BGM~ .
     * @param prm_bgm_no BGMԍ(0 ` )
     */
    virtual void stop(int prm_bgm_no);

    /**
     * BGMꎞ~ .
     * @param prm_bgm_no BGMԍ(0 ` )
     */
    virtual void pause(int prm_bgm_no);

    /**
     * BGM̈ꎞ~ .
     * @param prm_bgm_no  BGMԍ(0 ` )
     */
    virtual void unpause(int prm_bgm_no);

    /**
     * SBGMԍBGM~ .
     */
    virtual void stop();

    /**
     * SBGMԍBGMꎞ~ .
     */
    virtual void pause();

    /**
     * SBGMԍBGM̈ꎞ~ .
     */
    virtual void unpause();

    virtual bool isPerforming(int prm_bgm_no);
    /**
     * BGM̈ꎞ~f .
     * @param prm_bgm_no BGMԍ(0 ` )
     * @return true:ꎞ~^false:ꎞ~ł͖
     */
    virtual bool isPause(int prm_bgm_no);

    virtual bool isStopping(int prm_bgm_no);

    virtual Bgm* getBgm(int prm_bgm_no);

    /**
     * BGM̐U镑 .
     * Ƀ{[ωAtF[hCEAEgʂB
     */
    virtual void behave();

    /**
     * tBGMɃtF[hʂsB
     * @param prm_bgm_no              BGMԍ(0 ` )
     * @param prm_frame           tF[hɔ₷t[
     * @param prm_target_volume   BڕW{[(0 ` 100)
     */
    virtual void fade(int prm_bgm_no, frame prm_frame, int prm_target_volume);

    /**
     * BGMAtF[hCɂĐJnB
     * @param prm_bgm_no  BGMԍ(0 ` )
     * @param prm_frame tF[hCt[
     */
    virtual void performFadein(int prm_bgm_no, frame prm_frame);

    /**
     * tBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     * @param prm_bgm_no BGMԍ(0 ` )
     * @param prm_frame tF[hAEgt[
     */
    virtual void fadeoutStop(int prm_bgm_no, frame prm_frame);

    /**
     * SBGMԍ̉tBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     * tF[hAEgԂ setDefaultFadeFrames() w̃t[B
     */
    virtual void fadeoutStopAll(frame prm_frame);


    virtual ~BgmConductor();
};

}
#endif /*GGAF_DX_BGMCONDUCTOR_H_*/
