#ifndef GGAF_DX_SCENE_H_
#define GGAF_DX_SCENE_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/scene/MainScene.h"

#include "jp/ggaf/core/util/Curtain.hpp"

namespace GgafDx {

/**
 * CoreOԁAV[NX.
 * ̋@\V[NXɒǉĂ܂B<BR>
 * EBGMt<BR>
 * EBGMtF[hCEtF[hAEg<BR>
 * EV[̕`IuWFNg̃tF[hCEtF[hAEg<BR>
 * CoreOԓł́ÃNXV[Ƃ܂B<BR>
 * @version 1.00
 * @since 2008/01/24
 * @author Masatoshi Tsuge
 */
class Scene : public GgafCore::MainScene {
private :

    /**
     * draw() ̃I[o[Ch֎~ .
     * E(Spacetime)SĂ̕`sdg݂ɂȂ܂B<BR>
     * āAI[o[ChĂt[[NĂяo邱Ƃ͂܂B<BR>
     * ăI[o[ChȂ߂ private ŎB<BR>
     * Spacetime::draw() QƂB<BR>
     */
    void draw() override {
    }

public :
    /** [r]V[̃tF[hCEAEgpJ[eiftHgł̓J[ej */
    SceneCurtain* _pCurtain;
    /** [r]BGMt */
    BgmConductor* _pConductor;
    /** [r]V[̃ */
    float _scene_alpha;
    float _scene_alpha_from_top;
public:
    /**
     * RXgN^ .
     * @param prm_name
     * @return
     */
    Scene(const char* prm_name, GgafCore::SceneMediator* prm_pSceneMediator = nullptr);

    void setSceneAlpha(float prm_scene_alpha);
    float getSceneAlpha();
    void addSceneAlpha(float prm_scene_alpha);

    void setSceneAlphaFromTop(float prm_scene_alpha_from_top);
    float getSceneAlphaFromTop();

    /**
     * J[etւ .
     * @param prm_pCurtain_new VJ[e
     */
    void chengeCurtain(SceneCurtain* prm_pCurtain_new);

    SceneCurtain* getSceneCurtain() {
        return _pCurtain;
    }

    virtual void processPreJudgement() override;

    virtual void pauseTree() override;
    virtual void pause() override;

    virtual void unpauseTree() override;
    virtual void unpause() override;

    /**
     * V[̃AN^[tF[hC .
     * @param prm_frame_fade At@l 1.0 ɂȂ܂ł̎st[(0`)
     */
    void fadeinScene(int prm_frame_fade);

    /**
      * V[̃AN^[tF[hAEg .
     * @param prm_frame_fade At@l 0.0 ɂȂ܂ł̎st[(0`)
     */
    void fadeoutScene(int prm_frame_fade);


    void fadeoutBgm(int prm_frame_fade);
    void fadeoutBgmTree(int prm_frame_fade);

    /**
     * V[̃AN^[tF[hAEgƓɁABGMtF[hAEg .
     * BGḾAV[o[ _pConductor(BgmConductorIuWFNg) 
     * tĂ邱ƂOB
     * @param prm_frame_fade tF[hAEgt[
     */
    void fadeoutSceneWithBgm(int prm_frame_fade);

    /**
     * c[V[̃AN^[tF[hAEgƓɁABGMtF[hAEg .
     * BGḾAV[o[ _pConductor(BgmConductorIuWFNg) 
     * tĂ邱ƂOB
     * @param prm_frame_fade tF[hAEgt[
     */
    void fadeoutSceneWithBgmTree(int prm_frame_fade);


    inline BgmConductor* getBgmConductor() {
        return _pConductor;
    }

    virtual void onEnd() override;

    virtual ~Scene();
};

}
#endif /*GGAF_DX_SCENE_H_*/
