#ifndef GGAF_DX_SPRITEMODEL_H_
#define GGAF_DX_SPRITEMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * SpriteActorpfNX.
 * @version 1.00
 * @since 2008/02/22
 * @author Masatoshi Tsuge
 */
class SpriteModel : public Model {
    friend class ModelManager;

public:
    /** _\ */
    struct VERTEX : public VERTEX_3D_BASE {
        DWORD color;      // _Fiݖgpj
        float tu, tv;     // _̃eNX`W
    };

    /** _obt@ */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** _FVF */
    static DWORD FVF;

    VERTEX* _pVertexBuffer_data;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    float _model_width_px;
    float _model_height_px;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    SpriteModel(const char* prm_model_name);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     */
    virtual ~SpriteModel(); //fXgN^
};

}
#endif /*GGAF_DX_SPRITEMODEL_H_*/
