#ifndef GGAF_DX_SKINANIMESHMODEL_H_
#define GGAF_DX_SKINANIMESHMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"
#include "jp/ggaf/dx/effect/SkinAniMeshEffect.h"
#include <map>
#include <vector>

namespace GgafDx {

/**
 * D3DXActorpfNX.(gpAÕAj[Vt[ŉBappendGroupChildAsFk()Ŏ)
 * SkinAniMeshModel  D3DXLoadMeshFromX gpāAXt@C烂ff[^ǂݍݐݒ肷B<BR>
 * @version 1.00
 * @since 2009/11/25
 * @author Masatoshi Tsuge
 */
class SkinAniMeshModel : public Model {
    friend class ModelManager;

public:
    /** _FVF */
    struct VERTEX : public Model::VERTEX_3D_BASE {
        DWORD color;      // _̐FiIuWFNg̃}eAJ[ƂĎgpj
        float tu, tv;     // eNX`W
        float infl_weight[4];     // _d(TODO:Sł́H)
        byte  infl_bone_id_order[4]; //{[ID̒ʂԍ
    };
    /**
     * _obt@̕⑫ .
     */
    struct INDEXPARAM {
        UINT MaterialNo;
        INT BaseVertexIndex;
        UINT MinIndex;
        UINT NumVertices;
        UINT StartIndex;
        UINT PrimitiveCount;
    };

    /**
     * ꊇ`Pʂ̃{[Rrl[VO[v .
     */
    class BoneConbiGrp {
    public:
        /** O[v̍ŏ̃{[Rrl[VCfbNX */
        int bone_combi_start_index;
        /** O[v bone_combi_start_index ̃{[Rrl[VCfbNX */
        int bone_combi_count;
        /** O[v̒_obt@JnCfbNX */
        DWORD grp_vertex_start;
        /** O[v grp_vertex_start ̒_obt@ */
        DWORD grp_vertex_count;

        std::vector<DWORD> vec_infl_bone_id_order; //j[Nvec_cb_idx_order}Ă
        std::vector<DWORD> vec_cb_idx_order;       //vec_infl_bone_id_order }ꂽ

        //bone_id Abone_id_order 𓾂MAP
        std::map<DWORD, DWORD> map_infl_bone_id_to_order;
        /** `掞̍ŏIIȕϊsiʂj */
        BoneConbiGrp() {
            bone_combi_start_index = 0;
            bone_combi_count = 0;
            grp_vertex_start = 0;
            grp_vertex_count = 0;
        }
    };
    std::vector<BoneConbiGrp> _vec_bone_combi_grp_info;

    SkinAniMeshModel::VERTEX* _paVtxBuffer_data;

    WORD* _paIndexBuffer_data;
    /** VF[_[͒_tH[}bg */
    LPDIRECT3DVERTEXDECLARATION9 _pVertexDeclaration;
    /** _obt@iSt[̃bVj */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** CfbNXobt@iSt[̃bVj  */
    LPDIRECT3DINDEXBUFFER9 _pIndexBuffer;
    /** f_ */
    UINT _nVertices;
    /** fʂ̐ */
    UINT _nFaces;
    /** P_̃TCY */
    UINT _size_vertex_unit;
    /** f_TCYv */
    UINT _size_vertices;
    int _index_param_num;
    INDEXPARAM* _paIndexParam;
    /** SkinAniMeshFrame舵AllocateHierarchyNX */
    SkinAniMeshAllocHierarchy* _pAllocHierarchy;
    /** [hϊstt[\̂̃[g */
    SkinAniMeshFrame* _pFrameRoot;
    /** Aj[VRg[AActorɂ͂ꂪ clone Actorɕێ邱ƂɂȂ */
    ID3DXAnimationController* _pAniControllerBase;

    /** _pFrameRoot ăt[𒼗񉻂́Avfԍ̓t[CfbNXƌď̂  */
    std::vector<SkinAniMeshFrame*> _vecAllBoneFrame;
    /** _pFrameRoot ĕ`Ώۂt[𒼗񉻂́Avfԍ̘͂A  */
    std::vector<SkinAniMeshFrame*> _vecDrawBoneFrame;


    std::vector<SkinAniMeshFrame*> _vecBoneIdFrame;

    /** ̕`ŃZbgłϊs */
    int _draw_combined_matrix_set_num;

    /** Aj[VZbg */
    UINT _num_animation_set;
    /** AnimationSet AAnimationSetCfbNX擾ł}bv */
    std::map<ID3DXAnimationSet*, UINT> _mapAnimationSet_AniSetindex;
    /** [Aj[VZbgCfbNX][t[CfbNX]  Aj[VZbg̃Aj[VΏۂ̃t[ł邩ǂԂ */
    bool** _papaBool_AnimationSetIndex_BoneFrameIndex_is_act;

public:
    /**
     * RXgN^<BR>
     * @param prm_model f̎ʖB".x"ǉƒ`Xt@CɂȂB
     * @return
     */
    SkinAniMeshModel(const char* prm_model);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    ID3DXAnimationController* getCloneAnimationController();

    /** t[ď擾 */
    void setFrameInfo(SkinAniMeshFrame* prm_pFrame);

    void setAnimationFrameIndex();

    /** setFrameInfo(SkinAniMeshFrame*) ŎgpAframe_index̒ʂԍ */
    DWORD _tmp_frame_index;

    int getOffsetFromElem( D3DVERTEXELEMENT9 *elems, D3DDECLUSAGE usage );

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     * deletêSkinAniMeshModelManagerł<BR>
     */
    virtual ~SkinAniMeshModel(); //fXgN^

};

}
#endif /*GGAF_DX_SKINANIMESHMODEL_H_*/
