#ifndef GGAF_DX_MORPHMESHMODEL_H_
#define GGAF_DX_MORPHMESHMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * MorphMeshModelp̃fNX.
 * MorphMeshModel  MeshModel ̕`悷@\ɉA[tAj[V@\L郂fłB<BR>
 * <b>̃f ( prm_model_name ) ̗^Ɠǂݍ܂Xt@Cɂ</b><BR>
 * ၄<BR>
 * <table border=1>
 * <tr>
 * <th>prm_model_name</th>
 * <th>vC}bV Xt@C</th>
 * <th>[t^[Qbg Xt@C</th>
 * </tr>
 * <tr>
 * <td>"M,ball_0"</td>
 * <td>ball_0.x</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>"M,ball_1"</td>
 * <td>ball_0.x</td>
 * <td>ball_1.x</td>
 * </tr>
 * <tr>
 * <td>"M,ball_2"</td>
 * <td>ball_0.x</td>
 * <td>ball_1.x, ball_2.x</td>
 * </tr>
 * <tr>
 * <td>"M,ball_6"</td>
 * <td>ball_0.x</td>
 * <td>ball_1.x, ball_2.x, ball_3.x,EEEball_6.x</td>
 * </tr>
 * </table>
 * @version 1.00
 * @since 2009/05/08
 * @author Masatoshi Tsuge
 */
class MorphMeshModel : public Model {
    friend class ModelManager;

public:
    struct INDEXPARAM {
        UINT MaterialNo;
        INT BaseVertexIndex;
        UINT MinIndex;
        UINT NumVertices;
        UINT StartIndex;
        UINT PrimitiveCount;
    };


    /** vC}bV̒_tH[}bg` */
    struct VERTEX_PRIMARY : public Model::VERTEX_3D_BASE {
        DWORD color;      // _̐Fiݖgpj
        float tu, tv;     // eNX`W
    };

    /** [t^[QbgbV̒_tH[}bg` */
    struct VERTEX_MORPH : public Model::VERTEX_3D_BASE {
    };

    /** [t^[Qbg */
    int _morph_target_num;
    /** VF[_[͒_tH[}bg */
    LPDIRECT3DVERTEXDECLARATION9 _pVertexDeclaration;
    /** _obt@ivC}j */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer_primary;
    /** _obt@̔zivf[t^[Qbgj */
    LPDIRECT3DVERTEXBUFFER9* _paIDirect3DVertexBuffer9_morph;

    /** CfbNXobt@ivC}̂݁j */
    LPDIRECT3DINDEXBUFFER9 _pIndexBuffer;

    /** _̃TCYivC}j */
    UINT _size_vertices_primary;
    /** 1_̃TCYivC}j */
    UINT _size_vertex_unit_primary;
    /** _̃TCYi[t^[Qbgj */
    UINT _size_vertices_morph;
    /** 1_̃TCYi[t^[Qbgj */
    UINT _size_vertex_unit_morph;

    /** DrawIndexedPrimitive`p[^[ivC}̂݁j */
    INDEXPARAM* _paIndexParam;
    /** }eAސivC}̂݁j */
    UINT _material_list_grp_num;

    /** _obt@̎ʂRs[̒_zivC}j */
    VERTEX_PRIMARY* _paVtxBuffer_data_primary;
    /** _obt@̎ʂRs[̒_z̃[t^[Qbgz */
    VERTEX_MORPH**  _papaVtxBuffer_data_morph;
    /** CfbNXobt@̎ʂRs[ivC}̂݁j */
    WORD* _paIndexBuffer_data;

    /** Paul񃂃fivfvC}{[t^[Qbgj */
    Frm::Model3D** _papModel3D;
    /** Paul񃁃bVivfvC}{[t^[Qbgj */
    Frm::Mesh** _papMeshesFront;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name f`̎ʖ
     */
    MorphMeshModel(const char* prm_model_name);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     */
    virtual ~MorphMeshModel(); //fXgN^
};

}
#endif /*GGAF_DX_MORPHMESHMODEL_H_*/
