#ifndef GGAF_DX_MASSSPRITEMODEL_H_
#define GGAF_DX_MASSSPRITEMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/MassModel.h"

namespace GgafDx {

/**
 * MassSpriteActorpfNX.
 * @version 1.00
 * @since 2016/02/25
 * @author Masatoshi Tsuge
 */
class MassSpriteModel : public MassModel {
    friend class ModelManager;

public:
    struct VERTEX_model : public Model::VERTEX_3D_BASE {
        float tu, tv;     // eNX`W
    };
    VERTEX_model* _paVtxBuffer_data_model;
    WORD* _paIndexBuffer_data;

    float _model_width_px;
    float _model_height_px;
    float _model_half_width_px;
    float _model_half_height_px;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    MassSpriteModel(const char* prm_model_name);

    static void createVertexModel(void* prm, MassModel::VertexModelInfo* out_info);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    /**
     * fXgN^<BR>
     */
    virtual ~MassSpriteModel(); //fXgN^
};

}
#endif /*GGAF_DX_MASSSPRITEMODEL_H_*/
