#ifndef GGAF_DX_BOARDMODEL_H_
#define GGAF_DX_BOARDMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * BoardActorpfNX.
 * @version 1.00
 * @since 2009/03/10
 * @author Masatoshi Tsuge
 */
class BoardModel : public Model {
    friend class ModelManager;
    friend class BoardActor;

public:
    struct VERTEX {
        float x, y, z; // _W
        float tu, tv; // eNX`W
    };

    /** _FVF */
    static DWORD FVF;
    /** _obt@ */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;

    VERTEX* _pVertexBuffer_data;

    float _model_width_px;
    float _model_height_px;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    BoardModel(const char* prm_model_name);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     * deletêBoardModelManagerł<BR>
     */
    virtual ~BoardModel(); //fXgN^

};

}
#endif /*GGAF_DX_BOARDMODEL_H_*/
