#ifndef GGAF_DX_VECDRIVER_H_
#define GGAF_DX_VECDRIVER_H_
#include "GgafDxCommonHeader.h"
#include "ActorDriver.h"

#include "jp/ggaf/dx/util/GeoElem.h"
#include "jp/ggaf/dx/actor/GeometricActor.h"

namespace GgafDx {

/**
 * AN^[悹͎ԁiAN^[̐ړxj  .
 * ͎Ԃ͉X̖ڂɂ͐G܂񂪁A(AN^[)グAuړvủ]vs킹鐢blłB<BR>
 * (AN^[)͎̈ӎvœ삹ƂA͎Ԃ̂ŕщ܂邱Ƃł܂B<BR>
 * {Iȓ͎͗ԂłقƂǃJo[łĂ܂܂B̂ŁA҂͎g̉ZɏWł̂łB<BR>
 * 񉉎Ҏg͂ĈړE]sƁA͎Ԃł͏oȂA蕡GȈړ\ł傤B<BR>
 * ҈lɂA͎ԂWňltĂ܂B<BR>
 * <BR>
 * ͂ĒuA܂͍WvZxiʉjNXłB<BR>
 * GeometricActor ̃o<BR>
 *  _x,  _y,  _z  EEE AN^[̍W<BR>
 * _rx, _ry, _rz  EEE AN^[̎]px<BR>
 * ω܂BxNgAxAAԁAɂĊǗ삷邽߂ɍ쐬NXB<BR>
 * ʂ̊{IȈړA]͎͗ԂɔCāA<BR>
 * AN^[ŗL̓Ȉړ] processBehave() ɒڋLqBƂ݌vvzB<BR>
 * @version 1.00
 * @since 2008/08/20
 * @author Masatoshi Tsuge
 */
class VecDriver : public ActorDriver {

private:
    /** [r]͎Ԃ̏A(ړx̕⍲) */
    VecDriverMvAssistant* _pAsstMv;
    /** [r]͎Ԃ̏B(]ppx̕⍲) */
    VecDriverFaceAngAssistant* _pAsstFaceAng;
    /** [r]͎Ԃ̏C(ړppx̕⍲) */
    VecDriverMvAngAssistant* _pAsstMvAng;

public:
    /** [r]ΏۃAN^[ */
   // GeometricActor* const _pActor;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpActor
     */
    explicit VecDriver(GeometricActor* prm_pActor);

    /**
     * ͎Ԃ̏A(ړx̕⍲)擾 .
     * @return ͎Ԃ̏A
     */
    VecDriverMvAssistant* asstMv();

    /**
     * ͎Ԃ̏B(]ppx̕⍲)擾 .
     * @return ͎Ԃ̏B
     */
    VecDriverFaceAngAssistant* asstFaceAng();

    /**
     * ͎Ԃ̏C(ړppx̕⍲)擾 .
     * @return ͎Ԃ̏C
     */
    VecDriverMvAngAssistant* asstMvAng();

    void reset();

public: //_rx , _ry, _rz ֘A //////////////////////////////////////////////
    /** [r]ΏۃĽ(_rx, _ry, _rz)ւ̎Q */
    angle* _actor_face[3];
    /** [r/w]]p̊pxi]pɖt[Zpj */
    angvelo _angvelo_face[3];
    /** [r/w]]p̊px(ōl360,000) */
    angvelo _top_angvelo_face[3];
    /** [r/w]]p̊px(ōl-360,000) */
    angvelo _bottom_angvelo_face[3];
    /** [r/w]]p̊pxipxɖt[Zlj */
    angacce _angacce_face[3];
    /** [r/w]]p̊pxipxɖt[Zlj */
    angjerk _angjerk_face[3];
    /** [r/w]ڕW̎]pLtO */
    bool _is_targeting_face[3];
    /** [r/w]ڕW̎]p~@\LtO */
    bool _face_targeting_stop_flg[3];
    /** [r/w]ڕWƂL̎]p̕p(0`360,000) */
    angle _target_face[3];
    /** [r/w]ڕW̎]p~@\LɂȂ] */
    int _face_stop_allow_way[3]; //TURN_CLOCKWISE or TURN_COUNTERCLOCKWISE or TURN_BOTH
    /** [r/w]ڕW̎]p~@\LɂȂpxi]ʁj */
    angvelo _face_stop_allow_angvelo[3]; //̊px菬l̏ꍇ@\LƂz

public:
    void setMvAngByFaceAng() {
        setRzRyMvAng(_pActor->_rz, _pActor->_ry);
    }
    /**
     * Actor̖ڕW̎]p~@\L(ڕW̎]pݒ)<BR>
     * ɐݒ肳ꂽ]pɂȂƁA]ppxyю]ppx 0 ɂA]~܂B<BR>
     * ]ppx 0 ̏ꍇAN܂B{\bhsƌďɌςƂƂӖł͂܂B <BR>
     * ]ppx̐ݒ𕹂ĎsāAʓr]sȂĂB<BR>
     * Iɂ́AaddFaceAng(prm_axis, int) t[sdg݂łB<BR>
     * ڕW̉]pɓBȂ΁A̖ڕW̎]p~@\͉(̃tOAZbg)܂B<BR>
     * @param   prm_axis    ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param   prm_target    BڕW̉]p(0`360,000)
     * @param   prm_allow_way  ~i(TURN_CLOCKWISE/TURN_COUNTERCLOCKWISE/TURN_BOTH)
     * @param   prm_allow_angvelo ~@\LɂȂ]px
     */
    void setStopTargetFaceAng(axis prm_axis,
                              angle prm_target,
                              int prm_allow_way = TURN_BOTH,
                              angvelo prm_allow_angvelo = D360ANG);

    /**
     * Actor̖ڕW]~@\L(XYW̑ΏXYWŐݒ)<BR>
     * @param   prm_axis    ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param   prm_tx  ΏXW
     * @param   prm_ty  ΏYW
     * @param   prm_allow_way  ~@\LɂȂ]
     * @param   prm_allow_angvelo ~@\LɂȂ]px
     */
    void setStopTargetFaceAngTwd(axis prm_axis,
                                 coord prm_tx,
                                 coord prm_ty,
                                 int prm_allow_way = TURN_BOTH,
                                 angvelo prm_allow_angvelo = D360ANG);
    /**
     * ]p̊pxi]pɖt[Zljݒ .
     * @param prm_axis ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_angvelo px
     */
    void setFaceAngVelo(axis prm_axis, angvelo prm_angvelo);

    /**
     * ]p̊pxi]pɖt[Zljݒ .
     * @param prm_axis_x_angvelo X]̊px
     * @param prm_axis_z_angvelo Z]̊px
     * @param prm_axis_y_angvelo Y]̊px
     */
    void setRollPitchYawFaceAngVelo(angvelo prm_axis_x_angvelo,
                                    angvelo prm_axis_z_angvelo,
                                    angvelo prm_axis_y_angvelo);

    /**
     * Rolling(X]p)̊pxݒ .
     * setFaceAngVelo(AXIS_X, prm_angvelo); ƓB
     * @param prm_axis_x_angvelo X]̊px
     */
    inline void setRollFaceAngVelo(angvelo prm_axis_x_angvelo) {
        setFaceAngVelo(AXIS_X, prm_axis_x_angvelo);
    }
    inline void setRxFaceAngVelo(angvelo prm_axis_x_angvelo) {
        setFaceAngVelo(AXIS_X, prm_axis_x_angvelo);
    }

    /**
     * Pitching(Z]p)̊pxݒ .
     * setFaceAngVelo(AXIS_Z, prm_angvelo); ƓB
     * @param prm_axis_z_angvelo Z]̊px
     */
    inline void setPitchFaceAngVelo(angvelo prm_axis_z_angvelo) {
        setFaceAngVelo(AXIS_Z, prm_axis_z_angvelo);
    }
    inline void setRzFaceAngVelo(angvelo prm_axis_z_angvelo) {
        setFaceAngVelo(AXIS_Z, prm_axis_z_angvelo);
    }

    /**
     * Yawing(Y]p)̊pxݒ .
     * setFaceAngVelo(AXIS_Y, prm_angvelo); ƓB
     * @param prm_axis_y_angvelo Y]̊px
     */
    inline void setYawFaceAngVelo(angvelo prm_axis_y_angvelo) {
        setFaceAngVelo(AXIS_Y, prm_axis_y_angvelo);
    }
    inline void setRyFaceAngVelo(angvelo prm_axis_y_angvelo) {
        setFaceAngVelo(AXIS_Y, prm_axis_y_angvelo);
    }


    void forceFaceAngVeloRange(axis prm_axis,
                               angvelo prm_angvelo01,
                               angvelo prm_angvelo02);
    /**
     * ]p̊pxi]p̊pxɖt[Zljݒ .
     * @param prm_axis ]iAXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_angacce px
     */
    void setFaceAngAcce(axis prm_axis, angacce prm_angacce);

    /**
     * Rolling(X]p)̊pxݒ .
     * setFaceAngAcce(AXIS_X, prm_angacce); ƓB
     * @param prm_axis_x_angacce X]p̊px
     */
    inline void setRollFaceAngAcce(angvelo prm_axis_x_angacce) {
        setFaceAngAcce(AXIS_X, prm_axis_x_angacce);
    }
    inline void setRxFaceAngAcce(angvelo prm_axis_x_angacce) {
        setFaceAngAcce(AXIS_X, prm_axis_x_angacce);
    }

    /**
     * Pitching(Z]p)̊pxݒ .
     * setFaceAngAcce(AXIS_Z, prm_angacce); ƓB
     * @param prm_axis_z_angacce Z]p̊px
     */
    inline void setPitchFaceAngAcce(angvelo prm_axis_z_angacce) {
        setFaceAngAcce(AXIS_Z, prm_axis_z_angacce);
    }

    inline void setRzFaceAngAcce(angvelo prm_axis_z_angacce) {
        setFaceAngAcce(AXIS_Z, prm_axis_z_angacce);
    }

    /**
     * Yawing(Y]p)̊pxݒ .
     * setFaceAngAcce(AXIS_Y, prm_angacce); ƓB
     * @param prm_axis_y_angacce Y]p̊px
     */
    inline void setYawFaceAngAcce(angvelo prm_axis_y_angacce) {
        setFaceAngAcce(AXIS_Y, prm_axis_y_angacce);
    }

    inline void setRyFaceAngAcce(angvelo prm_axis_y_angacce) {
        setFaceAngAcce(AXIS_Y, prm_axis_y_angacce);
    }

    angle getFaceAngDistance(axis prm_axis, coord prm_tx, coord prm_ty, int prm_way);

    angle getFaceAngDistance(axis prm_axis, angle prm_target, int prm_way);

    ////////////////////////////////////////////////////MOVER

public: //_x, _y, _z ֘A //////////////////////////////////////////////
    /** [r]L̈ړpPʃxNg */
    float _vX, _vY, _vZ;
    /** [r/w]ړpZ]p */
    angle _rz_mv;
    /** [r/w]ړpY]p */
    angle _ry_mv;
    /** [r/w]ړx */
    velo _velo_mv;
    /** [r/w]ړx */
    velo _top_velo_mv;
    /** [r/w]ړx */
    velo _bottom_velo_mv;
    /** [r/w]ړx */
    acce _acc_mv;

    /** [r/w]ړpiZ]j̊pxiړpiZ]jɖt[Zpj */
    angvelo _angvelo_rz_mv;
    /** [r/w]ړpiZ]j̊px(ōl360,000) */
    angvelo _top_angvelo_rz_mv;
    /** [r/w]ړpiZ]j̊px(ōl-360,000) */
    angvelo _bottom_angvelo_rz_mv;
    /** [r/w]ړpiZ]j̊pxipxɖt[Zlj */
    angacce _angacce_rz_mv;
    /** [r/w]ړpiZ]j̊pxipxɖt[Zlj */
    angjerk _angjerk_rz_mv;
    /** [r/w]ڕẄړpiZ]jLtO */
    bool _is_targeting_rz_mv;
    /** [r/w]ڕẄړpiZ]j~@\LtO */
    bool _rz_mv_targeting_stop_flg;
    /** ڕWƂL̈ړpiZ]j̕p(0`360,000) */
    angle _target_rz_mv;
    /** [r/w]ڕẄړpiZ]j~@\LɂȂi] */
    int _rz_mv_stop_allow_way; //TURN_CLOCKWISE or TURN_COUNTERCLOCKWISE or TURN_BOTH
    /** [r/w]ڕẄړpiZ]j~@\LɂȂړppx */
    angvelo _rz_mv_stop_allow_angvelo;
    /** [r/w]O@\LtO */
    bool _relate_RzFaceAng_with_RzMvAng_flg;
    //true  : ړpiZ]jύXƁAɔp]p(Z)ɂݒ肳
    //false : ړpiZ]jZ]p͓Ɨ

    /** [r/w]ړpiY]j̊pxiړpiY]jɖt[Zpj */
    angvelo _angvelo_ry_mv;
    /** [r/w]ړpiY]j̊px(ōl360,000) */
    angvelo _top_angvelo_ry_mv;
    /** [r/w]ړpiY]j̊px(ōl-360,000) */
    angvelo _bottom_angvelo_ry_mv;
    /** [r/w]ړpiY]j̊pxipxɖt[Zlj */
    angacce _angacce_ry_mv;
    /** [r/w]ړpiY]j̊pxipxɖt[Zlj */
    angjerk _angjerk_ry_mv;
    /** [r/w]ڕẄړpiY]jLtO */
    bool _is_targeting_ry_mv;
    /** [r/w]ڕẄړpiY]j~@\LtO */
    bool _ry_mv_targeting_stop_flg;
    /** [r/w]ڕWƂL̈ړpiY]j̕p(0`360,000) */
    angle _target_ry_mv;
    /** [r/w]ڕẄړpiY]j~@\LɂȂi] */
    int _ry_mv_stop_allow_way; //TURN_CLOCKWISE or TURN_COUNTERCLOCKWISE or TURN_BOTH
    /** [r/w]ڕẄړpiY]j~@\LɂȂړppx */
    angvelo _ry_mv_stop_allow_angvelo;
    /** [r/w]O@\LtO */
    bool _relate_RyFaceAng_with_RyMvAng_flg;
    //true  : ړpiY]jύXƁAɔp]p(Y)ɂݒ肳
    //false : ړpiY]jY]p͓Ɨ

    bool _taget_face_alltime_flg;
    const GeometricActor* _taget_face_alltime_pActor;
    coord _taget_face_alltime_tx;
    coord _taget_face_alltime_ty;
    coord _taget_face_alltime_tz;
    angvelo _taget_face_alltime_angvelo;
    angacce _taget_face_alltime_angacce;
    int _taget_face_alltime_way;
    bool _taget_face_alltime_optimize_ang;

public:
    /**
     * ړxݒ .
     * @param   prm_velo_mv  ړx
     */
    void setMvVelo(velo prm_velo_mv);

    /**
     * ړxZ .
     * @param prm_velo_mv_Offset Zړx
     */
    void addMvVelo(velo prm_velo_mv_Offset);

    /**
     * ړx̏ݒ肵Aړx͈̔͂𐧌 .
     * ̈ړxPAړxQ̑召͂ǂł܂ȂBiŔ肷j
     * @param prm_velo_mv01  ړxP
     * @param prm_velo_mv02  ړxQ
     */
    void forceMvVeloRange(velo prm_velo_mv01, velo prm_velo_mv02);

    /**
     * ړx̏ݒ肵Aړx͈̔͂𐧌 .
     * ĺA-prm_velo_mv ` prm_velo_mv ͈̔͂ɂȂB
     * @param prm_velo_mv ړx
     */
    void forceMvVeloRange(velo prm_velo_mv);

    /**
     * ݂̈ړx擾 .
     * @return ݂̈ړx
     */
    inline velo getMvVelo() const {
        return _velo_mv;
    }

    /**
     * ړx擾 .
     * @return ړx
     */
    inline velo getMvVeloTop() const {
        return _top_velo_mv;
    }

    /**
     * ړx擾 .
     * @return ړx
     */
    inline velo getMvVeloBottom() const {
        return _bottom_velo_mv;
    }

    /**
     * ݂̈ړxړxɍXV .
     */
    inline void setMvVeloTop() {
        _velo_mv = _top_velo_mv;
    }

    /**
     * ݂̈ړxړxɍXV .
     */
    inline void setMvVeloBottom() {
        _velo_mv = _bottom_velo_mv;
    }

    /**
     * ړxݒ .
     * @param prm_acceMove ړx
     */
    void setMvAcce(acce prm_acceMove);

    /**
     * ړxAu~ړvɂݒ肷 .
     * <pre><code>
     *
     *    x(v)
     *     ^       a:xi_acc_mv ɐݒ肳j
     *     |       D:~܂ł̈ړij
     *     |      V0:_̑xi= ݂ _velo_mv gpj
     *   V0|      Te:~t[ i߂lj
     *     |_
     *     |  _
     *     |    _ Εӂ̌Xa
     *     |   D  _
     *     |        _
     *   --+----------_-----> (t)
     *   0 |          Te
     *
     * </code></pre>
     * }̂悤ȏԂz肵A̋(D)Ax(a)vZ _acc_mv ݒ肵ĂB<BR>
     * ~܂ł̃t[(Te)  (D) ɂω邽ߎwsB<BR>
     * @param prm_target_distance ~ړ(D)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setMvAcceToStop(coord prm_target_distance);


    /**
     * ]p̊pxAu~̋pvɂݒ肷 .
     * @param prm_axis ](AXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_target_distance ~̈ړpx(D)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setFaceAngAcceToStop(axis prm_axis, angle prm_target_distance);


    /**
     * ړxAuڕWBxvuړ(B܂łɔ₷)vɂݒ .
     * <pre><code>
     *
     *    x(v)
     *     ^        a:xi_acc_mv ɐݒ肳j
     *     |        D:ړij
     *     |       V0:_̑xi= ݂ _velo_mv gpj
     *     |       Vt:ڕWBxij
     *     |       Te:ڕWBxɒB̎ԁi߂lj
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (t)
     *   0 |        Te
     *
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁAړ(D)Ax(a)vZ _acc_mv ɐݒ肵ĂB<BR>
     * ڕWB܂ŕKvȃt[(Te) ̓p[^ɂω邽ߎwsB<BR>
     * ߑFsetMvAcceByD(0, D)  setMvAcceToStop(D) Ɠł
     * @param prm_target_distance  ڕWBxɒB܂łɔ₷(D)
     * @param prm_target_velo ڕWBx(Vt)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setMvAcceByD(coord prm_target_distance, velo prm_target_velo);

    /**
     * ]p̊pxup(B܂łɔ₷)vuڕWBpxvɂݒ .
     * @param prm_axis ](AXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_target_distance ڕWBpxɒB܂łɔ₷](D)
     * @param prm_target_angvelo ڕWBpx(Vt)
     * @return KvȎԃt[(Te)BQllɂǂB
     */
    frame setFaceAngAcceByD(axis prm_axis, angle prm_target_distance, angvelo prm_target_angvelo);

    /**
     * ړxAuڕWBxvu₷ԁvɂݒ .
     * <pre><code>
     *
     *    x(v)
     *     ^        a:xi_acc_mv ɐݒ肳)
     *     |        D:ړ i߂lj
     *     |       V0:_̑xi= ݂ _velo_mv gpj
     *     |       Vt:ڕWBxij
     *     |       Te:ڕWBxɒB̎ԁij
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (tt[)
     *   0 |        Te
     *
     *    a = (Vt-V0) / Te
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁA̓B(Te) Ax(a)vZݒ肵ĂB<BR>
     * ړ(D)́Ap[^ɂω邽ߎwsB<BR>
     * @param prm_target_frames ₷(Te)
     * @param prm_target_velo   ڕWBx(Vt)
     * @return ړ(D)
     */
    coord setMvAcceByT(frame prm_target_frames, velo prm_target_velo);

    /**
     * ]p̊pxuڕWBpxvu₷ԁvɂݒ .
     * @param prm_axis ](AXIS_X / AXIS_Y / AXIS_Z)
     * @param prm_target_frames  ₷(Te)
     * @param prm_target_angvelo ڕWBx(Vt)
     * @return ړp(D)
     */
    angle setFaceAngAcceByT(axis prm_axis, frame prm_target_frames, angvelo prm_target_angvelo);

    /**
     * Actor̈ړpiZ]jݒB<BR>
     * Z̈ړpiZ]j͈͊Oi0`360,000 ȊOj̒lɂȂĂA 0`360,000 ͈͓̔̒lɍČvZ܂B<BR>
     * O@\L(_relate_RzFaceAng_with_RzMvAng_flg)̏ꍇA<BR>
     * ActořړpiZ]jƓ悤 setStopTargetFaceAng(int) s܂B<BR>
     *
     * @param   prm_ang ړpiZ]j(0`360,000)
     */
    void setRzMvAng(angle prm_ang);

    /**
     * ݂ Actor ̈ړpiZ]j։ZiŌZjB<BR>
     *
     * ɓn̂́AړpiZ]j̑łBActor̈ړpiZ]ji_rz_mvj𑊑Ύwł郁\bhłB<BR>
     * Z̈ړpiZ]j͈͊Oi0`360,000 ȊOj̒lɂȂĂAŏIIɂ setRzMvAng(int) Ăяo܂̂<BR>
     *  0`360,000 ͈͓̔̒lɍĐݒ肳܂B<BR>
     * łZiZjړpiZ]j́AZړx̏Ɖ̊Ԃ͈̔͂Ɍ܂B<BR>
     * ܂A̗LȔ͈͈͂ȉ̒ʂƂȂ܂B<BR>
     *
     *   _bottom_angvelo_rz_mv  ̓p  _top_angvelo_rz_mv  łB<BR>
     *
     * ͈͊Ö̈ړpiZ]jw肵ꍇ́A߂͈͓̔̒lɋIɗ}A̒lZ܂B<BR>
     * ܂AO@\L(_relate_RzFaceAng_with_RzMvAng_flg)̏ꍇA<BR>
     * Z̈ړpiZ]j̒lAZ̖ڕW̎]pƂĐݒ肳܂BiőOɐݒ肳܂BAOAO0̃L̏ꍇłǁGj<BR>
     *
     * y⑫Fz<BR>
     * {\bht[s邱ƂXYʂ̉~^\ɂȂ܂B<BR>
     * ̈ړpiZ]jA 0 ɁA߂lZꍇ́Aɂ₩ȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * tɁÄړpiZ]jA0 A藣ꂽlZꍇ́AspIȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * ftHgZړx̏Ɖi_bottom_angvelo_rz_mvA_top_angvelo_rz_mv)   -360000 , 360000<BR>
     * ƂȂĂ܂B͏uɁi1t[ŁjǂȈړpiZ]jɂς邱ƂӖ܂B<BR>
     *
     * @param   prm_ang ړpiZ]j(͈́F_bottom_angvelo_rz_mv ` _top_angvelo_rz_mv)
     */
    void addRzMvAng(angle prm_ang);

    angle getRzMvAng() {
        return _rz_mv;
    }
    /**
     * Actor̖ڕẄړpiZ]j~@\L(ڕẄړpiZ]jݒ)<BR>
     * ɐݒ肳ꂽړpiZ]jɂȂ܂ŁAړpiZ]jZ(Z)𖈃t[s܂B<BR>
     * ZŹAړpiZ]j̊pxi_angvelo_rz_mvj̐Ō肳܂B<BR>
     * <B>ړpiZ]j̊px 0 Ȃ΁AN܂B</B>삳ɂ́ApxKvłB<BR>
     * Iɂ́AaddRzMvAng(int) t[sdg݂łB(this->behave()Ŏs)<BR>
     * ڕẄړpiZ]jɓBȂ΁A̖ڕẄړpiZ]j~@\͉܂B<BR>
     *
     * @param   prm_target_rz_mv BڕẄړpiZ]j(-360,000`360,000)
     * @param   prm_allow_way  ~@\LɂȂi]
     * @param   prm_allow_angvelo ~@\LɂȂړppx(ȏ̊px̏ꍇ͒~܂)
     */
    void setStopTargetRzMvAng(angle prm_target_rz_mv,
                              int prm_allow_way = TURN_BOTH,
                              angvelo prm_allow_angvelo = D360ANG);

    void setRzMvAngVelo(angvelo prm_angvelo_rz_mv);

    void forceRzMvAngVeloRange(angvelo prm_angvelo_rz_mv01, angvelo prm_angvelo_rz_mv02);

    void setRzMvAngAcce(angacce prm_angacce_rz_mv);

    angle getRzMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way);

    /**
     * g̈ړpZ]p( _rz_mv )ƁA^[Qbg̉]pƂ̍擾.
     * TURN_COUNTERCLOCKWISE EEE]ōيp擾A̒lŕԂB
     * TURN_CLOCKWISE        EEE]Eōيp擾A̒lɕԂB
     * TURN_CLOSE_TO         EEE^[Qbg̉]pƋ߂̉]Ŏ擾A͕̒lɂȂB
     * TURN_ANTICLOSE_TO     EEE^[Qbg̉]pƋ̉]Ŏ擾A͕̒lɂȂB
     * @param prm_target_rz_mv ^[Qbgp̒l
     * @param prm_way TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @return
     */
    angle getRzMvAngDistance(angle prm_target_rz_mv, int prm_way);

    /**
     * Actor̈ړpiY]jݒB<BR>
     * Z̈ړpiY]j͈͊Oi0`360,000 ȊOj̒lɂȂĂA 0`360,000 ͈͓̔̒lɍČvZ܂B<BR>
     * O@\L(_relate_RyFaceAng_with_RyMvAng_flg)̏ꍇA<BR>
     * ActořړpiY]jƓ悤 setStopTargetFaceAng(int) s܂B<BR>
     * @param prm_ang ړpiY]j(0`360,000)
     */
    void setRyMvAng(angle prm_ang);

    /**
     * ݂ Actor ̈ړpiY]j։ZiŌZjB<BR>
     *
     * ɓn̂́AړpiY]j̑łBActor̈ړpiY]ji_ry_mvj𑊑Ύwł郁\bhłB<BR>
     * Z̈ړpiY]j͈͊Oi0`360,000 ȊOj̒lɂȂĂAŏIIɂ setRyMvAng(int) Ăяo܂̂<BR>
     *  0`360,000 ͈͓̔̒lɍĐݒ肳܂B<BR>
     * łZiZjړpiY]j́AYړx̏Ɖ̊Ԃ͈̔͂Ɍ܂B<BR>
     * ܂A̗LȔ͈͈͂ȉ̒ʂƂȂ܂B<BR>
     *
     *   _bottom_angvelo_ry_mv  ̓p  _top_angvelo_ry_mv  łB<BR>
     *
     * ͈͊Ö̈ړpiY]jw肵ꍇ́A߂͈͓̔̒lɋIɗ}A̒lZ܂B<BR>
     * ܂AO@\L(_relate_RyFaceAng_with_RyMvAng_flg)̏ꍇA<BR>
     * Z̈ړpiY]j̒lAZ̖ڕW̎]pƂĐݒ肳܂BiőOɐݒ肳܂BAOAO0̃L̏ꍇłǁGj<BR>
     *
     * y⑫Fz<BR>
     * {\bht[s邱ƂXZʂ̉~^\ɂȂ܂B<BR>
     * ̈ړpiY]jA 0 ɁA߂lZꍇ́Aɂ₩ȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * tɁÄړpiY]jA0 A藣ꂽlZꍇ́AspIȃJ[u`Ȃ]邱ƂӖ܂B<BR>
     * ftHgYړx̏Ɖi_bottom_angvelo_ry_mvA_top_angvelo_ry_mv) <BR>
     *
     *  -360,000  ̓p  360,000<BR>
     *
     * ƂȂĂ܂B͏uɁi1t[ŁjǂȈړpiY]jɂς邱ƂӖ܂B<BR>
     *
     * @param   prm_ang ړpiY]j(͈́F_bottom_angvelo_ry_mv ` _top_angvelo_ry_mv)
     */
    void addRyMvAng(angle prm_ang);

    angle getRyMvAng() {
        return _ry_mv;
    }

    /**
     * Actor̖ڕWY]ړp̎~@\L .
     * ڕẄړpiY]jݒ肷B<BR>
     * ɐݒ肳ꂽړpiY]jɂȂ܂ŁAړpiY]jZ(Z)𖈃t[s܂B<BR>
     * ZŹAړpiY]j̊pxi_angvelo_ry_mvj̐Ō肳܂B<BR>
     * <B>ړpiY]j̊px 0 Ȃ΁AN܂B</B>삳ɂ́ApxKvłB<BR>
     * Iɂ́AaddRyMvAng(int) t[sdg݂łB(this->behave()Ŏs)<BR>
     * ڕẄړpiY]jɓBȂ΁A̖ڕẄړpiY]j~@\͉܂B<BR>
     *
     * @param   prm_target_ry_mv BڕẄړpiY]j(-360,000`360,000)
     * @param   prm_allow_way  ~@\LɂȂi]
     * @param   prm_allow_angvelo ~@\LɂȂړppx(ȏ̊px̏ꍇ͒~܂)
     */
    void setStopTargetRyMvAng(angle prm_target_ry_mv,
                              int prm_allow_way = TURN_BOTH,
                              angvelo prm_allow_angvelo = D360ANG);

    void setRyMvAngVelo(angvelo prm_angvelo_ry_mv);

    void forceRyMvAngVeloRange(angvelo prm_angvelo_ry_mv01, angvelo prm_angvelo_ry_mv02);

    void setRyMvAngAcce(angacce prm_angacce_ry_mv);

    angle getRyMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way);

    angle getRyMvAngDistance(angle prm_target_ry_mv, int prm_way);


    void forceRzRyMvAngVeloRange(angvelo prm_angvelo_rzry_mv01, angvelo prm_angvelo_rzry_mv02);

    void setRzRyMvAngVelo(angvelo prm_angvelo_rz_mv, angvelo prm_angvelo_ry_mv);

    void setRzRyMvAngAcce(angacce prm_angacce_rz_mv, angacce prm_angacce_ry_mv);


    /**
     * g̈ړpZY]p(_rz_mv, _ry_mv)ƁA^[Qbg̉]pƂ̍œKȍ擾 .
     * Ӗg RzRy ܂ł̋oA<BR>
     * BAȌȂ RzRy ̑gݍ킹̗pB<BR>
     * (ӁFɒnY]邽߁AŏAO͕KŒZɂ炸)<BR>
     * ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     * ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     * vȂƂꍇ́AZYʂɋ߂ĉB<BR>
     * @param prm_target_rz
     * @param prm_target_ry
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param out_d_rz
     * @param out_d_ry
     */
    void getRzRyMvAngDistanceTwd(angle prm_target_rz, angle prm_target_ry,int prm_way,
                                 angle& out_d_rz, angle& out_d_ry);

    /**
     * g̎]pZY]p(_face[AXIS_Z], _face[AXIS_Y])ƁA^[Qbg̉]pƂ̍œKȍ擾 .
     * Ӗg RzRy ܂ł̋oA<BR>
     * BAȌȂ RzRy ̑gݍ킹̗pB<BR>
     * (ӁFɒnY]邽߁AŏAO͕KŒZɂ炸)<BR>
     * ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     * ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     * vȂƂꍇ́AZYʂɋ߂ĉB<BR>
     * @param prm_target_rz
     * @param prm_target_ry
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param out_d_rz
     * @param out_d_ry
     */
    void getRzRyFaceAngDistanceTwd(angle prm_target_rz, angle prm_target_ry,int prm_way,
                                   angle& out_d_rz, angle& out_d_ry);
    /**
     * ړ(RzRy)ݒ .
     * @param prm_rz
     * @param prm_ry
     */
    void setRzRyMvAng(angle prm_rz, angle prm_ry);

    /**
     * ړ(RzRy)xNgɂݒ .
     * @param prm_vx xNgXvf
     * @param prm_vy xNgYvf
     * @param prm_vz xNgZvf
     * @param prm_opt œKtOitrue:RzRy̍ŏɂȂ悤ɍœK^false:ʂ̃Ro[g)
     */
    void setRzRyMvAng(dxcoord prm_vx, dxcoord prm_vy, dxcoord prm_vz, bool prm_opt = false);

    /**
     *  ړ(RzRy)ARyRzŐݒB
     * @param prm_ry
     * @param prm_rz
     */
    void setRzRyMvAng_by_RyRz(angle prm_ry, angle prm_rz);

    /**
     * ڕWW_Wwňړp(RzRy)ݒB.
     * xNgKōsȂB
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     */
    void setMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz);

    /**
     * ڕWW_Wwňړp(RzRy)ݒB.
     * As(ZW)ČvZsB
     * xNgKōsȂB
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     */
    inline void setMvAngTwd(coord prm_tx, coord prm_ty) {
        setMvAngTwd(prm_tx, prm_ty, _pActor->_z);
    }

    /**
     * ڕWW_wΏۃAN^[̍Wwňړp(RzRy)ݒB.
     * xNgKōsȂB
     * @param prm_pActor_target ڕWΏۃAN^[
     */
    inline void setMvAngTwd(const GeometricActor* prm_pActor_target) {
        setMvAngTwd(
            prm_pActor_target->_x,
            prm_pActor_target->_y,
            prm_pActor_target->_z
        );
    }

    inline void setMvAngTwd(const GeoElem* prm_pGeoElem) {
        setMvAngTwd(
            prm_pGeoElem->x,
            prm_pGeoElem->y,
            prm_pGeoElem->z
        );
    }

    void reverseMvAng();

    void setStopTargetMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz);

    void setStopTargetMvAngTwd(const GeometricActor* prm_pActor_target);

    /**
     * ]p(ZY)ڕWɃ^[QbgV[NGXs .
     * @param prm_rz_target ڕW]p(Z)
     * @param prm_ry_target ڕW]p(Y)
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    void turnRzRyFaceAngTo(angle prm_rz_target, angle prm_ry_target,
                           angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                           int prm_way = TURN_CLOSE_TO,
                           bool prm_optimize_ang = false);

    /**
     * ]pڕWɃ^[QbgV[NGXs .
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    void turnFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                        angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                        int prm_way = TURN_CLOSE_TO,
                        bool prm_optimize_ang = false);


    /**
     * ]p(ZY)ڕWɃ^[Qbg̕悤ȃV[NGXs
     * @param prm_pActor_target ڕWIuWFNg
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    inline void turnFaceAngTwd(const GeometricActor* prm_pActor_target,
                               angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                               int prm_way = TURN_CLOSE_TO,
                               bool prm_optimize_ang = false) {
        turnFaceAngTwd(
                prm_pActor_target->_x,
                prm_pActor_target->_y,
                prm_pActor_target->_z,
                prm_angvelo,
                prm_angacce,
                prm_way,
                prm_optimize_ang
        );
    }
    inline void turnFaceAngTwd(const GeoElem* prm_pGeoElem,
                               angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                               int prm_way = TURN_CLOSE_TO,
                               bool prm_optimize_ang = false) {
        turnFaceAngTwd(
                prm_pGeoElem->x,
                prm_pGeoElem->y,
                prm_pGeoElem->z,
                prm_angvelo,
                prm_angacce,
                prm_way,
                prm_optimize_ang
        );
    }

    /**
     * ]pڕW̊p]V[NGXs .
     * @param prm_axis   (AXIS_X or AXIS_Y or AXIS_Z)
     * @param prm_distance piFTURN_COUNTERCLOCKWISEAFTURN_CLOCKWISEj
     * @param prm_angvelo pxiprm_distance̐Ɉˑj
     * @param prm_angacce pxiprm_distance̐Ɉˑj
     */
    void turnFaceAng(axis prm_axis,
                     angle prm_distance,
                     angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0);

    /**
     * ]p(Z)ڕWɃ^[QbgV[NGXs .
     * @param prm_rz_target ڕW]p(Z)
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRzFaceAngTo(angle prm_rz_target,
                         angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                         int prm_way = TURN_CLOSE_TO);

    /**
     * ]p(Y)ڕWɃ^[QbgV[NGXs .
     * @param prm_ry_target ڕW]p(Y)
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRyFaceAngTo(angle prm_ry_target,
                         angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                         int prm_way = TURN_CLOSE_TO);

    /**
     * ]p(X)ڕWɃ^[QbgV[NGXs .
     * @param prm_rx_target ڕW]p(X)
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void rollFaceAngTo(angle prm_rx_target,
                       angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                       int prm_way = TURN_CLOSE_TO);

    /**
     * ړpڕWɃ^[QbgV[NGXs .
     * @param prm_rz_target ڕWړp(Z)
     * @param prm_ry_target ڕWړp(Y)
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    void turnRzRyMvAngTo(angle prm_rz_target, angle prm_ry_target,
                         angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                         int prm_way = TURN_CLOSE_TO,
                         bool prm_optimize_ang = false);

    /**
     * ړpڕWɃ^[QbgV[NGXs .
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    void turnMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                      angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                      int prm_way = TURN_CLOSE_TO,
                      bool prm_optimize_ang = false);

    /**
     * ړpɖڕWɃ^[QbgV[NGXs .
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    void keepOnTurningFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                 angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                                 int prm_way = TURN_CLOSE_TO,
                                 bool prm_optimize_ang = false) {
        turnFaceAngTwd(prm_tx, prm_ty, prm_tz,
                       prm_angvelo,  prm_angacce,
                       prm_way, prm_optimize_ang );
        _taget_face_alltime_flg = true;
        _taget_face_alltime_pActor = nullptr;
        _taget_face_alltime_tx = prm_tx;
        _taget_face_alltime_ty = prm_ty;
        _taget_face_alltime_tz = prm_tz;
        _taget_face_alltime_angvelo = prm_angvelo;
        _taget_face_alltime_angacce = prm_angacce;
        _taget_face_alltime_way = prm_way;
        _taget_face_alltime_optimize_ang = prm_optimize_ang;
    }

    /**
     * ړpɖڕWɃ^[QbgV[NGXs .
     * @param prm_pActor_target ڕWIuWFNg
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    void keepOnTurningFaceAngTwd(const GeometricActor* prm_pActor_target,
                                 angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                                 int prm_way = TURN_CLOSE_TO,
                                 bool prm_optimize_ang = false) {
        keepOnTurningFaceAngTwd(
                prm_pActor_target->_x,
                prm_pActor_target->_y,
                prm_pActor_target->_z,
                prm_angvelo, prm_angacce,
                prm_way, prm_optimize_ang);
        _taget_face_alltime_pActor = prm_pActor_target;
    }

    /**
     * ړpڕWɃ^[Qbg̍WɂV[NGXs
     * @param prm_pActor_target ڕWIuWFNg
     * @param prm_angvelo ^[QbeBOsɉZpxA܂pxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO<BR>
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_rz_target, prm_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _rz_mv, _ry_mv <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_rz_target, prm_ry_target ̂܂܃^[Q[gƂB<BR>
     */
    inline void turnMvAngTwd(const GeometricActor* prm_pActor_target,
                             angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                             int prm_way = TURN_CLOSE_TO,
                             bool prm_optimize_ang = false) {
        turnMvAngTwd(
                prm_pActor_target->_x,
                prm_pActor_target->_y,
                prm_pActor_target->_z,
                prm_angvelo,
                prm_angacce,
                prm_way,
                prm_optimize_ang
        );
    }

    inline void turnMvAngTwd(const GeoElem* prm_pGeoElem,
                             angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                             int prm_way = TURN_CLOSE_TO,
                             bool prm_optimize_ang = false) {
        turnMvAngTwd(
                prm_pGeoElem->x,
                prm_pGeoElem->y,
                prm_pGeoElem->z,
                prm_angvelo,
                prm_angacce,
                prm_way,
                prm_optimize_ang
        );
    }

    /**
     * ړp(Z)ڕW̊p]V[NGXs .
     * @param prm_rz_distance  ړp̉]p(Z)
     * @param prm_angvelo ^[Qbgֈړp]ړɓKppxiprm_distance̐Ɉˑj
     * @param prm_angacce pxiprm_distance̐Ɉˑj
     */
    void turnRzMvAng(angle prm_rz_distance,
                     angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0);

    /**
     * ړp(Y)ڕW̊p]V[NGXs .
     * @param prm_ry_distance  ړp̉]p(Y)
     * @param prm_angvelo ^[Qbgֈړp]ړɓKppxiprm_distance̐Ɉˑj
     * @param prm_angacce pxiprm_distance̐Ɉˑj
     */
    void turnRyMvAng(angle prm_ry_distance,
                     angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0);

    /**
     * ړp(Z)ڕWɃ^[QbgV[NGXs .
     * @param prm_rz_target ڕWړp(Z)
     * @param prm_angvelo ^[Qbgֈړp]ړɓKppxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRzMvAngTo(angle prm_rz_target,
                       angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                       int prm_way = TURN_CLOSE_TO);

    /**
     * ړp(Y)ڕWɃ^[QbgV[NGXs .
     * @param prm_ry_target ڕWړp(Y)
     * @param prm_angvelo ^[Qbgֈړp]ړɓKpڕWړp]ړpxi̊pxŎwBŐj
     * @param prm_angacce pxi̊pxŎwBŐj
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     */
    void turnRyMvAngTo(angle prm_ry_target,
                       angvelo prm_angvelo = D360ANG, angacce prm_angacce = 0,
                       int prm_way = TURN_CLOSE_TO);

    void stopTurningMvAng();

    void stopTurningFaceAng();

    /**
     * ڕW]pɃ^[QbgV[NGXs .
     * turn**FaceAng**() sA]̖ڕWړpɉ]̏ꍇ trueB
     * @return true:s/false:słȂ
     */
    bool isTurningFaceAng() const;

    /**
     * ڕWړpɃ^[QbgV[NGXs .
     * turn**MvAng**() sA]̖ڕWړpɉ]̏ꍇ trueB
     * @return true:s/false:słȂ
     */
    bool isTurningMvAng() const;

    /**
     * ړpɔĎ]pXViZ]ƁAY]j .
     * true ݒ肷ƁAIɈړp̕ɌςB<BR>
     * false ݒ肷ƁAړpƌ͓ƗAftHg͂B<BR>
     * @param prm_b true:ړpɔĎ]pXV/false:ړpƎ]p͓Ɨ
     */
    void linkFaceAngByMvAng(bool prm_b) {
        _relate_RyFaceAng_with_RyMvAng_flg = prm_b;
        _relate_RzFaceAng_with_RzMvAng_flg = prm_b;
        if (prm_b) {
            _pActor->_rz = _rz_mv;
            _pActor->_ry = _ry_mv;
        }
    }

    /**
     * ړpɔĎ]pXViZ]̂݁j .
     * true ݒ肷ƁAZ]̂ݎIɈړp̕ɌςB<BR>
     * false ݒ肷ƁAړpƌ͓ƗAftHg͂B<BR>
     * @param prm_b true:Z]ɂĈړpɔĎ]pXV/false:ړpƎ]p͓Ɨ
     */
    void linkRzFaceAngByMvAng(bool prm_b) {
        _relate_RzFaceAng_with_RzMvAng_flg = prm_b;
        if (prm_b) {
            _pActor->_rz = _rz_mv;
        }
    }

    /**
     * ړpɔĎ]pXViY]̂݁j .
     * true ݒ肷ƁAY]̂ݎIɈړp̕ɌςB<BR>
     * false ݒ肷ƁAړpƌ͓ƗAftHg͂B<BR>
     * @param prm_b true:Y]ɂĈړpɔĎ]pXV/false:ړpƎ]p͓Ɨ
     */
    void linkRyFaceAngByMvAng(bool prm_b) {
        _relate_RyFaceAng_with_RyMvAng_flg = prm_b;
        if (prm_b) {
            _pActor->_ry = _ry_mv;
        }
    }

    /**
     * ͎Ԃ̎dp .
     *  VecDriver IuWFNgԂgɈp .
     * @param prm_pVecDriver p
     */
    void takeoverMvFrom(VecDriver* const prm_pVecDriver);

    /**
     * ړ~܂B
     */
    void stopMv();

    /**
     * ͎ԂU镑 .
     * ͎ԋ@\𗘗pꍇ́Ã\bh𖈃t[ĂяosĂB<BR>
     * tɗ͎ԂKvƂȂꍇ́Ã\bhĂяoȂƂŁAptH[}Xɉe^܂B<BR>
     */
    virtual void behave();

    virtual ~VecDriver();
};

}
#endif /*GGAF_DX_VECDRIVER_H_*/

