#ifndef GGAF_DX_PUPPETEER_H_
#define GGAF_DX_PUPPETEER_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/core/util/AccelerationValue.hpp"
#include <vector>
#include <d3dx9.h>
#include <d3dx9anim.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

namespace GgafDx {

/**
 * pyb^[(l`) .
 * pyb^[́AŒ݂邳ꂽpybg(BoneAniMeshActor)𑀂_őA<BR>
 * lXȌ|(Aj[V)邱Ƃol(IuWFNg)łB<BR>
 * cOȂApybg͓2ނ̌|܂ł鎖o܂B<BR>
 * ŔApyb^[̘rQ{łBȂłˁB<BR>
 * gāApybg܂ĂB<BR>
 * <BR>
 * Iɂ́ÃNX́AID3DXAnimationController ̃bp[NXłB<BR>
 * őgbN 2 łB
 * ȓ́A<BR>
 * @ Aj[VuXs[hvyсud݁v́A{Aj[VgbNlA<BR>
 *    AAnimationSet ɕRtĊǗB<BR>
 *    Aj[Vؑ֎ɁAAj[VɕRÂuXs[hvyсud݁v
 *    gbNɐݒ肷悤ɂĂB<BR>
 * A tĐA[v̋@\<BR>
 * łB
 * @version 1.00
 * @since 2011/02/22
 * @author Masatoshi Tsuge
 */
class Puppeteer : public GgafCore::Object {
private:
    /** [r]pybg̃Aj[VRg[[ */
    ID3DXAnimationController* _pAc;
    /**
     * |([V) .
     */
    class Performance {
    public:
        /** Aj[VZbg */
        LPD3DXANIMATIONSET _pAnimationSet;
        UINT _animation_set_index;
        double _period;
        /** [J^C */
        GgafCore::AccelerationValue<double> _local_time;
        /** ڕW[v(1.5Ȃǂ̎w\) */
        double _target_loop;

        double _loop_count;
        GgafCore::AccelerationValue<double> _weight;
        /** [v@ */
        PuppeteerMethod _method;
    public:
        Performance();
        void setAnimationSet(LPD3DXANIMATIONSET prm_pAnimationSet, UINT prm_animation_set_index);
        virtual ~Performance();
    };

    /** pyb^[̑_ */
    struct Stick {
        /** _ԍ(Aj[VgbNԍ) */
        UINT _tno;
        /** [VuhL */
        BOOL _enable_motion_blend;
        /** pyb^[̑_̐ɂĂ鎝l^(|) */
        Performance* _pPerformance;
    };

public:
    /** [r/w]pybg̎l^(|) */
    Performance* _paPerformances;
    /** [r]pybg̎l^(|)̐AAnimationSet ̐ */
    UINT _num_perform;
    /** [r/w]pAEp̃pyb^[̑_(Aj[VgbN)  [0]:p^[1]:Ep  */
    Stick _aStick[2];
    /** [r]݂̃gbNɐݒ肳ĂAj[VZbgBݒ̏ꍇnullptrB[0]:gbN0^[1]gbN1 */
    ID3DXAnimationSet* _paAs[2];

    /** Aj[VRg[̃ftHĝPt[̃Aj[Vt[ */
    double _ani_time_delta;
    double _ani_time_period;
    double _speed_rate;
public:
    /**
     * RXgN^ .
     * @param prm_pPuppet 
     * @return
     */
    explicit Puppeteer(ID3DXAnimationController* prm_pAc_cloned);

    /**
     * vCĂ炤ipybgj .
     * @param prm_handed vCpyb^[̑_ (LEFT_HAND or RIGHT_HAND)
     * @param prm_performance_no vC|ԍiAj[VRg[[̃Aj[VZbgIDɈvj
     * @param prm_loopnum ̌|̃[v 0.0 ` (P񔼃[v1.5Ƃ悤ɂw\B̐w(-1)Ŗ[vAj[V)
     * @param prm_target_speed ڕWXs[h ʏ -1.0 ` 0.0 ` 1.0 (1.0ŒʏXs[hAȏ\B̒lwŋtAj[VɂȂ)
     * @param prm_shift_speed_frames ڕWXs[hւ̓Bt[BXɃXs[hω܂B(0 wő prm_target_speed ɂȂ)
     * @param prm_target_weight ڕWd݁iAj[Vj 0.0 ` 1.0 (̐s)
     * @param prm_shift_weight_frames ڕWdւݓBt[AXɏd݂ωB(0 wő prm_target_weight ɂȂ)
     * @param prm_method
     */


    /**
     *vCĂ炤ipybgj .
     * @param prm_handed vCpyb^[̑_ (LEFT_HAND or RIGHT_HAND)
     * @param prm_performance_no vC|ԍiAj[VRg[[̃Aj[VZbgIDɈvj
     * @param prm_one_loop_frames ̌|̂P[vɔ₷t[
     * @param prm_loopnum ̌|̃[v 0.0 ` (P񔼃[v1.5Ƃ悤ɂw\B̐w(-1)Ŗ[vAj[V)
     * @param prm_method
     */
    void play(PuppeteerStick prm_handed,
              UINT prm_performance_no,
              double prm_loopnum,
              PuppeteerMethod prm_method = PLAY_LOOPING
    );

    /**
     * pyb^[̉E|ƍ| .
     */
    void exchangPerformance();

    void stop();

    virtual void behave();
    virtual void updateAnimationTrack();

    virtual int getPerformanceNum() {
        return _num_perform;
    }

    void setSpeedRate(double prm_speed_rate) {
        _speed_rate = prm_speed_rate;
    }
    virtual ~Puppeteer();

};

}
#endif /*GGAF_DX_PUPPETEER_H_*/
