#ifndef GGAF_DX_CHECKER_H_
#define GGAF_DX_CHECKER_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"

namespace GgafDx {

/**
 * `FbNɊւFXȋ@\NX .
 * iGeometryCheckerj
 * @version 1.00
 * @since 2008/08/20
 * @author Masatoshi Tsuge
 */
class Checker : public GgafCore::Object {

public:
    /** ΏۃAN^[ */
    GeometricActor* const _pActor;
    /** 蔻̈ */
    CollisionArea* _pCollisionArea;
public:
    /**
     * RXgN^<BR>
     * @param	prm_pActor	KpActor
     */
    explicit Checker(GeometricActor* prm_pActor);

    /**
     * 蔻̈XVÄ̗c[ɓo^ .
     */
    virtual void updateHitArea() = 0;

    /**
     * 蔻̈쐬i蔻̈vf̔z쐬j .
     * ŗ̈̔z𐶐܂B
     * ŏɕKsĂB
     * @param prm_colli_part_num 蔻̈̓蔻̈vf(1`n)
     */
    virtual void createCollisionArea(int prm_colli_part_num);

    /**
     * qbgĂ邩ǂ
     * @param prm_pOtherChecker ̃`FbJ[
     * @return
     */
    virtual bool isHit(const Checker* const prm_pOtherChecker) = 0;

    virtual GeometricActor* getTargetActor() {
        if (_pActor == nullptr) {
            _TRACE_(FUNC_NAME<<" nullptrł邪悢̂I");
        }
        return _pActor;
    }

    inline CollisionArea* getArea() {
        return _pCollisionArea;
    }

    /**
     * 蔻̗̈vfLɂB
     * ftHg͗LԂɂȂĂ܂B
     * @param prm_index Lɂ铖蔻̗̈vfԍ
     */
    virtual void enable(int prm_index);

    /**
     * 蔻̗̈vf𖳌ɂB
     * @param prm_index ɂ铖蔻̗̈vfԍ
     */
    virtual void disable(int prm_index);

    /**
     * 蔻̗̈vfLׂB
     * @param prm_index ׂ蔻̗̈vfԍ
     * @return true:L / false:
     */
    virtual bool isEnable(int prm_index);

    virtual ~Checker();
};

}
#endif /*GGAF_DX_CHECKER_H_*/

