#ifndef GGAF_DX_ICUBEMAPACTOR_H_
#define GGAF_DX_ICUBEMAPACTOR_H_
#include "GgafDxCommonHeader.h"

#include <d3d9.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

namespace GgafDx {

/**
 * L[u}bvIuWFNgpC^[tFCXB
 * @version 1.00
 * @since 2011/05/27
 * @author Masatoshi Tsuge
 */
class ICubeMapActor {

public:
    /** }bveNX` */
    TextureConnection* _pCubeMapTextureConnection;
    /** }bveNX`f肱ݗ */
    float _reflectance;

    const char* _cubemap_tex;

public:
    ICubeMapActor();

    /**
     * }bsOeNX`Ɖf荞݋w肷B .
     * RXgN^ȊOŎsƁAeNX`r̊֌WŏxłB
     * @param prm_cubemap_tex eNX`t@C
     * @param prm_reflectance }bveNX`̉f荞݋(0.0`1.0)B
     *                        prm_cubemap_tex̐FɈ̗悶Añ}eAFɉZ܂B
     *                        0.0:f荞ݖA0.3:嗝΂炢A1.0:
     */
    void setCubeMap(const char* prm_cubemap_tex, float prm_reflectance);

    /**
     * }bsOeNX`w肷B .
     * RXgN^ȊOŎsƁAeNX`r̊֌WŏxłB
     * @param prm_cubemap_tex }bbveNX`t@C
     */
    void setCubeMapTexture(const char* prm_cubemap_tex);

    /**
     * }bv̉f荞݋ .
     * @param prm_reflectance }bveNX`̉f荞݋(0.0`1.0)B
     *                        prm_cubemap_tex̐FɈ̗悶Añ}eAFɉZ܂B
     *                        0.0:f荞ݖA0.3:嗝΂炢A1.0:
     */
    void setCubeMapReflectance(float prm_reflectance);

    IDirect3DBaseTexture9* getCubeMapTexture();

    float getCubeMapReflectance() {
        return _reflectance;
    }

    virtual ~ICubeMapActor(); //fXgN^

};

}
#endif /*GGAF_DX_ICUBEMAPACTOR_H_*/
