#ifndef GGAF_DX_SPRITEACTORD_H_
#define GGAF_DX_SPRITEACTORD_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/actor/FigureActor.h"

namespace GgafDx {

/**
 * XvCgAN^[.
 * FigureActor pA|SɃeNX`\t<BR>
 * [XvCg@\ǉAN^[łB<BR>
 * |<BR>
 * @version 1.00
 * @since 2007/11/14
 * @author Masatoshi Tsuge
 */
class SpriteActor : public FigureActor {

public:
    /** [r]f */
    SpriteModel* const _pSpriteModel;
    /** [r]GtFNg */
    SpriteEffect* const _pSpriteEffect;
    /** [r]UVtbp[(ppAj) */
    UvFlipper* const _pUvFlipper;

    float _far_rate;
    Align _align;
    Valign _valign;

public:
    /**
     * RXgN^ .
     * @param prm_name AN^[́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`A ".x" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    SpriteActor(const char* prm_name,
                const char* prm_model_id,
                const char* prm_effect_id,
                const char* prm_technique,
                Checker* prm_pChecker );

    virtual void processDraw() override;

    virtual ~SpriteActor();

    /**
     * ̍Wł\ .
     * @param prm_b
     */
    void drawAnyFar(bool prm_b) {
        if (prm_b) {
            _far_rate = 0.999f;
        } else {
            _far_rate = -1.0f;
        }
    }

    inline UvFlipper* getUvFlipper() {
        return _pUvFlipper;
    }
};

}
#endif /*GGAF_DX_SPRITEACTORD_H_*/
