#ifndef GGAF_DX_REGULARPOLYGONSPRITEACTOR_H_
#define GGAF_DX_REGULARPOLYGONSPRITEACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/actor/FigureActor.h"

namespace GgafDx {

/**
 * p`^XvCgAN^[ .
 * FigureActor pA|SɃeNX`\t<BR>
 * [XvCg@\ǉAN^[łB<BR>
 * |<BR>
 * @version 1.00
 * @since 2010/10/18
 * @author Masatoshi Tsuge
 */
class RegularPolygonSpriteActor : public FigureActor {

public:
    /** [r]f */
    RegularPolygonSpriteModel* const _pRegularPolygonSpriteModel;
    /** [r]GtFNg */
    RegularPolygonSpriteEffect* const _pRegularPolygonSpriteEffect;
    /** [r]UVtbp[(ppAj) */
    UvFlipper* const _pUvFlipper;

    float _far_rate;

    Align _align;

    Valign _valign;
    /** `悷邩 */
    int _draw_fan_num;
    /** p``Jnŏ̒_̊pxʒu */
    angle _circumference_begin_position;

public:
    /**
     * RXgN^ .
     * @param prm_name AN^[́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`A ".x" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    RegularPolygonSpriteActor(const char* prm_name,
                              const char* prm_model_id,
                              const char* prm_effect_id,
                              const char* prm_technique,
                              Checker* prm_pChecker );

    virtual void processDraw() override;

    virtual ~RegularPolygonSpriteActor();

    /**
     * ̍Wł\ .
     * @param prm_b
     */
    void drawAnyFar(bool prm_b) {
        if (prm_b) {
            _far_rate = 0.999f;
        } else {
            _far_rate = -1.0f;
        }
    }

//    virtual void setAlign(Align prm_align, Valign prm_valign);
//    virtual void setAlign(Align prm_align);
//    virtual void setValign(Valign prm_valign);

    inline UvFlipper* getUvFlipper() {
        return _pUvFlipper;
    }
    /**
     * `悷FAN(^)̖擾
     * @return `悷FAN(^)̖
     */
    int getDrawFanNum() {
        return _draw_fan_num;
    }

    /**
     * `悷FAN(^)̖w肷 .
     * @param prm_draw_fan_num `悷FAN(^)̖
     */
    void setDrawFanNum(int prm_draw_fan_num) {
        _draw_fan_num = prm_draw_fan_num;
    }

    /**
     * p``Jnŏ̒_̊pxʒuݒ肷 .
     * @param prm_ang ŏ̒_̊pxʒu
     */
    void setBeginAngPos(angle prm_ang) {
        _circumference_begin_position = prm_ang;
    }

    /**
     * ݂̑p``Jnŏ̒_̊pxʒu擾
     * @return ŏ̒_̊pxʒu
     */
    angle getBeginAngPos() {
        return _circumference_begin_position;
    }
};

}
#endif /*GGAF_DX_REGULARPOLYGONSPRITEACTOR_H_*/
