#ifndef GGAF_DX_FIGUREACTOR_H_
#define GGAF_DX_FIGUREACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/actor/GeometricActor.h"
#include "jp/ggaf/dx/manager/ModelManager.h"
#include "jp/ggaf/dx/manager/EffectManager.h"

namespace GgafDx {

/**
 * ʂɕ`sAN^[̒ۃNX .
 * GeometricActor  fAGtFNgA}eAȂǂێA<BR>
 * `֘A\bh`<BR>
 * @version 1.00
 * @since 2009/06/10
 * @author Masatoshi Tsuge
 */
class FigureActor : public GeometricActor {
private:
    /**
     * draw()̎gp֎~ .
     * E(Spacetime)SĂ̕`sdg݂ɂȂ܂B
     * Spacetime::draw() QƂB
     * m[hc[p draw \bhʂŎgȂ悤ɂ邽privateŎB
     */
    void draw() override {}

protected:
    /** [r]fڑ */
    ModelConnection* const _pModelCon;
    /** [r]f */
    Model* const _pModel;
    /** [r]GtFNgڑ */
    EffectConnection* const _pEffectCon;
    /** [r]GtFNg */
    Effect* const _pEffect;
    /** [r]ꎞeNjbN */
    char* _temp_technique;
    /** [r]ꎞeNjbNnbVl */
    hashval _hash_temp_technique;
    /** [r]ꎞeNjbNIt[ */
    frame _frame_of_behaving_temp_technique_end;
    /** [r]tF[fBOx */
    AlphaFader* _pAlphaFader;
    /** [r]JXg */
    Colorist* _pColorist;
public:
    /** [r/w]`掞AZobt@lĕ`sۂBtrue:l^false:Zobt@𖳎ĕ`  */
    bool _zenable;
    /** [r/w]`掞AZobt@֏݂sۂBtrue:Zobt@֐[xށ^false:Zobt@ւ͉܂Ȃ */
    bool _zwriteenable;

    /** [r]߂̕`掞ɎgpꂽeNjbÑnbVR[h */
    static hashval _hash_technique_last_draw;

    /** [r]`惌x̎̃AN^[ */
    FigureActor* _pNextRenderActor;
    /** [r/w]݂̃}eÃl (0.0 <= _alpha <= 1.0) */
    float _alpha;
    /** [r/w]JOL\̏ꍇ true */
    bool _cull_enable;
    /** [r/w]JOL\̏ꍇ̃JO D3DCULL_CCW(default) or D3DCULL_CW */
    DWORD _cull_mode;
    DWORD _cull_mode_default;
    /** [r]ݕ`ɎgpĂVF[_[eNjbN */
    char* _technique;
    /** [r]ݕ`ɎgpẴVF[_[eNjbÑnbVR[h */
    hashval _hash_technique;
    /** [r/w]݂̃}eAʃJ[(TODO:Diffuse ̂ݎgpj */
    D3DMATERIAL9* _paMaterial;

    /** [r/w]݂̕`[x */
    int _now_drawdepth;
    /** [r/w]ʂȌŒ`[xA-1łȂ _now_drawdepth Dł̐[xKp */
    int _specal_render_depth_index;
    /** [r]ꎞeNjbNKp̏ꍇ true */
    bool _is_temp_technique;
    /** [r]gfIuWFNg̍ŏ̃RlN^[łꍇtrue */
    bool _is_first_model_connector;
    /** [r]gGtFNgIuWFNg̍ŏ̃RlN^[łꍇtrue */
    bool _is_first_effect_connector;

public:
    /**
     * RXgN^ .
     * @param prm_name f́iCӁj
     * @param prm_model fʃL[
     * @param prm_effect GtFNgʃL[
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    FigureActor(const char* prm_name,
                      const char* prm_model,
                      const char* prm_effect,
                      const char* prm_technique,
                      Checker* prm_pChecker);

    /**
     * RXgN^ .
     * ModelManager::processCreateResource() y
     * EffectManager::processCreateResource()
     * ̐QƂׂB
     * @param prm_name AN^[́iCӁj
     * @param prm_model_id f`
     * @param prm_model_type f^Cv
     * @param prm_effect_id GtFNg`
     * @param prm_effect_type GtFNg^Cv
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    FigureActor(const char* prm_name,
                const char* prm_model_id,
                const char prm_model_type,
                const char* prm_effect_id,
                const char prm_effect_type,
                const char* prm_technique,
                Checker* prm_pChecker);

    virtual FigureActor* getPrev() const override {  //ς̖߂l
        return (FigureActor*)GgafCore::Actor::getPrev();
    }

    virtual FigureActor* getNext() const override {  //ς̖߂l
        return (FigureActor*)GgafCore::Actor::getNext();
    }

    /**
     * tF[fBOxIuWFNg擾 .
     * @return tF[fBOxIuWFNg
     */
    AlphaFader* getAlphaFader();

    /**
     * JXg擾 .
     * @return JXg
     */
    Colorist* getColorist();

    /**
     * VF[_[̃eNjbNύX .
     * \B
     * @param prm_technique eNjbN
     */
    virtual void changeEffectTechnique(const char* prm_technique);

    /**
     * VF[_[̃eNjbNꎞIɕύX .
     * ɈꎞeNjbNgp͖BAA
     * ɈꎞeNjbNgpɋIɈꎞeNjbNύXꍇ̂悤ɂłB
     * <code>
     * if (_is_temp_technique == false) {
     *     changeEffectTechnique("ύXeNjbN");
     * }
     * </code>
     * @param prm_technique eNjbN
     * @param prm_frame ύXeNjbŇpt[
     */
    virtual void changeEffectTechniqueMoment(const char* prm_technique, frame prm_frame);

    /**
     * sJƌB
     * @param prm_frame 鎞
     */
    virtual void effectFlush(frame prm_frame = MAX_FRAME);

    /**
     * ZGtFNg .
     * @param prm_frame
     */
    virtual void effectBlendOne(frame prm_frame = MAX_FRAME);

    /**
     * WGtFNgɖ߂ .
     */
    virtual void effectDefault();

    /**
     * ʂȕ`[xB .
     * 0ȏwꍇA`[xwɂ̒lgpB
     * ̐̎wꍇAݒɖ߂i_specal_render_depth_index̃ftHg-1)
     * @param prm_drawdepth `[x
     */
    void setSpecialRenderDepthIndex(int prm_drawdepth);

    /**
     * ʂȕ`[xw .
     */
    void resetSpecialRenderDepthIndex();

    /**
     * ʂ̕`掖O .
     * `sɂĂ̏dvȎOsȂ܂B
     * EonCreateModel() ̌Ăяo
     * EiK_O̐[xvZ
     * EꎞeNjbNl
     * I[o[Ch񐄏B
     * I[o[Chꍇ́A
     * FigureActor::processPreDraw() \bhŌĂяoA
     * ͎Oœ̏邩AȂlĂB
     * TODO:private virtual ɂׂۂHBfainal ~
     */
    virtual void processPreDraw() override;

    /**
     * ʂ̕`掖㏈ .
     * fobO[h (MY_DEBUG  1)̏ꍇ
     * 蔻̈`悷B
     * (ƂĂ drawHitArea() R[邾)
     */
    virtual void processAfterDraw() override;

    /**
     * 蔻̈` .
     * ۂ͉̏ʃNXɔCB
     */
    virtual void drawHitArea() {};

    /**
     * {AN^[̕`掞̃}eAAt@lݒ .
     * 1.0 ȏ̏ꍇJOONA<br>
     * 1.0 菬ȏꍇAJOOFFA<br>
     * Ƃ@\킹B<br>
     * @param prm_alpha AN^[̃}eAAt@l
     */
    virtual void setAlpha(float prm_alpha);

    /**
     * {AN^[̕`掞̃}eAAt@lZ .
     * @param prm_alpha Z}eAAt@l
     */
    virtual void addAlpha(float prm_alpha);

    /**
     * {AN^[̕`掞̃}eAAt@l擾 .
     * @return AN^[݂̌̃At@l
     */
    virtual float getAlpha() const {
        return _alpha;
    }

    /**
     * {AN^[̕`掞̃}eAJ[ݒB .
     * LN^ŜɐFd˂ʂ𓾂B<br>
     * @́AʂɈˑB<br>
     * Ė{\bhɂu}eAJ[v̈Ӗ́A<br>
     * uDirectX̃}eAv̈ӖƈvȂȂB<br>
     * @param r Redx(0.0 ` 1.0)
     * @param g Greenx(0.0 ` 1.0)
     * @param b Bluex(0.0 ` 1.0)
     */
    virtual void setMaterialColor(float r, float g, float b);

    virtual void setMaterialRed(float r);
    virtual void setMaterialGreen(float g);
    virtual void setMaterialBlue(float b);
    virtual float getMaterialRed();
    virtual float getMaterialGreen();
    virtual float getMaterialBlue();

    /**
     * {AN^[̕`掞̃}eAJ[ݒB .
     * @param prm_rgb
     */
    virtual void setMaterialColor(const GgafCore::Rgb* prm_rgb);

    /**
     * }eAJ[fǂݍݎ̏ԂɃZbgB
     */
    virtual void resetMaterialColor();

    inline Model* getModel() const {
        return _pModel;
    }

    virtual Effect* getEffect() const {
        return _pEffect;
    }
    /**
     * JO`悷邩ǂB
     * @param prm_bool true:JO`悠(default) / false:JOAʂ`
     */
    inline void setCullingDraw(bool prm_bool) {
        _cull_enable = prm_bool;
        if (_cull_enable) {
            _cull_mode = _cull_mode_default;
        } else {
            _cull_mode = D3DCULL_NONE;
        }
    }

    inline void setCullingMode(DWORD prm__cull_mode) {
        _cull_mode_default = prm__cull_mode;
        _cull_mode = _cull_mode_default;
    }

    /**
     * `掞Zobt@l邩 .
     * @param prm_bool true:l(default) / false:
     */
    inline void setZEnableDraw(bool prm_bool) {
        _zenable = prm_bool;
    }

    /**
     * `掞Zobt@ނ .
     * @param prm_bool true:(default) / false:܂Ȃ
     */
    inline void setZWriteEnable(bool prm_bool) {
        _zwriteenable = prm_bool;
    }

    /**
     * fꂽ̏ .
     * fIuWFNg new ꂽꍇɂP񂾂Ăяo܂B
     * fPʂŐݒ肵I[o[ChĉB
     */
    virtual void onCreateModel() = 0;

    /**
     * ʓɕ\Ă邩 .
     * @return 0(false):Viewport͈͓
     *         1       :Viewport̏㕽ʂŔ͈͊O
     *         2       :Viewport̉ʂ艺Ŕ͈͊O
     *         3       :Viewport̍ʂ荶Ŕ͈͊O
     *         4       :Viewport̉EʂEŔ͈͊O
     *         5       :Viewport̎OʂOŔ͈͊O
     *         6       :Viewport̉ʂ艜Ŕ͈͊O
     *         D揇ʏɕł܂BiF1  4  1 Ԃ܂j
     */
    virtual int isOutOfView() override;

    bool isFirstModelConnector() {
        return _is_first_model_connector;
    }

    bool isFirstEffectConnector() {
        return _is_first_effect_connector;
    }

    virtual ~FigureActor(); //fXgN^
};

}
#endif /*GGAF_DX_FIGUREACTOR_H_*/
