#include "jp/ggaf/core/util/Rgb.h"

#include <map>

using namespace GgafCore;
std::map<std::string, std::string> Rgb::_cname;

Rgb::Rgb() : Object(),
        _allowedChars("0123456789abcdefABCDEF#") , _red(0), _green(0), _blue(0), _r(0), _g(0), _b(0), _hex(""), _is_valid(true) {
    init();
}

Rgb::Rgb(std::string prm_str_color) : Object(),
        _allowedChars("0123456789abcdefABCDEF#") , _red(0), _green(0), _blue(0), _r(0), _g(0), _b(0), _hex(""), _is_valid(true) {
    init();
    set(prm_str_color);
}

void Rgb::init() {
    static volatile bool is_init = Rgb::initStatic(); //ÓIo
}
bool Rgb::initStatic() {
    Rgb::_cname["snow"] = "#FFFAFA";
    Rgb::_cname["ghost white"] = "#F8F8FF";
    Rgb::_cname["GhostWhite"] = "#F8F8FF";
    Rgb::_cname["white smoke"] = "#F5F5F5";
    Rgb::_cname["WhiteSmoke"] = "#F5F5F5";
    Rgb::_cname["gainsboro"] = "#DCDCDC";
    Rgb::_cname["floral white"] = "#FFFAF0";
    Rgb::_cname["FloralWhite"] = "#FFFAF0";
    Rgb::_cname["old lace"] = "#FDF5E6";
    Rgb::_cname["OldLace"] = "#FDF5E6";
    Rgb::_cname["linen"] = "#FAF0E6";
    Rgb::_cname["antique white"] = "#FAEBD7";
    Rgb::_cname["AntiqueWhite"] = "#FAEBD7";
    Rgb::_cname["papaya whip"] = "#FFEFD5";
    Rgb::_cname["PapayaWhip"] = "#FFEFD5";
    Rgb::_cname["blanched almond"] = "#FFEBCD";
    Rgb::_cname["BlanchedAlmond"] = "#FFEBCD";
    Rgb::_cname["bisque"] = "#FFE4C4";
    Rgb::_cname["peach puff"] = "#FFDAB9";
    Rgb::_cname["PeachPuff"] = "#FFDAB9";
    Rgb::_cname["navajo white"] = "#FFDEAD";
    Rgb::_cname["NavajoWhite"] = "#FFDEAD";
    Rgb::_cname["moccasin"] = "#FFE4B5";
    Rgb::_cname["cornsilk"] = "#FFF8DC";
    Rgb::_cname["ivory"] = "#FFFFF0";
    Rgb::_cname["lemon chiffon"] = "#FFFACD";
    Rgb::_cname["LemonChiffon"] = "#FFFACD";
    Rgb::_cname["seashell"] = "#FFF5EE";
    Rgb::_cname["honeydew"] = "#F0FFF0";
    Rgb::_cname["mint cream"] = "#F5FFFA";
    Rgb::_cname["MintCream"] = "#F5FFFA";
    Rgb::_cname["azure"] = "#F0FFFF";
    Rgb::_cname["alice blue"] = "#F0F8FF";
    Rgb::_cname["AliceBlue"] = "#F0F8FF";
    Rgb::_cname["lavender"] = "#E6E6FA";
    Rgb::_cname["lavender blush"] = "#FFF0F5";
    Rgb::_cname["LavenderBlush"] = "#FFF0F5";
    Rgb::_cname["misty rose"] = "#FFE4E1";
    Rgb::_cname["MistyRose"] = "#FFE4E1";
    Rgb::_cname["white"] = "#FFFFFF";
    Rgb::_cname["black"] = "#000000";
    Rgb::_cname["dark slate gray"] = "#2F4F4F";
    Rgb::_cname["DarkSlateGray"] = "#2F4F4F";
    Rgb::_cname["dark slate grey"] = "#2F4F4F";
    Rgb::_cname["DarkSlateGrey"] = "#2F4F4F";
    Rgb::_cname["dim gray"] = "#696969";
    Rgb::_cname["DimGray"] = "#696969";
    Rgb::_cname["dim grey"] = "#696969";
    Rgb::_cname["DimGrey"] = "#696969";
    Rgb::_cname["slate gray"] = "#708090";
    Rgb::_cname["SlateGray"] = "#708090";
    Rgb::_cname["slate grey"] = "#708090";
    Rgb::_cname["SlateGrey"] = "#708090";
    Rgb::_cname["light slate gray"] = "#778899";
    Rgb::_cname["LightSlateGray"] = "#778899";
    Rgb::_cname["light slate grey"] = "#778899";
    Rgb::_cname["LightSlateGrey"] = "#778899";
    Rgb::_cname["gray"] = "#BEBEBE";
    Rgb::_cname["grey"] = "#BEBEBE";
    Rgb::_cname["light grey"] = "#D3D3D3";
    Rgb::_cname["LightGrey"] = "#D3D3D3";
    Rgb::_cname["light gray"] = "#D3D3D3";
    Rgb::_cname["LightGray"] = "#D3D3D3";
    Rgb::_cname["midnight blue"] = "#191970";
    Rgb::_cname["MidnightBlue"] = "#191970";
    Rgb::_cname["navy"] = "#000080";
    Rgb::_cname["navy blue"] = "#000080";
    Rgb::_cname["NavyBlue"] = "#000080";
    Rgb::_cname["cornflower blue"] = "#6495ED";
    Rgb::_cname["CornflowerBlue"] = "#6495ED";
    Rgb::_cname["dark slate blue"] = "#483D8B";
    Rgb::_cname["DarkSlateBlue"] = "#483D8B";
    Rgb::_cname["slate blue"] = "#6A5ACD";
    Rgb::_cname["SlateBlue"] = "#6A5ACD";
    Rgb::_cname["medium slate blue"] = "#7B68EE";
    Rgb::_cname["MediumSlateBlue"] = "#7B68EE";
    Rgb::_cname["light slate blue"] = "#8470FF";
    Rgb::_cname["LightSlateBlue"] = "#8470FF";
    Rgb::_cname["medium blue"] = "#0000CD";
    Rgb::_cname["MediumBlue"] = "#0000CD";
    Rgb::_cname["royal blue"] = "#4169E1";
    Rgb::_cname["RoyalBlue"] = "#4169E1";
    Rgb::_cname["blue"] = "#0000FF";
    Rgb::_cname["dodger blue"] = "#1E90FF";
    Rgb::_cname["DodgerBlue"] = "#1E90FF";
    Rgb::_cname["deep sky blue"] = "#00BFFF";
    Rgb::_cname["DeepSkyBlue"] = "#00BFFF";
    Rgb::_cname["sky blue"] = "#87CEEB";
    Rgb::_cname["SkyBlue"] = "#87CEEB";
    Rgb::_cname["light sky blue"] = "#87CEFA";
    Rgb::_cname["LightSkyBlue"] = "#87CEFA";
    Rgb::_cname["steel blue"] = "#4682B4";
    Rgb::_cname["SteelBlue"] = "#4682B4";
    Rgb::_cname["light steel blue"] = "#B0C4DE";
    Rgb::_cname["LightSteelBlue"] = "#B0C4DE";
    Rgb::_cname["light blue"] = "#ADD8E6";
    Rgb::_cname["LightBlue"] = "#ADD8E6";
    Rgb::_cname["powder blue"] = "#B0E0E6";
    Rgb::_cname["PowderBlue"] = "#B0E0E6";
    Rgb::_cname["pale turquoise"] = "#AFEEEE";
    Rgb::_cname["PaleTurquoise"] = "#AFEEEE";
    Rgb::_cname["dark turquoise"] = "#00CED1";
    Rgb::_cname["DarkTurquoise"] = "#00CED1";
    Rgb::_cname["medium turquoise"] = "#48D1CC";
    Rgb::_cname["MediumTurquoise"] = "#48D1CC";
    Rgb::_cname["turquoise"] = "#40E0D0";
    Rgb::_cname["cyan"] = "#00FFFF";
    Rgb::_cname["light cyan"] = "#E0FFFF";
    Rgb::_cname["LightCyan"] = "#E0FFFF";
    Rgb::_cname["cadet blue"] = "#5F9EA0";
    Rgb::_cname["CadetBlue"] = "#5F9EA0";
    Rgb::_cname["medium aquamarine"] = "#66CDAA";
    Rgb::_cname["MediumAquamarine"] = "#66CDAA";
    Rgb::_cname["aquamarine"] = "#7FFFD4";
    Rgb::_cname["dark green"] = "#006400";
    Rgb::_cname["DarkGreen"] = "#006400";
    Rgb::_cname["dark olive green"] = "#556B2F";
    Rgb::_cname["DarkOliveGreen"] = "#556B2F";
    Rgb::_cname["dark sea green"] = "#8FBC8F";
    Rgb::_cname["DarkSeaGreen"] = "#8FBC8F";
    Rgb::_cname["sea green"] = "#2E8B57";
    Rgb::_cname["SeaGreen"] = "#2E8B57";
    Rgb::_cname["medium sea green"] = "#3CB371";
    Rgb::_cname["MediumSeaGreen"] = "#3CB371";
    Rgb::_cname["light sea green"] = "#20B2AA";
    Rgb::_cname["LightSeaGreen"] = "#20B2AA";
    Rgb::_cname["pale green"] = "#98FB98";
    Rgb::_cname["PaleGreen"] = "#98FB98";
    Rgb::_cname["spring green"] = "#00FF7F";
    Rgb::_cname["SpringGreen"] = "#00FF7F";
    Rgb::_cname["lawn green"] = "#7CFC00";
    Rgb::_cname["LawnGreen"] = "#7CFC00";
    Rgb::_cname["green"] = "#00FF00";
    Rgb::_cname["chartreuse"] = "#7FFF00";
    Rgb::_cname["medium spring green"] = "#00FA9A";
    Rgb::_cname["MediumSpringGreen"] = "#00FA9A";
    Rgb::_cname["green yellow"] = "#ADFF2F";
    Rgb::_cname["GreenYellow"] = "#ADFF2F";
    Rgb::_cname["lime green"] = "#32CD32";
    Rgb::_cname["LimeGreen"] = "#32CD32";
    Rgb::_cname["yellow green"] = "#9ACD32";
    Rgb::_cname["YellowGreen"] = "#9ACD32";
    Rgb::_cname["forest green"] = "#228B22";
    Rgb::_cname["ForestGreen"] = "#228B22";
    Rgb::_cname["olive drab"] = "#6B8E23";
    Rgb::_cname["OliveDrab"] = "#6B8E23";
    Rgb::_cname["dark khaki"] = "#BDB76B";
    Rgb::_cname["DarkKhaki"] = "#BDB76B";
    Rgb::_cname["khaki"] = "#F0E68C";
    Rgb::_cname["pale goldenrod"] = "#EEE8AA";
    Rgb::_cname["PaleGoldenrod"] = "#EEE8AA";
    Rgb::_cname["light goldenrod yellow"] = "#FAFAD2";
    Rgb::_cname["LightGoldenrodYellow"] = "#FAFAD2";
    Rgb::_cname["light yellow"] = "#FFFFE0";
    Rgb::_cname["LightYellow"] = "#FFFFE0";
    Rgb::_cname["yellow"] = "#FFFF00";
    Rgb::_cname["gold"] = "#FFD700";
    Rgb::_cname["light goldenrod"] = "#EEDD82";
    Rgb::_cname["LightGoldenrod"] = "#EEDD82";
    Rgb::_cname["goldenrod"] = "#DAA520";
    Rgb::_cname["dark goldenrod"] = "#B8860B";
    Rgb::_cname["DarkGoldenrod"] = "#B8860B";
    Rgb::_cname["rosy brown"] = "#BC8F8F";
    Rgb::_cname["RosyBrown"] = "#BC8F8F";
    Rgb::_cname["indian red"] = "#CD5C5C";
    Rgb::_cname["IndianRed"] = "#CD5C5C";
    Rgb::_cname["saddle brown"] = "#8B4513";
    Rgb::_cname["SaddleBrown"] = "#8B4513";
    Rgb::_cname["sienna"] = "#A0522D";
    Rgb::_cname["peru"] = "#CD853F";
    Rgb::_cname["burlywood"] = "#DEB887";
    Rgb::_cname["beige"] = "#F5F5DC";
    Rgb::_cname["wheat"] = "#F5DEB3";
    Rgb::_cname["sandy brown"] = "#F4A460";
    Rgb::_cname["SandyBrown"] = "#F4A460";
    Rgb::_cname["tan"] = "#D2B48C";
    Rgb::_cname["chocolate"] = "#D2691E";
    Rgb::_cname["firebrick"] = "#B22222";
    Rgb::_cname["brown"] = "#A52A2A";
    Rgb::_cname["dark salmon"] = "#E9967A";
    Rgb::_cname["DarkSalmon"] = "#E9967A";
    Rgb::_cname["salmon"] = "#FA8072";
    Rgb::_cname["light salmon"] = "#FFA07A";
    Rgb::_cname["LightSalmon"] = "#FFA07A";
    Rgb::_cname["orange"] = "#FFA500";
    Rgb::_cname["dark orange"] = "#FF8C00";
    Rgb::_cname["DarkOrange"] = "#FF8C00";
    Rgb::_cname["coral"] = "#FF7F50";
    Rgb::_cname["light coral"] = "#F08080";
    Rgb::_cname["LightCoral"] = "#F08080";
    Rgb::_cname["tomato"] = "#FF6347";
    Rgb::_cname["orange red"] = "#FF4500";
    Rgb::_cname["OrangeRed"] = "#FF4500";
    Rgb::_cname["red"] = "#FF0000";
    Rgb::_cname["hot pink"] = "#FF69B4";
    Rgb::_cname["HotPink"] = "#FF69B4";
    Rgb::_cname["deep pink"] = "#FF1493";
    Rgb::_cname["DeepPink"] = "#FF1493";
    Rgb::_cname["pink"] = "#FFC0CB";
    Rgb::_cname["light pink"] = "#FFB6C1";
    Rgb::_cname["LightPink"] = "#FFB6C1";
    Rgb::_cname["pale violet red"] = "#DB7093";
    Rgb::_cname["PaleVioletRed"] = "#DB7093";
    Rgb::_cname["maroon"] = "#B03060";
    Rgb::_cname["medium violet red"] = "#C71585";
    Rgb::_cname["MediumVioletRed"] = "#C71585";
    Rgb::_cname["violet red"] = "#D02090";
    Rgb::_cname["VioletRed"] = "#D02090";
    Rgb::_cname["magenta"] = "#FF00FF";
    Rgb::_cname["violet"] = "#EE82EE";
    Rgb::_cname["plum"] = "#DDA0DD";
    Rgb::_cname["orchid"] = "#DA70D6";
    Rgb::_cname["medium orchid"] = "#BA55D3";
    Rgb::_cname["MediumOrchid"] = "#BA55D3";
    Rgb::_cname["dark orchid"] = "#9932CC";
    Rgb::_cname["DarkOrchid"] = "#9932CC";
    Rgb::_cname["dark violet"] = "#9400D3";
    Rgb::_cname["DarkViolet"] = "#9400D3";
    Rgb::_cname["blue violet"] = "#8A2BE2";
    Rgb::_cname["BlueViolet"] = "#8A2BE2";
    Rgb::_cname["purple"] = "#A020F0";
    Rgb::_cname["medium purple"] = "#9370DB";
    Rgb::_cname["MediumPurple"] = "#9370DB";
    Rgb::_cname["thistle"] = "#D8BFD8";
    Rgb::_cname["snow1"] = "#FFFAFA";
    Rgb::_cname["snow2"] = "#EEE9E9";
    Rgb::_cname["snow3"] = "#CDC9C9";
    Rgb::_cname["snow4"] = "#8B8989";
    Rgb::_cname["seashell1"] = "#FFF5EE";
    Rgb::_cname["seashell2"] = "#EEE5DE";
    Rgb::_cname["seashell3"] = "#CDC5BF";
    Rgb::_cname["seashell4"] = "#8B8682";
    Rgb::_cname["AntiqueWhite1"] = "#FFEFDB";
    Rgb::_cname["AntiqueWhite2"] = "#EEDFCC";
    Rgb::_cname["AntiqueWhite3"] = "#CDC0B0";
    Rgb::_cname["AntiqueWhite4"] = "#8B8378";
    Rgb::_cname["bisque1"] = "#FFE4C4";
    Rgb::_cname["bisque2"] = "#EED5B7";
    Rgb::_cname["bisque3"] = "#CDB79E";
    Rgb::_cname["bisque4"] = "#8B7D6B";
    Rgb::_cname["PeachPuff1"] = "#FFDAB9";
    Rgb::_cname["PeachPuff2"] = "#EECBAD";
    Rgb::_cname["PeachPuff3"] = "#CDAF95";
    Rgb::_cname["PeachPuff4"] = "#8B7765";
    Rgb::_cname["NavajoWhite1"] = "#FFDEAD";
    Rgb::_cname["NavajoWhite2"] = "#EECFA1";
    Rgb::_cname["NavajoWhite3"] = "#CDB38B";
    Rgb::_cname["NavajoWhite4"] = "#8B795E";
    Rgb::_cname["LemonChiffon1"] = "#FFFACD";
    Rgb::_cname["LemonChiffon2"] = "#EEE9BF";
    Rgb::_cname["LemonChiffon3"] = "#CDC9A5";
    Rgb::_cname["LemonChiffon4"] = "#8B8970";
    Rgb::_cname["cornsilk1"] = "#FFF8DC";
    Rgb::_cname["cornsilk2"] = "#EEE8CD";
    Rgb::_cname["cornsilk3"] = "#CDC8B1";
    Rgb::_cname["cornsilk4"] = "#8B8878";
    Rgb::_cname["ivory1"] = "#FFFFF0";
    Rgb::_cname["ivory2"] = "#EEEEE0";
    Rgb::_cname["ivory3"] = "#CDCDC1";
    Rgb::_cname["ivory4"] = "#8B8B83";
    Rgb::_cname["honeydew1"] = "#F0FFF0";
    Rgb::_cname["honeydew2"] = "#E0EEE0";
    Rgb::_cname["honeydew3"] = "#C1CDC1";
    Rgb::_cname["honeydew4"] = "#838B83";
    Rgb::_cname["LavenderBlush1"] = "#FFF0F5";
    Rgb::_cname["LavenderBlush2"] = "#EEE0E5";
    Rgb::_cname["LavenderBlush3"] = "#CDC1C5";
    Rgb::_cname["LavenderBlush4"] = "#8B8386";
    Rgb::_cname["MistyRose1"] = "#FFE4E1";
    Rgb::_cname["MistyRose2"] = "#EED5D2";
    Rgb::_cname["MistyRose3"] = "#CDB7B5";
    Rgb::_cname["MistyRose4"] = "#8B7D7B";
    Rgb::_cname["azure1"] = "#F0FFFF";
    Rgb::_cname["azure2"] = "#E0EEEE";
    Rgb::_cname["azure3"] = "#C1CDCD";
    Rgb::_cname["azure4"] = "#838B8B";
    Rgb::_cname["SlateBlue1"] = "#836FFF";
    Rgb::_cname["SlateBlue2"] = "#7A67EE";
    Rgb::_cname["SlateBlue3"] = "#6959CD";
    Rgb::_cname["SlateBlue4"] = "#473C8B";
    Rgb::_cname["RoyalBlue1"] = "#4876FF";
    Rgb::_cname["RoyalBlue2"] = "#436EEE";
    Rgb::_cname["RoyalBlue3"] = "#3A5FCD";
    Rgb::_cname["RoyalBlue4"] = "#27408B";
    Rgb::_cname["blue1"] = "#0000FF";
    Rgb::_cname["blue2"] = "#0000EE";
    Rgb::_cname["blue3"] = "#0000CD";
    Rgb::_cname["blue4"] = "#00008B";
    Rgb::_cname["DodgerBlue1"] = "#1E90FF";
    Rgb::_cname["DodgerBlue2"] = "#1C86EE";
    Rgb::_cname["DodgerBlue3"] = "#1874CD";
    Rgb::_cname["DodgerBlue4"] = "#104E8B";
    Rgb::_cname["SteelBlue1"] = "#63B8FF";
    Rgb::_cname["SteelBlue2"] = "#5CACEE";
    Rgb::_cname["SteelBlue3"] = "#4F94CD";
    Rgb::_cname["SteelBlue4"] = "#36648B";
    Rgb::_cname["DeepSkyBlue1"] = "#00BFFF";
    Rgb::_cname["DeepSkyBlue2"] = "#00B2EE";
    Rgb::_cname["DeepSkyBlue3"] = "#009ACD";
    Rgb::_cname["DeepSkyBlue4"] = "#00688B";
    Rgb::_cname["SkyBlue1"] = "#87CEFF";
    Rgb::_cname["SkyBlue2"] = "#7EC0EE";
    Rgb::_cname["SkyBlue3"] = "#6CA6CD";
    Rgb::_cname["SkyBlue4"] = "#4A708B";
    Rgb::_cname["LightSkyBlue1"] = "#B0E2FF";
    Rgb::_cname["LightSkyBlue2"] = "#A4D3EE";
    Rgb::_cname["LightSkyBlue3"] = "#8DB6CD";
    Rgb::_cname["LightSkyBlue4"] = "#607B8B";
    Rgb::_cname["SlateGray1"] = "#C6E2FF";
    Rgb::_cname["SlateGray2"] = "#B9D3EE";
    Rgb::_cname["SlateGray3"] = "#9FB6CD";
    Rgb::_cname["SlateGray4"] = "#6C7B8B";
    Rgb::_cname["LightSteelBlue1"] = "#CAE1FF";
    Rgb::_cname["LightSteelBlue2"] = "#BCD2EE";
    Rgb::_cname["LightSteelBlue3"] = "#A2B5CD";
    Rgb::_cname["LightSteelBlue4"] = "#6E7B8B";
    Rgb::_cname["LightBlue1"] = "#BFEFFF";
    Rgb::_cname["LightBlue2"] = "#B2DFEE";
    Rgb::_cname["LightBlue3"] = "#9AC0CD";
    Rgb::_cname["LightBlue4"] = "#68838B";
    Rgb::_cname["LightCyan1"] = "#E0FFFF";
    Rgb::_cname["LightCyan2"] = "#D1EEEE";
    Rgb::_cname["LightCyan3"] = "#B4CDCD";
    Rgb::_cname["LightCyan4"] = "#7A8B8B";
    Rgb::_cname["PaleTurquoise1"] = "#BBFFFF";
    Rgb::_cname["PaleTurquoise2"] = "#AEEEEE";
    Rgb::_cname["PaleTurquoise3"] = "#96CDCD";
    Rgb::_cname["PaleTurquoise4"] = "#668B8B";
    Rgb::_cname["CadetBlue1"] = "#98F5FF";
    Rgb::_cname["CadetBlue2"] = "#8EE5EE";
    Rgb::_cname["CadetBlue3"] = "#7AC5CD";
    Rgb::_cname["CadetBlue4"] = "#53868B";
    Rgb::_cname["turquoise1"] = "#00F5FF";
    Rgb::_cname["turquoise2"] = "#00E5EE";
    Rgb::_cname["turquoise3"] = "#00C5CD";
    Rgb::_cname["turquoise4"] = "#00868B";
    Rgb::_cname["cyan1"] = "#00FFFF";
    Rgb::_cname["cyan2"] = "#00EEEE";
    Rgb::_cname["cyan3"] = "#00CDCD";
    Rgb::_cname["cyan4"] = "#008B8B";
    Rgb::_cname["DarkSlateGray1"] = "#97FFFF";
    Rgb::_cname["DarkSlateGray2"] = "#8DEEEE";
    Rgb::_cname["DarkSlateGray3"] = "#79CDCD";
    Rgb::_cname["DarkSlateGray4"] = "#528B8B";
    Rgb::_cname["aquamarine1"] = "#7FFFD4";
    Rgb::_cname["aquamarine2"] = "#76EEC6";
    Rgb::_cname["aquamarine3"] = "#66CDAA";
    Rgb::_cname["aquamarine4"] = "#458B74";
    Rgb::_cname["DarkSeaGreen1"] = "#C1FFC1";
    Rgb::_cname["DarkSeaGreen2"] = "#B4EEB4";
    Rgb::_cname["DarkSeaGreen3"] = "#9BCD9B";
    Rgb::_cname["DarkSeaGreen4"] = "#698B69";
    Rgb::_cname["SeaGreen1"] = "#54FF9F";
    Rgb::_cname["SeaGreen2"] = "#4EEE94";
    Rgb::_cname["SeaGreen3"] = "#43CD80";
    Rgb::_cname["SeaGreen4"] = "#2E8B57";
    Rgb::_cname["PaleGreen1"] = "#9AFF9A";
    Rgb::_cname["PaleGreen2"] = "#90EE90";
    Rgb::_cname["PaleGreen3"] = "#7CCD7C";
    Rgb::_cname["PaleGreen4"] = "#548B54";
    Rgb::_cname["SpringGreen1"] = "#00FF7F";
    Rgb::_cname["SpringGreen2"] = "#00EE76";
    Rgb::_cname["SpringGreen3"] = "#00CD66";
    Rgb::_cname["SpringGreen4"] = "#008B45";
    Rgb::_cname["green1"] = "#00FF00";
    Rgb::_cname["green2"] = "#00EE00";
    Rgb::_cname["green3"] = "#00CD00";
    Rgb::_cname["green4"] = "#008B00";
    Rgb::_cname["chartreuse1"] = "#7FFF00";
    Rgb::_cname["chartreuse2"] = "#76EE00";
    Rgb::_cname["chartreuse3"] = "#66CD00";
    Rgb::_cname["chartreuse4"] = "#458B00";
    Rgb::_cname["OliveDrab1"] = "#C0FF3E";
    Rgb::_cname["OliveDrab2"] = "#B3EE3A";
    Rgb::_cname["OliveDrab3"] = "#9ACD32";
    Rgb::_cname["OliveDrab4"] = "#698B22";
    Rgb::_cname["DarkOliveGreen1"] = "#CAFF70";
    Rgb::_cname["DarkOliveGreen2"] = "#BCEE68";
    Rgb::_cname["DarkOliveGreen3"] = "#A2CD5A";
    Rgb::_cname["DarkOliveGreen4"] = "#6E8B3D";
    Rgb::_cname["khaki1"] = "#FFF68F";
    Rgb::_cname["khaki2"] = "#EEE685";
    Rgb::_cname["khaki3"] = "#CDC673";
    Rgb::_cname["khaki4"] = "#8B864E";
    Rgb::_cname["LightGoldenrod1"] = "#FFEC8B";
    Rgb::_cname["LightGoldenrod2"] = "#EEDC82";
    Rgb::_cname["LightGoldenrod3"] = "#CDBE70";
    Rgb::_cname["LightGoldenrod4"] = "#8B814C";
    Rgb::_cname["LightYellow1"] = "#FFFFE0";
    Rgb::_cname["LightYellow2"] = "#EEEED1";
    Rgb::_cname["LightYellow3"] = "#CDCDB4";
    Rgb::_cname["LightYellow4"] = "#8B8B7A";
    Rgb::_cname["yellow1"] = "#FFFF00";
    Rgb::_cname["yellow2"] = "#EEEE00";
    Rgb::_cname["yellow3"] = "#CDCD00";
    Rgb::_cname["yellow4"] = "#8B8B00";
    Rgb::_cname["gold1"] = "#FFD700";
    Rgb::_cname["gold2"] = "#EEC900";
    Rgb::_cname["gold3"] = "#CDAD00";
    Rgb::_cname["gold4"] = "#8B7500";
    Rgb::_cname["goldenrod1"] = "#FFC125";
    Rgb::_cname["goldenrod2"] = "#EEB422";
    Rgb::_cname["goldenrod3"] = "#CD9B1D";
    Rgb::_cname["goldenrod4"] = "#8B6914";
    Rgb::_cname["DarkGoldenrod1"] = "#FFB90F";
    Rgb::_cname["DarkGoldenrod2"] = "#EEAD0E";
    Rgb::_cname["DarkGoldenrod3"] = "#CD950C";
    Rgb::_cname["DarkGoldenrod4"] = "#8B6508";
    Rgb::_cname["RosyBrown1"] = "#FFC1C1";
    Rgb::_cname["RosyBrown2"] = "#EEB4B4";
    Rgb::_cname["RosyBrown3"] = "#CD9B9B";
    Rgb::_cname["RosyBrown4"] = "#8B6969";
    Rgb::_cname["IndianRed1"] = "#FF6A6A";
    Rgb::_cname["IndianRed2"] = "#EE6363";
    Rgb::_cname["IndianRed3"] = "#CD5555";
    Rgb::_cname["IndianRed4"] = "#8B3A3A";
    Rgb::_cname["sienna1"] = "#FF8247";
    Rgb::_cname["sienna2"] = "#EE7942";
    Rgb::_cname["sienna3"] = "#CD6839";
    Rgb::_cname["sienna4"] = "#8B4726";
    Rgb::_cname["burlywood1"] = "#FFD39B";
    Rgb::_cname["burlywood2"] = "#EEC591";
    Rgb::_cname["burlywood3"] = "#CDAA7D";
    Rgb::_cname["burlywood4"] = "#8B7355";
    Rgb::_cname["wheat1"] = "#FFE7BA";
    Rgb::_cname["wheat2"] = "#EED8AE";
    Rgb::_cname["wheat3"] = "#CDBA96";
    Rgb::_cname["wheat4"] = "#8B7E66";
    Rgb::_cname["tan1"] = "#FFA54F";
    Rgb::_cname["tan2"] = "#EE9A49";
    Rgb::_cname["tan3"] = "#CD853F";
    Rgb::_cname["tan4"] = "#8B5A2B";
    Rgb::_cname["chocolate1"] = "#FF7F24";
    Rgb::_cname["chocolate2"] = "#EE7621";
    Rgb::_cname["chocolate3"] = "#CD661D";
    Rgb::_cname["chocolate4"] = "#8B4513";
    Rgb::_cname["firebrick1"] = "#FF3030";
    Rgb::_cname["firebrick2"] = "#EE2C2C";
    Rgb::_cname["firebrick3"] = "#CD2626";
    Rgb::_cname["firebrick4"] = "#8B1A1A";
    Rgb::_cname["brown1"] = "#FF4040";
    Rgb::_cname["brown2"] = "#EE3B3B";
    Rgb::_cname["brown3"] = "#CD3333";
    Rgb::_cname["brown4"] = "#8B2323";
    Rgb::_cname["salmon1"] = "#FF8C69";
    Rgb::_cname["salmon2"] = "#EE8262";
    Rgb::_cname["salmon3"] = "#CD7054";
    Rgb::_cname["salmon4"] = "#8B4C39";
    Rgb::_cname["LightSalmon1"] = "#FFA07A";
    Rgb::_cname["LightSalmon2"] = "#EE9572";
    Rgb::_cname["LightSalmon3"] = "#CD8162";
    Rgb::_cname["LightSalmon4"] = "#8B5742";
    Rgb::_cname["orange1"] = "#FFA500";
    Rgb::_cname["orange2"] = "#EE9A00";
    Rgb::_cname["orange3"] = "#CD8500";
    Rgb::_cname["orange4"] = "#8B5A00";
    Rgb::_cname["DarkOrange1"] = "#FF7F00";
    Rgb::_cname["DarkOrange2"] = "#EE7600";
    Rgb::_cname["DarkOrange3"] = "#CD6600";
    Rgb::_cname["DarkOrange4"] = "#8B4500";
    Rgb::_cname["coral1"] = "#FF7256";
    Rgb::_cname["coral2"] = "#EE6A50";
    Rgb::_cname["coral3"] = "#CD5B45";
    Rgb::_cname["coral4"] = "#8B3E2F";
    Rgb::_cname["tomato1"] = "#FF6347";
    Rgb::_cname["tomato2"] = "#EE5C42";
    Rgb::_cname["tomato3"] = "#CD4F39";
    Rgb::_cname["tomato4"] = "#8B3626";
    Rgb::_cname["OrangeRed1"] = "#FF4500";
    Rgb::_cname["OrangeRed2"] = "#EE4000";
    Rgb::_cname["OrangeRed3"] = "#CD3700";
    Rgb::_cname["OrangeRed4"] = "#8B2500";
    Rgb::_cname["red1"] = "#FF0000";
    Rgb::_cname["red2"] = "#EE0000";
    Rgb::_cname["red3"] = "#CD0000";
    Rgb::_cname["red4"] = "#8B0000";
    Rgb::_cname["DeepPink1"] = "#FF1493";
    Rgb::_cname["DeepPink2"] = "#EE1289";
    Rgb::_cname["DeepPink3"] = "#CD1076";
    Rgb::_cname["DeepPink4"] = "#8B0A50";
    Rgb::_cname["HotPink1"] = "#FF6EB4";
    Rgb::_cname["HotPink2"] = "#EE6AA7";
    Rgb::_cname["HotPink3"] = "#CD6090";
    Rgb::_cname["HotPink4"] = "#8B3A62";
    Rgb::_cname["pink1"] = "#FFB5C5";
    Rgb::_cname["pink2"] = "#EEA9B8";
    Rgb::_cname["pink3"] = "#CD919E";
    Rgb::_cname["pink4"] = "#8B636C";
    Rgb::_cname["LightPink1"] = "#FFAEB9";
    Rgb::_cname["LightPink2"] = "#EEA2AD";
    Rgb::_cname["LightPink3"] = "#CD8C95";
    Rgb::_cname["LightPink4"] = "#8B5F65";
    Rgb::_cname["PaleVioletRed1"] = "#FF82AB";
    Rgb::_cname["PaleVioletRed2"] = "#EE799F";
    Rgb::_cname["PaleVioletRed3"] = "#CD6889";
    Rgb::_cname["PaleVioletRed4"] = "#8B475D";
    Rgb::_cname["maroon1"] = "#FF34B3";
    Rgb::_cname["maroon2"] = "#EE30A7";
    Rgb::_cname["maroon3"] = "#CD2990";
    Rgb::_cname["maroon4"] = "#8B1C62";
    Rgb::_cname["VioletRed1"] = "#FF3E96";
    Rgb::_cname["VioletRed2"] = "#EE3A8C";
    Rgb::_cname["VioletRed3"] = "#CD3278";
    Rgb::_cname["VioletRed4"] = "#8B2252";
    Rgb::_cname["magenta1"] = "#FF00FF";
    Rgb::_cname["magenta2"] = "#EE00EE";
    Rgb::_cname["magenta3"] = "#CD00CD";
    Rgb::_cname["magenta4"] = "#8B008B";
    Rgb::_cname["orchid1"] = "#FF83FA";
    Rgb::_cname["orchid2"] = "#EE7AE9";
    Rgb::_cname["orchid3"] = "#CD69C9";
    Rgb::_cname["orchid4"] = "#8B4789";
    Rgb::_cname["plum1"] = "#FFBBFF";
    Rgb::_cname["plum2"] = "#EEAEEE";
    Rgb::_cname["plum3"] = "#CD96CD";
    Rgb::_cname["plum4"] = "#8B668B";
    Rgb::_cname["MediumOrchid1"] = "#E066FF";
    Rgb::_cname["MediumOrchid2"] = "#D15FEE";
    Rgb::_cname["MediumOrchid3"] = "#B452CD";
    Rgb::_cname["MediumOrchid4"] = "#7A378B";
    Rgb::_cname["DarkOrchid1"] = "#BF3EFF";
    Rgb::_cname["DarkOrchid2"] = "#B23AEE";
    Rgb::_cname["DarkOrchid3"] = "#9A32CD";
    Rgb::_cname["DarkOrchid4"] = "#68228B";
    Rgb::_cname["purple1"] = "#9B30FF";
    Rgb::_cname["purple2"] = "#912CEE";
    Rgb::_cname["purple3"] = "#7D26CD";
    Rgb::_cname["purple4"] = "#551A8B";
    Rgb::_cname["MediumPurple1"] = "#AB82FF";
    Rgb::_cname["MediumPurple2"] = "#9F79EE";
    Rgb::_cname["MediumPurple3"] = "#8968CD";
    Rgb::_cname["MediumPurple4"] = "#5D478B";
    Rgb::_cname["thistle1"] = "#FFE1FF";
    Rgb::_cname["thistle2"] = "#EED2EE";
    Rgb::_cname["thistle3"] = "#CDB5CD";
    Rgb::_cname["thistle4"] = "#8B7B8B";
    Rgb::_cname["gray0"] = "#000000";
    Rgb::_cname["grey0"] = "#000000";
    Rgb::_cname["gray1"] = "#030303";
    Rgb::_cname["grey1"] = "#030303";
    Rgb::_cname["gray2"] = "#050505";
    Rgb::_cname["grey2"] = "#050505";
    Rgb::_cname["gray3"] = "#080808";
    Rgb::_cname["grey3"] = "#080808";
    Rgb::_cname["gray4"] = "#0A0A0A";
    Rgb::_cname["grey4"] = "#0A0A0A";
    Rgb::_cname["gray5"] = "#0D0D0D";
    Rgb::_cname["grey5"] = "#0D0D0D";
    Rgb::_cname["gray6"] = "#0F0F0F";
    Rgb::_cname["grey6"] = "#0F0F0F";
    Rgb::_cname["gray7"] = "#121212";
    Rgb::_cname["grey7"] = "#121212";
    Rgb::_cname["gray8"] = "#141414";
    Rgb::_cname["grey8"] = "#141414";
    Rgb::_cname["gray9"] = "#171717";
    Rgb::_cname["grey9"] = "#171717";
    Rgb::_cname["gray10"] = "#1A1A1A";
    Rgb::_cname["grey10"] = "#1A1A1A";
    Rgb::_cname["gray11"] = "#1C1C1C";
    Rgb::_cname["grey11"] = "#1C1C1C";
    Rgb::_cname["gray12"] = "#1F1F1F";
    Rgb::_cname["grey12"] = "#1F1F1F";
    Rgb::_cname["gray13"] = "#212121";
    Rgb::_cname["grey13"] = "#212121";
    Rgb::_cname["gray14"] = "#242424";
    Rgb::_cname["grey14"] = "#242424";
    Rgb::_cname["gray15"] = "#262626";
    Rgb::_cname["grey15"] = "#262626";
    Rgb::_cname["gray16"] = "#292929";
    Rgb::_cname["grey16"] = "#292929";
    Rgb::_cname["gray17"] = "#2B2B2B";
    Rgb::_cname["grey17"] = "#2B2B2B";
    Rgb::_cname["gray18"] = "#2E2E2E";
    Rgb::_cname["grey18"] = "#2E2E2E";
    Rgb::_cname["gray19"] = "#303030";
    Rgb::_cname["grey19"] = "#303030";
    Rgb::_cname["gray20"] = "#333333";
    Rgb::_cname["grey20"] = "#333333";
    Rgb::_cname["gray21"] = "#363636";
    Rgb::_cname["grey21"] = "#363636";
    Rgb::_cname["gray22"] = "#383838";
    Rgb::_cname["grey22"] = "#383838";
    Rgb::_cname["gray23"] = "#3B3B3B";
    Rgb::_cname["grey23"] = "#3B3B3B";
    Rgb::_cname["gray24"] = "#3D3D3D";
    Rgb::_cname["grey24"] = "#3D3D3D";
    Rgb::_cname["gray25"] = "#404040";
    Rgb::_cname["grey25"] = "#404040";
    Rgb::_cname["gray26"] = "#424242";
    Rgb::_cname["grey26"] = "#424242";
    Rgb::_cname["gray27"] = "#454545";
    Rgb::_cname["grey27"] = "#454545";
    Rgb::_cname["gray28"] = "#474747";
    Rgb::_cname["grey28"] = "#474747";
    Rgb::_cname["gray29"] = "#4A4A4A";
    Rgb::_cname["grey29"] = "#4A4A4A";
    Rgb::_cname["gray30"] = "#4D4D4D";
    Rgb::_cname["grey30"] = "#4D4D4D";
    Rgb::_cname["gray31"] = "#4F4F4F";
    Rgb::_cname["grey31"] = "#4F4F4F";
    Rgb::_cname["gray32"] = "#525252";
    Rgb::_cname["grey32"] = "#525252";
    Rgb::_cname["gray33"] = "#545454";
    Rgb::_cname["grey33"] = "#545454";
    Rgb::_cname["gray34"] = "#575757";
    Rgb::_cname["grey34"] = "#575757";
    Rgb::_cname["gray35"] = "#595959";
    Rgb::_cname["grey35"] = "#595959";
    Rgb::_cname["gray36"] = "#5C5C5C";
    Rgb::_cname["grey36"] = "#5C5C5C";
    Rgb::_cname["gray37"] = "#5E5E5E";
    Rgb::_cname["grey37"] = "#5E5E5E";
    Rgb::_cname["gray38"] = "#616161";
    Rgb::_cname["grey38"] = "#616161";
    Rgb::_cname["gray39"] = "#636363";
    Rgb::_cname["grey39"] = "#636363";
    Rgb::_cname["gray40"] = "#666666";
    Rgb::_cname["grey40"] = "#666666";
    Rgb::_cname["gray41"] = "#696969";
    Rgb::_cname["grey41"] = "#696969";
    Rgb::_cname["gray42"] = "#6B6B6B";
    Rgb::_cname["grey42"] = "#6B6B6B";
    Rgb::_cname["gray43"] = "#6E6E6E";
    Rgb::_cname["grey43"] = "#6E6E6E";
    Rgb::_cname["gray44"] = "#707070";
    Rgb::_cname["grey44"] = "#707070";
    Rgb::_cname["gray45"] = "#737373";
    Rgb::_cname["grey45"] = "#737373";
    Rgb::_cname["gray46"] = "#757575";
    Rgb::_cname["grey46"] = "#757575";
    Rgb::_cname["gray47"] = "#787878";
    Rgb::_cname["grey47"] = "#787878";
    Rgb::_cname["gray48"] = "#7A7A7A";
    Rgb::_cname["grey48"] = "#7A7A7A";
    Rgb::_cname["gray49"] = "#7D7D7D";
    Rgb::_cname["grey49"] = "#7D7D7D";
    Rgb::_cname["gray50"] = "#7F7F7F";
    Rgb::_cname["grey50"] = "#7F7F7F";
    Rgb::_cname["gray51"] = "#828282";
    Rgb::_cname["grey51"] = "#828282";
    Rgb::_cname["gray52"] = "#858585";
    Rgb::_cname["grey52"] = "#858585";
    Rgb::_cname["gray53"] = "#878787";
    Rgb::_cname["grey53"] = "#878787";
    Rgb::_cname["gray54"] = "#8A8A8A";
    Rgb::_cname["grey54"] = "#8A8A8A";
    Rgb::_cname["gray55"] = "#8C8C8C";
    Rgb::_cname["grey55"] = "#8C8C8C";
    Rgb::_cname["gray56"] = "#8F8F8F";
    Rgb::_cname["grey56"] = "#8F8F8F";
    Rgb::_cname["gray57"] = "#919191";
    Rgb::_cname["grey57"] = "#919191";
    Rgb::_cname["gray58"] = "#949494";
    Rgb::_cname["grey58"] = "#949494";
    Rgb::_cname["gray59"] = "#969696";
    Rgb::_cname["grey59"] = "#969696";
    Rgb::_cname["gray60"] = "#999999";
    Rgb::_cname["grey60"] = "#999999";
    Rgb::_cname["gray61"] = "#9C9C9C";
    Rgb::_cname["grey61"] = "#9C9C9C";
    Rgb::_cname["gray62"] = "#9E9E9E";
    Rgb::_cname["grey62"] = "#9E9E9E";
    Rgb::_cname["gray63"] = "#A1A1A1";
    Rgb::_cname["grey63"] = "#A1A1A1";
    Rgb::_cname["gray64"] = "#A3A3A3";
    Rgb::_cname["grey64"] = "#A3A3A3";
    Rgb::_cname["gray65"] = "#A6A6A6";
    Rgb::_cname["grey65"] = "#A6A6A6";
    Rgb::_cname["gray66"] = "#A8A8A8";
    Rgb::_cname["grey66"] = "#A8A8A8";
    Rgb::_cname["gray67"] = "#ABABAB";
    Rgb::_cname["grey67"] = "#ABABAB";
    Rgb::_cname["gray68"] = "#ADADAD";
    Rgb::_cname["grey68"] = "#ADADAD";
    Rgb::_cname["gray69"] = "#B0B0B0";
    Rgb::_cname["grey69"] = "#B0B0B0";
    Rgb::_cname["gray70"] = "#B3B3B3";
    Rgb::_cname["grey70"] = "#B3B3B3";
    Rgb::_cname["gray71"] = "#B5B5B5";
    Rgb::_cname["grey71"] = "#B5B5B5";
    Rgb::_cname["gray72"] = "#B8B8B8";
    Rgb::_cname["grey72"] = "#B8B8B8";
    Rgb::_cname["gray73"] = "#BABABA";
    Rgb::_cname["grey73"] = "#BABABA";
    Rgb::_cname["gray74"] = "#BDBDBD";
    Rgb::_cname["grey74"] = "#BDBDBD";
    Rgb::_cname["gray75"] = "#BFBFBF";
    Rgb::_cname["grey75"] = "#BFBFBF";
    Rgb::_cname["gray76"] = "#C2C2C2";
    Rgb::_cname["grey76"] = "#C2C2C2";
    Rgb::_cname["gray77"] = "#C4C4C4";
    Rgb::_cname["grey77"] = "#C4C4C4";
    Rgb::_cname["gray78"] = "#C7C7C7";
    Rgb::_cname["grey78"] = "#C7C7C7";
    Rgb::_cname["gray79"] = "#C9C9C9";
    Rgb::_cname["grey79"] = "#C9C9C9";
    Rgb::_cname["gray80"] = "#CCCCCC";
    Rgb::_cname["grey80"] = "#CCCCCC";
    Rgb::_cname["gray81"] = "#CFCFCF";
    Rgb::_cname["grey81"] = "#CFCFCF";
    Rgb::_cname["gray82"] = "#D1D1D1";
    Rgb::_cname["grey82"] = "#D1D1D1";
    Rgb::_cname["gray83"] = "#D4D4D4";
    Rgb::_cname["grey83"] = "#D4D4D4";
    Rgb::_cname["gray84"] = "#D6D6D6";
    Rgb::_cname["grey84"] = "#D6D6D6";
    Rgb::_cname["gray85"] = "#D9D9D9";
    Rgb::_cname["grey85"] = "#D9D9D9";
    Rgb::_cname["gray86"] = "#DBDBDB";
    Rgb::_cname["grey86"] = "#DBDBDB";
    Rgb::_cname["gray87"] = "#DEDEDE";
    Rgb::_cname["grey87"] = "#DEDEDE";
    Rgb::_cname["gray88"] = "#E0E0E0";
    Rgb::_cname["grey88"] = "#E0E0E0";
    Rgb::_cname["gray89"] = "#E3E3E3";
    Rgb::_cname["grey89"] = "#E3E3E3";
    Rgb::_cname["gray90"] = "#E5E5E5";
    Rgb::_cname["grey90"] = "#E5E5E5";
    Rgb::_cname["gray91"] = "#E8E8E8";
    Rgb::_cname["grey91"] = "#E8E8E8";
    Rgb::_cname["gray92"] = "#EBEBEB";
    Rgb::_cname["grey92"] = "#EBEBEB";
    Rgb::_cname["gray93"] = "#EDEDED";
    Rgb::_cname["grey93"] = "#EDEDED";
    Rgb::_cname["gray94"] = "#F0F0F0";
    Rgb::_cname["grey94"] = "#F0F0F0";
    Rgb::_cname["gray95"] = "#F2F2F2";
    Rgb::_cname["grey95"] = "#F2F2F2";
    Rgb::_cname["gray96"] = "#F5F5F5";
    Rgb::_cname["grey96"] = "#F5F5F5";
    Rgb::_cname["gray97"] = "#F7F7F7";
    Rgb::_cname["grey97"] = "#F7F7F7";
    Rgb::_cname["gray98"] = "#FAFAFA";
    Rgb::_cname["grey98"] = "#FAFAFA";
    Rgb::_cname["gray99"] = "#FCFCFC";
    Rgb::_cname["grey99"] = "#FCFCFC";
    Rgb::_cname["gray100"] = "#FFFFFF";
    Rgb::_cname["grey100"] = "#FFFFFF";
    Rgb::_cname["dark grey"] = "#A9A9A9";
    Rgb::_cname["DarkGrey"] = "#A9A9A9";
    Rgb::_cname["dark gray"] = "#A9A9A9";
    Rgb::_cname["DarkGray"] = "#A9A9A9";
    Rgb::_cname["dark blue"] = "#00008B";
    Rgb::_cname["DarkBlue"] = "#00008B";
    Rgb::_cname["dark cyan"] = "#008B8B";
    Rgb::_cname["DarkCyan"] = "#008B8B";
    Rgb::_cname["dark magenta"] = "#8B008B";
    Rgb::_cname["DarkMagenta"] = "#8B008B";
    Rgb::_cname["dark red"] = "#8B0000";
    Rgb::_cname["DarkRed"] = "#8B0000";
    Rgb::_cname["light green"] = "#90EE90";
    Rgb::_cname["LightGreen"] = "#90EE90";
    return true;
}

bool Rgb::isValid() {
    if (_hex.length() != 6) {
        return false;
    } else {
        if (_hex.find_first_not_of(_allowedChars) != _hex.npos) {
            return false;
        } else {
            return true;
        }
    }
}

void Rgb::set(std::string prm_str_color) {
    _hex = prm_str_color;
    if (_hex[0] == '#') {
        _hex.erase(_hex.begin());
    }
    _is_valid = isValid();
    if (_is_valid) {
        _red = UTIL::hex2dec(_hex.substr(0, 2));
        _green = UTIL::hex2dec(_hex.substr(2, 2));
        _blue = UTIL::hex2dec(_hex.substr(4, 2));
        _r = _red * 0.00392157f; // 0.00392157f = 1.0f / 255.0f i255Ŋ̂Ɠ)
        _g = _green * 0.00392157f;
        _b = _blue * 0.00392157f;
    } else {
        if (Rgb::_cname.find(prm_str_color) == Rgb::_cname.end()) {
            throwCriticalException("HEXl(F)RGBɕϊo܂Bprm_str_color="<<prm_str_color);
        } else {
            _hex = Rgb::_cname[prm_str_color];
            if (_hex[0] == '#') {
                _hex.erase(_hex.begin());
            }
            _is_valid = true;
            _red = UTIL::hex2dec(_hex.substr(0, 2));
            _green = UTIL::hex2dec(_hex.substr(2, 2));
            _blue = UTIL::hex2dec(_hex.substr(4, 2));
            _r = _red * 0.00392157f; // 0.00392157f = 1.0f / 255.0f i255Ŋ̂Ɠ)
            _g = _green * 0.00392157f;
            _b = _blue * 0.00392157f;
        }

    }
}

std::string Rgb::toStr() {
    std::ostringstream oss;
    oss << "#" << UTIL::dec2hex(_red,2) <<
                  UTIL::dec2hex(_green,2) <<
                  UTIL::dec2hex(_blue,2);
    return oss.str();
}
