#include "jp/ggaf/core/actor/ex/TreeFormation.h"

#include "jp/ggaf/core/actor/SceneMediator.h"
#include "jp/ggaf/core/actor/GroupHead.h"
#include "jp/ggaf/core/util/Status.h"

using namespace GgafCore;

TreeFormation::TreeFormation(const char* prm_name, frame prm_offset_frames_end) :
        Formation(prm_name, prm_offset_frames_end)
{
    _class_name = "TreeFormation";
    _pIte = nullptr;
    _can_called_up = true;
    _is_append_member_experienced = false;
}

void TreeFormation::appendFormationMember(Actor* prm_pChild) {
#ifdef MY_DEBUG
    if (wasDeclaredEnd()) {
        //I҂̂
        _TRACE_("x TreeFormation::appendChild("<<NODE_INFO_P(prm_pChild)<<") Ɏɂ䂭߂FormationłBqɒǉ邱Ƃ͂̂ł͂ȂĤHBthis="<<NODE_INFO);
    }
#endif
    _num_formation_member++;
    if (_pChildFirst == nullptr) {
        //cɎʂ𐳂`邽߂ɁAǉ̎ʂAg̎ʂɏ㏑iTreeFormationj
        kind_t kind = prm_pChild->getDefaultKind();
        getStatus()->set(STAT_DEFAULT_ACTOR_KIND, kind);
        //o[ TreeFormation AappendGroupChild  appendFormationMember sꍇA
        //܂o[ TreeFormation AappendGroupChild ́A=0Ȃ̂ŁA쐬ꂽc̎ʂ0ō쐬Ă܂B
        //̌appendFormationMembersĂA0ɑĂ܂Ƃ肪LB
        //ŁAc̎0ꍇAʂ𖳗XVB
        GroupHead* myGroupHead = getGroupHead(); //c
        if (myGroupHead) {
            //ɏĂ܂ĂBiV[ɑĂj
            if (myGroupHead->_kind == kind) {
                //Aʂɐ̂ŖȂB
            } else {
                //ʂςĂB̒c̎ʂ𖳗ύXł邩H
                if (myGroupHead->_kind == 0) {
                    //0̂Ŗc̎ʂĂ܂B
                    _TRACE_(FUNC_NAME<<" "<<NODE_INFO<<" ́Aςݒc̎(g̎)"<<myGroupHead->_kind<<"ƁAǉo[̎"<<kind<<"قȂ܂B\n"
                            "KɂAcʂ 0 ̂ŁAXV܂Bc="<<myGroupHead->_kind<<"  Vc="<<kind<<"");
                    myGroupHead->setKind(kind);
                } else {
                    _TRACE_(FUNC_NAME<<" "<<NODE_INFO<<" ́Aςݒc̎(g̎)"<<myGroupHead->_kind<<"ƁAǉo[̎"<<kind<<"قȂ܂B");
                    _TRACE_("ςݒcz̏Ԃ͈ȉł");
                    myGroupHead->dump();
                    throwCriticalException(NODE_INFO<<" ́Aςݒc̎(g̎)"<<myGroupHead->_kind<<"ƁAǉo[̎"<<kind<<"قȂ܂B");
                }
            }
        } else {
            //cȂV[ɂ͖Ȃ̂ŁA
            //V[ɏɎg̎ʂŒc쐬̂ł悵B
        }
    } else {
#ifdef MY_DEBUG
        if (getDefaultKind() != prm_pChild->getDefaultKind()) {
            throwCriticalException("قȂʂ̃AN^[o^悤ƂĂ܂B \n"
                                       "z="<<getDefaultKind()<<"[_pChildFirst="<<_pChildFirst->getName()<<"] \n"
                                       "="<<prm_pChild->getDefaultKind()<<"["<<prm_pChild->getName()<<"]");
        }
#endif
    }
    prm_pChild->_pFormation = this; //o[փtH[[Vݒ
    Formation::appendChild(prm_pChild);
    prm_pChild->inactivate(); //tH[[VȂ̂calledUp܂Ŕ񊈓B
    _is_append_member_experienced = true;
}

void TreeFormation::processFinal() {
    if (_was_all_sayonara || wasDeclaredEnd() || willInactivateAfter()) {
        //I҂̂
    } else {
        if (getChildFirst() == nullptr) {  //zȂꍇAtH[[V͂ȂƂɂȂAgIȁH
            if (_is_append_member_experienced) {
                onSayonaraAll(); //R[obN
                sayonara(_offset_frames_end);
                _was_all_sayonara = true;
            } else {
                //A܂appendFormationMember()oĂȂ̂ŏIȂB
                //TreeFormationƂĂ̖ʂ܂ł͎˂ȂB
            }
        }
    }
}

void TreeFormation::onEnd() {
    Formation::onEnd();
}

Actor* TreeFormation::calledUpMember(int prm_formation_child_num) {
    if (wasDeclaredEnd() || willInactivateAfter()) {
        //I҂̂
        return nullptr;
    }

    if (_can_called_up) {
        if (_pIte) {
            //ȍ~ next
            _pIte = _pIte->getNext();
        } else {
            //͎q擪
            _pIte = getChildFirst();
            if (!_pIte) {
                //o[ǉĂȂ
                _TRACE_("x TreeFormation::calledUpMember() o[ǉĂ܂B̂ł́HBthis="<<NODE_INFO);
                _can_called_up = false; //񂩂 calledUpMember() s
                _num_formation_member = 0;
                return nullptr;
            }
        }

        _num_called_up++;
        _pIte->activate();

        if (_pIte->getNext() == getChildFirst()) {
            //Ō̂P
            _can_called_up = false; //񂩂 calledUpMember() s
            _num_formation_member = _num_called_up; //destroyedFollower ґSŔ̈׍Đݒ
        }
        if (prm_formation_child_num <= _num_called_up) {
            //ɒB
            _can_called_up = false; //񂩂 calledUpMember() s
            _num_formation_member = _num_called_up; //destroyedFollower ґSŔ̈׍Đݒ
        }

        return _pIte;
    } else {
        return nullptr;
    }
}

TreeFormation::~TreeFormation() {

}
