#include "jp/ggaf/core/actor/ex/ActorDepository.h"

#include "jp/ggaf/core/util/Status.h"

using namespace GgafCore;

ActorDepository::ActorDepository(const char* prm_name) : DestructActor(prm_name) {
    _obj_class |= Obj_ggaf_ActorDepository;
    _class_name = "ActorDepository";
    setHitAble(false);
}

void ActorDepository::put(Actor* prm_pChild) {
    if (_pChildFirst == nullptr) {
        //ʂp
        getStatus()->set(STAT_DEFAULT_ACTOR_KIND, prm_pChild->getDefaultKind());
    } else {
#ifdef MY_DEBUG
        if (getDefaultKind() != prm_pChild->getDefaultKind()) {
            throwCriticalException("قȂʂ̃AN^[o^悤ƂĂ܂B \n"
                                       "z="<<getDefaultKind()<<"[_pChildFirst="<<_pChildFirst->getName()<<"] \n"
                                       "="<<prm_pChild->getDefaultKind()<<"["<<prm_pChild->getName()<<"]");
        }
#endif
    }
    prm_pChild->_pDependenceDepository = this;
    prm_pChild->inactivate(); //񊈓ɁB
    DestructActor::appendChild(prm_pChild);
}

void ActorDepository::onReset() {
    _TRACE_(FUNC_NAME<<" "<<NODE_INFO<<"");
    if (_pChildFirst == nullptr) {
        return;
    }
    //ActorDepository ̃ZbǵAzSĔ񊈓ԂƂA
    //ʏAN^[̏t[ŊԂƂȂ邱Ƃ}邽߂
    //_frame_of_life_when_activation = 0 ݒ
    Actor* pActor = getChildFirst();
    while (pActor) {
        if (pActor->isActive()) {
            //TODO:EEEƔY݂ǂȀׂH
            pActor->inactivateImmed();
            pActor->onInactive();
        } else {
            //inactive Ɠt[A܂ inactive \ active \肪Ă
            //inactivate() ̎sɂÂق̂ŋ񊈓ƂȂB
            pActor->inactivate();
        }
        pActor->reset(); //Zbg
        if (pActor->isLast()) {
            break;
        } else {
            pActor = pActor->getNext();
            continue;
        }
    }
}

void ActorDepository::end(frame prm_offset_frames) {
    frame end_frame_delay = prm_offset_frames + (_child_num*2) + 1; //o[ɏx点B
    //end()sς݂̏ꍇA葁end()ȂΗLƂ
    if (_frame_of_life < _frame_of_life_when_end &&
                         _frame_of_life_when_end < _frame_of_life + end_frame_delay + GGAF_END_DELAY) {
        //end()sς݂łAɍŵ _frame_of_life_when_end ɓB邽ߖB
        return;
    }
    _frame_of_life_when_end = _frame_of_life + end_frame_delay + GGAF_END_DELAY;
    inactivateDelay(prm_offset_frames); //wt[ɂinactivateŝ͓

    Actor* pElementTemp = _pChildFirst;
    while (pElementTemp) {
        end_frame_delay -= 2;
        pElementTemp->end(end_frame_delay);
        if (pElementTemp->_is_last_flg) {
            break;
        } else {
            pElementTemp = pElementTemp->_pNext;
        }
    }
}

//œKā
//TODO:ActorDepositorýAGroupHeadpāA
//ʂGroupHeadƂɂ΃AN^[̐点̂ł͂Ȃ
//ꍇɂ肯肩AƂōlB
