#include "jp/ggaf/core/actor/SceneMediator.h"

#include "jp/ggaf/core/scene/Scene.h"
#include "jp/ggaf/core/actor/MainActor.h"
#include "jp/ggaf/core/actor/GroupHead.h"
#include "jp/ggaf/core/util/Status.h"

using namespace GgafCore;

SceneMediator::SceneMediator(Scene* prm_pScene_platform) : Actor("SceneMediator"),
_pScene_platform(nullptr)
{
    _obj_class |= Obj_ggaf_SceneMediator;
    _class_name = "SceneMediator";
    _pScene_platform = prm_pScene_platform;
    setHitAble(false);
}

void SceneMediator::throwEventUpperTree(hashval prm_no, void* prm_pSource) {
    Scene* s = getPlatformScene();
    if (s) {
        s->throwEventUpperTree(prm_no, this); //ʂ͋ȂBŏV[֓
    }
}

void SceneMediator::remove() {
    throwCriticalException("Error! SceneMediatorremove()ɂč폜͍s܂I");
}

GroupHead* SceneMediator::appendGroupChild(kind_t prm_kind, MainActor* prm_pMainActor) {
    if (prm_pMainActor->_pSceneMediator) {
        throwCriticalException("Error! SceneMediator::appendGroupChild ς݂𖳗ړ悤ƂĂ܂B\n"
                " extract() sĂoȂłH prm_pMainActor="<<NODE_INFO_P(prm_pMainActor)<<"/this="<<NODE_INFO);
    }
    GroupHead* pChildGroupActor = searchChildGroupHead(prm_kind); //qɓʒc邩T
    if (!pChildGroupActor) {
        //qɓʒcȂꍇAcVɍ쐬
        pChildGroupActor = NEW GroupHead(prm_kind);
        appendChild(pChildGroupActor);
        pChildGroupActor->setSceneMediator(this);
    }
    pChildGroupActor->appendChild(prm_pMainActor);
    prm_pMainActor->setGroupHead(pChildGroupActor);
    prm_pMainActor->setSceneMediator(this);
    return pChildGroupActor;
}

GroupHead* SceneMediator::appendGroupChild(MainActor* prm_pMainActor) {
    return appendGroupChild(prm_pMainActor->getDefaultKind(), prm_pMainActor);
}

GroupHead* SceneMediator::searchChildGroupHead(kind_t prm_kind) {
    if (_pChildFirst == nullptr) {
        return nullptr;
    } else {
        Actor* pChildActor = _pChildFirst;
        GroupHead* pChildGroupHead_ret = nullptr;
        do {
            if (pChildActor->instanceOf(Obj_ggaf_GroupHead)) {
                pChildGroupHead_ret = (GroupHead*)pChildActor;
                if (pChildGroupHead_ret->_kind == prm_kind && pChildGroupHead_ret->_frame_of_life_when_end == 0) {
                    return pChildGroupHead_ret;
                }
            }
            if (pChildActor->_is_last_flg) {
                break;
            } else {
                pChildActor = pChildActor->_pNext;
            }
        } while (true);

        return nullptr;
    }
}

void SceneMediator::updateActiveInTheTree() {
    Scene* pPlatform = getPlatformScene();
    if (pPlatform) {
        if (pPlatform->_is_active_in_the_tree_flg) {
            _is_active_in_the_tree_flg = _is_active_flg;
        } else {
            _is_active_in_the_tree_flg = false;
        }
    } else {
        throwCriticalException("_is_active_in_the_tree_flg XVł܂B this="<<NODE_INFO);
    }
}

God* SceneMediator::askGod() {
    if (_pGod == nullptr) {
#ifdef MY_DEBUG
        if (getPlatformScene() == nullptr) {
            throwCriticalException("_͂̐ɑ݂镨̂݉ył܂B܂͂̐ɑȂII("<<getName()<<")");
        }
#endif
        _pGod = getPlatformScene()->askGod();
    }
    return _pGod;
}

Actor* SceneMediator::search(hashval prm_name_hash) {
    if (_pChildFirst == nullptr) {
        return nullptr;
    } else {
        Actor* pPrev = this;
        Actor* pCur = getChildFirst();

        while (pCur != this) {
            if (pCur->_name_hash == prm_name_hash) {
                return pCur; //܂
            } else {
                pPrev = pCur;
            }
            if (pPrev == pCur->getParent()) {
                //ォ~ėꍇ
                goto susume;
            } else if (pPrev == pCur->getPrev()) {
                //ɐiŗꍇ
                goto susume;
            } else {
                //オĂꍇ
                //E֍s݂
                if (pCur->_is_last_flg) {
                    //ƎvE[̂ŁAɖ߂
                    pCur = pCur->getParent();
                } else {
                    //E֍ŝŁAsI
                    pCur = pCur->getNext();
                }
                continue;
            }
susume:
            //~Ȃ΍~
            if (pCur->getChildFirst()) {
                pCur = pCur->getChildFirst();
            } else {
                //~Ȃꍇ͉E֍s݂
                if (pCur->_is_last_flg) {
                    //ƎvE[̂ŁAɖ߂
                    pCur = pCur->getParent();
                } else {
                    //E֍ŝŁAsI
                    pCur = pCur->getNext();
                }
            }
        }
        return nullptr;
    }
}
SceneMediator::~SceneMediator() {
}
