#include "jp/ggaf/core/God.h"

#include "jp/ggaf/core/exception/CriticalException.h"
#include "jp/ggaf/core/Cradle.h"
#include "jp/ggaf/core/GarbageBox.h"
#include "jp/ggaf/core/Config.h"
#include "jp/ggaf/core/scene/Spacetime.h"
#include "jp/ggaf/core/scene/DisusedScene.h"
#include "jp/ggaf/core/actor/DisusedActor.h"

#include <process.h>

using namespace GgafCore;

CRITICAL_SECTION God::CS1;
CRITICAL_SECTION God::CS2;
#ifdef MY_DEBUG
unsigned int God::_num_drawing = 0;
#endif
unsigned int God::_num_active_actor = 0;

God* God::_pGod = nullptr;

God::God() : Object(),
  _pSpacetime(nullptr),
  _fps(0.0) {
    God::_pGod = this;
    timeBeginPeriod(1);
    _frame_of_God = 0;
    _handle_god_love01 = (HANDLE)_beginthreadex(nullptr, 0, God::love, nullptr, CREATE_SUSPENDED, &_th_id01);

    if (_handle_god_love01 == 0) {
        throwCriticalException("Error! Xbh쐬sI");
    }
    ::InitializeCriticalSection(&(God::CS1));
    ::InitializeCriticalSection(&(God::CS2));
    ::ResumeThread(_handle_god_love01);
    ::SetThreadPriority(_handle_god_love01, THREAD_PRIORITY_IDLE);
    _time_at_beginning_frame = timeGetTime();
    _time_of_next_view = _time_at_beginning_frame;
    _time_calc_fps_next = _time_at_beginning_frame + 1;
    _visualize_frames = 0;
    _prev_visualize_frames = 0;
    _is_behaved_flg = false;
    _is_materialized_flg = false;
    GarbageBox::_pGarbageBox = NEW GarbageBox();
    _was_cleaned = false;
    _skip_count_of_frame = 0;
    _max_skip_frames = (int)CONFIG::MAX_SKIP_FRAME;
    _slowdown_mode = SLOWDOWN_MODE_DEFAULT;
    _sync_frame_time = false;
    _cnt_frame = 0;

    _pException_god = nullptr;
    _pCradleRoot = nullptr;
    _pCradleBlessing = nullptr;
    _is_loving_flg   = true;
    _have_to_rest_flg = false;
    _is_resting_flg   = false;
    _was_finished_flg = false;

    //_base_fps = CONFIG::FPS;
    _apaTime_offset_of_next_view[0] = getArrTimeOffset(1000, CONFIG::FPS);
    _apaTime_offset_of_next_view[1] = getArrTimeOffset(1500, CONFIG::FPS);
    _apaTime_offset_of_next_view[2] = getArrTimeOffset(2000, CONFIG::FPS);
    _aTime_offset_of_next_view[0] = 1.0 / CONFIG::FPS;
    _aTime_offset_of_next_view[1] = 1.5 / CONFIG::FPS;
    _aTime_offset_of_next_view[2] = 2.0 / CONFIG::FPS;
}


//void God::setSpacetimeFps(int prm_fps) {
//    GGAF_DELETEARR_NULLABLE(_apaTime_offset_of_next_view[0]);
//    GGAF_DELETEARR_NULLABLE(_apaTime_offset_of_next_view[1]);
//    GGAF_DELETEARR_NULLABLE(_apaTime_offset_of_next_view[2]);
//    _base_fps = prm_fps;
//    _apaTime_offset_of_next_view[0] = getArrTimeOffset(1000, _base_fps);
//    _apaTime_offset_of_next_view[1] = getArrTimeOffset(1500, _base_fps);
//    _apaTime_offset_of_next_view[2] = getArrTimeOffset(2000, _base_fps);
//    _aTime_offset_of_next_view[0] = 1.0 / _base_fps;
//    _aTime_offset_of_next_view[1] = 1.5 / _base_fps;
//    _aTime_offset_of_next_view[2] = 2.0 / _base_fps;
//}

DWORD* God::getArrTimeOffset(DWORD sec, DWORD fps) {
    DWORD base = sec / fps;
    DWORD r = sec % fps;
    double rr = 1.0*r / fps;
    DWORD* paTimeOffset = new DWORD[fps];
    double x = 1.0;

    for (int i = 0; i < fps; i++) {
        x += rr;
        if (x > 1.0) {
            paTimeOffset[i] = base + 1;
            x -= 1.0;
        } else {
            paTimeOffset[i] = base;
        }
    }
    return paTimeOffset;

}


void God::be() {

    // yz
    // PTCNiPt[j͈̏ȉ̗lɑ傫TɕAɎŝƂB
    //
    // @Mo = presentSpacetimeMoment();      CEK{
    // AJu = executeSpacetimeJudge();       菈EK{
    // BMa = makeSpacetimeMaterialize();    `揈(d)EXLbv
    // CVi = presentSpacetimeVisualize();   `tbvEXLbv(ABƇC̓Zbg)
    // DFi = finalizeSpacetime();           ŏIEK{
    //
    // ōsȂƂ́włACVi  1/60 bɈ肵Ďs邱ƁxƂB
    // ŁA̗lȐ݌vsB
    // E悸 CVi s^C~O\ߌ肷B́A@ɏdȂ낤ƂςȂB
    //    _time_of_next_view = _time_of_next_view + (1/60b)
    //   ƂB
    // EAJu s_ŁABMaACVi s邩ǂc_time_of_next_view ܂ł̎ԂŔfB
    //   Ԃɗ]TLꍇAAJu s㑦 BMa sǍ _time_of_next_view ܂ő҂ CVi sB
    //    AJu sAt[ɂ߂荞łꍇ BMaACVi ̓XLbvB
    // EL{[ƂA_max_skip_frames t[ɂP͕K BMaACVi sB
    //   ͂ǂȂɏdȂ낤ƂAvOĂ邱Ƃo邽߁B
    //
    //
    //y莞̗z}z
    //        _time_of_next_view                                              _time_of_next_view
    //                 |              3frame begin                                      |              4frame begin
    //                 |                   |                                            |                   |
    //                 v                   v                                            v                   v
    // ==================================================================================================================================================> 
    //  <--- wait ---> |(2f-CVi)| 2f-DFi | 3f-@Mo | 3f-AJu |(3f-BMa)|<--- wait --->|(3f-CVi)| 3f-DFi | 4f-@Mo | 4f-AJu |(4f-BMa)|<--- wait -
    //                 |                   |                                            |                   |
    // -- 2frame ------------------------->|<-------------------------- 3frame ---------------------------->|<----------------  4frame ---------
    //                 |                                                                |
    //                 |<----------------------- 1/60 sec ----------------------------->|
    //                 |                                                 |
    //                 |<--- I΁AOl߂ɂł ------>|
    //                       ̕wait肷B
    //
    // Ӂ
    // E܂ CVi  1/60 bDŖڎwdg݂łāA
    //   t[JE^ 1/60 bɃJEgAbvƂdg݂ł͖ilĂȂjB
    //   _time_of_next_view `  _time_of_next_view ͏ɌŒ莞(1/60 sec)ł邪A
    //   ႦΏ}ł 3frame begin  ` 4frame begin Ԃ̎Ԃ͑OɂϓB
    //

    if (_pSpacetime == nullptr) {
        //̐܂ꍇ́A悸̐쐬B
        _pSpacetime = createSpacetime();
#ifdef MY_DEBUG
        if (_pSpacetime == nullptr) {
            throwCriticalException("Error! ̐ĉI");
        }
#endif
        _pSpacetime->_pGod = this;
        _time_at_beginning_frame = timeGetTime();
        _time_of_next_view = _time_at_beginning_frame+100; //0.1bJn
        _time_calc_fps_next = _time_at_beginning_frame + 1;
    }
#ifdef MY_DEBUG
    //_iʃXbhjO`FbN
    if (_pException_god) {
        throw *_pException_god;
    }
#endif

    if (_is_behaved_flg == false) {
        _is_behaved_flg = true;
        BEGIN_SYNCHRONIZED1; // ----->rJn
        _frame_of_God++;
        presentSpacetimeMoment(); //@
        executeSpacetimeJudge();  //A
        _time_of_next_view += _apaTime_offset_of_next_view[_slowdown_mode][_cnt_frame];
        _cnt_frame++;
        if (_cnt_frame >= CONFIG::FPS) { _cnt_frame = 0; }
        if (timeGetTime() >= _time_of_next_view) { //`^C~Ot[ɂȂA͉߂Ăꍇ
            //makeSpacetimeMaterialize ̓pX
            _is_materialized_flg = false;
        } else {
            //`^C~Ot[ɂȂĂȂB]TB
             _is_materialized_flg = true;
            makeSpacetimeMaterialize(); //B
            //A makeSpacetimeMaterialize() ɂI[o[邩ȂB
        }
        END_SYNCHRONIZED1;  // <-----rI
    }

    _time_at_beginning_frame = timeGetTime();

    if (_time_at_beginning_frame >= _time_of_next_view) {
        //`^C~Ot[ɂȂA͉߂Ăꍇ
        BEGIN_SYNCHRONIZED1;  // ----->rJn
        if (_is_materialized_flg) { // B makeSpacetimeMaterialize() sς݂̏ꍇ
            //`LiXLbvȂj
            presentSpacetimeVisualize();  _visualize_frames++; //C
            finalizeSpacetime(); //D
        } else {                   // B makeSpacetimeMaterialize() sĂȂꍇ
            //`斳iXLbvj
            if (_sync_frame_time) { //[h
                //ŕ`ȂB
                finalizeSpacetime(); //D
            } else {   //[hł͂Ȃꍇ͒ʏXLbv
                _skip_count_of_frame++;
                //AAXLbvƂĂ MAX_SKIP_FRAME t[ɂP͕`͂B
                if (_skip_count_of_frame >= _max_skip_frames) {
                    makeSpacetimeMaterialize(); //B
                    presentSpacetimeVisualize();  _visualize_frames++; //C
                    finalizeSpacetime();        //D
                    _skip_count_of_frame = 0;
                } else {
                    finalizeSpacetime(); //D
                }
            }
        }
        _is_behaved_flg = false;
        END_SYNCHRONIZED1;    // <-----rI

        //fpsvZ
        if (_time_at_beginning_frame >= _time_calc_fps_next) {
            const int d_visualize_frames = _visualize_frames - _prev_visualize_frames;
            if (d_visualize_frames == 0) {
                _fps = 0;
            } else {
                static const double inv_offset_default = 1.0f / _aTime_offset_of_next_view[SLOWDOWN_MODE_DEFAULT];
                _fps = inv_offset_default * d_visualize_frames * _aTime_offset_of_next_view[_slowdown_mode];
            }
            _time_calc_fps_next += 1000;
            _prev_visualize_frames = _visualize_frames;
        }

     } else { //`^C~Ot[ɂȂĂȂ(]T)
         _sync_frame_time = false;
         Sleep(1); //<--- wait --->  ЂƂƂ
     }
    return;
}

void God::presentSpacetimeMoment() {
    Spacetime* pSpacetime = _pSpacetime;
    pSpacetime->nextFrame();
    pSpacetime->behave();
    pSpacetime->settleBehavior();
}

void God::executeSpacetimeJudge() {
    _pSpacetime->preJudge();
    _pSpacetime->judge();
}

void God::makeSpacetimeMaterialize() {
    if (God::_num_active_actor > CONFIG::OBJNUM_TO_SLOWDOWN2) {
        _slowdown_mode = SLOWDOWN_MODE_30FPS;
    } else if (God::_num_active_actor > CONFIG::OBJNUM_TO_SLOWDOWN1) {
        _slowdown_mode = SLOWDOWN_MODE_40FPS;
    } else {
        _slowdown_mode = SLOWDOWN_MODE_DEFAULT;
    }
#ifdef MY_DEBUG
    God::_num_drawing = 0;
#endif
    God::_num_active_actor = 0;
    Spacetime* pSpacetime = _pSpacetime;
    pSpacetime->preDraw();
    pSpacetime->draw();
    pSpacetime->afterDraw();
}

void God::presentSpacetimeVisualize() {
    _pSpacetime->dump();
}

void God::finalizeSpacetime() {
    _pSpacetime->doFinally();
}

void God::clean() {
    if (!_was_cleaned) {
        _TRACE_(FUNC_NAME<<" start");
        if (_pSpacetime) {
            _TRACE_("_pSpacetime != nullptr");
            //_~߂
            Sleep(10);
            _is_loving_flg = false;
            _TRACE_("God::~God() _܂ő҂EEE");
            for (int i = 0; _was_finished_flg == false; i++) {
                Sleep(10); //_܂ő҂
                if (i > 5*100*60) {
                    _TRACE_("God::~God() 5ҋ@܂A_甽܂Bm܂IA break ܂Bv");
                    break;
                }
            }
            _TRACE_("God::~God() _܂");
            //r̉AXbhI܂ő҂
            _TRACE_("God::~God()  WaitForSingleObject(_handle_god_love01, 120*1000) .....");
            DWORD r = WaitForSingleObject(_handle_god_love01, 120*1000);  //DeleteCriticalSections߂ɕKv
            if (r == WAIT_TIMEOUT) {
                throwCriticalException("I͂Ȃ̂ɁAԂ_܂IĂ܂EEEEi܁jBfobOu܂H");
            }
            _TRACE_("God::~God()  CloseHandle(_handle_god_love01) .....");
            CloseHandle(_handle_god_love01);
            _TRACE_("God::~God()  DeleteCriticalSection(&(God::CS1)); .....");
            DeleteCriticalSection(&(God::CS1));
            _handle_god_love01 = nullptr;
            _TRACE_("God::~God() ɐ_XbhIBNeBJZNV");

#ifdef MY_DEBUG
            //c[\\
            _TRACE_("Dumping _pSpacetime ...");
            _pSpacetime->dump();
#endif

            //^
            _TRACE_(FUNC_NAME<<"");
            flood();
            //S~
#ifdef MY_DEBUG
            _TRACE_("Dumping GarbageBox::_pGarbageBox->_pDisusedScene ...");
            GarbageBox::_pGarbageBox->_pDisusedScene->dump();
            _TRACE_("GarbageBox::_pGarbageBox->_pDisusedActor ...");
            GarbageBox::_pGarbageBox->_pDisusedActor->dump();
#endif
            _TRACE_("GGAF_DELETE(GarbageBox::_pGarbageBox);");
            GGAF_DELETE(GarbageBox::_pGarbageBox);
            //̐ŐĂ镨|
            Sleep(20);
            _TRACE_("GGAF_DELETE(_pSpacetime);");
            GGAF_DELETE(_pSpacetime);
            _TRACE_("God::~God()  DeleteCriticalSection(&(God::CS2)); .....");
            DeleteCriticalSection(&(God::CS2));
        }


        GGAF_DELETEARR(_apaTime_offset_of_next_view[0]);
        GGAF_DELETEARR(_apaTime_offset_of_next_view[1]);
        GGAF_DELETEARR(_apaTime_offset_of_next_view[2]);
        //_O _pException_god NĂ邩ȂB
        _TRACE_("GGAF_DELETE_NULLABLE(_pException_god);");
        GGAF_DELETE_NULLABLE(_pException_god);
        _TRACE_(FUNC_NAME<<" end");
    }
}

God::~God() {
    timeEndPeriod(1);
    clean();
    _was_cleaned = true;
}

MainActor* God::receive_Actor(uint64_t prm_cradle_no, Object* prm_pReceiver) {
    return (MainActor*)God::receive(prm_cradle_no, prm_pReceiver);
}

MainScene* God::receive_Scene(uint64_t prm_cradle_no, Object* prm_pReceiver) {
    return (MainScene*)receive(prm_cradle_no, prm_pReceiver);
}

void God::createCradle(uint64_t prm_cradle_no,
                       Object* (*prm_pFunc)(void*, void*, void*),
                       Object* prm_pWisher,
                       Object* prm_pReceiver,
                       void* prm_pArg1,
                       void* prm_pArg2,
                       void* prm_pArg3) {
    _TRACE2_("˗l:("<<prm_pWisher<<") ʃXbh̐_A [" << prm_cradle_no << "-"<<prm_pReceiver<<"]ƂĂ`B");
    //ɏjĂȂ`FbN
    Cradle* pCradle = _pCradleRoot;
    while (pCradle) {
        if (pCradle->_cradle_no == prm_cradle_no &&  pCradle->_pReceiver == prm_pReceiver) {
            _TRACE_("x God::createCradle() 肩[" << prm_cradle_no << "-"<<prm_pReceiver<<"]͊ɑ݂Ă܂IBӐ}Ă܂H");
            return;
        }
        if (pCradle->_is_last_cradle_flg) {
            break;
        }
        pCradle = pCradle->_pCradle_next;
    }
    //肩͖ł悤Ȃ̂Ő擪ɃXgbN
    Cradle* pCradle_new;
    pCradle_new = NEW Cradle(prm_cradle_no);
    pCradle_new->_pObject_creation=nullptr;
    pCradle_new->_pFunc = prm_pFunc;
    pCradle_new->_pWisher = prm_pWisher;
    pCradle_new->_pReceiver = prm_pReceiver;
    pCradle_new->_time_of_wants = timeGetTime();
    pCradle_new->_pArg1 = prm_pArg1;
    pCradle_new->_pArg2 = prm_pArg2;
    pCradle_new->_pArg3 = prm_pArg3;
    pCradle_new->_progress = 0;
    if (_pCradleRoot == nullptr) {
        _TRACE2_("˗l:("<<prm_pWisher<<") A_l͂ɂłˁB肢A܂ˁHB");
        pCradle_new->_is_first_cradle_flg = true;
        pCradle_new->_is_last_cradle_flg = true;
        pCradle_new->_pCradle_next = pCradle_new;
        pCradle_new->_pCradle_prev = pCradle_new;
        _pCradleRoot = pCradle_new;
        _pCradleBlessing = pCradle_new;
    } else {
        _TRACE2_("˗l:("<<prm_pWisher<<") 肩܂Ă܂ˁAX肩܂B");
        pCradle_new->_is_first_cradle_flg = false;
        pCradle_new->_is_last_cradle_flg = true;
        Cradle* pCradle_last = _pCradleRoot->_pCradle_prev;
        pCradle_last->_is_last_cradle_flg = false;
        pCradle_last->_pCradle_next = pCradle_new;
        pCradle_new->_pCradle_prev = pCradle_last;
        pCradle_new->_pCradle_next = _pCradleRoot;
        _pCradleRoot->_pCradle_prev = pCradle_new;
    }
}

int God::chkCradle(uint64_t prm_cradle_no) {
    Cradle* pCradle;
    pCradle = _pCradleRoot;
    if (pCradle == nullptr) {
        return -1;
    }
    while (_is_loving_flg) {
        if (pCradle->_cradle_no == prm_cradle_no) {
            return pCradle->_progress;
        } else {
            if (pCradle->_is_last_cradle_flg) {
                return -1;
            } else {
                pCradle = pCradle->_pCradle_next;
            }
        }
    }
    return -2;
}

void* God::receive(uint64_t prm_cradle_no, Object* prm_pReceiver) {
    _TRACE2_("l:"<< (prm_pReceiver ? prm_pReceiver->toString() : "nullptr") <<"("<<prm_pReceiver<<") ܂ǁA["<<prm_cradle_no<<"-"<<prm_pReceiver<<"]ɗ܂ƁB");
    Cradle* pCradle= _pCradleRoot;
    Cradle* pCradle_my_next;
    Cradle* pCradle_my_prev;
    DWORD waittime = 0;
    void* objectCreation;

    if (pCradle == nullptr) {
        //肩疳G[IAG[bZ[WB
        _TRACE_(FUNC_NAME<<" 肩疳G[I");
        God::debuginfo();
        throwCriticalException("Error! prm_cradle_no="<<prm_cradle_no<<" 肩XgnullptrőSďjς݂Ă܂B\n"
                                   "createCradlereceivȇΉĂ܂B\n"
                                   "l(receiveĂь)="<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<")");
    }

    //receiveC[v
    while (_is_loving_flg) {
        if (pCradle->_cradle_no == prm_cradle_no && (pCradle->_pReceiver == nullptr || pCradle->_pReceiver == prm_pReceiver) ) {
            while (_is_loving_flg) {
                if (pCradle->_progress < 2) {
                    _TRACE2_("l:"<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") ˂_lA["<<prm_cradle_no<<"-"<<prm_pReceiver<<"]̏j܂`HA5~b҂悤BpCradle->_progress="<<(pCradle->_progress));
#ifdef _DEBUG
                    //fobO̓^CAEg
#else

                    if (waittime > 1000*600) { //10
                        _TRACE_(FUNC_NAME<<" ^CAEgG[I");
                        God::debuginfo();
                        //^CAEgG[IAG[bZ[WB
                        throwCriticalException("Error! 肩["<<pCradle->getDebuginfo()<<"]̏j҂ԃ^CAEgA擾ł܂B\n"
                                                   "炩̗RŃCXbh~Ă\傫łB"
                                                   "l(receiveĂь)="<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<")");
                    } else {
                    }
#endif
                    END_SYNCHRONIZED1; // <----- rI
                    Sleep(5);
                    BEGIN_SYNCHRONIZED1; // ----->rJn
                    waittime += 5;
                    if (pCradle->_progress == 1) {
                        //ς
                        _TRACE_N_("I");
                        continue; //҂
                    } else if (pCradle->_progress == 0) {
                        //H
                        pCradle = _pCradleRoot; //xŏTB
                        _TRACE_N_("c");
                        break;
                    } else if (pCradle->_progress == 2) {
                        //
                        pCradle = _pCradleRoot;
                        _TRACE_N_("(^_^)v");
                        break;
                    }
                } else {

#ifdef MY_DEBUG
                    if (waittime > 0) {
                        _TRACE_N_("҂I");
                    }
#endif
                    _TRACE2_("l:"<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") `A["<<prm_cradle_no<<"-"<<prm_pReceiver<<"]͏jłˁBɁI");
                    if (pCradle->_is_first_cradle_flg && pCradle->_is_last_cradle_flg) {
                        //Ō̈ receive
                        objectCreation = pCradle->_pObject_creation;
                        pCradle->_pObject_creation = nullptr;
                        GGAF_DELETE(pCradle);
                        pCradle = nullptr;
                        _pCradleRoot = nullptr;
                        _pCradleBlessing = nullptr;
                        _TRACE2_("l:"<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") AƂł_͋łˁBɂɂȂHA˂H");
                        return (void*)objectCreation;
                    } else {
                        //ԂreceiveAqB
                        pCradle_my_next = pCradle->_pCradle_next;
                        pCradle_my_prev = pCradle->_pCradle_prev;
                        pCradle_my_prev->_pCradle_next = pCradle_my_next;
                        pCradle_my_next->_pCradle_prev = pCradle_my_prev;
                        if (pCradle->_is_last_cradle_flg) {
                            pCradle_my_prev->_is_last_cradle_flg = true;
                        }
                        if (pCradle->_is_first_cradle_flg) {
                            _pCradleRoot = pCradle_my_next;
                            pCradle_my_next->_is_first_cradle_flg = true;
                        }
                        if (_pCradleBlessing == pCradle) {
                            _pCradleBlessing = pCradle_my_next;
                        }
                        objectCreation = pCradle->_pObject_creation;
                        pCradle->_pObject_creation = nullptr;
                        GGAF_DELETE(pCradle);
                        pCradle = nullptr;

                        return (void*)objectCreation;
                    }
                }
            }
        } else {
            if (pCradle->_is_last_cradle_flg) {
                _TRACE_(FUNC_NAME<<" 肩̌`ՂA擾oȂG[I");
                God::debuginfo();
                //肩̌`ՂA擾oȂG[IAG[bZ[WB
                throwCriticalException("_ST܂ǁAȂ肩("<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"ւ 肩ԍ:"<<prm_cradle_no<<"-"<<prm_pReceiver<<")́A܂B\n"
                                           "createCradle()  God::receive() ̑ΉĂ܂BcreateCradle()RA͓ God::receive() QȏサĂ܂񂩁HB\n"
                                           "Fl(receiveĂь)="<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") łB\n"
                                           "iȂ݂ɁAݐ_̍ŏII[_[́A肩ԍ("<<pCradle->_cradle_no<<"-"<<pCradle->_pReceiver<<")ŁA]񂾐l(createCradle(Ăь)=("<<pCradle->_pWisher<<") łj");
            } else {
                pCradle = pCradle->_pCradle_next;
            }
        }
    }
#ifdef MY_DEBUG
    if (_pException_god) {
        throw *(_pException_god);
    }
#endif
    return nullptr;
}

void God::beginRest() {
    _TRACE_(FUNC_NAME<<" _xe");
    _have_to_rest_flg = true;
}

bool God::isResting() {
    if (_is_resting_flg) {
        _TRACE_(FUNC_NAME<<" _x~");
    } else {
        _TRACE_(FUNC_NAME<<" _ғ");
    }
    return _is_resting_flg;
}

void God::finishRest() {
    _TRACE_(FUNC_NAME<<" __Axe͂܂BI");
    _have_to_rest_flg = false;
}


void God::flood() {
    //_ɂߍłSĂ̂肩j
    //_(God)AvIɎs\B
    _TRACE2_("_ ^Jn");
    Cradle* pCradle = _pCradleRoot;
    if (pCradle == nullptr) {
        _TRACE2_("_ II");
        return;
    }
    uint64_t cnt = 0;
    while (_is_loving_flg || _was_finished_flg == false) {
        Sleep(10);
        _TRACE_(FUNC_NAME<<" _ ͂܂Ă܂EEE");
        cnt++;
        if (cnt > 100*60*5) {
            _TRACE_(FUNC_NAME<<" _ ܂Ă܂EEEAB");
            break;
        }
    }

    God::debuginfo();

    while (true) {
        if (pCradle->_is_last_cradle_flg) {
            _TRACE2_("_ 肩폜["<<pCradle->getDebuginfo()<<"]AŌ̃XgbN");
            GGAF_DELETE(pCradle);
            pCradle = nullptr;
            _pCradleRoot = nullptr;
            _pCradleBlessing = nullptr;
            break;
        } else {
            _TRACE2_("_ 肩폜["<<pCradle->getDebuginfo()<<"]");
            Cradle* pCradle_my_next = pCradle->_pCradle_next;
            GGAF_DELETE(pCradle);
            pCradle = pCradle_my_next;
        }
    }
    _TRACE2_("_ ^");
    return;
}

void God::repent(Object* prm_pReceiver) {
    //V]񂾐lȂׁAl̂Ȃ肪폜ijς݂̖폜jB
    Cradle* pCradle = _pCradleRoot;
    while (pCradle) {
        if (pCradle->_pReceiver == prm_pReceiver) {
            if (pCradle->_is_last_cradle_flg && pCradle->_is_first_cradle_flg) {
                //Ō̈
                GGAF_DELETE(pCradle);
                _pCradleRoot = nullptr;
                _pCradleBlessing = nullptr;
                break; //I
            } else {
                //Ԃ̏ꍇA|C^qB
                Cradle* pCradle_t_next = pCradle->_pCradle_next;
                Cradle* pCradle_t_prev = pCradle->_pCradle_prev;
                pCradle_t_prev->_pCradle_next = pCradle_t_next;
                pCradle_t_next->_pCradle_prev = pCradle_t_prev;

                if (pCradle->_is_last_cradle_flg) {
                    pCradle_t_prev->_is_last_cradle_flg = true;
                }
                if (pCradle->_is_first_cradle_flg) {
                    _pCradleRoot = pCradle_t_next;
                    pCradle_t_next->_is_first_cradle_flg = true;
                }
                if (_pCradleBlessing == pCradle) {
                    _pCradleBlessing = pCradle_t_next;
                }
                _TRACE_(FUNC_NAME<<" l("<<prm_pReceiver<<")Sׁ̈A肩폜܂B" << pCradle->getDebuginfo() << "");
                GGAF_DELETE(pCradle);
                pCradle = pCradle_t_next;
                continue;
            }
        } else {
            if (pCradle->_is_last_cradle_flg) {
                break; //I
            } else {
                pCradle = pCradle->_pCradle_next;
                continue;
            }
        }
    }
}

void God::debuginfo() {
    _TRACE_(FUNC_NAME<<" _ ݂̂肩");
    try {
        Cradle* p = _pCradleRoot;
        if (p) {
            while(p) {
                _TRACE_("E" << p->getDebuginfo() );
                p = p->_pCradle_next;
                if (p == _pCradleRoot) {
                    break;
                }
            }
        } else {
            _TRACE_("E肩͂܂I");
        }
    } catch (...) {
        _TRACE_(FUNC_NAME<<" ȂƂƂł傤B݂̐_̏Ԃ̕\s\łBȔnȁG");
    }
    _TRACE_(FUNC_NAME<<" ȏ");
}

unsigned __stdcall God::love(void* prm_arg) {
    return pGOD->loveEternal(prm_arg);
}
unsigned God::loveEternal(void* prm_arg) {
    try {
        Object* (*funcBlessing)(void*, void*, void*) = nullptr;
        Object* pObject = nullptr;
        Sleep(1000); //god ̃CX^X܂łق̂Ƒ҂Kv邩Ȃ

        //j܂邭_̈[vI
        while (_is_loving_flg) {
            if (_have_to_rest_flg) {
                _is_resting_flg = true;
                Sleep(100);
                continue;
            } else {
                _is_resting_flg = false;
            }

BEGIN_SYNCHRONIZED1; // ----->rJn
            Cradle* pCradleBlessing = _pCradleBlessing;
            if (pCradleBlessing) {
                if (pCradleBlessing->_progress == 0) { //Ȃ܂
                    _TRACE2_("_ 悵A肩["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"]͖(_progress == "<<pCradleBlessing->_progress<<")ȁB䂦ɍ܂I");
                    pCradleBlessing->_progress = 1; //Xe[^Xj
                    pCradleBlessing->_time_of_create_begin = timeGetTime();
                    funcBlessing = pCradleBlessing->_pFunc;
                    void* arg1 = pCradleBlessing->_pArg1;
                    void* arg2 = pCradleBlessing->_pArg2;
                    void* arg3 = pCradleBlessing->_pArg3;
                    _TRACE2_("_ jJnI["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"]");
                    Sleep(2);
                    END_SYNCHRONIZED1; // <----- rI

                    pObject = (*funcBlessing)(arg1, arg2, arg3); //jAaB

                    BEGIN_SYNCHRONIZED1; // ----->rJn
                    Sleep(2);
                    _TRACE2_("_ jI܂ꂽ̂["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"] (^_^)v");
                    if (_pCradleBlessing == nullptr) {
                        //_pCradleBlessing j nullptr ɂȂĂ܂ĂꍇLZB
                        _TRACE2_("_ K[IBĵɃLZEEEBj܂BpObjectdelete!");
                        GGAF_DELETE(pObject);
END_SYNCHRONIZED1; // <----- rI
                        continue;
                    } else if (_pCradleBlessing == pCradleBlessing) {
                        //ȃP[X
                        pCradleBlessing->_pObject_creation = pObject; //肩ɏ悹
                        pCradleBlessing->_progress = 2; //Xe[^Xjς݂
                        pCradleBlessing->_time_of_create_finish = timeGetTime();
                        _TRACE2_("_ j肩̖["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"]AIɒuƂ܂B");
                    }  else if (_pCradleBlessing != pCradleBlessing) {
                        _TRACE2_("_ xA肩̖["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"]ĂԂɁA"
                                 "_pCradleBlessing Aʂ̂肩["<<_pCradleBlessing->_cradle_no<<"-"<<_pCradleBlessing->_pReceiver<<"]wĂ܂IĂ邩܂IIɌɖ߂܂IvI");
                        _pCradleBlessing = pCradleBlessing; //|C^߂
                        pCradleBlessing->_pObject_creation = pObject; //肩ɏ悹
                        pCradleBlessing->_progress = 2; //Xe[^Xjς݂
                        pCradleBlessing->_time_of_create_finish = timeGetTime();
                        _TRACE2_("_ j肩̖["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"]AIɒuƂ܂EEEB");
                    }
                } else {
                    _TRACE2_("_ 肩["<<pCradleBlessing->_cradle_no<<"-"<<pCradleBlessing->_pReceiver<<"]̖́Ajς݂ŃXgbNĂ邵EEE(_progress == "<<pCradleBlessing->_progress<<")B");
                }
            }
            if (_pCradleRoot == nullptr) {
                //ҋ@
                _TRACE2_("_ `܂B肩IIEEEȂ̂HBiҋ@j");
END_SYNCHRONIZED1; // <----- rI
                if (_fps >= CONFIG::FPS_TO_CLEAN_GARBAGE_BOX) {
                    _TRACE2_("_ قǖZȂ̂ŁAS~̃S~oƂB");
                    GarbageBox::_pGarbageBox->clean(5); //ɂȂ̂ŁAS~|
                    GarbageBox::_cnt_cleaned = 0;
                }
            } else {
                if (_pCradleRoot != nullptr && _pCradleRoot->_pCradle_prev->_progress == 0) {
                    _TRACE2_("_ EEEĵ肩CzBŏIڕŴ肩["<<_pCradleRoot->_pCradle_prev->_cradle_no<<"/l="<<_pCradleRoot->_pCradle_prev->_pReceiver<<"]Ȃ̂HB");
                    _pCradleBlessing = _pCradleBlessing->_pCradle_next;
END_SYNCHRONIZED1; // <----- rI
                } else {
                    _TRACE2_("_ āAj肩͖BIɏjς̂񂪂܂Ă̂𑁂ɗIBiҋ@j");
END_SYNCHRONIZED1; // <----- rI
                    if (_fps >= CONFIG::FPS_TO_CLEAN_GARBAGE_BOX) {
                        _TRACE2_("_ قǖZȂȂ̂ŁAS~̃S~oƂB");
                        GarbageBox::_pGarbageBox->clean(5); //ɂȂ̂ŁAS~|
                        GarbageBox::_cnt_cleaned = 0;
                    }
                }
            }
            Sleep(2);
        } // <-- while (_is_loving_flg)
        _TRACE2_("_ 悤ȂA܂܂傤B");
        _was_finished_flg = true;
    } catch (CriticalException& e) {
        debuginfo();
        _TRACE_("_O ƂƂ݂܂G"<<e.getMsg());
        _is_loving_flg = false;
        _was_finished_flg = true;
        _pException_god = NEW CriticalException(e.getMsg());
        return 1;
    }
    return 0;
}


