#ifndef GGAF_CORE_RESOURCEMANAGER_H_
#define GGAF_CORE_RESOURCEMANAGER_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Object.h"
#include "jp/ggaf/core/util/Util.h"
#include "jp/ggaf/core/util/ResourceConnection.hpp"
#include "windows.h"
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

#ifndef _MSC_VER
    #include <atomic>
#endif

namespace GgafCore {

/**
 * ǗNXB .
 * ǗNX́AbsOwڑIuWFNg(ResourceConnection)xǗ܂B<BR>
 * (Resource)𖳑ʂɐs킸AQƂĎg܂킵B new ̂ǂӎȂB<BR>
 * ȂƂɎgNXłB<BR>
 * ResourceManager : Resource : ResourceConnection  = 1 : N : N <BR>
 * ̊֌WŁAŃZbgłB<BR>
 * ǗNX͎ȋ@\́AڑNX̃CX^Xĩ|C^jɃXgŕێA擾vꍇA
 * ێĂ΂ԂAێĂȂΐāAXgɒǉセԂ܂B
 * ӁFXbhZ[t̕ۏ؂͓ɂQXbh܂ŁBRXbhȏ͐삵܂B
 * (GdxfwActorManagerėp)
 * @tparam T ̌^ǐ^ɕRtڑIuWFNg擾łj
 * @version 1.00
 * @since 2007/11/16
 * @author Masatoshi Tsuge
 */
template<class T>
class ResourceManager : public Object {
    friend class ResourceConnection<T>;

private:
    /**
     * ResourceConnectionIuWFNgXgɒǉB<BR>
     * @param prm_pNew ǉResourceConnectionIuWFNg̃|C^
     */
    virtual void add(ResourceConnection<T>* prm_pNew);

    /**
     * ResourceConnectionIuWFNgXg猟B<BR>
     * @param prm_idstr ʖ
     * @return  ]ResourceConnectionIuWFNg̃|C^BXgɑ݂Ȃꍇ nullptr
     */
    virtual ResourceConnection<T>* find(const char* prm_idstr);

    /**
     * ̂𐶐 .
     * connect() AꍇĂяo܂B
     * processCreateResource(const char*, void*) R[܂B
     * @param prm_idstr connect() œnꂽʖ
     * @param prm_p connect() œnꂽRp[^
     */
    T* createResource(const char* prm_idstr, void* prm_p);

    /**
     * ڑIuWFNg𐶐.
     * @param prm_idstr ʖ
     * @param prm_pResource ڑIuWFNgValueB܂莑CX^XB
     * @return ڑIuWFNg
     */
    ResourceConnection<T>* createResourceConnection(const char* prm_idstr, T* prm_pResource);

protected:
#ifdef _MSC_VER
    //TODO:VC++2005ȍ~(x86)  volatile ́AoAʂiƎvjB
    //gcc(x86)́AAg~bNۏ؂͖ std::atomic gBVC++ atomic ܂ł͂Ƃ肠EEEB
    /** connecttrue̔rtO */
    static volatile bool _is_connecting_resource;
    /** connect邽߂ɑ҂ĂtO */
    static volatile bool _is_waiting_to_connect;
#else
    /** connecttrue̔rtO */
    static volatile std::atomic<bool> _is_connecting_resource;
    /** connect邽߂ɑ҂ĂtO */
    static volatile std::atomic<bool> _is_waiting_to_connect;
#endif


    /** [r]}l[W */
    char* _manager_name;
    /** [r]ResourceConnectionIuWFNg̃Xg̐擪̃|C^BI[nullptr */
    ResourceConnection<T>* _pConn_first;

protected:
    /**
     * ڑIuWFNg̐ʂŎ܂B.
     * ̃\bh createResourceConnection ĂяoA{ev[gp҂Kv܂B<BR>
     * prm_idstr  ڑIuWFNg𐶐郍WbNĂB<BR>
     * قƂǂ́AResourceConnection NX new āAԂOKBBR>
     * @param prm_idstr  ̎ʖnꂽAǂڑIuWFNg𐶐邩H Ƃʖ
     * @param prm_pResource |C^
     * @return ResourceConnection ڑIuWFNg̃CX^XiResourceConnection NX̃CX^Xj
     */
    virtual ResourceConnection<T>* processCreateConnection(const char* prm_idstr, T* prm_pResource) = 0;

    /**
     * ۂ̎̂𐶐ʂŎ܂B.
     * ̃\bh createResource ĂяoA{ev[gp҂Kv܂B<BR>
     * prm_idstr  𐶐郍WbNĂB<BR>
     * @param prm_idstr ̎ʖnꂽAǂ𐶐(new)邩H Ƃʖ
     * @param prm_p Rp[^
     * @return CX^X̃|C^
     */
    virtual T* processCreateResource(const char* prm_idstr, void* prm_pConnector) = 0;

//    int ResourceManager<T>::getConnectionNum();

public:
    /**
     * RXgN^
     */
    ResourceManager(const char* prm_manager_name);

    /**
     * fXgN^BێXg܂B .
     * SĂ̕ێXg ResourceConnectionɑ΂AResourceConnectionrelease()PxsA<BR>
     * ResourceConnection̐ڑJE^0Ȃ΁Adelete ܂B<BR>
     * ResourceConnection̐ڑJE^0łȂ΁Agp҂̃WbNŉR̋ꂪ̂
     * ꌾ delete ܂B<BR>
     */
    virtual ~ResourceManager();

    /**
     * ڑ(ResourceConnection)IuWFNg擾B<BR>
     * ێXgɑ݂΂ԂA݂Ȃ new ܂B<BR>
     * ێXg擾ꍇAڑJE^܂B<BR>
     * new ꍇAڑJE^1łB<BR>
     * @param prm_idstr ʖ
     * @param prm_connector 炩̈BȂꍇ́AڑthisnĉB
     * @return ʖɕRtڑ(ResourceConnection)
     */
    virtual ResourceConnection<T>* connect(const char* prm_idstr, void* prm_connector);

    /**
     * }lW[ێ郊Xgo͂܂BifobOpj .
     */
    virtual void dump();
};

// ---------------------------------------------------------------------//



#ifdef _MSC_VER

template<class T>
volatile bool ResourceManager<T>::_is_connecting_resource = false;

template<class T>
volatile bool ResourceManager<T>::_is_waiting_to_connect = false;

#else

template<class T>
volatile std::atomic<bool> ResourceManager<T>::_is_connecting_resource(false);

template<class T>
volatile std::atomic<bool> ResourceManager<T>::_is_waiting_to_connect(false);

#endif



template<class T>
ResourceManager<T>::ResourceManager(const char* prm_manager_name) : Object() {
    _TRACE3_("ResourceManager<T>::ResourceManager(" << prm_manager_name << ")");

    int len = strlen(prm_manager_name);
    _manager_name = NEW char[len+1];
    strcpy(_manager_name, prm_manager_name);
    _pConn_first = nullptr;
}

template<class T>
ResourceConnection<T>* ResourceManager<T>::find(const char* prm_idstr) {
    ResourceConnection<T>* pCurrent = _pConn_first;

    while (pCurrent) {
        //_TRACE_("pCurrent->_idstr -> "<<(pCurrent->_idstr)<<" prm_idstr="<<prm_idstr);
        if (strcmp(pCurrent->_idstr, prm_idstr) == 0) {
            return pCurrent;
        }
        pCurrent = pCurrent->_pNext;
    }
    return nullptr;
}

template<class T>
void ResourceManager<T>::add(ResourceConnection<T>* prm_pResource_new) {
    if (_pConn_first == nullptr) {
        _pConn_first = prm_pResource_new;
        return;
    } else {
        ResourceConnection<T>* pCurrent = _pConn_first;
        while (pCurrent->_pNext) {
            pCurrent = pCurrent->_pNext;
        }
        pCurrent->_pNext = prm_pResource_new;
        return;
    }
}

template<class T>
ResourceConnection<T>* ResourceManager<T>::connect(const char* prm_idstr, void* prm_connector) {
    if (prm_idstr == nullptr) {
        _TRACE3_("x ResourceManager<T>::connect(nullptr) [" << _manager_name << "]");
    }
    if (_is_waiting_to_connect || _is_connecting_resource) {
        _TRACE_("x ResourceManager<T>::connect() "<<_manager_name<<"́ARlNgɂ炸AXconnect() vߑҋ@܂EE ҋ@("<<prm_idstr<<")");
    }
    for (int i = 0; _is_waiting_to_connect || _is_connecting_resource; i++) {
        Sleep(10);
        if (i > 10*100*60) {
            //10ȏ㖳
            _TRACE_("ResourceManager<T>::connect() "<<_manager_name<<"ցAprm_idstr="<<prm_idstr<<"  connect()悤ƂāÃRlNg10ҋ@EEE");
            throwCriticalException("ɁAconnect()Ă邩Ax܂B(1)");
        }
        if (i % 100 == 0) {
            _TRACE_("x ResourceManager<T>::connect() "<<_manager_name<<"́ARlNgɂ炸AXconnect() vߑҋ@܂EE ҋ@("<<prm_idstr<<") ҂="<<i);
        }
    }
    _is_waiting_to_connect = false;
    _is_connecting_resource = true;

    //TODO:ȈՓIȔrBقڊSł͂ȂB
    ResourceConnection<T>* pObj = nullptr;
    for (int i = 0; ResourceConnection<T>::_is_closing_resource; i++) {
        _is_waiting_to_connect = true;
        Sleep(10);
        if (i > 10*100*60) {
            //Pȏ㖳
            _TRACE_("ResourceManager<T>::connect()  "<<_manager_name<<"ցAprm_idstr="<<prm_idstr<<"  connect()悤ƂāÃN[Y10ҋ@EEE");
            throwCriticalException("ɁAconnect()Ă邩Ax܂B(2)");
        }
        if (i % 100 == 0) {
            _TRACE_("x ResourceManager<T>::connect() "<<_manager_name<<"́ÃN[YɁAconnect() vߑҋ@܂EE ҋ@("<<prm_idstr<<") ҂="<<i);
        }
    }
    //TODO:
    //close()ɁAʃXbhconnect()ƁB
    //VrAȃ^C~OŃj󂷂鋰ꂪcĂAXXvƎv̂ǂIB
    //int (v~eBu) ̃Ag~bN𗘗pĔrłƈՂɍlĂA
    //XbhZ[tSΉ悤ƂƁAȂ߂ǂƂB׋ɂȂB
    //ԂSĂ connect() Ăяo connect() s̏`ׂB
    //templateɂ͎̂ŝGivoid*ɂׂjB
    //gގ͋C悤ARR͎Ԃ̂Ƃɂ낤B̂GGG
    //_TRACE_(" connect to " << _manager_name<<" for "<<prm_idstr<<"...");
    pObj = find(prm_idstr);
    if (pObj == nullptr) {
        //ȂΐBڑJE^P
        T* pResource = createResource(prm_idstr, prm_connector);
        pObj = createResourceConnection(prm_idstr, pResource);
        pObj->_num_connection = 1;
        pObj->_p_first_connector = prm_connector;
        add(pObj);
        _TRACE3_("ResourceManager<T>::connect [" << _manager_name << "]" << prm_idstr << "͖̂ŁAVK쐬ĕێɌ");
        _is_connecting_resource = false;
        return pObj;
    } else {
        //ς݂Ȃ炻ԂBڑJE^{P
        pObj->_num_connection++;
        _TRACE3_("ResourceManager<T>::connect [" << _manager_name << "]" << prm_idstr << "͂̂ŐڑJEg{P." << pObj->_num_connection);
        _is_connecting_resource = false;
        return pObj;
    }
}

template<class T>
T* ResourceManager<T>::createResource(const char* prm_idstr, void* prm_p) {
    _TRACE3_("ResourceManager<T>::createResource [" << _manager_name << "]" << prm_idstr << "𐶐܂傤");
    T* p = processCreateResource(prm_idstr, prm_p);
    return p;
}

template<class T>
ResourceConnection<T>* ResourceManager<T>::createResourceConnection(const char* prm_idstr, T* prm_pResource) {
    _TRACE3_("ResourceManager<T>::createResourceConnection [" << _manager_name << "]" << prm_idstr << "𐶐܂傤");
    ResourceConnection<T>* p = processCreateConnection(prm_idstr, prm_pResource);
    p->_pManager = this; //}l[Wo^
    return p;
}

template<class T>
void ResourceManager<T>::dump() {
    ResourceConnection<T>* pCurrent = _pConn_first;
    if (_pConn_first == nullptr) {
        _TRACE_(FUNC_NAME << " [" << _manager_name << "] ێXgɂ͂Ȃɂ܂B");
    } else {
        ResourceConnection<T>* pCurrent_next;
        while (pCurrent) {
            _TRACE_(FUNC_NAME << " [" << _manager_name << "] [" << pCurrent->_idstr << "" << pCurrent->_num_connection << "Connection]");
            pCurrent_next = pCurrent->_pNext;
            if (pCurrent_next == nullptr) {
                pCurrent = nullptr;
                break;
            } else {
                pCurrent = pCurrent_next;
            }
        }
    }
}

//template<class T>
//int* ResourceManager<T>::getConnectionNum() {
//    ResourceConnection<T>* pCurrent = _pConn_first;
//    int n = 0;
//    while (pCurrent) {
//        n++;
//        pCurrent = pCurrent->_pNext;
//    }
//    return n;
//}


template<class T>
ResourceManager<T>::~ResourceManager() {
#ifdef MY_DEBUG
    _TRACE_(FUNC_NAME << " ["<<_manager_name<<"] begin --->");
    dump();
#endif
    ResourceConnection<T>* pCurrent = _pConn_first;
    if (_pConn_first == nullptr) {
        _TRACE3_("RlNVXg͋łB["<<_manager_name<<"]͐ɊJł傤B");
    } else {
        ResourceConnection<T>* pCurrent_next;
        while (pCurrent) {
            int rnum = pCurrent->_num_connection;
            _TRACE_("x["<<_manager_name<<"]ɁARlNV[" << pCurrent->_idstr << "" << rnum
                    << "Connection]cĂ̂ō폜o܂Bclose()RvłBʂ" << rnum << " close() ݂܂B");
//            T* r = pCurrent->peek();
            pCurrent_next = pCurrent->_pNext;
//            if (r) {
//                pCurrent->processReleaseResource(r); //\[X̉
//            }
            for (int i = 0; i < rnum; i++) {
                _TRACE_("x["<<i<<"] close() 炵܂BpCurrent="<<(pCurrent->_idstr)<<"("<<pCurrent<<")");
                pCurrent->close(); //E܂ŉ
                _TRACE_("x["<<i<<"] close() ܂B");
            }
            if (pCurrent_next == nullptr) {
                //Ō̈
                break;
            } else {
                pCurrent = pCurrent_next;
            }
        }
    }
#ifdef MY_DEBUG
    _TRACE_(FUNC_NAME << " ["<<_manager_name<<"] end   <---");
#endif
    GGAF_DELETEARR_NULLABLE(_manager_name);
}

}
#endif /*GGAF_CORE_RESOURCEMANAGER_H_*/
