#ifndef GGAF_CORE_REPEATSEQ_H_
#define GGAF_CORE_REPEATSEQ_H_
#include "GgafCommonHeader.h"

#include <map>
#include <string>
#ifndef _MSC_VER
    #include <atomic>
#endif

namespace GgafCore {

/**
 * NX(PXbhpBXbhZ[tł͗L܂) .
 * f[^x[X̃V[NGXiIuWFNgĵ悤ɁA̔Ԃ܂B
 * @version 1.00
 * @since 2007/12/11
 * @author Masatoshi Tsuge
 */
class RepeatSeq {
private:
    class Seq {
    public:
        int _value;
        int _min;
        int _max;
    public :
        Seq() : _value(0), _min(0), _max(0)  {}
        inline void init(int min, int max) {
            _min = min;
            _max = max;
            _value = _min;
        }
        inline void setMin() {
            _value = _min;
        }
        inline void setMax() {
            _value = _max;
        }
        inline void set(int val) {
            _value = val;
        }
        inline int nextVal() {
            _value++;
            if (_value > _max) {
                _value = _min;
            }
            return _value;
        }
    };

    static std::map<std::string, RepeatSeq::Seq> mapSeq;

#ifdef _MSC_VER
    //TODO:VC++2005ȍ~(x86)  volatile ́AoAʂiƎvjB
    //gcc(x86)́AAg~bNۏ؂͖ std::atomic gBVC++ atomic ܂ł͂Ƃ肠EEEB
    static volatile bool _is_lock;
#else
    static volatile std::atomic<bool> _is_lock;
#endif


public:
    /**
     * IuWFNg쐬 .
     * @param ID R鏇IuWFNgIDiC)
     * @param min ŏl
     * @param max ől
     */
    static void create(std::string ID, int min, int max);
    static void create(const char* ID, int min, int max);
    /**
     * ID̏IuWFNg쐬ςׂ݂ .
     * @param ID IuWFNgID
     * @return true:ς݁^false:
     */
    static bool isExist(std::string& ID);
    static bool isExist(const char* ID);   static void set(std::string& ID, int val);
    static void set(const char* ID, int val);
    static void setMax(std::string& ID);
    static void setMax(const char* ID);
    static void setMin(std::string& ID);
    static void setMin(const char* ID);

    /**
     * IuWFNg̔ԂAJEg̒lɃZbgĂ .
     * @param ID 쐬̏IuWFNgID
     * @return ݂̒l
     */
    static int nextVal(std::string& ID);
    static int nextVal(const char* ID);
};

}
#endif /*GGAF_CORE_REPEATSEQ_H_*/
