#ifndef GGAF_CORE_LINKEDLISTRING_H_
#define GGAF_CORE_LINKEDLISTRING_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include "jp/ggaf/core/exception/CriticalException.h"

namespace GgafCore {

/**
 * oAXg(O[)\zB.
 * <B>yz</B><BR>
 * IuWFNgփ|C^̊oAXg쐬܂B<BR>
 * Ⴆ΁Â悤ȃR[h
 * <pre><code>
 * Object* A = new Object();
 * Object* B = new Object();
 * Object* C = new Object();
 * Object* D = new Object();
 * Object* E = new Object();
 * LinkedListRing<Object> ring_list = LinkedListRing<Object>();
 * ring_list.addLast(A);
 * ring_list.addLast(B);
 * ring_list.addLast(C);
 * ring_list.addLast(D);
 * ring_list.addLast(E);
 * </code></pre>
 *
 * T̗vfŉ}̂悤ȍ\̂鎖o܂B<BR>
 * <pre>
 * -------------------------------------------------
 * ([E])[A]![B][C][D][E]([A]!)
 * -------------------------------------------------
 *
 * -------------------------------------------------
 * C[W}   [`]!
 *             ^  _
 *          [d]    [a]
 *            \      /
 *           [c][[b]
 * --------------------------------------------------
 * 擪vf     :[A]     (=getFirst();)
 * ԗvf     :[B]`[D]
 * vf     :[E]     (=getLast(); =getFirst()->getPrev();)
 * Jgvf :[A]     (=getCurrent();)
 * </pre>
 * ev[g͓ێ|C^̌^w肵܂B<BR>
 * ܂AuLinkedListRing<Object*>();vł͂ȂuLinkedListRing<Object>();vƂ邱ƂƂ܂B<BR>
 * w[A]x́w [ ] x ́AwvfxƌĂ΂ꕨiReij\Aw[A]x́wAx͗vfێwlx\Ă܂B<BR>
 * }́ẃx́Avfm݂|C^wĂ鎖Ă܂B<BR>
 * "!" ̓Jgvf(J[\wĂ悤Ȃ)ŁA{ev[g\bhɂ@\̊ƂȂvfłB<BR>
 * [́w([E])xƁw([A]!)xƂ\ĹAvfXg̐擪ƖA݂AĂ鎖Ă܂B<BR>
 * ɂȂĂ邽ߏI[Ai next  prev \łB<BR>
 * next  prev ł̏I[͂܂񂪁AtOɂăXg̐擪vfAvf͊ǗĂ܂B<BR>
 * }ł́Aw[A]x 擪vfAw[E]x 𖖔vfAƂēǗĂAʏ̐`Xĝ悤Ȏg\łB<BR>
 * [ߑ]<BR>
 * {NX̐ŁAuvfvƂ\́A̓Ci[NX ElemIuWFNgւ̃|C^̎wA<BR>
 * uvf̒lvƂ\ Elem IuWFNg̃o _pValue w܂B<BR>
 * uvf̒lv̌^ T* łB̗ł Object* ^w܂BObject ̒l̂ł͂܂B
 * <BR>
 * @tparam T Ǘvf̌^ǐ^̃|C^^ŊǗBj
 * @version 1.00
 * @since 2008/12/19
 * @author Masatoshi Tsuge
 */
template<class T>
class LinkedListRing: public Object {

public:
    /**
     * Rei .
     * lbvAO|C^ێB
     */
    class Elem {
    public:
        /** [r]ۂ̗vf̒l */
        const T* _pValue;
        /** [r]vf */
        Elem* _pNext;
        /** [r]Ovf */
        Elem* _pPrev;
        /** [r]֘Avfz */
        Elem** _papRelation;
        /** [r]擪vftO (vf擪vf̏ꍇ true)*/
        bool _is_first_flg;
        /** [r]vftO (vfvf̏ꍇ true)*/
        bool _is_last_flg;
        /** [r/w]delete_pValuedelete邩ǂ̃tO */
        bool _is_delete_value;
        /** [r]擪vf̃CfbNX(0`)BcreateIndex()sō쐬 */
        int _idx;

    public:
        /**
         * RXgN^
         * @param prm_pValue li|C^j
         * @param prm_relation_num ǉmۂ֘Avf
         * @param prm_is_delete_value true  : LinkedListRingCX^XdeleteɁAvf(_pValue)deleteB<BR>
         *                            false : vf(_pValue)deleteȂB
         */
        Elem(const T* prm_pValue, int prm_relation_num,
                bool prm_is_delete_value = true) {
            _pValue = prm_pValue;
            _pNext = _pPrev = nullptr;
            if (prm_relation_num == 0) {
                _papRelation = nullptr;
            } else {
                _papRelation = NEW Elem*[prm_relation_num];
                for (int i = 0; i < prm_relation_num; i++) {
                    _papRelation[i] = nullptr;
                }
            }
            _is_first_flg = _is_last_flg = false;
            _is_delete_value = prm_is_delete_value;
            _idx = -1;
        }
        /**
         * vf̒lԂB
         * @return l
         */
        inline T* getValue() const {
            return (T*) _pValue;
        }
        /**
         * vfIɊ֘At .
         * @param prm_connection_index vf֘Aڑԍ
         * @param prm_pOppElem ֘Avf
         */
        void connect(int prm_connection_index, Elem* prm_pOppElem) {
            _papRelation[prm_connection_index] = prm_pOppElem;
        }
        /**
         * fXgN^.
         * ێvf̒ldelete܂B<BR>
         */
        ~Elem() {
            if (_is_delete_value) {
                GGAF_DELETE(_pValue);
            }
            GGAF_DELETEARR_NULLABLE(_papRelation);
        }
    }; //class Elem

    /** [r]擪vf */
    Elem* _pElem_first;
    /** [r]Jgvf */
    Elem* _pElemActive;
    /** [r]vf */
    int _num_elem;
    /** [r]֘Avf */
    int _relation_num;
    /** [r]CfbNXɑ΂vfl̔zAcreateIndex()sō쐬 */
    const T** _papLinearVal;

public:
    /**
     * RXgN^ .
     * g֘AvfƂ́Anext prev ȊOɃ[Vs}łB
     * @param prm_extend_relation_num g֘Avf
     */
    LinkedListRing(int prm_extend_relation_num = 0);

    /**
     * fXgN^.
     * ێvf̒ĺAnullptrŖꍇAꂼ delete ɂ܂B<BR>
     * TODO:delete[] ₻̑̉@ɑΉ
     */
    virtual ~LinkedListRing();

    /**
     * ̒lAJgvf́uvɒǉB
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                addNext(X) sBJgvf [C] ́uvɑ}B
     * ---usv------------------------------
     * ([E])[A][B][C]![X][D][E]([A])
     * -------------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addNext ́A<BR>
     * ̒l̗vf̓JgvfɂȂ܂B<BR>
     * Qڈȍ~ addNext() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * nullptr(vfȂ)
     * -------------------------------------------
     *                addNext(A)
     * -------------------------------------------
     * ([A]!)[A]!([A]!)
     * -------------------------------------------
     *                addNext(B)
     * -------------------------------------------
     * ([B])[A]![B]([A]!)
     * -------------------------------------------
     *                addNext(C)
     * -------------------------------------------
     * ([B])[A]![C][B]([A]!)
     * -------------------------------------------
     * </pre>
     * <BR>
     * Jgvf̏ԂŖ{\bhsÁuvɑ}sꍇA<BR>
     * ̒lA̗vflɂȂ܂Bi̒l̗vfA擪ɂ͂Ȃ܂j<BR>
     * <pre>
     * ---usOv------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     *                addNext(X)
     * ---usv------------------------------
     * ([X])[A][B][C][D][E]![X]([A])
     * -------------------------------------------
     * </pre>
     * createIndex() ɂč쐬ꂽCfbNX͔j܂B
     *
     * @param prm_pNew CX^Xςݗvf̃|C^
     * @param prm_is_delete_value true  : XgdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̒ǉvflɂĉsȂB
     */
    virtual void addNext(const T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * ̒lAJgvf́uOvɒǉBJgvf͕ωȂ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                addPrev(X)
     * ---usv------------------------------
     * ([E])[A][B][X][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addPrev() ́A
     * ̒l̓JgvflƂȂ܂B<BR>
     * Qڈȍ~ addPrev() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * nullptr(vfȂ)
     * -------------------------------------------
     *                addPrev(A)
     * -------------------------------------------
     * ([A]!)[A]!([A]!)
     * -------------------------------------------
     *                addPrev(B)
     * -------------------------------------------
     * ([A]!)[B][A]!([B])
     * -------------------------------------------
     *                addPrev(C)
     * -------------------------------------------
     * ([A]!)[B][C][A]!([B])
     * -------------------------------------------
     * </pre>
     * <BR>
     * Jgvf擪̏ԂŖ{\bhsA擪́uOvɑ}sꍇA<BR>
     * ̒l̗vf擪ɂȂ܂Bi̒l̗vfɂ͂Ȃ܂j<BR>
     * <pre>
     * ---usOv------------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * -------------------------------------------
     *                addPrev(X)
     * ---usv------------------------------
     * ([E])[X][A]![B][C][D][E]([X])
     * -------------------------------------------
     * </pre>
     * createIndex() ɂč쐬ꂽCfbNX͔j܂B
     *
     * @param prm_pNew Vvf̒l
     * @param prm_is_delete_value true  : XgdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̒ǉvfɂĉsȂB
     */
    virtual void addPrev(const T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * ̒lA(_is_last_flg  true)ƂĒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                addLast(X)
     * ---usv------------------------------
     * ([X])[A][B][C]![D][E][X]([A])
     * -------------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addLast() ́A
     * ̒l̓JgvfɂȂ܂B<BR>
     * Qڈȍ~ addLast() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * nullptr(vfȂ)
     * -------------------------------------------
     *                addLast(A)
     * -------------------------------------------
     * ([A]!)[A]!([A]!)
     * -------------------------------------------
     *                addLast(B)
     * -------------------------------------------
     * ([B])[A]![B]([A]!)
     * -------------------------------------------
     *                addLast(C)
     * -------------------------------------------
     * ([C])[A]![B][C]([A]!)
     * -------------------------------------------
     * </pre>
     * createIndex() ɂč쐬ꂽCfbNX͔j܂B
     *
     * @param prm_pNew Vvf̒l
     * @param prm_is_delete_value true  : Xg̃CX^XdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : Xg̃CX^XdeleteɁA̒ǉvflɂĉsȂB
     */
    virtual void addLast(const T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * ̒lA擪(_is_first_flg  true)ƂĒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                addFirst(X)
     * ---usv------------------------------
     * ([E])[X][A][B][C]![D][E]([X])
     * -------------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addFirst() ́A
     * ̒l̓JgvfȂ܂B<BR>
     * Qڈȍ~ addFirst() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * nullptr(vfȂ)
     * -------------------------------------------
     *                addFirst(A)
     * -------------------------------------------
     * ([A]!)[A]!([A]!)
     * -------------------------------------------
     *                addFirst(B)
     * -------------------------------------------
     * ([A]!)[B][A]!([B])
     * -------------------------------------------
     *                addFirst(C)
     * -------------------------------------------
     * ([A]!)[C][B][A]!([C])
     * -------------------------------------------
     * </pre>
     * createIndex() ɂč쐬ꂽCfbNX͔j܂B
     *
     * @param prm_pNew Vvf̒l
     * @param prm_is_delete_value true  : XgdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̒ǉvflɂĉsȂB
     */
    virtual void addFirst(const T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * Jgvfi߁A̗vf̒l𓾂 .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                next()sBJgvfuvɐi߁Al D Qbg
     * ---usv------------------------------
     * ([E])[A][B][C][D]![E]([A])
     * -------------------------------------------
     * </pre>
     * <BR>
     * Jgvf̏ԂŖ{\bhsƁA<BR>
     * 擪JgvfɂȂ܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     *                 next()sBJgvfu(擪)vɐi߁Al A Qbg
     * ---usv------------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * -------------------------------------------
     * </pre>
     * @return Jgvfi߂A̗vf̒lԂ
     */
    virtual T* next();

    /**
     * Jgvf߂A̗vf̒l𓾂 .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                prev() sBl B Qbg
     * ---usv------------------------------
     * ([E])[A][B]![C][D][E]([A])
     * -------------------------------------------
     * </pre>
     * <BR>
     * Jgvf擪̏ԂŖ{\bhsƁA<BR>
     * JgvfɂȂ܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * -------------------------------------------
     *                  prev() sBJgvfuO()vɈړAl E Qbg
     * ---usv------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     * </pre>
     * @return JgvfOɖ߂A̗vf̒lԂ
     */
    virtual T* prev();

    /**
     * Jgvf擪ɖ߂A̗vf̒l𓾂 .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                Jg擪ɈړA̗vf̒l A Qbg
     * ---usv------------------------------
     * ([E])[A]![B][C][D][E]([A])
     * -------------------------------------------
     * </pre>
     * @return Jgvf擪ɖ߂A̗vf̒lԂ
     */
    virtual T* first();
    /**
     * Jgvf𖖔ֈړB .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                Jg𖖔ɈړA̗vf̒l E Qbg
     * ---usv------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     * </pre>
     * @return Jgvf𖖔ֈړ́A̗vf̒l
     */
    virtual T* last();

    /**
     * Jgvfw̐擪vf̐΃CfbNXɈړA̗vf̒l𓾂 .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                current(1); JgړA̗vf̒l B Qbg
     * ---usv------------------------------
     * ([E])[A][B]![C][D][E]([A])
     *         0    1     2    3    4
     * -------------------------------------------
     * </pre>
     * @param n 擪vf̐΃CfbNX
     * @return Jgvfړ́A̗vf̒l
     */
    virtual T* current(int n);

    /**
     * Jgvf֘AvfֈړA̗vf̒l𓾂  .
     * ̊֘Avfڑԍ͈͊ȌꍇA͊֘Aݒ̏ꍇG[
     * @param prm_connection_index ֘Avfڑԍ
     * @return Jgvf֘Avfֈړ́A̗vf̒l
     */
    virtual T* gotoRelation(int prm_connection_index);

    /**
     * Jgvf̗̎vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                getNext() sBɕωɁAl D Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * Jgvf̏ԂŖ{\bhsƁA<BR>
     * 擪vf̒l擾邱ƂɂȂ܂B<BR>
     * <pre>
     * ---usOv------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     *                 getNext() sBɕωɁAl A Qbg
     * ---usv------------------------------
     * (![E])[A][B][C][D][E]!([A])
     * -------------------------------------------
     * </pre>
     * @return ̗vf̒l
     */
    virtual T* getNext() const;

    /**
     * Jgvf̂Ԗڂ̗vf̒l擾BJgvf͕ωȂ .
     * getNext(1) ́AgetNext() ƓłBgetNext(0)  getCurrent()ƓłB
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     *                   0     1    2     3
     *   2     3    4    5
     * -------------------------------------------
     *                getNext(2) sBɕωɁAl E Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @param n CfbNX
     * @return Jgvf炎Ԗڂ̗vf̒l (A n >= 0)
     */
    virtual T* getNext(int n) const;

    /**
     * Jgvf̂PO̗vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                getPrev() sBɕωɁAl B Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @return O̗vf̒l
     */
    virtual T* getPrev() const;

    /**
     * Jgvf̂ԖڑO̗vf̒l擾BJgvf͕ωȂ .
     * getPrev(1) ́AgetPrev() ƓłBgetPrev(0)  get()ƓłB
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     *   3     2    1    0
     *                   5     4    3     2
     * -------------------------------------------
     *                getPrev(2) sBɕωɁAl A Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @param n CfbNX
     * @return Jgvf炎ԖڑO̗vf̒l (A n >= 0)
     */
    virtual T* getPrev(int n) const;

    /**
     * 擪̗vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                ω[A]Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @return 擪̗vf̒l
     */
    virtual T* getFirst() const;

    /**
     * 擪vf̂Ԗڂ̗vf̒l擾BJgvf͕ωȂ .
     * getFromFirst(0) ́AgetFirst() ƓłB
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     *         0    1    2     3    4     5
     *   4     5    6
     * -------------------------------------------
     *                getFromFirst(3) sBɕωɁAl D Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @param n CfbNX
     * @return 擪vf炎Ԗڂ̗vf̒l (A n >= 0)
     */
    virtual T* getFromFirst(int n) const;

    /**
     * ̗vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                getLast() sBɕωɁAl E Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @return ̗vf̒l
     */
    virtual T* getLast() const;

    /**
     * Jgvf̒liێĂej擾 .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                sBɕωɁAl C Qbg
     * ---usv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * @return  Jgvf̒l
     */
    virtual T* getCurrent() const;

    /**
     * ֘Avf̒l擾BJgvf͕ωȂ .
     * @param prm_connection_index ֘Avfڑԍ
     * @return ֘Avf̒l^͈͊ȌꍇA͊֘Aݒ̏ꍇ nullptr
     */
    virtual T* getRelation(int prm_connection_index) const;

    /**
     * ݂̃Jgvf́A擪牽Ԗڂ(0`)ԂB
     * getCurrent() nullptr ̏ꍇ -1 ԂB
     * @return Jgvf̃CfbNX
     */
    virtual int getCurrentIndex() const;

    /**
     * JgvfXg̖ł邩ǂ肷 .
     * <pre>
     * -------------------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     * }̏ꍇ true
     * </pre>
     * @return true:ł^false:ł͖
     */
    virtual bool isLast() const;

    /**
     * JgvfXg̐擪ł邩ǂ肷 .
     * <pre>
     * -------------------------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * -------------------------------------------
     * }̏ꍇ true
     * </pre>
     * @return true:ł^false:ł͖
     */
    virtual bool isFirst() const;

    /**
     * Jgvfɒl㏑ݒ肷B .
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                set(X) c l X ㏑āAX̒l C Qbg
     * ---usv------------------------------
     * ([E])[A][B][X]![D][E]([A])
     * -------------------------------------------
     *
     * AA㏑Ǒ̗vfݒ莞ɁA delete tOZbgɂĂꍇA
     * {\bhsɓ delete A߂lɂ nullptrԂ܂B
     * </pre>
     * @param prm_pVal Vvf̒l
     * @param prm_is_delete_value true  : XgdeleteɁA̗vflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̗vflɂĉsȂB
     * @return ̐ݒvf delete ̏ꍇ nullptr ^ ̐ݒvf delete ł͂ȂꍇA㏑O̗vf(ɗp鎖zB)
     */
    virtual T* set(const T* prm_pVal, bool prm_is_delete_value = true);

    /**
     * Jgvf𔲂 .
     * VȃJgvf next ̗vfɕςB
     * <pre>
     * ---usOv------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     *                remove() c vf [C] BĒl C Qbg
     * ---usv------------------------------
     * ([E])[A][B][D]![E]([A])
     * -------------------------------------------
     * </pre>
     *
     * <BR>
     * Jgvfꍇ<BR>
     * VȃJgvf͐擪vfɕςB
     * <pre>
     * ---usOv------------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * -------------------------------------------
     *                remove() c vf [C] BĒl E Qbg
     * ---usv------------------------------
     * ([D])[A]![B][C][D]([A]!)
     * -------------------------------------------
     * </pre>
     * createIndex() ɂč쐬ꂽCfbNX͔j܂BiKvł΍č쐬Ăj
     * l̉Kvȏꍇ́A߂lgpČĂьōsĉB
     * @return OɃJgvfvf̒l
     */
    virtual T* remove();

    /**
     * SĂ̗vf𔲂 .
     */
    virtual int removeAll();

    /**
     * 擪牽ԖڂԂB
     * ێĂvf̒l̓|C^̂߁Al̔rł͂Ȃ|C^(AhX)v
     * CfbNXԂ܂BCfbNX0̐lłB
     * <pre><code>
     * Object* A = new Object();
     * Object* B = new Object();
     * Object* C = new Object();
     * Object* D = new Object();
     * Object* E = new Object();
     * LinkedListRing<Object> ring_list = LinkedListRing<Object>();
     * ring_list.addLast(A);
     * ring_list.addLast(B);
     * ring_list.addLast(C);
     * ring_list.addLast(D);
     *
     * int a = ring_list.indexOf(A);   // a = 0 ƂȂ
     * int b = ring_list.indexOf(B);   // b = 1 ƂȂ
     * int c = ring_list.indexOf(C);   // c = 2 ƂȂ
     * int d = ring_list.indexOf(D);   // d = 3 ƂȂ
     * int e = ring_list.indexOf(E);   // e = -1 ƂȂ(݂Ȃꍇ̖߂l)
     * </code></pre>
     * @param prm_pVal CfbNX𒲂ׂvf
     * @return ݂ꍇÃCfbNX(0`)ԂA݂Ȃꍇ -1 ԂB
     */
    virtual int indexOf(const T* prm_pVal) const;

    /**
     * vfԂ .
     * <pre>
     * -------------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * }̏ꍇAlength()  5 Ԃ
     * ܂Avfꍇ 0 Ԃ܂B
     * @return vf
     */
    virtual int length() const;

    /**
     * 擪vfԂ .
     * <pre>
     * -------------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * }̏ꍇAgetElemFirst() ͗vf [A] Ԃil A ł͖jB
     * @return
     */
    Elem* getElemFirst() const {
        return _pElem_first;
    }

    /**
     * JgvfԂ .
     * <pre>
     * -------------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * -------------------------------------------
     * </pre>
     * }̏ꍇAgetElemActive() ͗vf [C] Ԃil C ł͖jB
     * @return
     */
    Elem* getElemActive() const {
        return _pElemActive;
    }

    /**
     * 擪炎Ԗڂ̗vfԂ .
     * <pre>
     * -------------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     *         0    1    2     3    4     5
     *   4     5
     * -------------------------------------------
     * </pre>
     * }̏ꍇAgetElemFromFirst(3) ͗vf [D] Ԃil D ł͖jB
     * @param n 擪̃CfbNX(A n >= 0)
     * @return 擪炎Ԗڂ̗vf
     */
    Elem* getElemFromFirst(int n) const {
        if (_pElem_first == nullptr) {
            return nullptr;
        }
        Elem* pElem = _pElem_first;
        int x = n % _num_elem;
        for (int i = 0; i < x; i++) {
            pElem = pElem->_pNext;
        }
        return pElem;
    }

    /**
     * CfbNX쐬 .
     * vflւ̎QƂAzɕʓrێQƎɗp܂B
     * CfbNXŒl擾郁\bh̃ptH[}Xオ܂B
     * AvfύXƁAč\z̕Kv܂B
     * vflǉAvfωȂXgȂ΁A{\bhs܂傤B
     */
    void createIndex();

    /**
     * SĂ̗vflɑ΂Ďẘ֐s .
     * vfñ|C^A֐|C^ pFunc̑P T* ɓnĂ܂B
     * prm1, prm2, prm3 ́A֐|C^ void*, void*, void* ɓnĂ܂B(Lv`IɎgāI)<BR>
     * <BR>
     * gp၄<BR>
     * tH[[V̕ґo[̃IuWFNg(Actor*)ALinkedListRingXg(listFollowers_)
     * ǗĂƂB<BR>
     * ̕ґo[SɁA(order1)oB̑x int velo_mv_ ƂB
     * ƂꍇAȉ̂悤ȊɂȂB<BR>
     * <BR>
     * <code><pre>
     *
     * class FormationXXX : public DepositoryFormation {
     * public :
     *     int velo_mv_;
     *     LinkedListRing<Actor> listFollowers_;
     *
     *     static void FormationXXX::order1(Actor* prm_pActor, void* p1, void* p2, void* p3) {
     *         //X̃o[
     *         EnemyXXX* pEnemyXXX = (EnemyDelheid*)prm_pActor; //̌^ɃLXg
     *         int velo_mv = *((velo*)p1);                       //Lv`̌^ɖ߂
     *         pEnemyXXX->getVecDriver()->setMvVelo(velo_mv);         //ݒ
     *     }
     *
     *     void processBehavior() {
     *         //SĂ̕ґo[ɉxoB
     *         velo_mv_ = 3000; //x
     *         listFollowers_.executeFunc(FormationXXX::order1, &velo_mv_, nullptr, nullptr);
     *     }
     * }
     *
     * </pre></code>
     * @param pFunc vflɎs֐Bp[^(T*, void*, void*, void*) ŒBT* vf̒lnB
     * @param prm1 n̂P
     * @param prm2 n̂Q
     * @param prm3 n̂R
     */
    void executeFunc(void (*pFunc)(T*, void*, void*, void*), void* prm1, void* prm2, void* prm3) {
        if (_pElemActive == nullptr) {
            return;
        } else {
            Elem* pElem = _pElem_first;
            int n = _num_elem;
            for (int i = 0; i < n; i++) {
                pFunc((T*) pElem->_pValue, prm1, prm2, prm3);
                pElem = pElem->_pNext;
            }
            return;
        }
    }
};

//////////////////////////////////////////////////////////////////

/**
 * ͎
 */

template<class T>
LinkedListRing<T>::LinkedListRing(int prm_extend_relation_num) :
        Object() {
    _num_elem = 0;
    _pElemActive = nullptr;
    _pElem_first = nullptr;
    _relation_num = prm_extend_relation_num;
    _papLinearVal = nullptr;
}


template<class T>
void LinkedListRing<T>::addNext(const T* prm_pNew,
        bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwCriticalException("[LinkedListRing::addNext()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);
    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_last_flg = true;
        pElem->_is_first_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        Elem* pMy = _pElemActive;
        if (pMy->_is_last_flg) {
            pMy->_is_last_flg = false;
            pElem->_is_last_flg = true;
            pElem->_is_first_flg = false;
        }
        Elem* pMyNext = _pElemActive->_pNext;
        pMy->_pNext = pElem;
        pElem->_pPrev = pMy;
        pElem->_pNext = pMyNext;
        pMyNext->_pPrev = pElem;
    }
    _num_elem++;
    if (_papLinearVal) {
        GGAF_DELETEARR(_papLinearVal);
    }
}

template<class T>
void LinkedListRing<T>::addPrev(const T* prm_pNew,
        bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwCriticalException("[LinkedListRing::addPrev()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);
    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_last_flg = true;
        pElem->_is_first_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        Elem* pMy = _pElemActive;
        if (pMy->_is_first_flg) {
            pMy->_is_first_flg = false;
            pElem->_is_first_flg = true;
            pElem->_is_last_flg = false;
            _pElem_first = pElem;
        }
        Elem* pMyPrev = _pElemActive->_pPrev;
        pMyPrev->_pNext = pElem;
        pElem->_pPrev = pMyPrev;
        pElem->_pNext = pMy;
        pMy->_pPrev = pElem;
    }
    _num_elem++;
    if (_papLinearVal) {
        GGAF_DELETEARR(_papLinearVal);
    }
}

template<class T>
void LinkedListRing<T>::addLast(const T* prm_pNew,
        bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwCriticalException("[LinkedListRing::addLast()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);

    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_first_flg = true;
        pElem->_is_last_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        //Qڈȍ~
        pElem->_is_first_flg = false;
        pElem->_is_last_flg = true;
        Elem* pLastElem = _pElem_first->_pPrev;
        pLastElem->_is_last_flg = false;
        pLastElem->_pNext = pElem;
        pElem->_pPrev = pLastElem;
        pElem->_pNext = _pElem_first;
        _pElem_first->_pPrev = pElem;
    }
    _num_elem++;
    if (_papLinearVal) {
        GGAF_DELETEARR(_papLinearVal);
    }
}

template<class T>
void LinkedListRing<T>::addFirst(const T* prm_pNew,
        bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwCriticalException("[LinkedListRing::addFirst()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);
    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_first_flg = true;
        pElem->_is_last_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        Elem* pFirstElem = _pElem_first;
        Elem* pLastElem = _pElem_first->_pPrev;
        pLastElem->_pNext = pElem;
        pElem->_pPrev = pLastElem;
        pElem->_pNext = pFirstElem;
        pFirstElem->_pPrev = pElem;
        pFirstElem->_is_first_flg = false;

        pElem->_is_first_flg = true;
        pElem->_is_last_flg = false;
        _pElem_first = pElem;
    }
    _num_elem++;
    if (_papLinearVal) {
        GGAF_DELETEARR(_papLinearVal);
    }
}

template<class T>
T* LinkedListRing<T>::next() {
    _pElemActive = _pElemActive->_pNext;
    return (T*) _pElemActive->_pValue;
}

template<class T>
T* LinkedListRing<T>::prev() {
    _pElemActive = _pElemActive->_pPrev;
    return (T*) _pElemActive->_pValue;
}

template<class T>
T* LinkedListRing<T>::first() {
    _pElemActive = _pElem_first;
    return (T*) _pElemActive->_pValue;
}

template<class T>
T* LinkedListRing<T>::last() {
    _pElemActive = _pElem_first->_pPrev; //Ȃ̂ŁA擪̈O͖
    return (T*) _pElemActive->_pValue;
}

template<class T>
T* LinkedListRing<T>::current(int n) {
    Elem* pElem = _pElem_first;
    for (int i = 0; i < n; i++) {
        pElem = pElem->_pNext;
    }
    _pElemActive = pElem;
    return (T*) _pElemActive->_pValue;
}

template<class T>
T* LinkedListRing<T>::gotoRelation(int prm_connection_index) {
#ifdef MY_DEBUG
    if (_relation_num-1 < prm_connection_index) {
        throwCriticalException("LinkedListRing<T>::gotoRelation ڑvfԍ͈̔͊OłBprm_connection_index="<<prm_connection_index);
    }
#endif
    _pElemActive = _pElemActive->_papRelation[prm_connection_index];
#ifdef MY_DEBUG
    if (_pElemActive == nullptr) {
        throwCriticalException("LinkedListRing<T>::gotoRelation ڑvfԍ̗vfݒłBprm_connection_index="<<prm_connection_index);
    }
#endif
    return (T*) _pElemActive->_pValue;
}

template<class T>
T* LinkedListRing<T>::getNext() const {
    return (T*) _pElemActive->_pNext->_pValue;
}

template<class T>
T* LinkedListRing<T>::getNext(int n) const {
#ifdef MY_DEBUG
    if (n < 0) {
        throwCriticalException("LinkedListRing<T>::getNext ɂ͐̐ݒ肷Kv܂ n="<<n);
    }
#endif
    if (_papLinearVal) { //CfbNX
        int i = _pElemActive->_idx + n;
        return (T*) _papLinearVal[(i >= _num_elem ? (i % _num_elem) : i)];
    } else { //CfbNXȂ
        Elem* pElem = _pElemActive;
        int x = n % _num_elem;
        for (int i = 0; i < x; i++) {
            pElem = pElem->_pNext;
        }
        return (T*) pElem->_pValue;
    }
}

//template<class T>
//T* LinkedListRing<T>::getFromCurrent(int n) const {
//    if (_papLinearVal) { //CfbNX
//      int i = _pElemActive->_idx + n;
//      if (i >= _num_elem) {
//          return (T*)_papLinearVal[(i % _num_elem)];
//      } else if (i < 0) {
//          int x = (-i) % _num_elem;
//          if (x == 0) {
//              return (T*)_papLinearVal[0];
//          } else {
//              return (T*)_papLinearVal[_num_elem - x];
//          }
//
//      } else {
//          return (T*)_papLinearVal[i];
//      }
//    } else { //CfbNXȂ
//      Elem* pElem = _pElemActive;
//      if (n > 0) {
//          for (int i = 0; i < n; i++) {
//              pElem = pElem->_pNext;
//          }
//      } else if (n < 0) {
//          for (int i = 0; i > n; i--) {
//              pElem = pElem->_pPrev;
//          }
//      }
//        return (T*)pElem->_pValue;
//    }
//}

template<class T>
T* LinkedListRing<T>::getFromFirst(int n) const {
#ifdef MY_DEBUG
    if (n < 0) {
        throwCriticalException("LinkedListRing<T>::getFromFirst ɂ͐̐ݒ肷Kv܂ n="<<n);
    }
#endif
    Elem* pElem = _pElem_first;
    if (pElem == nullptr) {
        return nullptr;
    }
    if (_papLinearVal) { //CfbNX
        return (T*) _papLinearVal[(n >= _num_elem ? (n % _num_elem) : n)];
    } else { //CfbNXȂ
        int x = n % _num_elem;
        for (int i = 0; i < x; i++) {
            pElem = pElem->_pNext;
        }
        return (T*) pElem->_pValue;
    }
}

template<class T>
T* LinkedListRing<T>::getPrev() const {
    return (T*) _pElemActive->_pPrev->_pValue;
}

template<class T>
T* LinkedListRing<T>::getPrev(int n) const {
#ifdef MY_DEBUG
    if (n < 0) {
        throwCriticalException("LinkedListRing<T>::getPrev ɂ͐̐ݒ肷Kv܂ n="<<n);
    }
#endif
    if (_papLinearVal) { //CfbNX
        int i = _pElemActive->_idx - (n % _num_elem);
        return (T*) _papLinearVal[(i >= 0 ? i : _num_elem + i)];
    } else { //CfbNXȂ
        Elem* pElem = _pElemActive;
        int x = n % _num_elem;
        for (int i = 0; i < x; i++) {
            pElem = pElem->_pPrev;
        }
        return (T*) pElem->_pValue;
    }
}

template<class T>
T* LinkedListRing<T>::getFirst() const {
    return (T*) _pElem_first->_pValue;
}

template<class T>
T* LinkedListRing<T>::getLast() const {
    return (T*) _pElem_first->_pPrev->_pValue; //Ȃ̂ŁA擪̈O͖
}

template<class T>
T* LinkedListRing<T>::getCurrent() const {
    if (_pElemActive == nullptr) {
        return nullptr;
    } else {
        return (T*) _pElemActive->_pValue;
    }
}

template<class T>
T* LinkedListRing<T>::getRelation(int prm_connection_index) const {
#ifdef MY_DEBUG
    if (_relation_num-1 < prm_connection_index) {
        throwCriticalException("LinkedListRing<T>::getRelation ڑvfԍ͈̔͊OłBprm_connection_index="<<prm_connection_index);
    }
#endif
    Elem* pE = _pElemActive->_papRelation[prm_connection_index];
    if (pE) {
        return (T*) pE->_pValue;
    } else {
        return nullptr;
    }
}

template<class T>
int LinkedListRing<T>::getCurrentIndex() const {
    if (_pElemActive == nullptr) {
        return -1;
    } else {
        if (_papLinearVal) {
            return _pElemActive->_idx;
        } else {
            //]̕@
            Elem* pElem = _pElem_first;
            int n = _num_elem;
            for (int i = 0; i < n; i++) {
                if (pElem == _pElemActive) {
                    return i;
                } else {
                    pElem = pElem->_pNext;
                }
            }
            return -1;
        }
    }
}

template<class T>
bool LinkedListRing<T>::isLast() const {
    return _pElemActive->_is_last_flg;
}

template<class T>
bool LinkedListRing<T>::isFirst() const {
    return _pElemActive->_is_first_flg;
}

template<class T>
T* LinkedListRing<T>::set(const T* prm_pVal, bool prm_is_delete_value) {
    const T* pValue = _pElemActive->_pValue;
    bool is_delete_value = _pElemActive->_is_delete_value;
    _pElemActive->_pValue = prm_pVal;
    _pElemActive->_is_delete_value = prm_is_delete_value;

    if (_papLinearVal) {
        _papLinearVal[_pElemActive->_idx] = prm_pVal;
    }

    if (is_delete_value) {
        GGAF_DELETE(pValue);
        return nullptr;
    } else {
        return (T*) pValue;
    }

}

template<class T>
T* LinkedListRing<T>::remove() {
    Elem* pMy = _pElemActive;
    if (pMy) {
        if (_papLinearVal) {
            //vfύX̂ŃCfbNX͖ɂ
            GGAF_DELETEARR(_papLinearVal);
        }
        _num_elem--;
        if (pMy->_is_first_flg && pMy->_is_last_flg) {
            //vfP̏ꍇ
            _pElemActive = nullptr;
            _pElem_first = nullptr;
            const T* r = pMy->_pValue;
            GGAF_DELETE(pMy);
            return (T*) r;
        } else {
            //AO
            Elem* pMyNext = _pElemActive->_pNext;
            Elem* pMyPrev = _pElemActive->_pPrev;
            //ׂ̃m[hmqAwȂB
            pMyPrev->_pNext = pMyNext;
            pMyNext->_pPrev = pMyPrev;
            if (pMy->_is_last_flg) { //vfȂ
                pMyPrev->_is_last_flg = true; //O̗vfVɂȂ
            }
            if (pMy->_is_first_flg) { //vf擪Ȃ
                _pElem_first = pMyNext;
                pMyNext->_is_first_flg = true; //̗vfV擪ɂȂ
            }
            _pElemActive = pMyNext; //Jgvf next ɍXVB
            const T* r = pMy->_pValue;
            GGAF_DELETE(pMy);
            return (T*) r;
        }
    } else {
        return nullptr;
    }
}

template<class T>
int LinkedListRing<T>::removeAll() {
    if (_papLinearVal) {
        //vfύX̂ŃCfbNX͖ɂ
        GGAF_DELETEARR(_papLinearVal);
    }

    Elem* pElem = _pElem_first;
    int n = 0;
    while (pElem) {
        if (pElem->_is_last_flg) {
            GGAF_DELETE(pElem);
            break;
        } else {
            Elem* pTmp = pElem->_pNext;
            GGAF_DELETE(pElem);
            pElem = pTmp;
        }
    }
    _num_elem = 0;
    _pElemActive = nullptr;
    _pElem_first = nullptr;
    return n;
}

template<class T>
int LinkedListRing<T>::indexOf(const T* prm_pVal) const {
    if (_pElem_first == nullptr) {
        return -1;
    }
    int r = 0;
    Elem* pElem = _pElem_first;
    while (true) {
        if (pElem->_pValue == prm_pVal) {
            return r;
        } else {
            if (pElem->_is_last_flg) {
                break;
            } else {
                pElem = pElem->_pNext;
                r++;
            }
        }
    }
    return -1;
}

template<class T>
int LinkedListRing<T>::length() const {
    return _num_elem;
}

template<class T>
void LinkedListRing<T>::createIndex() {
    if (_papLinearVal) {
        GGAF_DELETEARR(_papLinearVal);
    }
    Elem* p = _pElem_first;
    int len = length();
    _papLinearVal = NEW const T*[len];
    for (int i = 0; i < len; i++) {
        p->_idx = i;
        _papLinearVal[i] = p->_pValue;
        p = p->_pNext;
    }
}

template<class T>
LinkedListRing<T>::~LinkedListRing() {
    _TRACE_("LinkedListRing<T>::~LinkedListRing() _num_elem="<<_num_elem);
    //Ɏqꍇ
    if (_pElem_first) {
        //܂qdelete
        if (_num_elem == 1) {
            //qvf͂P̏ꍇ
            GGAF_DELETE(_pElem_first);
            _pElem_first = nullptr;
            _pElemActive = nullptr;
            _num_elem = 0;

        } else {
            //qvf͂Qȏ̏ꍇ
            Elem* pLast = _pElem_first->_pPrev;
            Elem* pLastPrev = pLast->_pPrev;
            while (true) {
                GGAF_DELETE(pLast); //delete
                if (pLastPrev->_is_first_flg) {
                    GGAF_DELETE(_pElem_first); //pChildLastPrev == _pChildFirst ł
                    _pElem_first = nullptr;
                    _pElemActive = nullptr;
                    _num_elem = 0;
                    break;
                }
                pLast = pLastPrev;
                pLastPrev = pLastPrev->_pPrev;
            }
        }
    }

    if (_papLinearVal) {
        GGAF_DELETEARR(_papLinearVal);
    }
}

}
#endif /*GGAF_CORE_LINKEDLISTRING_H_*/
