#ifndef GGAF_CORE_DEPOSITORYFORMATION_H_
#define GGAF_CORE_DEPOSITORYFORMATION_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/actor/ex/Formation.h"

#include "jp/ggaf/core/util/LinkedListRing.hpp"

namespace GgafCore {

/**
 * f|WgǗ̃tH[[VǗ[NX .
 * ґo[͎g񂷃tH[[VB
 * gpꍇ́A{NXpA
 * setFormationMember(ActorDepository*) ɂ
 * ґo[̃f|WgIuWFNgo^ĂB
 * ܂Ao^̃AN^[j󂳂ꂽꍇ́AґSŔ̂߂
 * Actor::notifyDestroyedToFormation(); R[ĂB
 * processFinal() ς݂ł̂ŁAI[o[Chꍇ͒ӂĉB
 * @version 1.00
 * @since 2008/08/08
 * @author Masatoshi Tsuge
 */
class DepositoryFormation : public Formation {

public:
    /** [r]ґvfƂĊǗĂAN^[̃Xg */
    LinkedListRing<Actor> _listFollower;
    bool _can_called_up;
    /** [r]\o[̃XgbJ[inullptȑꍇ\o[͔zAN^[̂͂j */
    ActorDepository* _pDepo;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_offset_frames_end tH[[VI̗P\t[
     * @return
     */
    DepositoryFormation(const char* prm_name, frame prm_offset_frames_end);

    /**
     * ґ\o[XgbNꂽf|Wgݒ肷 .
     * o[ɂ́Ap\bh calledUpMember() gpB
     * o[ÍAsayonara() gpB
     * @param prm_pDepo
     */
    void setFormationMember(ActorDepository* prm_pDepo);

    /**
     * ґo[SĔ񊈓Ȃ΁A{tH[[VIuWFNg .
     * \o[S sayonara() ŁAf|Wgɖ߂ꍇA
     * {tH[[VIuWFNg悤ɂ邽߂̎dg݂B
     * ʂ processFinal() ̏Kvȏꍇ́A
     * I[o[ChāȀł̉
     * <code>
     * TreeFormation::processFinal();
     * </code>
     * ĂяoĂA
     */
    virtual void processFinal() override;

    /**
     * f|WgAN^[{tH[[Vo[ƂĐݒ肵擾iWj .
     * setFormationMembersitory() ̎OsKvB<BR>
     * {\bhĂяoƁAf|WgɊǗꂽo[ dispatch() ܂B( activate() )
     * f|Wg̃o[ׂĊŁA͊Ăꍇ nullptr Ԃ܂B<BR>
     * ܂A prm_formation_child_num ͍őґ\vŁA̐ȏ̌Ăяoł nullptr Ԃ܂B<BR>
     * xł nullptr ԂƁAtO _can_called_up  false ɂȂAȍ~{tH[[VIuWFNg
     * o[ĂяołȂ悤ɂȂ܂BƓ(_can_called_up==false󂯂)processFinal() ł́A
     * SĂ̕ґo[񊈓A{tH[[VIuWFNgI sayonara(_offset_frames_end) s悤ɂȂ܂B<BR>
     * yn}Pz[ calledUpMember ĂяoŁAf|WgXgbN͊ɂAȂnullptrԂꍇA
     * _can_called_up = false ɂȂ܂BāA{tH[[VIuWFNǵAȂ sayonara(_offset_frames_end) sIB
     * ƂɂȂ܂B\o[mۂłȂꍇlĉB<BR>
     * yn}QzcalledUpMember() Ď擾o[ sayonara() (Iɂinactive()) 邱ƂɂAґ痣EƂɂȂ܂B
     * ]āAcalledUpMember() o[Ainactive() āAꎞۗLmۂ邱Ƃ́ȀuԂɕґ痣EƓӂɂȂ܂̂ŁA
     * ł܂B̂悤ɂꍇ TreeFormation g܂B<BR>
     * @param prm_formation_child_num {tH[[V̊ǗviґSŐjBȗ͔zo[ƂȂB
     * @return ґ\ṽAN^[B
     *         őґ\vI[o[ČĂяoꍇA
     *         f|Wgɍ\vȂꍇ nullptr
     */
    Actor* calledUpMember(int prm_formation_child_num = INT_MAX);

    /**
     * ܂Aґmۂs\ŁAcalledUpMember() ]n邩ǂB .
     * @return trueF]n^falseF]nȂ
     */
    bool canCalledUp() const;

    /**
     * o[cĂΉ܂B
     * păI[o[Chꍇ́A
     * DepositoryFormation::onEnd() ĂяoĉB
     */
    virtual void onEnd() override;

    /**
     * f|Wg[hǗ̕ґSĂ sayonara() sB
     */
    virtual void sayonaraFollwer();

    /**
     * ґɏAN^[SĂȂ(sayonara()Ăяoꂽ)ꍇR[obN郁\bh .
     * KvɉĉʂŃI[o[ChĉB
     */
    virtual void onSayonaraAll() override {
    }

    virtual ~DepositoryFormation();
};

}
#endif /*GGAF_CORE_DEPOSITORYFORMATION_H_*/
