#ifndef GGAF_CORE_MAINACTOR_H_
#define GGAF_CORE_MAINACTOR_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/actor/Actor.h"

namespace GgafCore {

/**
 * ʂ̃AN^[() .
 * ʃAN^[NXւ̃C^[tFCXłA<BR>
 * VɃAN^[NXꍇ{NXpăAN^[NX邱ƂƂB<BR>
 * @version 1.00
 * @since 2008/03/24
 * @author Masatoshi Tsuge
 */
class MainActor : public Actor {

public:
    /** [r]gO[v̒c */
    GroupHead* _pGroupHead;
    /** [r]gO[v̒c̃V[ */
    SceneMediator* _pSceneMediator;

public:
    MainActor(const char* prm_name);

    virtual MainActor* getNext() const override { //ϖ߂l
        return (MainActor*)Actor::getNext();
    }

    virtual MainActor* getPrev() const override { //ϖ߂l
        return (MainActor*)Actor::getPrev();
    }

    void updateActiveInTheTree() override;

    /**
     * c[m[hAXg؂藣AƗB .
     * ؂藣ꌊJ́Ãm[h𖄂߂܂iĘA܂j<BR>
     * m[hɎqԂ牺ĂꍇA؂藣ꂽƂɂȂ܂B<BR>
     * MainActoȑꍇAz _pSceneMediator y _pGroupHead  nullptr ZbgB<BR>
     * @return  m[h̃|C^
     */
    virtual MainActor* extract() override;

    /**
     * V[҂ݒ肷B .
     */
    virtual void setSceneMediator(SceneMediator* prm_pSceneMediator);

    /**
     * cݒ肷B<BR>
     */
    virtual void setGroupHead(GroupHead* prm_pGroupHead);

    /**
     * V[̃V[Ҏ擾BAV[ɏĂȂꍇ́A̐(Spacetime)̃V[҂Ԃ .
     * @return V[҂̒ҁB(Ȃꍇ ̐(Spacetime)̒)
     */
    SceneMediator* getSceneMediator();

    /**
     * V[c擾B .
     * @return c ^ Ȃꍇ nullptr
     */
    virtual GroupHead* getGroupHead();

    /**
     * VɎʂݒ肵AAN^[zɒǉB
     * ʂ̓AN^[ێʂ𖳎A̎ʂD悷B<BR>
     * gƎʂقȂꍇ͎qɒc(GroupHead)ł̂܂qɈ̃AN^[ǉ܂B<BR>
     * gƎʂꍇ́APɎqɈ̃AN^[ǉ܂B<BR>
     * @param prm_kind 
     * @param prm_pMainActor ʂƋɒǉAN^[
     * @return AN^[̒c(GroupHead)
     */
    GroupHead* appendGroupChild(kind_t prm_kind, MainActor* prm_pMainActor);

    /**
     * VɎʂݒ肵AAN^[zɒǉB .
     * Aʂ̓AN^[ێʂ̗pB<BR>
     * gƎʂقȂꍇ͎qɒc(GroupHead)ł̂܂qɈ̃AN^[ǉ܂B<BR>
     * gƎʂꍇ́APɎqɈ̃AN^[ǉ܂B<BR>
     * @param prm_pMainActor ʂƋɒǉAN^[
     * @return AN^[̒c(GroupHead)
     */
    GroupHead* appendGroupChild(MainActor* prm_pMainActor);

    /**
     * z̐\ȒcTB
     * @param prm_kind Tc̎
     * @return cA݂͑Ȃ nullptr
     */
    GroupHead* searchChildGroupHead(kind_t prm_kind);

    /**
     * _ɉy .
     * @return  Ă΂ďoĂ_
     */
    virtual God* askGod() override;

    /**
     * Ăc̎ʂ擾 .
     * ʂ̎ŎRɎgp邱ƂzB
     * @return
     */
    kind_t lookUpKind();

    virtual ~MainActor();
};

}
#endif /*GGAF_CORE_MAINACTOR_H_*/
