#ifndef GGAF_CORE_NODE_H_
#define GGAF_CORE_NODE_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include <cstring>
#include "jp/ggaf/core/util/Util.h"
#include "jp/ggaf/core/exception/CriticalException.h"

namespace GgafCore {

/**
 * vfmoAXg([)ŁAc[\邱Ƃłev[głB.
 * c[m[hAZm[hoAXgŌOʒu֌W̊TOB
 * ܂AZm[hɐ擪m[hAm[h̊TOB擪m[hƖm[h̓tOŊǗB
 * Ȃ̂Ő擪m[hAm[h݂͌ɘAĂB
 * m[h͎livfCX^Xjw킯ł͂ȂAm[h̃IuWFNgglƂĂB
 * ܂AReiɔ񂸁B<BR>
 * łQƉ񐔂炵AptH[}Xグ悤ƂׁEEEB<BR>
 *
 * <B>yz</B><BR>
 * <PRE STYLE="font-size:12px">
 * EÊóEEE
 *       
 * (d)̂`̂âb̂ĉd(`)
 *             
 *                                       
 *     (g)̂êf̂g(e)        (k)̂ĥîĵk(h)
 *                                               
 *                 EEE                              EEE
 * </PRE>
 * }̂悤ȍ\̂鎖o܂B<BR>
 * íu(d)̂`̂âb̂ĉd(`)v͗vfiCX^Xj̑oŃ|C^wĂ鎖Ă܂B<BR>
 * [́u(d)vƁu(`)v́AAXg̐擪ƖA݂AĂ鎖𖾎Ă܂B(ɂȂĂ)<BR>
 * }Ŏg̃CX^XubvƂꍇAubv̎_evf̂悤Ɍď́Ayђ`邱ƂƂ܂B<BR>
 * <TABLE BORDER="1">
 * <TR><TD>ubv</TD><TD>m[h</TD></TR>
 * <TR><TD>u`v</TD><TD>擪(First)m[hB m[hAXgiZm[hj̐擪ƂӖłBu`v  _is_first_flg  true ɂȂĂ܂B(m[h false)</TD></TR>
 * <TR><TD>udv</TD><TD>(Last)m[hB m[hAXgiZm[hj̍ŌƂӖłBudv  _is_last_flg  true ɂȂĂ܂B(̃m[h false)</TD></TR>
 * <TR><TD>ucv</TD><TD>(Next)m[hB}ł͍EƂĂ܂B_pNext|C^wĂvfɂȂ܂B</TD></TR>
 * <TR><TD>uav</TD><TD>O(Prev)m[hB_pPrev wĂ|C^łB</TD></TR>
 * <TR><TD>uov</TD><TD>e(Parent)m[hBm[hAXĝP̊Kw̃m[hłB_pParent |C^wĂvfłBSẴm[h͒߂̐em[h̃|C^Ă܂B</TD></TR>
 * <TR><TD>uhCiCjCkv</TD><TD>ubvq(Child)m[hƌĂт܂B</TD></TR>
 * <TR><TD>uhv</TD><TD> qm[h̒œɁuhv͎qm[h̐擪m[hƌĂсAm[h _pChildFirst |C^wĂvfƂȂĂ܂B</TD></TR>
 * </TABLE>
 * <BR>
 *
 * <B>y̑p⑫z</B>
 * <TABLE BORDER="1">
 * <TR>
 * <TD>um[hvuv</TD>
 * <TD>m[hȊÕm[hSĂwĂ܂B</TD>
 * </TR><TR>
 * <TD>uzm[hvuzv</TD>
 * <TD>m[hm̃c[Kw\ɂāAm[h<B></B>Ԃ牺SẴm[hwĂ܂Bm[h͊܂܂܂B</TD>
 * </TR><TR>
 * <TD>uc[v</TD>
 * <TD>m[h𒸓_ƂAm[h{zm[hō\c[\̂w܂B</TD>
 * </TR><TR>
 * <TD>uc[m[hv</TD>
 * <TD>m[h𒸓_ƂAm[h{zm[hō\c[\̃m[hSĂw܂B</TD>
 * </TR><TR>
 * <TD>uc[v</TD>
 * <TD>m[h܂܂Ăc[\̑SĂw܂B</TD>
 * </TR><TR>
 * <TD>um[hNXv</TD>
 * <TD>NodeNXANodeNX𒼐ځEԐڌpĂNXw܂B</TD>
 * </TR><TR>
 * <TD>uʁvuʁv</TD>
 * <TD>m[hNX̃NXp֌W\Ă܂B
 * {hLgł́ANXp֌W̕\́uX[p[vuqv́uevuqvƌ킸<B>uʁvuʁv</B>œꂷ邱Ƃɂ܂B<BR>
 * uevuqvƕ\ꍇ͂ꂼem[hAqm[h̃c[\̎\̂Ƃ܂Bi₱łˁj<BR>
 * ၄<BR>
 * EʂHogehogeŎꂽRRB<BR>
 *      ӖFHogehogeNXpAŎĂRR<BR>
 * EqHogehogeŎꂽRRB<BR>
 *      ӖFc[\̎qm[hɂHogehogeNXIuWFNgŎĂRR<BR>
 * </TD>
 * </TR>
 * </TABLE>
 * @tparam T Ǘvf̌^ǐ^̃|C^^ŊǗBj
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */

template<class T>
class Node : public Object {

public:
    /** [r]m[hʖ(50܂) */
    char* _name;
    /** [r]NXifobOŎgp܂j */
    const char* _class_name;
    /** [r]em[h */
    T* _pParent;
    /** [r]m[h */
    T* _pNext;
    /** [r]Om[h */
    T* _pPrev;
    /** [r]qm[h̐擪m[h */
    T* _pChildFirst;
    /** [r]擪m[htO (m[h擪m[h̏ꍇ true)*/
    bool _is_first_flg;
    /** [r]m[htO (m[hm[h̏ꍇ true)*/
    bool _is_last_flg;
    /** [r]qm[h̐ */
    int _child_num;

    hashval _name_hash;
public:
    /**
     * RXgN^
     * @param prm_name m[h́ij[Nɂĉj
     */
    explicit Node(const char* prm_name);

    /**
     * fXgN^Bc[m[h܂B .
     * m[hqm[hꍇAqm[hĂ玩gB<BR>
     * m[hŏIm[hꍇAm[hA痣EAOm[hŏIm[htOZbgāAgB<BR>
     * m[h擪m[hꍇAm[hA痣EAm[hem[h  qm[h̐擪m[hA 擪m[htOZbgAgB<BR>
     * m[hԃm[hꍇÃׂm[h̘Ač\zB<BR>
     * m[h̘AgwiPlڂjꍇAem[h  qm[h̐擪m[hiwĂjnullptrɕύXĂB<BR>
     * ̂悤ȍ\̏ꍇAm[h P deleteƁA͇@`L̏ƂȂB<BR>
     * m[hԂŎQƊ֌Wꍇ́AӂKvB<BR>
     * <pre>
     * (o)̇Lo(o)
     *         
     * (d)̇K`̇GȧBḃAċ@d(`)
     *             
     *                                       
     * (g)̇JėIḟHg(e)    (k)̇FḣEi̇Dj̇Ck(h)
     *
     * q݂΂DŖm[hĂB
     * </pre>
     */
    virtual ~Node();

    /**
     * m[h擾 .
     * @return m[h
     */
    inline virtual char* getName() const {
        return _name;
    }

    /**
     * NX擾 .
     * @return NX
     */
    inline virtual const char* getClassName() const {
        return _class_name;
    }

    /**
     * P̐em[hݒ肷B
     * @param    prm_pParent    em[h
     */
    inline virtual void setParent(T* prm_pParent) {
        _pParent = prm_pParent;
    }

    /**
     * c[m[hAXg؂藣AƗB .
     * ؂藣ꌊJ́Ãm[h𖄂߂܂iĘA܂j<BR>
     * m[hɎqԂ牺ĂꍇA؂藣ꂽƂɂȂ܂B<BR>
     * @return    T* m[h̃|C^
     */
    virtual T* extract();

    /**
     * m[hAŏIm[hֈړ .
     * qm[hAɂĈړ܂Bm[hƎqm[h̊֌W͕܂B<BR>
     *<PRE>
     * ----------------usOv
     *         e
     *         
     * idĵ`̂âb̂ĉd́i`j
     * -----------------------
     *         }ŎubvƂꍇÂ悤ȏԂɂȂ
     * ----------------usv
     *         e
     *         
     * idĵ`̂âĉd̂b́i`j
     * -----------------------
     * </PRE>
     */
    virtual void moveLast();

    /**
     * m[hA擪m[hֈړ .
     * qm[hAɂĈړ܂Bm[hƎqm[h̊֌W͕܂B<BR>
     *<PRE>
     * ----------------usOv
     *       e
     *       
     * (d)̂`̂âb̂ĉd(`)
     * -----------------------
     *         }ŎubvƂꍇÂ悤ȏԂɂȂ
     * ----------------usv
     *       e
     *       
     * (d)̂b̂`̂âĉd(b)
     * -----------------------
     * </PRE>
     */
    virtual void moveFirst();

    /**
     * ̃m[h擾B
     * @return    T*    m[h
     */
    inline virtual T* getNext() const {
        return _pNext;
    }

    /**
     * Õm[h擾B
     * @return    T*    Om[h
     */
    inline virtual T* getPrev() const {
        return _pPrev;
    }

    /**
     * P̐em[h擾B
     * @return    T*    em[h
     */
    inline virtual T* getParent() const {
        return _pParent;
    }

    /**
     * m[hqm[h̍Ōɒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B<BR>
     *<PRE>
     * ----------------usOv
     *       b
     *       
     * (j)̂ĥîj(h)
     * -----------------------
     *          }ŎubvƂꍇAɃm[huwvappendChild 
     *          ̂悤ȏԂɂȂ
     * ----------------usv
     *       b
     *       
     * (w)̂ĥîĵw(h)
     * -----------------------
     * </PRE>
     *
     * @param   prm_pChild    CX^Xς݃m[h̃|C^
     */
    virtual void appendChild(T* prm_pChild);

    /**
     * m[hqm[h̐擪ɒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B<BR>
     *<PRE>
     * ----------------usOv
     *       b
     *       
     * (j)̂ĥîj(h)
     * -----------------------
     *          }ŎubvƂꍇAɃm[huwvprependChild 
     *          ̂悤ȏԂɂȂ
     * ----------------usv
     *       b
     *       
     * (j)̂ŵĥîj(w)
     * -----------------------
     * </PRE>
     *
     * @param   prm_pChild    CX^Xς݃m[h̃|C^
     */
    virtual void prependChild(T* prm_pChild);

    /**
     * qm[hm[ĥw肵Ď擾 .
     * ݂Ȃꍇ̓G[<BR>
     *  char* ̔r܂ōs߁AdłB<BR>
     * t[s悤Ȏgpׂ͔łB<BR>
     * @param    prm_child_name    qm[h
     * @return    T*    ŏɃqbgqm[hɑΉqm[h̃|C^
     */
    virtual T* getChildByName(const char* prm_child_name);

    /**
     * ̃m[hqm[hɑ݂ꍇ擾 .
     * @param prm_pChild qm[h
     * @return ݂ꍇqm[hԂA݂Ȃꍇ nullptr Ԃ
     */
    virtual T* getChild(T* prm_pChild) const;

    /**
     * qm[h擪̃CfbNXwŎ擾 .
     * 0  _pChildFirst ƓB
     * @param prm_index CfbNX(0`)
     * @return
     */
    virtual T* getChild(int prm_index) const;

    /**
     * qm[h̃O[v̐擪m[h擾 .
     * qm[h݂ȂꍇnullptrB
     * @return    T*    qm[h̐擪m[h
     */
    inline virtual T* getChildFirst() const {
        return _pChildFirst;
    }

    /**
     * qm[h̃O[v̖m[h擾 .
     * qm[h݂ȂꍇnullptrB
     * @return T*   qm[h̖m[h
     */
    inline virtual T* getChildLast() const {
        if (_pChildFirst) {
            return _pChildFirst->_pPrev;
        } else {
            return nullptr;
        }
    }

    /**
     * qm[h݃`FbN .
     *  char* ̔r܂ōs߁AdłB<BR>
     * t[s悤Ȏgpׂ͔łB<BR>
     * @param    prm_child_actor_name    ݃`FbNqm[h
     * @return    bool true:݂^false:݂Ȃ
     */
    virtual bool hasChild(char* prm_child_actor_name) const;


    /**
     * qm[h擾 .
     * @return  T*  qm[h
     */
    inline virtual int getNumChild() const {
        return _child_num;
    }

    /**
     * m[h擪m[hׂ .
     * @return    bool true:擪m[h^false:擪m[hł͂Ȃ
     */
    inline virtual bool isFirst() const {
        return _is_first_flg;
    }

    /**
     * m[hm[hׂ .
     * @return    bool true:m[h^false:m[hł͂Ȃ
     */
    inline virtual bool isLast() const {
        return _is_last_flg;
    }

    virtual std::string toString() override {
        return getName();
    }

};

//////////////////////////////////////////////////////////////////

/**
 * ͎
 */
template<class T>
Node<T>::Node(const char* prm_name) :
    Object(),
    _name(nullptr),
    _class_name("Node<T>"),
    _pParent(nullptr),
    _pNext((T*)this),
    _pPrev((T*)this),
    _pChildFirst(nullptr),
    _is_first_flg(true),
    _is_last_flg(true),
    _child_num(0)
{
    _name_hash = UTIL::easy_hash(prm_name);
    int len = strlen(prm_name);
    _name = NEW char[len+1];
    strcpy(_name, prm_name);


//#ifdef MY_DEBUG
//    if (strlen(prm_name) > 49) {
//        throwCriticalException("[Node RXgN^ Error! prm_name ̕I[o[ prm_name="<<prm_name<<"");
//    }
//    if (strlen(prm_name) == 0) {
//        throwCriticalException("[Node RXgN^ Error! prm_name ̕0prm_name="<<prm_name<<"");
//
//    }
//#endif
//    _name = NEW char[51];
//    strcpy(_name, prm_name);
}

template<class T>
T* Node<T>::extract() {
    if (_pParent) {
        //AO
        _pParent->_child_num--;
        T* pMyNext = _pNext;
        T* pMyPrev = _pPrev;
        if (_is_first_flg && _is_last_flg) {
            //Âݏꍇ
            _pParent->_pChildFirst = nullptr;
        } else {
            //A甲oꍇ
            //ׂ̃m[hmqAwȂB
            pMyPrev->_pNext = pMyNext;
            pMyNext->_pPrev = pMyPrev;
            if (_is_last_flg) {
                pMyPrev->_is_last_flg = true;
            }
            if (_is_first_flg) {
                pMyNext->_is_first_flg = true;
                _pParent->_pChildFirst = pMyNext;
            }
        }
        _pParent = nullptr;
        _pNext = (T*)this;
        _pPrev = (T*)this;
        _is_first_flg = true;
        _is_last_flg = true;
        //c[͈ێ̂ŁA_pChildFirst ̂܂܁inullptrɂȂj
        return ((T*)this);
    } else {
        //TODO:RRɏꍇ́Aextract()KvȂB
        //_pParentȂɂĂȂextract()KvȂB
        //ƁA߂Ă邪ÁAvfǉ邽߂̃\bh appendChild() prependChild() ݂̂ł邱ƂOƂȂB
        //appendChild() prependChild() ݂̂ōc[\́Ae̒_͏ɗBƂȂ邩炾B
        //AaddNext() ̂悤ɗׂɗvfǉ郁\bhȂ΂ȂȂꍇA
        //e̒_юȂA`̂悤ȍ\̂悤ɂꍇ́A
        //̏ꏊɉÂݐ؂藣ǉKv鎖YꂸɁB

        return ((T*)this);
    }
}

template<class T>
void Node<T>::moveLast() {
    if (_is_last_flg) { //ɍŏIm[hȂΉȂ
        return;
    } else if (_is_first_flg) { //擪m[hȂ΁Ae̎wĂ擪m[hւ炷
        _pParent->_pChildFirst = _pNext;
        _pPrev->_is_last_flg = false;
        _is_first_flg = false;
        _is_last_flg = true;
        _pNext->_is_first_flg = true;
    } else { //ԃm[h
        //ׂ̃m[hmq
        _pPrev->_pNext = _pNext;
        _pNext->_pPrev = _pPrev;
        //m[hƐ擪m[h̊Ԃɂ肱܂
        T* pFirst = _pParent->_pChildFirst; //First
        T* pLast = pFirst->_pPrev;        //Last
        pLast->_is_last_flg = false;      //LastLasttO
        _is_last_flg = true;              //VLasttOZbg
        _pPrev = pLast;                   //̑O͌Last
        _pNext = pFirst;                  //̎͌FirstB
        pLast->_pNext = (T*)this;         //Last͉̎
        pFirst->_pPrev = (T*)this;        //First̑O͉ƂȂB
    }
}

template<class T>
void Node<T>::moveFirst() {
    if (_is_first_flg) { //ɐ擪m[hȂΉȂ
        return;
    } else if (_is_last_flg) { //m[hȂ΁Ae̎wĂ擪m[hOɂ炷
        _pParent->_pChildFirst = (T*)this;
        _pPrev->_is_last_flg = true;
        _is_first_flg = true;
        _is_last_flg = false;
        _pNext->_is_first_flg = false;
    } else { //ԃm[h
        //ׂ̃m[hmq
        _pPrev->_pNext = _pNext;
        _pNext->_pPrev = _pPrev;
        //m[hƐ擪m[h̊Ԃɂ肱܂
        T* pFirst = _pParent->_pChildFirst; //First
        T* pLast = pFirst->_pPrev;        //Last
        pFirst->_is_first_flg = false;    //FirstFirsttO
        _is_first_flg = true;             //VFirsttOZbg
        _pPrev = pLast;                   //̑O͌LastŁA
        _pNext = pFirst;                  //̎͌FirstB
        pLast->_pNext = (T*)this;         //Last͉̎ŁA
        pFirst->_pPrev = (T*)this;        //First̑O͉ƂȂB
        _pParent->_pChildFirst = (T*)this;  //ɁAeChildFirstƂȂ̂B
    }
}

template<class T>
T* Node<T>::getChildByName(const char* prm_child_name) {
#ifdef MY_DEBUG
    if (_pChildFirst == nullptr) {
        throwCriticalException("[Node<" << _class_name << ">::getChild()] Error! _pChildFirstnullptrłB");
    }
#endif
    T* pNodeTemp = _pChildFirst;
    do {
        if (strcmp(pNodeTemp->getName(), prm_child_name) == 0) {
            break;
        }
#ifdef MY_DEBUG
        if (pNodeTemp->_is_last_flg) {
            throwCriticalException("[Node<" << _class_name << ">::getChild()] Error! qm[h݂͑܂B(prm_child_actor_name=" << prm_child_name << ")");
        }
#endif
        pNodeTemp = pNodeTemp->_pNext;
    } while (true);
    return pNodeTemp;
}

template<class T>
T* Node<T>::getChild(T* prm_pChild) const {
    if (_pChildFirst == nullptr) {
        return nullptr;
    }
    T* pNodeTemp = _pChildFirst;
    do {
        if (prm_pChild == pNodeTemp) {
            break;
        }
        if (pNodeTemp->_is_last_flg) {
            return nullptr;
        }
        pNodeTemp = pNodeTemp->_pNext;
    } while (true);
    return pNodeTemp;
}

template<class T>
T* Node<T>::getChild(int prm_index) const {
    T* pNodeTemp = _pChildFirst;
    for (int i = 0; i < prm_index; i++) {
        pNodeTemp = pNodeTemp->_pNext;
    }
    return pNodeTemp;
}

template<class T>
bool Node<T>::hasChild(char* prm_child_actor_name) const {
    if (_pChildFirst == nullptr) {
        return false;
    } else {
        T* pNodeTemp = _pChildFirst;
        do {
            if (strcmp(pNodeTemp->getName(), prm_child_actor_name) == 0) {
                return true;
            }
            if (pNodeTemp->_is_last_flg) {
                return false;
            } else {
                pNodeTemp = pNodeTemp->_pNext;
            }
        } while (true);
    }
}

template<class T>
void Node<T>::appendChild(T* prm_pChild) {
#ifdef MY_DEBUG
    if (prm_pChild->_pParent) {
        throwCriticalException("[Node<" << _class_name << ">::appendChild()] Error! m[h͊ɏ("
                << prm_pChild->_pParent->_name << "ɏ)Ă܂(this=" << _name << "/prm_pChild=" << prm_pChild->getName() << ")");
    }
#endif
    prm_pChild->_pParent = (T*)this;
    prm_pChild->_is_last_flg = true;
    if (_pChildFirst == nullptr) { //ŏ̎q
        prm_pChild->_is_first_flg = true;
        _pChildFirst = prm_pChild;
        _pChildFirst->_pNext = prm_pChild;
        _pChildFirst->_pPrev = prm_pChild;
    } else {  //Qڈȍ~̎q
        prm_pChild->_is_first_flg = false;
        T* pChildLast = _pChildFirst->_pPrev;
        pChildLast->_is_last_flg = false;
        pChildLast->_pNext = prm_pChild;
        prm_pChild->_pPrev = pChildLast;
        prm_pChild->_pNext = _pChildFirst;
        _pChildFirst->_pPrev = prm_pChild;
    }
    _child_num++;
}

template<class T>
void Node<T>::prependChild(T* prm_pChild) {
#ifdef MY_DEBUG
    if (prm_pChild->_pParent) {
        throwCriticalException("[Node<" << _class_name << ">::prependChild()] Error! m[h͊ɏ("
                << prm_pChild->_pParent->_name << "ɏ)Ă܂(this=" << _name << "/prm_pChild=" << prm_pChild->getName() << ")");
    }
#endif
    prm_pChild->_pParent = (T*)this;
    prm_pChild->_is_first_flg = true;
    if (_pChildFirst == nullptr) { //ŏ̎q
        prm_pChild->_is_last_flg = true;
        prm_pChild->_pNext = prm_pChild;
        prm_pChild->_pPrev = prm_pChild;
    } else {
        prm_pChild->_is_last_flg = false;
        T* pChildLast = _pChildFirst->_pPrev;
        pChildLast->_pNext = prm_pChild;
        prm_pChild->_pPrev = pChildLast;
        prm_pChild->_pNext = _pChildFirst;
        _pChildFirst->_pPrev = prm_pChild;
        _pChildFirst->_is_first_flg = false;
    }
    _pChildFirst = prm_pChild;

    _child_num++;
}

/*
 template<class T>
 bool Node<T>::isNamed(const char* prm_name) {
 char*::size_type iLen = prm_name.length();
 if (prm_name.rfind('*') == iLen-1) {}


 return _name;
 }
 */


template<class T>
Node<T>::~Node() {
    //Ɏqꍇ
    if (_pChildFirst) {
        //܂qdelete
        if (_pChildFirst->_is_last_flg) {
            //qm[h͂P̏ꍇ
            GGAF_DELETE(_pChildFirst);
            _pChildFirst = nullptr;
        } else {
            //qm[h͂Qȏ̏ꍇ
            T* pChildLast = _pChildFirst->_pPrev;
            T* pChildLastPrev = pChildLast->_pPrev;
            while (true) {
                GGAF_DELETE(pChildLast); //delete
                if (pChildLastPrev->_is_first_flg) {
                    GGAF_DELETE(_pChildFirst); //pChildLastPrev == _pChildFirst ł
                    _pChildFirst = nullptr;
                    break;
                }
                pChildLast = pChildLastPrev;
                pChildLastPrev = pChildLastPrev->_pPrev;
            }
        }
    }

    //qȂԂ̏ꍇ
    if (_pParent) {
        _pParent->_child_num--;
        //AO
        T* pMyNext = _pNext;
        T* pMyPrev = _pPrev;
        if (_is_first_flg && _is_last_flg) {
            //AĂm[hÂݏꍇ
            _pParent->_pChildFirst = nullptr;
            _pParent = nullptr;
            _pNext = (T*)this;
            _pPrev = (T*)this;
            _pChildFirst = nullptr;
        } else {
            //A甲oꍇ
            //ׂ̃m[hmqAwȂB
            pMyPrev->_pNext = pMyNext;
            pMyNext->_pPrev = pMyPrev;
            if (_is_last_flg) {
                pMyPrev->_is_last_flg = true;
            }
            if (_is_first_flg) {
                pMyNext->_is_first_flg = true;
                _pParent->_pChildFirst = pMyNext;
            }
            _pParent = nullptr;
            _pNext = (T*)this;
            _pPrev = (T*)this;
            _pChildFirst = nullptr;
            _is_first_flg = true;
            _is_last_flg = true;
        }
    }
    GGAF_DELETEARR(_name);
}

}
#endif /*GGAF_CORE_NODE_H_*/
