package hiro.yoshioka.sql.util;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class FileDialogCellEditor extends DialogCellEditor {

	private static final int DEFAULT_EXTENT = 16;

	private static final int GAP = 6;

	private Composite composite;

	private CLabel fileImageLabel;

	private CLabel fileLabel;

	// private Image image;

	public FileDialogCellEditor(Composite parent) {
		this(parent, SWT.NONE);
	}

	public FileDialogCellEditor(Composite parent, int style) {
		super(parent, style);
	}

	protected Control createContents(Composite cell) {
		Color bg = cell.getBackground();
		composite = new Composite(cell, getStyle());
		composite.setBackground(bg);
		composite.setLayout(new GridLayout(1, false));
		// fileImageLabel = new CLabel(composite, SWT.LEFT);
		fileLabel = new CLabel(composite, SWT.LEFT);
		fileLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		return composite;
	}

	public void dispose() {
		// if (image != null) {
		// image.dispose();
		// image = null;
		// }
		super.dispose();
	}

	protected Object openDialogBox(Control cellEditorWindow) {
		FileDialog dialog = new FileDialog(cellEditorWindow.getShell(),
				SWT.OPEN);
		Object value = getValue();
		if (value != null) {
			dialog.setFileName((String) value);
		}
		value = dialog.open();

		return value;
	}

	protected void updateContents(Object value) {
		// if (image != null) {
		// image.dispose();
		// }

		if (value != null) {
			String fileName = (String) value;
			int idx = fileName.lastIndexOf('.');
			if (idx >= 0) {
				// try {
				// image = new Image(composite.getDisplay(), Program
				// .findProgram(fileName.substring(idx + 1))
				// .getImageData());
				// fileImageLabel.setImage(image);
				// } catch (RuntimeException e) {
				// // TODO Auto-generated catch block
				// e.printStackTrace();
				// }
			}
			fileLabel.setText(fileName);
			System.out.println("setteddddd[" + fileName + "]");
		}
	}
}
