package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sql.notes.ddl.ACL;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;

public class DominoTransactionRequest extends TransactionRequest {
	private ACL acl;
	private String dominoSearchQuery;

	public DominoTransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, IDBTable table) {
		super(operation, properties, table);
	}

	public DominoTransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, String sql_statemente,
			Object[] binds, IDBTable table) {
		super(operation, properties, sql_statemente, binds, table);
	}

	public DominoTransactionRequest(SQLOperationType unidExecuteQuery,
			ConnectionProperties connectionProperties, String[] uids) {
		super(unidExecuteQuery, connectionProperties, uids);
	}

	public ACL getAcl() {
		return acl;
	}

	public void setAcl(ACL acl) {
		this.acl = acl;
	}

	public void setDominoSearchQuery(String dominoSearchQuery) {
		this.dominoSearchQuery = dominoSearchQuery;
	}

	public String getDominoSearchQuery() {
		return dominoSearchQuery;
	}
}
