package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.oracle.util.WolfParserUtil;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.File;
import java.io.FileNotFoundException;

public class WolfProposalParserFactory extends ProposalParserFactory {

	public ParserUtil createParserUtil(String statement) {
		return new WolfParserUtil(statement);
	}

	public ParserUtil createParserUtil(File file) {
		try {
			return new WolfParserUtil(file);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

	public IProposalableParserUtil createParserUtil(String statement,
			DBRoot root) {
		return new WolfProposalParserUtil(statement, root);
	}

	public IProposalableParserUtil createParserUtil(File file, DBRoot root) {
		try {
			return new WolfProposalParserUtil(file, root);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

}
