package hiro.yoshioka.sql.resource.evernote;

import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;

import com.evernote.edam.type.Tag;

public class EvernoteTag extends DBResource implements Serializable {
	private static final long serialVersionUID = 2369951777366180685L;
	private String guid;
	private String parentGuid;
	private int noteCount;

	public EvernoteTag(IDBSchema schema, Tag tag) {
		super(schema);
		setName(tag.getName());
		this.guid = tag.getGuid();
		this.parentGuid = tag.getParentGuid();
	}

	public String getGuid() {
		return guid;
	}

	public String getParentGuid() {
		return parentGuid;
	}
	
	public void setNoteCount(int noteCount) {
		this.noteCount = noteCount;
	}

	@Override
	public void setName(String name) {
		name = name.replaceAll(StringUtil.HALF_SPACE__STRING,
				StringUtil.EMPTY_STRING);
		super.setName(name);
	}

	@Override
	public boolean contain(String pattern) {
		return false;
	}

	public int getNoteCount() {
		return this.noteCount;
	}

}