package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.util.ASTEditorTableListHolder;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.List;

public abstract class ASTDefaultDOL extends SimpleNode implements IDML {
	public ASTEditorTableListHolder fTableHolder;

	public ASTDefaultDOL(int id) {
		super(id);
	}

	public ASTDefaultDOL(AbsSQLParser p, int id) {
		super(p, id);
	}

	public boolean beginTransaction() {
		return false;
	}

	public boolean isDML() {
		return false;
	}

	public String infomatin() {
		return null;
	}

	public boolean isDDL() {
		return false;
	}

	public boolean isDOL() {
		return true;
	}

	private void test() {
		if (fTableHolder == null) {
			fTableHolder = new ASTEditorTableListHolder();
		}
	}

	@Override
	public void addTable(IDBTable table) {
		test();
		fTableHolder.addTable(table);
	}

	@Override
	public void addTableList(List list) {
		test();
		fTableHolder.addTableList(list);
	}

	@Override
	public boolean emptyTableList() {
		return fTableHolder == null || fTableHolder.size() == 0;
	}

	@Override
	public ASTEditorTableListHolder getEditorTableListHolder() {
		return fTableHolder;
	}
}
