package hiro.yoshioka.sql.resource;

import java.util.HashSet;
import java.util.Set;

public enum TableType {
	TABLE("TABLE"),

	VIEW("VIEW"),

	SYSTEM_TABLE("SYSTEM TABLE"),

	GLOBAL_TEMPORARY("GLOBAL TEMPORARY"),

	LOCAL_TEMPORARY("LOCAL TEMPORARY"),

	ALIAS("ALIAS"),

	PROCEDURE("PROCEDURE"),

	FUNCTION("FUNCTION"), TRIGGER("TRIGGER"),

	SYNONYM("SYNONYM"), UNKNOWN("UnKnown");

	public static final Set<TableType> TABLE_OR_VIEW_OR_PROCEDURE_OR_FUNCTION_SET = new HashSet<TableType>();
	public static final Set<TableType> TABLE_OR_VIEW_OR_SYNONYM_SET = new HashSet<TableType>();
	public static final Set<TableType> TABLE_OR_VIEW_SET = new HashSet<TableType>();
	public static final Set<TableType> TABLE_SET = new HashSet<TableType>();
	public static final Set<TableType> PROCEDURE_SET = new HashSet<TableType>();
	public static final Set<TableType> FUNCTION_SET = new HashSet<TableType>();
	public static final Set<TableType> VIEW_SET = new HashSet<TableType>();
	public static final Set<TableType> SYNONYM_SET = new HashSet<TableType>();

	static {
		TABLE_SET.add(TABLE);
		TABLE_SET.add(SYSTEM_TABLE);

		TABLE_OR_VIEW_SET.addAll(TABLE_SET);
		TABLE_OR_VIEW_SET.add(VIEW);

		TABLE_OR_VIEW_OR_SYNONYM_SET.addAll(TABLE_OR_VIEW_SET);
		TABLE_OR_VIEW_OR_SYNONYM_SET.add(SYNONYM);

		PROCEDURE_SET.add(PROCEDURE);
		FUNCTION_SET.add(FUNCTION);

		TABLE_OR_VIEW_OR_PROCEDURE_OR_FUNCTION_SET.addAll(TABLE_OR_VIEW_SET);
		TABLE_OR_VIEW_OR_PROCEDURE_OR_FUNCTION_SET.add(PROCEDURE);
		TABLE_OR_VIEW_OR_PROCEDURE_OR_FUNCTION_SET.add(FUNCTION);

		VIEW_SET.add(VIEW);

		SYNONYM_SET.add(SYNONYM);
	}

	private String typeString;

	private TableType(String typeString) {
		this.typeString = typeString;
	}

	public String getTypeString() {
		return typeString;
	}

	public boolean isTable() {
		return TABLE.equals(this) || SYSTEM_TABLE.equals(this);
	}

	public boolean isView() {
		return VIEW.equals(this);
	}

	public boolean isSynonym() {
		return SYNONYM.equals(this);
	}

	public boolean isSystem() {
		return SYSTEM_TABLE.equals(this);
	}

	public static TableType parse(String typeString) {
		for (TableType tt : values()) {
			if (tt.getTypeString().equalsIgnoreCase(typeString)) {
				return tt;
			}
		}
		TableType ret = valueOf(typeString);
		if (ret == null) {
			System.err.println("unkown table type [" + typeString + "]");
			return UNKNOWN;
		}
		return ret;
	}

	public boolean isFunctionOrProcedure() {
		return FUNCTION.equals(this) || PROCEDURE.equals(this);
	}
}
